///////////////////////////////////////////////////////
//  Copyright (c) 2009 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /     Vendor      : Xilinx 
// \  \    \/      Version     : 11.1i 
//  \  \           Description : Xilinx Functional Simulation Library Component
//  /  /                      
// /__/   /\       Filename    : X_PCIE_2_0.v
// \  \  /  \ 
//  \__\/\__ \                    
//                                 
//  Revision:		1.0
//  05/30/08 - CR - Initial version
//  06/18/08 - CR - added PLSELLNKWIDTH and removed PIPETXSWING.
//  07/23/08 - CR1014 - CFGLINKCONTROLRCB typo updated in yml
//  09/23/08 - CR490335 - Checkin complete simprim
//  10/13/08 - CR492333 - PCIE_2_0 yml parameter updates
//  10/13/08 - CR492334 - update X_PCIE_2_0_INST to B_PCIE_2_0_INST
//  10/24/08 - CR1014   - added glbl.GSR
//  11/04/08 - CR493971 - SIM_VERSION real to string
//  11/05/08 - CR495046 - replace case with if for parameter type integer - writer enhancement
//  01/27/09 - CR505569 - Writer update
//  02/18/09 - CR509025 - New pins & timing paths added
//  03/11/09 - CR511750 - Update attribute value to upper case
//  04/13/09 - CR518461 - Connect 4 new pins LNKCLKEN, CFGPMCSR* to RTL
//  05/05/09 - CR520519 - Update specify block from 100ps to 0ps
//  07/28/09 - CR528331 - YML update, new period checks
/////////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module X_PCIE_2_0 (
  CFGAERECRCCHECKEN,
  CFGAERECRCGENEN,
  CFGCOMMANDBUSMASTERENABLE,
  CFGCOMMANDINTERRUPTDISABLE,
  CFGCOMMANDIOENABLE,
  CFGCOMMANDMEMENABLE,
  CFGCOMMANDSERREN,
  CFGDEVCONTROL2CPLTIMEOUTDIS,
  CFGDEVCONTROL2CPLTIMEOUTVAL,
  CFGDEVCONTROLAUXPOWEREN,
  CFGDEVCONTROLCORRERRREPORTINGEN,
  CFGDEVCONTROLENABLERO,
  CFGDEVCONTROLEXTTAGEN,
  CFGDEVCONTROLFATALERRREPORTINGEN,
  CFGDEVCONTROLMAXPAYLOAD,
  CFGDEVCONTROLMAXREADREQ,
  CFGDEVCONTROLNONFATALREPORTINGEN,
  CFGDEVCONTROLNOSNOOPEN,
  CFGDEVCONTROLPHANTOMEN,
  CFGDEVCONTROLURERRREPORTINGEN,
  CFGDEVSTATUSCORRERRDETECTED,
  CFGDEVSTATUSFATALERRDETECTED,
  CFGDEVSTATUSNONFATALERRDETECTED,
  CFGDEVSTATUSURDETECTED,
  CFGDO,
  CFGERRAERHEADERLOGSETN,
  CFGERRCPLRDYN,
  CFGINTERRUPTDO,
  CFGINTERRUPTMMENABLE,
  CFGINTERRUPTMSIENABLE,
  CFGINTERRUPTMSIXENABLE,
  CFGINTERRUPTMSIXFM,
  CFGINTERRUPTRDYN,
  CFGLINKCONTROLASPMCONTROL,
  CFGLINKCONTROLAUTOBANDWIDTHINTEN,
  CFGLINKCONTROLBANDWIDTHINTEN,
  CFGLINKCONTROLCLOCKPMEN,
  CFGLINKCONTROLCOMMONCLOCK,
  CFGLINKCONTROLEXTENDEDSYNC,
  CFGLINKCONTROLHWAUTOWIDTHDIS,
  CFGLINKCONTROLLINKDISABLE,
  CFGLINKCONTROLRCB,
  CFGLINKCONTROLRETRAINLINK,
  CFGLINKSTATUSAUTOBANDWIDTHSTATUS,
  CFGLINKSTATUSBANDWITHSTATUS,
  CFGLINKSTATUSCURRENTSPEED,
  CFGLINKSTATUSDLLACTIVE,
  CFGLINKSTATUSLINKTRAINING,
  CFGLINKSTATUSNEGOTIATEDWIDTH,
  CFGMSGDATA,
  CFGMSGRECEIVED,
  CFGMSGRECEIVEDASSERTINTA,
  CFGMSGRECEIVEDASSERTINTB,
  CFGMSGRECEIVEDASSERTINTC,
  CFGMSGRECEIVEDASSERTINTD,
  CFGMSGRECEIVEDDEASSERTINTA,
  CFGMSGRECEIVEDDEASSERTINTB,
  CFGMSGRECEIVEDDEASSERTINTC,
  CFGMSGRECEIVEDDEASSERTINTD,
  CFGMSGRECEIVEDERRCOR,
  CFGMSGRECEIVEDERRFATAL,
  CFGMSGRECEIVEDERRNONFATAL,
  CFGMSGRECEIVEDPMASNAK,
  CFGMSGRECEIVEDPMETO,
  CFGMSGRECEIVEDPMETOACK,
  CFGMSGRECEIVEDPMPME,
  CFGMSGRECEIVEDSETSLOTPOWERLIMIT,
  CFGMSGRECEIVEDUNLOCK,
  CFGPCIELINKSTATE,
  CFGPMCSRPMEEN,
  CFGPMCSRPMESTATUS,
  CFGPMCSRPOWERSTATE,	   
  CFGPMRCVASREQL1N,
  CFGPMRCVENTERL1N,
  CFGPMRCVENTERL23N,
  CFGPMRCVREQACKN,
  CFGRDWRDONEN,
  CFGSLOTCONTROLELECTROMECHILCTLPULSE,
  CFGTRANSACTION,
  CFGTRANSACTIONADDR,
  CFGTRANSACTIONTYPE,
  CFGVCTCVCMAP,
  DBGSCLRA,
  DBGSCLRB,
  DBGSCLRC,
  DBGSCLRD,
  DBGSCLRE,
  DBGSCLRF,
  DBGSCLRG,
  DBGSCLRH,
  DBGSCLRI,
  DBGSCLRJ,
  DBGSCLRK,
  DBGVECA,
  DBGVECB,
  DBGVECC,
  DRPDO,
  DRPDRDY,
  LL2BADDLLPERRN,
  LL2BADTLPERRN,
  LL2PROTOCOLERRN,
  LL2REPLAYROERRN,
  LL2REPLAYTOERRN,
  LL2SUSPENDOKN,
  LL2TFCINIT1SEQN,
  LL2TFCINIT2SEQN,
  LNKCLKEN,		   
  MIMRXRADDR,
  MIMRXRCE,
  MIMRXREN,
  MIMRXWADDR,
  MIMRXWDATA,
  MIMRXWEN,
  MIMTXRADDR,
  MIMTXRCE,
  MIMTXREN,
  MIMTXWADDR,
  MIMTXWDATA,
  MIMTXWEN,
  PIPERX0POLARITY,
  PIPERX1POLARITY,
  PIPERX2POLARITY,
  PIPERX3POLARITY,
  PIPERX4POLARITY,
  PIPERX5POLARITY,
  PIPERX6POLARITY,
  PIPERX7POLARITY,
  PIPETX0CHARISK,
  PIPETX0COMPLIANCE,
  PIPETX0DATA,
  PIPETX0ELECIDLE,
  PIPETX0POWERDOWN,
  PIPETX1CHARISK,
  PIPETX1COMPLIANCE,
  PIPETX1DATA,
  PIPETX1ELECIDLE,
  PIPETX1POWERDOWN,
  PIPETX2CHARISK,
  PIPETX2COMPLIANCE,
  PIPETX2DATA,
  PIPETX2ELECIDLE,
  PIPETX2POWERDOWN,
  PIPETX3CHARISK,
  PIPETX3COMPLIANCE,
  PIPETX3DATA,
  PIPETX3ELECIDLE,
  PIPETX3POWERDOWN,
  PIPETX4CHARISK,
  PIPETX4COMPLIANCE,
  PIPETX4DATA,
  PIPETX4ELECIDLE,
  PIPETX4POWERDOWN,
  PIPETX5CHARISK,
  PIPETX5COMPLIANCE,
  PIPETX5DATA,
  PIPETX5ELECIDLE,
  PIPETX5POWERDOWN,
  PIPETX6CHARISK,
  PIPETX6COMPLIANCE,
  PIPETX6DATA,
  PIPETX6ELECIDLE,
  PIPETX6POWERDOWN,
  PIPETX7CHARISK,
  PIPETX7COMPLIANCE,
  PIPETX7DATA,
  PIPETX7ELECIDLE,
  PIPETX7POWERDOWN,
  PIPETXDEEMPH,
  PIPETXMARGIN,
  PIPETXRATE,
  PIPETXRCVRDET,
  PIPETXRESET,
  PL2LINKUPN,
  PL2RECEIVERERRN,
  PL2RECOVERYN,
  PL2RXELECIDLE,
  PL2SUSPENDOK,
  PLDBGVEC,
  PLINITIALLINKWIDTH,
  PLLANEREVERSALMODE,
  PLLINKGEN2CAP,
  PLLINKPARTNERGEN2SUPPORTED,
  PLLINKUPCFGCAP,
  PLLTSSMSTATE,
  PLPHYLNKUPN,
  PLRECEIVEDHOTRST,
  PLRXPMSTATE,
  PLSELLNKRATE,
  PLSELLNKWIDTH,
  PLTXPMSTATE,
  RECEIVEDFUNCLVLRSTN,
  TL2ASPMSUSPENDCREDITCHECKOKN,
  TL2ASPMSUSPENDREQN,
  TL2PPMSUSPENDOKN,
  TRNFCCPLD,
  TRNFCCPLH,
  TRNFCNPD,
  TRNFCNPH,
  TRNFCPD,
  TRNFCPH,
  TRNLNKUPN,
  TRNRBARHITN,
  TRNRD,
  TRNRDLLPDATA,
  TRNRDLLPSRCRDYN,
  TRNRECRCERRN,
  TRNREOFN,
  TRNRERRFWDN,
  TRNRREMN,
  TRNRSOFN,
  TRNRSRCDSCN,
  TRNRSRCRDYN,
  TRNTBUFAV,
  TRNTCFGREQN,
  TRNTDLLPDSTRDYN,
  TRNTDSTRDYN,
  TRNTERRDROPN,
  USERRSTN,
  CFGBYTEENN,
  CFGDI,
  CFGDSBUSNUMBER,
  CFGDSDEVICENUMBER,
  CFGDSFUNCTIONNUMBER,
  CFGDSN,
  CFGDWADDR,
  CFGERRACSN,
  CFGERRAERHEADERLOG,
  CFGERRCORN,
  CFGERRCPLABORTN,
  CFGERRCPLTIMEOUTN,
  CFGERRCPLUNEXPECTN,
  CFGERRECRCN,
  CFGERRLOCKEDN,
  CFGERRPOSTEDN,
  CFGERRTLPCPLHEADER,
  CFGERRURN,
  CFGINTERRUPTASSERTN,
  CFGINTERRUPTDI,
  CFGINTERRUPTN,
  CFGPMDIRECTASPML1N,
  CFGPMSENDPMACKN,
  CFGPMSENDPMETON,
  CFGPMSENDPMNAKN,
  CFGPMTURNOFFOKN,
  CFGPMWAKEN,
  CFGPORTNUMBER,
  CFGRDENN,
  CFGTRNPENDINGN,
  CFGWRENN,
  CFGWRREADONLYN,
  CFGWRRW1CASRWN,
  CMRSTN,
  CMSTICKYRSTN,
  DBGMODE,
  DBGSUBMODE,
  DLRSTN,
  DRPCLK,
  DRPDADDR,
  DRPDEN,
  DRPDI,
  DRPDWE,
  FUNCLVLRSTN,
  LL2SENDASREQL1N,
  LL2SENDENTERL1N,
  LL2SENDENTERL23N,
  LL2SUSPENDNOWN,
  LL2TLPRCVN,
  MIMRXRDATA,
  MIMTXRDATA,
  PIPECLK,
  PIPERX0CHANISALIGNED,
  PIPERX0CHARISK,
  PIPERX0DATA,
  PIPERX0ELECIDLE,
  PIPERX0PHYSTATUS,
  PIPERX0STATUS,
  PIPERX0VALID,
  PIPERX1CHANISALIGNED,
  PIPERX1CHARISK,
  PIPERX1DATA,
  PIPERX1ELECIDLE,
  PIPERX1PHYSTATUS,
  PIPERX1STATUS,
  PIPERX1VALID,
  PIPERX2CHANISALIGNED,
  PIPERX2CHARISK,
  PIPERX2DATA,
  PIPERX2ELECIDLE,
  PIPERX2PHYSTATUS,
  PIPERX2STATUS,
  PIPERX2VALID,
  PIPERX3CHANISALIGNED,
  PIPERX3CHARISK,
  PIPERX3DATA,
  PIPERX3ELECIDLE,
  PIPERX3PHYSTATUS,
  PIPERX3STATUS,
  PIPERX3VALID,
  PIPERX4CHANISALIGNED,
  PIPERX4CHARISK,
  PIPERX4DATA,
  PIPERX4ELECIDLE,
  PIPERX4PHYSTATUS,
  PIPERX4STATUS,
  PIPERX4VALID,
  PIPERX5CHANISALIGNED,
  PIPERX5CHARISK,
  PIPERX5DATA,
  PIPERX5ELECIDLE,
  PIPERX5PHYSTATUS,
  PIPERX5STATUS,
  PIPERX5VALID,
  PIPERX6CHANISALIGNED,
  PIPERX6CHARISK,
  PIPERX6DATA,
  PIPERX6ELECIDLE,
  PIPERX6PHYSTATUS,
  PIPERX6STATUS,
  PIPERX6VALID,
  PIPERX7CHANISALIGNED,
  PIPERX7CHARISK,
  PIPERX7DATA,
  PIPERX7ELECIDLE,
  PIPERX7PHYSTATUS,
  PIPERX7STATUS,
  PIPERX7VALID,
  PL2DIRECTEDLSTATE,
  PLDBGMODE,
  PLDIRECTEDLINKAUTON,
  PLDIRECTEDLINKCHANGE,
  PLDIRECTEDLINKSPEED,
  PLDIRECTEDLINKWIDTH,
  PLDOWNSTREAMDEEMPHSOURCE,
  PLRSTN,
  PLTRANSMITHOTRST,
  PLUPSTREAMPREFERDEEMPH,
  SYSRSTN,
  TL2ASPMSUSPENDCREDITCHECKN,
  TL2PPMSUSPENDREQN,
  TLRSTN,
  TRNFCSEL,
  TRNRDSTRDYN,
  TRNRNPOKN,
  TRNTCFGGNTN,
  TRNTD,
  TRNTDLLPDATA,
  TRNTDLLPSRCRDYN,
  TRNTECRCGENN,
  TRNTEOFN,
  TRNTERRFWDN,
  TRNTREMN,
  TRNTSOFN,
  TRNTSRCDSCN,
  TRNTSRCRDYN,
  TRNTSTRN,
  USERCLK
);
  parameter LOC = "UNPLACED";
  parameter [11:0] AER_BASE_PTR = 12'h128;
  parameter AER_CAP_ECRC_CHECK_CAPABLE = "FALSE";
  parameter AER_CAP_ECRC_GEN_CAPABLE = "FALSE";
  parameter [15:0] AER_CAP_ID = 16'h0001;
  parameter [4:0] AER_CAP_INT_MSG_NUM_MSI = 5'h0A;
  parameter [4:0] AER_CAP_INT_MSG_NUM_MSIX = 5'h15;
  parameter [11:0] AER_CAP_NEXTPTR = 12'h160;
  parameter AER_CAP_ON = "FALSE";
  parameter AER_CAP_PERMIT_ROOTERR_UPDATE = "TRUE";
  parameter [3:0] AER_CAP_VERSION = 4'h1;
  parameter ALLOW_X8_GEN2 = "FALSE";
  parameter [31:0] BAR0 = 32'hFFFFFF00;
  parameter [31:0] BAR1 = 32'hFFFF0000;
  parameter [31:0] BAR2 = 32'hFFFF000C;
  parameter [31:0] BAR3 = 32'hFFFFFFFF;
  parameter [31:0] BAR4 = 32'h00000000;
  parameter [31:0] BAR5 = 32'h00000000;
  parameter [7:0] CAPABILITIES_PTR = 8'h40;
  parameter [31:0] CARDBUS_CIS_POINTER = 32'h00000000;
  parameter [23:0] CLASS_CODE = 24'h000000;
  parameter CMD_INTX_IMPLEMENTED = "TRUE";
  parameter CPL_TIMEOUT_DISABLE_SUPPORTED = "FALSE";
  parameter [3:0] CPL_TIMEOUT_RANGES_SUPPORTED = 4'h0;
  parameter [6:0] CRM_MODULE_RSTS = 7'h00;
  parameter [15:0] DEVICE_ID = 16'h0007;
  parameter DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE = "TRUE";
  parameter DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE = "TRUE";
  parameter integer DEV_CAP_ENDPOINT_L0S_LATENCY = 0;
  parameter integer DEV_CAP_ENDPOINT_L1_LATENCY = 0;
  parameter DEV_CAP_EXT_TAG_SUPPORTED = "TRUE";
  parameter DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "FALSE";
  parameter integer DEV_CAP_MAX_PAYLOAD_SUPPORTED = 2;
  parameter integer DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT = 0;
  parameter DEV_CAP_ROLE_BASED_ERROR = "TRUE";
  parameter integer DEV_CAP_RSVD_14_12 = 0;
  parameter integer DEV_CAP_RSVD_17_16 = 0;
  parameter integer DEV_CAP_RSVD_31_29 = 0;
  parameter DEV_CONTROL_AUX_POWER_SUPPORTED = "FALSE";
  parameter DISABLE_ASPM_L1_TIMER = "FALSE";
  parameter DISABLE_BAR_FILTERING = "FALSE";
  parameter DISABLE_ID_CHECK = "FALSE";
  parameter DISABLE_LANE_REVERSAL = "FALSE";
  parameter DISABLE_RX_TC_FILTER = "FALSE";
  parameter DISABLE_SCRAMBLING = "FALSE";
  parameter [7:0] DNSTREAM_LINK_NUM = 8'h00;
  parameter [11:0] DSN_BASE_PTR = 12'h100;
  parameter [15:0] DSN_CAP_ID = 16'h0003;
  parameter [11:0] DSN_CAP_NEXTPTR = 12'h000;
  parameter DSN_CAP_ON = "TRUE";
  parameter [3:0] DSN_CAP_VERSION = 4'h1;
  parameter [10:0] ENABLE_MSG_ROUTE = 11'h000;
  parameter ENABLE_RX_TD_ECRC_TRIM = "FALSE";
  parameter ENTER_RVRY_EI_L0 = "TRUE";
  parameter EXIT_LOOPBACK_ON_EI = "TRUE";
  parameter [31:0] EXPANSION_ROM = 32'hFFFFF001;
  parameter [5:0] EXT_CFG_CAP_PTR = 6'h3F;
  parameter [9:0] EXT_CFG_XP_CAP_PTR = 10'h3FF;
  parameter [7:0] HEADER_TYPE = 8'h00;
  parameter [4:0] INFER_EI = 5'h00;
  parameter [7:0] INTERRUPT_PIN = 8'h01;
  parameter IS_SWITCH = "FALSE";
  parameter [9:0] LAST_CONFIG_DWORD = 10'h042;
  parameter integer LINK_CAP_ASPM_SUPPORT = 1;
  parameter LINK_CAP_CLOCK_POWER_MANAGEMENT = "FALSE";
  parameter LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP = "FALSE";
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7;
  parameter integer LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7;
  parameter integer LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7;
  parameter LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP = "FALSE";
  parameter [3:0] LINK_CAP_MAX_LINK_SPEED = 4'h1;
  parameter [5:0] LINK_CAP_MAX_LINK_WIDTH = 6'h08;
  parameter integer LINK_CAP_RSVD_23_22 = 0;
  parameter LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE = "FALSE";
  parameter integer LINK_CONTROL_RCB = 0;
  parameter LINK_CTRL2_DEEMPHASIS = "FALSE";
  parameter LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE = "FALSE";
  parameter [3:0] LINK_CTRL2_TARGET_LINK_SPEED = 4'h2;
  parameter LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE";
  parameter [14:0] LL_ACK_TIMEOUT = 15'h0000;
  parameter LL_ACK_TIMEOUT_EN = "FALSE";
  parameter integer LL_ACK_TIMEOUT_FUNC = 0;
  parameter [14:0] LL_REPLAY_TIMEOUT = 15'h0000;
  parameter LL_REPLAY_TIMEOUT_EN = "FALSE";
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0;
  parameter [5:0] LTSSM_MAX_LINK_WIDTH = 6'h01;
  parameter [7:0] MSIX_BASE_PTR = 8'h9C;
  parameter [7:0] MSIX_CAP_ID = 8'h11;
  parameter [7:0] MSIX_CAP_NEXTPTR = 8'h00;
  parameter MSIX_CAP_ON = "FALSE";
  parameter integer MSIX_CAP_PBA_BIR = 0;
  parameter [28:0] MSIX_CAP_PBA_OFFSET = 29'h00000050;
  parameter integer MSIX_CAP_TABLE_BIR = 0;
  parameter [28:0] MSIX_CAP_TABLE_OFFSET = 29'h00000040;
  parameter [10:0] MSIX_CAP_TABLE_SIZE = 11'h000;
  parameter [7:0] MSI_BASE_PTR = 8'h48;
  parameter MSI_CAP_64_BIT_ADDR_CAPABLE = "TRUE";
  parameter [7:0] MSI_CAP_ID = 8'h05;
  parameter integer MSI_CAP_MULTIMSGCAP = 0;
  parameter integer MSI_CAP_MULTIMSG_EXTENSION = 0;
  parameter [7:0] MSI_CAP_NEXTPTR = 8'h60;
  parameter MSI_CAP_ON = "FALSE";
  parameter MSI_CAP_PER_VECTOR_MASKING_CAPABLE = "TRUE";
  parameter integer N_FTS_COMCLK_GEN1 = 255;
  parameter integer N_FTS_COMCLK_GEN2 = 255;
  parameter integer N_FTS_GEN1 = 255;
  parameter integer N_FTS_GEN2 = 255;
  parameter [7:0] PCIE_BASE_PTR = 8'h60;
  parameter [7:0] PCIE_CAP_CAPABILITY_ID = 8'h10;
  parameter [3:0] PCIE_CAP_CAPABILITY_VERSION = 4'h2;
  parameter [3:0] PCIE_CAP_DEVICE_PORT_TYPE = 4'h0;
  parameter [4:0] PCIE_CAP_INT_MSG_NUM = 5'h00;
  parameter [7:0] PCIE_CAP_NEXTPTR = 8'h00;
  parameter PCIE_CAP_ON = "TRUE";
  parameter integer PCIE_CAP_RSVD_15_14 = 0;
  parameter PCIE_CAP_SLOT_IMPLEMENTED = "FALSE";
  parameter integer PCIE_REVISION = 2;
  parameter integer PGL0_LANE = 0;
  parameter integer PGL1_LANE = 1;
  parameter integer PGL2_LANE = 2;
  parameter integer PGL3_LANE = 3;
  parameter integer PGL4_LANE = 4;
  parameter integer PGL5_LANE = 5;
  parameter integer PGL6_LANE = 6;
  parameter integer PGL7_LANE = 7;
  parameter integer PL_AUTO_CONFIG = 0;
  parameter PL_FAST_TRAIN = "FALSE";
  parameter [7:0] PM_BASE_PTR = 8'h40;
  parameter integer PM_CAP_AUXCURRENT = 0;
  parameter PM_CAP_D1SUPPORT = "TRUE";
  parameter PM_CAP_D2SUPPORT = "TRUE";
  parameter PM_CAP_DSI = "FALSE";
  parameter [7:0] PM_CAP_ID = 8'h01;
  parameter [7:0] PM_CAP_NEXTPTR = 8'h48;
  parameter PM_CAP_ON = "TRUE";
  parameter [4:0] PM_CAP_PMESUPPORT = 5'h0F;
  parameter PM_CAP_PME_CLOCK = "FALSE";
  parameter integer PM_CAP_RSVD_04 = 0;
  parameter integer PM_CAP_VERSION = 3;
  parameter PM_CSR_B2B3 = "FALSE";
  parameter PM_CSR_BPCCEN = "FALSE";
  parameter PM_CSR_NOSOFTRST = "TRUE";
  parameter [7:0] PM_DATA0 = 8'h01;
  parameter [7:0] PM_DATA1 = 8'h01;
  parameter [7:0] PM_DATA2 = 8'h01;
  parameter [7:0] PM_DATA3 = 8'h01;
  parameter [7:0] PM_DATA4 = 8'h01;
  parameter [7:0] PM_DATA5 = 8'h01;
  parameter [7:0] PM_DATA6 = 8'h01;
  parameter [7:0] PM_DATA7 = 8'h01;
  parameter [1:0] PM_DATA_SCALE0 = 2'h1;
  parameter [1:0] PM_DATA_SCALE1 = 2'h1;
  parameter [1:0] PM_DATA_SCALE2 = 2'h1;
  parameter [1:0] PM_DATA_SCALE3 = 2'h1;
  parameter [1:0] PM_DATA_SCALE4 = 2'h1;
  parameter [1:0] PM_DATA_SCALE5 = 2'h1;
  parameter [1:0] PM_DATA_SCALE6 = 2'h1;
  parameter [1:0] PM_DATA_SCALE7 = 2'h1;
  parameter integer RECRC_CHK = 0;
  parameter RECRC_CHK_TRIM = "FALSE";
  parameter [7:0] REVISION_ID = 8'h00;
  parameter ROOT_CAP_CRS_SW_VISIBILITY = "FALSE";
  parameter SELECT_DLL_IF = "FALSE";
  parameter SIM_VERSION = "1.0";
  parameter SLOT_CAP_ATT_BUTTON_PRESENT = "FALSE";
  parameter SLOT_CAP_ATT_INDICATOR_PRESENT = "FALSE";
  parameter SLOT_CAP_ELEC_INTERLOCK_PRESENT = "FALSE";
  parameter SLOT_CAP_HOTPLUG_CAPABLE = "FALSE";
  parameter SLOT_CAP_HOTPLUG_SURPRISE = "FALSE";
  parameter SLOT_CAP_MRL_SENSOR_PRESENT = "FALSE";
  parameter SLOT_CAP_NO_CMD_COMPLETED_SUPPORT = "FALSE";
  parameter [12:0] SLOT_CAP_PHYSICAL_SLOT_NUM = 13'h0000;
  parameter SLOT_CAP_POWER_CONTROLLER_PRESENT = "FALSE";
  parameter SLOT_CAP_POWER_INDICATOR_PRESENT = "FALSE";
  parameter integer SLOT_CAP_SLOT_POWER_LIMIT_SCALE = 0;
  parameter [7:0] SLOT_CAP_SLOT_POWER_LIMIT_VALUE = 8'h00;
  parameter integer SPARE_BIT0 = 0;
  parameter integer SPARE_BIT1 = 0;
  parameter integer SPARE_BIT2 = 0;
  parameter integer SPARE_BIT3 = 0;
  parameter integer SPARE_BIT4 = 0;
  parameter integer SPARE_BIT5 = 0;
  parameter integer SPARE_BIT6 = 0;
  parameter integer SPARE_BIT7 = 0;
  parameter integer SPARE_BIT8 = 0;
  parameter [7:0] SPARE_BYTE0 = 8'h00;
  parameter [7:0] SPARE_BYTE1 = 8'h00;
  parameter [7:0] SPARE_BYTE2 = 8'h00;
  parameter [7:0] SPARE_BYTE3 = 8'h00;
  parameter [31:0] SPARE_WORD0 = 32'h00000000;
  parameter [31:0] SPARE_WORD1 = 32'h00000000;
  parameter [31:0] SPARE_WORD2 = 32'h00000000;
  parameter [31:0] SPARE_WORD3 = 32'h00000000;
  parameter [15:0] SUBSYSTEM_ID = 16'h0007;
  parameter [15:0] SUBSYSTEM_VENDOR_ID = 16'h10EE;
  parameter TL_RBYPASS = "FALSE";
  parameter integer TL_RX_RAM_RADDR_LATENCY = 0;
  parameter integer TL_RX_RAM_RDATA_LATENCY = 2;
  parameter integer TL_RX_RAM_WRITE_LATENCY = 0;
  parameter TL_TFC_DISABLE = "FALSE";
  parameter TL_TX_CHECKS_DISABLE = "FALSE";
  parameter integer TL_TX_RAM_RADDR_LATENCY = 0;
  parameter integer TL_TX_RAM_RDATA_LATENCY = 2;
  parameter integer TL_TX_RAM_WRITE_LATENCY = 0;
  parameter UPCONFIG_CAPABLE = "TRUE";
  parameter UPSTREAM_FACING = "TRUE";
  parameter UR_INV_REQ = "TRUE";
  parameter integer USER_CLK_FREQ = 3;
  parameter VC0_CPL_INFINITE = "TRUE";
  parameter [12:0] VC0_RX_RAM_LIMIT = 13'h03FF;
  parameter integer VC0_TOTAL_CREDITS_CD = 127;
  parameter integer VC0_TOTAL_CREDITS_CH = 31;
  parameter integer VC0_TOTAL_CREDITS_NPH = 12;
  parameter integer VC0_TOTAL_CREDITS_PD = 288;
  parameter integer VC0_TOTAL_CREDITS_PH = 32;
  parameter integer VC0_TX_LASTPACKET = 31;
  parameter [11:0] VC_BASE_PTR = 12'h10C;
  parameter [15:0] VC_CAP_ID = 16'h0002;
  parameter [11:0] VC_CAP_NEXTPTR = 12'h000;
  parameter VC_CAP_ON = "FALSE";
  parameter VC_CAP_REJECT_SNOOP_TRANSACTIONS = "FALSE";
  parameter [3:0] VC_CAP_VERSION = 4'h1;
  parameter [15:0] VENDOR_ID = 16'h10EE;
  parameter [11:0] VSEC_BASE_PTR = 12'h160;
  parameter [15:0] VSEC_CAP_HDR_ID = 16'h1234;
  parameter [11:0] VSEC_CAP_HDR_LENGTH = 12'h018;
  parameter [3:0] VSEC_CAP_HDR_REVISION = 4'h1;
  parameter [15:0] VSEC_CAP_ID = 16'h000B;
  parameter VSEC_CAP_IS_LINK_VISIBLE = "TRUE";
  parameter [11:0] VSEC_CAP_NEXTPTR = 12'h000;
  parameter VSEC_CAP_ON = "FALSE";
  parameter [3:0] VSEC_CAP_VERSION = 4'h1;
  
  localparam in_delay = 0;
  localparam out_delay = 0;
  localparam INCLK_DELAY = 0;
  localparam OUTCLK_DELAY = 0;
 
  output CFGAERECRCCHECKEN;
  output CFGAERECRCGENEN;
  output CFGCOMMANDBUSMASTERENABLE;
  output CFGCOMMANDINTERRUPTDISABLE;
  output CFGCOMMANDIOENABLE;
  output CFGCOMMANDMEMENABLE;
  output CFGCOMMANDSERREN;
  output CFGDEVCONTROL2CPLTIMEOUTDIS;
  output CFGDEVCONTROLAUXPOWEREN;
  output CFGDEVCONTROLCORRERRREPORTINGEN;
  output CFGDEVCONTROLENABLERO;
  output CFGDEVCONTROLEXTTAGEN;
  output CFGDEVCONTROLFATALERRREPORTINGEN;
  output CFGDEVCONTROLNONFATALREPORTINGEN;
  output CFGDEVCONTROLNOSNOOPEN;
  output CFGDEVCONTROLPHANTOMEN;
  output CFGDEVCONTROLURERRREPORTINGEN;
  output CFGDEVSTATUSCORRERRDETECTED;
  output CFGDEVSTATUSFATALERRDETECTED;
  output CFGDEVSTATUSNONFATALERRDETECTED;
  output CFGDEVSTATUSURDETECTED;
  output CFGERRAERHEADERLOGSETN;
  output CFGERRCPLRDYN;
  output CFGINTERRUPTMSIENABLE;
  output CFGINTERRUPTMSIXENABLE;
  output CFGINTERRUPTMSIXFM;
  output CFGINTERRUPTRDYN;
  output CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  output CFGLINKCONTROLBANDWIDTHINTEN;
  output CFGLINKCONTROLCLOCKPMEN;
  output CFGLINKCONTROLCOMMONCLOCK;
  output CFGLINKCONTROLEXTENDEDSYNC;
  output CFGLINKCONTROLHWAUTOWIDTHDIS;
  output CFGLINKCONTROLLINKDISABLE;
  output CFGLINKCONTROLRCB;
  output CFGLINKCONTROLRETRAINLINK;
  output CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  output CFGLINKSTATUSBANDWITHSTATUS;
  output CFGLINKSTATUSDLLACTIVE;
  output CFGLINKSTATUSLINKTRAINING;
  output CFGMSGRECEIVED;
  output CFGMSGRECEIVEDASSERTINTA;
  output CFGMSGRECEIVEDASSERTINTB;
  output CFGMSGRECEIVEDASSERTINTC;
  output CFGMSGRECEIVEDASSERTINTD;
  output CFGMSGRECEIVEDDEASSERTINTA;
  output CFGMSGRECEIVEDDEASSERTINTB;
  output CFGMSGRECEIVEDDEASSERTINTC;
  output CFGMSGRECEIVEDDEASSERTINTD;
  output CFGMSGRECEIVEDERRCOR;
  output CFGMSGRECEIVEDERRFATAL;
  output CFGMSGRECEIVEDERRNONFATAL;
  output CFGMSGRECEIVEDPMASNAK;
  output CFGMSGRECEIVEDPMETO;
  output CFGMSGRECEIVEDPMETOACK;
  output CFGMSGRECEIVEDPMPME;
  output CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  output CFGMSGRECEIVEDUNLOCK;
  output CFGPMCSRPMEEN;
  output CFGPMCSRPMESTATUS;
  output CFGPMRCVASREQL1N;
  output CFGPMRCVENTERL1N;
  output CFGPMRCVENTERL23N;
  output CFGPMRCVREQACKN;
  output CFGRDWRDONEN;
  output CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  output CFGTRANSACTION;
  output CFGTRANSACTIONTYPE;
  output DBGSCLRA;
  output DBGSCLRB;
  output DBGSCLRC;
  output DBGSCLRD;
  output DBGSCLRE;
  output DBGSCLRF;
  output DBGSCLRG;
  output DBGSCLRH;
  output DBGSCLRI;
  output DBGSCLRJ;
  output DBGSCLRK;
  output DRPDRDY;
  output LL2BADDLLPERRN;
  output LL2BADTLPERRN;
  output LL2PROTOCOLERRN;
  output LL2REPLAYROERRN;
  output LL2REPLAYTOERRN;
  output LL2SUSPENDOKN;
  output LL2TFCINIT1SEQN;
  output LL2TFCINIT2SEQN;
  output LNKCLKEN;
  output MIMRXRCE;
  output MIMRXREN;
  output MIMRXWEN;
  output MIMTXRCE;
  output MIMTXREN;
  output MIMTXWEN;
  output PIPERX0POLARITY;
  output PIPERX1POLARITY;
  output PIPERX2POLARITY;
  output PIPERX3POLARITY;
  output PIPERX4POLARITY;
  output PIPERX5POLARITY;
  output PIPERX6POLARITY;
  output PIPERX7POLARITY;
  output PIPETX0COMPLIANCE;
  output PIPETX0ELECIDLE;
  output PIPETX1COMPLIANCE;
  output PIPETX1ELECIDLE;
  output PIPETX2COMPLIANCE;
  output PIPETX2ELECIDLE;
  output PIPETX3COMPLIANCE;
  output PIPETX3ELECIDLE;
  output PIPETX4COMPLIANCE;
  output PIPETX4ELECIDLE;
  output PIPETX5COMPLIANCE;
  output PIPETX5ELECIDLE;
  output PIPETX6COMPLIANCE;
  output PIPETX6ELECIDLE;
  output PIPETX7COMPLIANCE;
  output PIPETX7ELECIDLE;
  output PIPETXDEEMPH;
  output PIPETXRATE;
  output PIPETXRCVRDET;
  output PIPETXRESET;
  output PL2LINKUPN;
  output PL2RECEIVERERRN;
  output PL2RECOVERYN;
  output PL2RXELECIDLE;
  output PL2SUSPENDOK;
  output PLLINKGEN2CAP;
  output PLLINKPARTNERGEN2SUPPORTED;
  output PLLINKUPCFGCAP;
  output PLPHYLNKUPN;
  output PLRECEIVEDHOTRST;
  output PLSELLNKRATE;
  output RECEIVEDFUNCLVLRSTN;
  output TL2ASPMSUSPENDCREDITCHECKOKN;
  output TL2ASPMSUSPENDREQN;
  output TL2PPMSUSPENDOKN;
  output TRNLNKUPN;
  output TRNRDLLPSRCRDYN;
  output TRNRECRCERRN;
  output TRNREOFN;
  output TRNRERRFWDN;
  output TRNRREMN;
  output TRNRSOFN;
  output TRNRSRCDSCN;
  output TRNRSRCRDYN;
  output TRNTCFGREQN;
  output TRNTDLLPDSTRDYN;
  output TRNTDSTRDYN;
  output TRNTERRDROPN;
  output USERRSTN;
  output [11:0] DBGVECC;
  output [11:0] PLDBGVEC;
  output [11:0] TRNFCCPLD;
  output [11:0] TRNFCNPD;
  output [11:0] TRNFCPD;
  output [12:0] MIMRXRADDR;
  output [12:0] MIMRXWADDR;
  output [12:0] MIMTXRADDR;
  output [12:0] MIMTXWADDR;
  output [15:0] CFGMSGDATA;
  output [15:0] DRPDO;
  output [15:0] PIPETX0DATA;
  output [15:0] PIPETX1DATA;
  output [15:0] PIPETX2DATA;
  output [15:0] PIPETX3DATA;
  output [15:0] PIPETX4DATA;
  output [15:0] PIPETX5DATA;
  output [15:0] PIPETX6DATA;
  output [15:0] PIPETX7DATA;
  output [1:0] CFGLINKCONTROLASPMCONTROL;
  output [1:0] CFGLINKSTATUSCURRENTSPEED;
  output [1:0] CFGPMCSRPOWERSTATE;
  output [1:0] PIPETX0CHARISK;
  output [1:0] PIPETX0POWERDOWN;
  output [1:0] PIPETX1CHARISK;
  output [1:0] PIPETX1POWERDOWN;
  output [1:0] PIPETX2CHARISK;
  output [1:0] PIPETX2POWERDOWN;
  output [1:0] PIPETX3CHARISK;
  output [1:0] PIPETX3POWERDOWN;
  output [1:0] PIPETX4CHARISK;
  output [1:0] PIPETX4POWERDOWN;
  output [1:0] PIPETX5CHARISK;
  output [1:0] PIPETX5POWERDOWN;
  output [1:0] PIPETX6CHARISK;
  output [1:0] PIPETX6POWERDOWN;
  output [1:0] PIPETX7CHARISK;
  output [1:0] PIPETX7POWERDOWN;
  output [1:0] PLLANEREVERSALMODE;
  output [1:0] PLRXPMSTATE;
  output [1:0] PLSELLNKWIDTH;
  output [2:0] CFGDEVCONTROLMAXPAYLOAD;
  output [2:0] CFGDEVCONTROLMAXREADREQ;
  output [2:0] CFGINTERRUPTMMENABLE;
  output [2:0] CFGPCIELINKSTATE;
  output [2:0] PIPETXMARGIN;
  output [2:0] PLINITIALLINKWIDTH;
  output [2:0] PLTXPMSTATE;
  output [31:0] CFGDO;
  output [31:0] TRNRDLLPDATA;
  output [3:0] CFGDEVCONTROL2CPLTIMEOUTVAL;
  output [3:0] CFGLINKSTATUSNEGOTIATEDWIDTH;
  output [5:0] PLLTSSMSTATE;
  output [5:0] TRNTBUFAV;
  output [63:0] DBGVECA;
  output [63:0] DBGVECB;
  output [63:0] TRNRD;
  output [67:0] MIMRXWDATA;
  output [68:0] MIMTXWDATA;
  output [6:0] CFGTRANSACTIONADDR;
  output [6:0] CFGVCTCVCMAP;
  output [6:0] TRNRBARHITN;
  output [7:0] CFGINTERRUPTDO;
  output [7:0] TRNFCCPLH;
  output [7:0] TRNFCNPH;
  output [7:0] TRNFCPH;

  input CFGERRACSN;
  input CFGERRCORN;
  input CFGERRCPLABORTN;
  input CFGERRCPLTIMEOUTN;
  input CFGERRCPLUNEXPECTN;
  input CFGERRECRCN;
  input CFGERRLOCKEDN;
  input CFGERRPOSTEDN;
  input CFGERRURN;
  input CFGINTERRUPTASSERTN;
  input CFGINTERRUPTN;
  input CFGPMDIRECTASPML1N;
  input CFGPMSENDPMACKN;
  input CFGPMSENDPMETON;
  input CFGPMSENDPMNAKN;
  input CFGPMTURNOFFOKN;
  input CFGPMWAKEN;
  input CFGRDENN;
  input CFGTRNPENDINGN;
  input CFGWRENN;
  input CFGWRREADONLYN;
  input CFGWRRW1CASRWN;
  input CMRSTN;
  input CMSTICKYRSTN;
  input DBGSUBMODE;
  input DLRSTN;
  input DRPCLK;
  input DRPDEN;
  input DRPDWE;
  input FUNCLVLRSTN;
  input LL2SENDASREQL1N;
  input LL2SENDENTERL1N;
  input LL2SENDENTERL23N;
  input LL2SUSPENDNOWN;
  input LL2TLPRCVN;
  input PIPECLK;
  input PIPERX0CHANISALIGNED;
  input PIPERX0ELECIDLE;
  input PIPERX0PHYSTATUS;
  input PIPERX0VALID;
  input PIPERX1CHANISALIGNED;
  input PIPERX1ELECIDLE;
  input PIPERX1PHYSTATUS;
  input PIPERX1VALID;
  input PIPERX2CHANISALIGNED;
  input PIPERX2ELECIDLE;
  input PIPERX2PHYSTATUS;
  input PIPERX2VALID;
  input PIPERX3CHANISALIGNED;
  input PIPERX3ELECIDLE;
  input PIPERX3PHYSTATUS;
  input PIPERX3VALID;
  input PIPERX4CHANISALIGNED;
  input PIPERX4ELECIDLE;
  input PIPERX4PHYSTATUS;
  input PIPERX4VALID;
  input PIPERX5CHANISALIGNED;
  input PIPERX5ELECIDLE;
  input PIPERX5PHYSTATUS;
  input PIPERX5VALID;
  input PIPERX6CHANISALIGNED;
  input PIPERX6ELECIDLE;
  input PIPERX6PHYSTATUS;
  input PIPERX6VALID;
  input PIPERX7CHANISALIGNED;
  input PIPERX7ELECIDLE;
  input PIPERX7PHYSTATUS;
  input PIPERX7VALID;
  input PLDIRECTEDLINKAUTON;
  input PLDIRECTEDLINKSPEED;
  input PLDOWNSTREAMDEEMPHSOURCE;
  input PLRSTN;
  input PLTRANSMITHOTRST;
  input PLUPSTREAMPREFERDEEMPH;
  input SYSRSTN;
  input TL2ASPMSUSPENDCREDITCHECKN;
  input TL2PPMSUSPENDREQN;
  input TLRSTN;
  input TRNRDSTRDYN;
  input TRNRNPOKN;
  input TRNTCFGGNTN;
  input TRNTDLLPSRCRDYN;
  input TRNTECRCGENN;
  input TRNTEOFN;
  input TRNTERRFWDN;
  input TRNTREMN;
  input TRNTSOFN;
  input TRNTSRCDSCN;
  input TRNTSRCRDYN;
  input TRNTSTRN;
  input USERCLK;
  input [127:0] CFGERRAERHEADERLOG;
  input [15:0] DRPDI;
  input [15:0] PIPERX0DATA;
  input [15:0] PIPERX1DATA;
  input [15:0] PIPERX2DATA;
  input [15:0] PIPERX3DATA;
  input [15:0] PIPERX4DATA;
  input [15:0] PIPERX5DATA;
  input [15:0] PIPERX6DATA;
  input [15:0] PIPERX7DATA;
  input [1:0] DBGMODE;
  input [1:0] PIPERX0CHARISK;
  input [1:0] PIPERX1CHARISK;
  input [1:0] PIPERX2CHARISK;
  input [1:0] PIPERX3CHARISK;
  input [1:0] PIPERX4CHARISK;
  input [1:0] PIPERX5CHARISK;
  input [1:0] PIPERX6CHARISK;
  input [1:0] PIPERX7CHARISK;
  input [1:0] PLDIRECTEDLINKCHANGE;
  input [1:0] PLDIRECTEDLINKWIDTH;
  input [2:0] CFGDSFUNCTIONNUMBER;
  input [2:0] PIPERX0STATUS;
  input [2:0] PIPERX1STATUS;
  input [2:0] PIPERX2STATUS;
  input [2:0] PIPERX3STATUS;
  input [2:0] PIPERX4STATUS;
  input [2:0] PIPERX5STATUS;
  input [2:0] PIPERX6STATUS;
  input [2:0] PIPERX7STATUS;
  input [2:0] PLDBGMODE;
  input [2:0] TRNFCSEL;
  input [31:0] CFGDI;
  input [31:0] TRNTDLLPDATA;
  input [3:0] CFGBYTEENN;
  input [47:0] CFGERRTLPCPLHEADER;
  input [4:0] CFGDSDEVICENUMBER;
  input [4:0] PL2DIRECTEDLSTATE;
  input [63:0] CFGDSN;
  input [63:0] TRNTD;
  input [67:0] MIMRXRDATA;
  input [68:0] MIMTXRDATA;
  input [7:0] CFGDSBUSNUMBER;
  input [7:0] CFGINTERRUPTDI;
  input [7:0] CFGPORTNUMBER;
  input [8:0] DRPDADDR;
  input [9:0] CFGDWADDR;

  reg AER_CAP_ECRC_CHECK_CAPABLE_BINARY;
  reg AER_CAP_ECRC_GEN_CAPABLE_BINARY;
  reg AER_CAP_ON_BINARY;
  reg AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY;
  reg ALLOW_X8_GEN2_BINARY;
  reg CMD_INTX_IMPLEMENTED_BINARY;
  reg CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY;
  reg DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY;
  reg DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY;
  reg DEV_CAP_EXT_TAG_SUPPORTED_BINARY;
  reg DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY;
  reg DEV_CAP_ROLE_BASED_ERROR_BINARY;
  reg DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY;
  reg DISABLE_ASPM_L1_TIMER_BINARY;
  reg DISABLE_BAR_FILTERING_BINARY;
  reg DISABLE_ID_CHECK_BINARY;
  reg DISABLE_LANE_REVERSAL_BINARY;
  reg DISABLE_RX_TC_FILTER_BINARY;
  reg DISABLE_SCRAMBLING_BINARY;
  reg DSN_CAP_ON_BINARY;
  reg ENABLE_RX_TD_ECRC_TRIM_BINARY;
  reg ENTER_RVRY_EI_L0_BINARY;
  reg EXIT_LOOPBACK_ON_EI_BINARY;
  reg IS_SWITCH_BINARY;
  reg LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY;
  reg LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY;
  reg LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY;
  reg LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY;
  reg LINK_CONTROL_RCB_BINARY;
  reg LINK_CTRL2_DEEMPHASIS_BINARY;
  reg LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY;
  reg LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY;
  reg LL_ACK_TIMEOUT_EN_BINARY;
  reg LL_REPLAY_TIMEOUT_EN_BINARY;
  reg MSIX_CAP_ON_BINARY;
  reg MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY;
  reg MSI_CAP_MULTIMSG_EXTENSION_BINARY;
  reg MSI_CAP_ON_BINARY;
  reg MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY;
  reg PCIE_CAP_ON_BINARY;
  reg PCIE_CAP_SLOT_IMPLEMENTED_BINARY;
  reg PL_FAST_TRAIN_BINARY;
  reg PM_CAP_D1SUPPORT_BINARY;
  reg PM_CAP_D2SUPPORT_BINARY;
  reg PM_CAP_DSI_BINARY;
  reg PM_CAP_ON_BINARY;
  reg PM_CAP_PME_CLOCK_BINARY;
  reg PM_CAP_RSVD_04_BINARY;
  reg PM_CSR_B2B3_BINARY;
  reg PM_CSR_BPCCEN_BINARY;
  reg PM_CSR_NOSOFTRST_BINARY;
  reg RECRC_CHK_TRIM_BINARY;
  reg ROOT_CAP_CRS_SW_VISIBILITY_BINARY;
  reg SELECT_DLL_IF_BINARY;
  reg SIM_VERSION_BINARY;
  reg SLOT_CAP_ATT_BUTTON_PRESENT_BINARY;
  reg SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY;
  reg SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY;
  reg SLOT_CAP_HOTPLUG_CAPABLE_BINARY;
  reg SLOT_CAP_HOTPLUG_SURPRISE_BINARY;
  reg SLOT_CAP_MRL_SENSOR_PRESENT_BINARY;
  reg SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY;
  reg SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY;
  reg SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY;
  reg SPARE_BIT0_BINARY;
  reg SPARE_BIT1_BINARY;
  reg SPARE_BIT2_BINARY;
  reg SPARE_BIT3_BINARY;
  reg SPARE_BIT4_BINARY;
  reg SPARE_BIT5_BINARY;
  reg SPARE_BIT6_BINARY;
  reg SPARE_BIT7_BINARY;
  reg SPARE_BIT8_BINARY;
  reg TL_RBYPASS_BINARY;
  reg TL_RX_RAM_RADDR_LATENCY_BINARY;
  reg TL_RX_RAM_WRITE_LATENCY_BINARY;
  reg TL_TFC_DISABLE_BINARY;
  reg TL_TX_CHECKS_DISABLE_BINARY;
  reg TL_TX_RAM_RADDR_LATENCY_BINARY;
  reg TL_TX_RAM_WRITE_LATENCY_BINARY;
  reg UPCONFIG_CAPABLE_BINARY;
  reg UPSTREAM_FACING_BINARY;
  reg UR_INV_REQ_BINARY;
  reg VC0_CPL_INFINITE_BINARY;
  reg VC_CAP_ON_BINARY;
  reg VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY;
  reg VSEC_CAP_IS_LINK_VISIBLE_BINARY;
  reg VSEC_CAP_ON_BINARY;
  reg [10:0] VC0_TOTAL_CREDITS_CD_BINARY;
  reg [10:0] VC0_TOTAL_CREDITS_PD_BINARY;
  reg [1:0] DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY;
  reg [1:0] DEV_CAP_RSVD_17_16_BINARY;
  reg [1:0] LINK_CAP_ASPM_SUPPORT_BINARY;
  reg [1:0] LINK_CAP_RSVD_23_22_BINARY;
  reg [1:0] LL_ACK_TIMEOUT_FUNC_BINARY;
  reg [1:0] LL_REPLAY_TIMEOUT_FUNC_BINARY;
  reg [1:0] PCIE_CAP_RSVD_15_14_BINARY;
  reg [1:0] RECRC_CHK_BINARY;
  reg [1:0] SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY;
  reg [1:0] TL_RX_RAM_RDATA_LATENCY_BINARY;
  reg [1:0] TL_TX_RAM_RDATA_LATENCY_BINARY;
  reg [2:0] DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY;
  reg [2:0] DEV_CAP_ENDPOINT_L1_LATENCY_BINARY;
  reg [2:0] DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY;
  reg [2:0] DEV_CAP_RSVD_14_12_BINARY;
  reg [2:0] DEV_CAP_RSVD_31_29_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY;
  reg [2:0] LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY;
  reg [2:0] LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY;
  reg [2:0] MSIX_CAP_PBA_BIR_BINARY;
  reg [2:0] MSIX_CAP_TABLE_BIR_BINARY;
  reg [2:0] MSI_CAP_MULTIMSGCAP_BINARY;
  reg [2:0] PGL0_LANE_BINARY;
  reg [2:0] PGL1_LANE_BINARY;
  reg [2:0] PGL2_LANE_BINARY;
  reg [2:0] PGL3_LANE_BINARY;
  reg [2:0] PGL4_LANE_BINARY;
  reg [2:0] PGL5_LANE_BINARY;
  reg [2:0] PGL6_LANE_BINARY;
  reg [2:0] PGL7_LANE_BINARY;
  reg [2:0] PL_AUTO_CONFIG_BINARY;
  reg [2:0] PM_CAP_AUXCURRENT_BINARY;
  reg [2:0] PM_CAP_VERSION_BINARY;
  reg [2:0] USER_CLK_FREQ_BINARY;
  reg [3:0] PCIE_REVISION_BINARY;
  reg [4:0] VC0_TX_LASTPACKET_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_CH_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_NPH_BINARY;
  reg [6:0] VC0_TOTAL_CREDITS_PH_BINARY;
  reg [7:0] N_FTS_COMCLK_GEN1_BINARY;
  reg [7:0] N_FTS_COMCLK_GEN2_BINARY;
  reg [7:0] N_FTS_GEN1_BINARY;
  reg [7:0] N_FTS_GEN2_BINARY;

  tri0 GSR = glbl.GSR;
  reg notifier;

  wire CFGAERECRCCHECKEN_OUT;
  wire CFGAERECRCGENEN_OUT;
  wire CFGCOMMANDBUSMASTERENABLE_OUT;
  wire CFGCOMMANDINTERRUPTDISABLE_OUT;
  wire CFGCOMMANDIOENABLE_OUT;
  wire CFGCOMMANDMEMENABLE_OUT;
  wire CFGCOMMANDSERREN_OUT;
  wire CFGDEVCONTROL2CPLTIMEOUTDIS_OUT;
  wire CFGDEVCONTROLAUXPOWEREN_OUT;
  wire CFGDEVCONTROLCORRERRREPORTINGEN_OUT;
  wire CFGDEVCONTROLENABLERO_OUT;
  wire CFGDEVCONTROLEXTTAGEN_OUT;
  wire CFGDEVCONTROLFATALERRREPORTINGEN_OUT;
  wire CFGDEVCONTROLNONFATALREPORTINGEN_OUT;
  wire CFGDEVCONTROLNOSNOOPEN_OUT;
  wire CFGDEVCONTROLPHANTOMEN_OUT;
  wire CFGDEVCONTROLURERRREPORTINGEN_OUT;
  wire CFGDEVSTATUSCORRERRDETECTED_OUT;
  wire CFGDEVSTATUSFATALERRDETECTED_OUT;
  wire CFGDEVSTATUSNONFATALERRDETECTED_OUT;
  wire CFGDEVSTATUSURDETECTED_OUT;
  wire CFGERRAERHEADERLOGSETN_OUT;
  wire CFGERRCPLRDYN_OUT;
  wire CFGINTERRUPTMSIENABLE_OUT;
  wire CFGINTERRUPTMSIXENABLE_OUT;
  wire CFGINTERRUPTMSIXFM_OUT;
  wire CFGINTERRUPTRDYN_OUT;
  wire CFGLINKCONTROLAUTOBANDWIDTHINTEN_OUT;
  wire CFGLINKCONTROLBANDWIDTHINTEN_OUT;
  wire CFGLINKCONTROLCLOCKPMEN_OUT;
  wire CFGLINKCONTROLCOMMONCLOCK_OUT;
  wire CFGLINKCONTROLEXTENDEDSYNC_OUT;
  wire CFGLINKCONTROLHWAUTOWIDTHDIS_OUT;
  wire CFGLINKCONTROLLINKDISABLE_OUT;
  wire CFGLINKCONTROLRCB_OUT;
  wire CFGLINKCONTROLRETRAINLINK_OUT;
  wire CFGLINKSTATUSAUTOBANDWIDTHSTATUS_OUT;
  wire CFGLINKSTATUSBANDWITHSTATUS_OUT;
  wire CFGLINKSTATUSDLLACTIVE_OUT;
  wire CFGLINKSTATUSLINKTRAINING_OUT;
  wire CFGMSGRECEIVEDASSERTINTA_OUT;
  wire CFGMSGRECEIVEDASSERTINTB_OUT;
  wire CFGMSGRECEIVEDASSERTINTC_OUT;
  wire CFGMSGRECEIVEDASSERTINTD_OUT;
  wire CFGMSGRECEIVEDDEASSERTINTA_OUT;
  wire CFGMSGRECEIVEDDEASSERTINTB_OUT;
  wire CFGMSGRECEIVEDDEASSERTINTC_OUT;
  wire CFGMSGRECEIVEDDEASSERTINTD_OUT;
  wire CFGMSGRECEIVEDERRCOR_OUT;
  wire CFGMSGRECEIVEDERRFATAL_OUT;
  wire CFGMSGRECEIVEDERRNONFATAL_OUT;
  wire CFGMSGRECEIVEDPMASNAK_OUT;
  wire CFGMSGRECEIVEDPMETOACK_OUT;
  wire CFGMSGRECEIVEDPMETO_OUT;
  wire CFGMSGRECEIVEDPMPME_OUT;
  wire CFGMSGRECEIVEDSETSLOTPOWERLIMIT_OUT;
  wire CFGMSGRECEIVEDUNLOCK_OUT;
  wire CFGMSGRECEIVED_OUT;
  wire CFGPMCSRPMEEN_OUT;
  wire CFGPMCSRPMESTATUS_OUT;
  wire CFGPMRCVASREQL1N_OUT;
  wire CFGPMRCVENTERL1N_OUT;
  wire CFGPMRCVENTERL23N_OUT;
  wire CFGPMRCVREQACKN_OUT;
  wire CFGRDWRDONEN_OUT;
  wire CFGSLOTCONTROLELECTROMECHILCTLPULSE_OUT;
  wire CFGTRANSACTIONTYPE_OUT;
  wire CFGTRANSACTION_OUT;
  wire DBGSCLRA_OUT;
  wire DBGSCLRB_OUT;
  wire DBGSCLRC_OUT;
  wire DBGSCLRD_OUT;
  wire DBGSCLRE_OUT;
  wire DBGSCLRF_OUT;
  wire DBGSCLRG_OUT;
  wire DBGSCLRH_OUT;
  wire DBGSCLRI_OUT;
  wire DBGSCLRJ_OUT;
  wire DBGSCLRK_OUT;
  wire DRPDRDY_OUT;
  wire LL2BADDLLPERRN_OUT;
  wire LL2BADTLPERRN_OUT;
  wire LL2PROTOCOLERRN_OUT;
  wire LL2REPLAYROERRN_OUT;
  wire LL2REPLAYTOERRN_OUT;
  wire LL2SUSPENDOKN_OUT;
  wire LL2TFCINIT1SEQN_OUT;
  wire LL2TFCINIT2SEQN_OUT;
  wire LNKCLKEN_OUT;
  wire MIMRXRCE_OUT;
  wire MIMRXREN_OUT;
  wire MIMRXWEN_OUT;
  wire MIMTXRCE_OUT;
  wire MIMTXREN_OUT;
  wire MIMTXWEN_OUT;
  wire PIPERX0POLARITY_OUT;
  wire PIPERX1POLARITY_OUT;
  wire PIPERX2POLARITY_OUT;
  wire PIPERX3POLARITY_OUT;
  wire PIPERX4POLARITY_OUT;
  wire PIPERX5POLARITY_OUT;
  wire PIPERX6POLARITY_OUT;
  wire PIPERX7POLARITY_OUT;
  wire PIPETX0COMPLIANCE_OUT;
  wire PIPETX0ELECIDLE_OUT;
  wire PIPETX1COMPLIANCE_OUT;
  wire PIPETX1ELECIDLE_OUT;
  wire PIPETX2COMPLIANCE_OUT;
  wire PIPETX2ELECIDLE_OUT;
  wire PIPETX3COMPLIANCE_OUT;
  wire PIPETX3ELECIDLE_OUT;
  wire PIPETX4COMPLIANCE_OUT;
  wire PIPETX4ELECIDLE_OUT;
  wire PIPETX5COMPLIANCE_OUT;
  wire PIPETX5ELECIDLE_OUT;
  wire PIPETX6COMPLIANCE_OUT;
  wire PIPETX6ELECIDLE_OUT;
  wire PIPETX7COMPLIANCE_OUT;
  wire PIPETX7ELECIDLE_OUT;
  wire PIPETXDEEMPH_OUT;
  wire PIPETXRATE_OUT;
  wire PIPETXRCVRDET_OUT;
  wire PIPETXRESET_OUT;
  wire PL2LINKUPN_OUT;
  wire PL2RECEIVERERRN_OUT;
  wire PL2RECOVERYN_OUT;
  wire PL2RXELECIDLE_OUT;
  wire PL2SUSPENDOK_OUT;
  wire PLLINKGEN2CAP_OUT;
  wire PLLINKPARTNERGEN2SUPPORTED_OUT;
  wire PLLINKUPCFGCAP_OUT;
  wire PLPHYLNKUPN_OUT;
  wire PLRECEIVEDHOTRST_OUT;
  wire PLSELLNKRATE_OUT;
  wire RECEIVEDFUNCLVLRSTN_OUT;
  wire TL2ASPMSUSPENDCREDITCHECKOKN_OUT;
  wire TL2ASPMSUSPENDREQN_OUT;
  wire TL2PPMSUSPENDOKN_OUT;
  wire TRNLNKUPN_OUT;
  wire TRNRDLLPSRCRDYN_OUT;
  wire TRNRECRCERRN_OUT;
  wire TRNREOFN_OUT;
  wire TRNRERRFWDN_OUT;
  wire TRNRREMN_OUT;
  wire TRNRSOFN_OUT;
  wire TRNRSRCDSCN_OUT;
  wire TRNRSRCRDYN_OUT;
  wire TRNTCFGREQN_OUT;
  wire TRNTDLLPDSTRDYN_OUT;
  wire TRNTDSTRDYN_OUT;
  wire TRNTERRDROPN_OUT;
  wire USERRSTN_OUT;
  wire [11:0] DBGVECC_OUT;
  wire [11:0] PLDBGVEC_OUT;
  wire [11:0] TRNFCCPLD_OUT;
  wire [11:0] TRNFCNPD_OUT;
  wire [11:0] TRNFCPD_OUT;
  wire [12:0] MIMRXRADDR_OUT;
  wire [12:0] MIMRXWADDR_OUT;
  wire [12:0] MIMTXRADDR_OUT;
  wire [12:0] MIMTXWADDR_OUT;
  wire [15:0] CFGMSGDATA_OUT;
  wire [15:0] DRPDO_OUT;
  wire [15:0] PIPETX0DATA_OUT;
  wire [15:0] PIPETX1DATA_OUT;
  wire [15:0] PIPETX2DATA_OUT;
  wire [15:0] PIPETX3DATA_OUT;
  wire [15:0] PIPETX4DATA_OUT;
  wire [15:0] PIPETX5DATA_OUT;
  wire [15:0] PIPETX6DATA_OUT;
  wire [15:0] PIPETX7DATA_OUT;
  wire [1:0] CFGLINKCONTROLASPMCONTROL_OUT;
  wire [1:0] CFGLINKSTATUSCURRENTSPEED_OUT;
  wire [1:0] CFGPMCSRPOWERSTATE_OUT;
  wire [1:0] PIPETX0CHARISK_OUT;
  wire [1:0] PIPETX0POWERDOWN_OUT;
  wire [1:0] PIPETX1CHARISK_OUT;
  wire [1:0] PIPETX1POWERDOWN_OUT;
  wire [1:0] PIPETX2CHARISK_OUT;
  wire [1:0] PIPETX2POWERDOWN_OUT;
  wire [1:0] PIPETX3CHARISK_OUT;
  wire [1:0] PIPETX3POWERDOWN_OUT;
  wire [1:0] PIPETX4CHARISK_OUT;
  wire [1:0] PIPETX4POWERDOWN_OUT;
  wire [1:0] PIPETX5CHARISK_OUT;
  wire [1:0] PIPETX5POWERDOWN_OUT;
  wire [1:0] PIPETX6CHARISK_OUT;
  wire [1:0] PIPETX6POWERDOWN_OUT;
  wire [1:0] PIPETX7CHARISK_OUT;
  wire [1:0] PIPETX7POWERDOWN_OUT;
  wire [1:0] PLLANEREVERSALMODE_OUT;
  wire [1:0] PLRXPMSTATE_OUT;
  wire [1:0] PLSELLNKWIDTH_OUT;
  wire [2:0] CFGDEVCONTROLMAXPAYLOAD_OUT;
  wire [2:0] CFGDEVCONTROLMAXREADREQ_OUT;
  wire [2:0] CFGINTERRUPTMMENABLE_OUT;
  wire [2:0] CFGPCIELINKSTATE_OUT;
  wire [2:0] PIPETXMARGIN_OUT;
  wire [2:0] PLINITIALLINKWIDTH_OUT;
  wire [2:0] PLTXPMSTATE_OUT;
  wire [31:0] CFGDO_OUT;
  wire [31:0] TRNRDLLPDATA_OUT;
  wire [3:0] CFGDEVCONTROL2CPLTIMEOUTVAL_OUT;
  wire [3:0] CFGLINKSTATUSNEGOTIATEDWIDTH_OUT;
  wire [5:0] PLLTSSMSTATE_OUT;
  wire [5:0] TRNTBUFAV_OUT;
  wire [63:0] DBGVECA_OUT;
  wire [63:0] DBGVECB_OUT;
  wire [63:0] TRNRD_OUT;
  wire [67:0] MIMRXWDATA_OUT;
  wire [68:0] MIMTXWDATA_OUT;
  wire [6:0] CFGTRANSACTIONADDR_OUT;
  wire [6:0] CFGVCTCVCMAP_OUT;
  wire [6:0] TRNRBARHITN_OUT;
  wire [7:0] CFGINTERRUPTDO_OUT;
  wire [7:0] TRNFCCPLH_OUT;
  wire [7:0] TRNFCNPH_OUT;
  wire [7:0] TRNFCPH_OUT;

  wire CFGERRACSN_IN;
  wire CFGERRCORN_IN;
  wire CFGERRCPLABORTN_IN;
  wire CFGERRCPLTIMEOUTN_IN;
  wire CFGERRCPLUNEXPECTN_IN;
  wire CFGERRECRCN_IN;
  wire CFGERRLOCKEDN_IN;
  wire CFGERRPOSTEDN_IN;
  wire CFGERRURN_IN;
  wire CFGINTERRUPTASSERTN_IN;
  wire CFGINTERRUPTN_IN;
  wire CFGPMDIRECTASPML1N_IN;
  wire CFGPMSENDPMACKN_IN;
  wire CFGPMSENDPMETON_IN;
  wire CFGPMSENDPMNAKN_IN;
  wire CFGPMTURNOFFOKN_IN;
  wire CFGPMWAKEN_IN;
  wire CFGRDENN_IN;
  wire CFGTRNPENDINGN_IN;
  wire CFGWRENN_IN;
  wire CFGWRREADONLYN_IN;
  wire CFGWRRW1CASRWN_IN;
  wire CMRSTN_IN;
  wire CMSTICKYRSTN_IN;
  wire DBGSUBMODE_IN;
  wire DLRSTN_IN;
  wire DRPCLK_IN;
  wire DRPDEN_IN;
  wire DRPDWE_IN;
  wire FUNCLVLRSTN_IN;
  wire LL2SENDASREQL1N_IN;
  wire LL2SENDENTERL1N_IN;
  wire LL2SENDENTERL23N_IN;
  wire LL2SUSPENDNOWN_IN;
  wire LL2TLPRCVN_IN;
  wire PIPECLK_IN;
  wire PIPERX0CHANISALIGNED_IN;
  wire PIPERX0ELECIDLE_IN;
  wire PIPERX0PHYSTATUS_IN;
  wire PIPERX0VALID_IN;
  wire PIPERX1CHANISALIGNED_IN;
  wire PIPERX1ELECIDLE_IN;
  wire PIPERX1PHYSTATUS_IN;
  wire PIPERX1VALID_IN;
  wire PIPERX2CHANISALIGNED_IN;
  wire PIPERX2ELECIDLE_IN;
  wire PIPERX2PHYSTATUS_IN;
  wire PIPERX2VALID_IN;
  wire PIPERX3CHANISALIGNED_IN;
  wire PIPERX3ELECIDLE_IN;
  wire PIPERX3PHYSTATUS_IN;
  wire PIPERX3VALID_IN;
  wire PIPERX4CHANISALIGNED_IN;
  wire PIPERX4ELECIDLE_IN;
  wire PIPERX4PHYSTATUS_IN;
  wire PIPERX4VALID_IN;
  wire PIPERX5CHANISALIGNED_IN;
  wire PIPERX5ELECIDLE_IN;
  wire PIPERX5PHYSTATUS_IN;
  wire PIPERX5VALID_IN;
  wire PIPERX6CHANISALIGNED_IN;
  wire PIPERX6ELECIDLE_IN;
  wire PIPERX6PHYSTATUS_IN;
  wire PIPERX6VALID_IN;
  wire PIPERX7CHANISALIGNED_IN;
  wire PIPERX7ELECIDLE_IN;
  wire PIPERX7PHYSTATUS_IN;
  wire PIPERX7VALID_IN;
  wire PLDIRECTEDLINKAUTON_IN;
  wire PLDIRECTEDLINKSPEED_IN;
  wire PLDOWNSTREAMDEEMPHSOURCE_IN;
  wire PLRSTN_IN;
  wire PLTRANSMITHOTRST_IN;
  wire PLUPSTREAMPREFERDEEMPH_IN;
  wire SYSRSTN_IN;
  wire TL2ASPMSUSPENDCREDITCHECKN_IN;
  wire TL2PPMSUSPENDREQN_IN;
  wire TLRSTN_IN;
  wire TRNRDSTRDYN_IN;
  wire TRNRNPOKN_IN;
  wire TRNTCFGGNTN_IN;
  wire TRNTDLLPSRCRDYN_IN;
  wire TRNTECRCGENN_IN;
  wire TRNTEOFN_IN;
  wire TRNTERRFWDN_IN;
  wire TRNTREMN_IN;
  wire TRNTSOFN_IN;
  wire TRNTSRCDSCN_IN;
  wire TRNTSRCRDYN_IN;
  wire TRNTSTRN_IN;
  wire USERCLK_IN;
  wire [127:0] CFGERRAERHEADERLOG_IN;
  wire [15:0] DRPDI_IN;
  wire [15:0] PIPERX0DATA_IN;
  wire [15:0] PIPERX1DATA_IN;
  wire [15:0] PIPERX2DATA_IN;
  wire [15:0] PIPERX3DATA_IN;
  wire [15:0] PIPERX4DATA_IN;
  wire [15:0] PIPERX5DATA_IN;
  wire [15:0] PIPERX6DATA_IN;
  wire [15:0] PIPERX7DATA_IN;
  wire [1:0] DBGMODE_IN;
  wire [1:0] PIPERX0CHARISK_IN;
  wire [1:0] PIPERX1CHARISK_IN;
  wire [1:0] PIPERX2CHARISK_IN;
  wire [1:0] PIPERX3CHARISK_IN;
  wire [1:0] PIPERX4CHARISK_IN;
  wire [1:0] PIPERX5CHARISK_IN;
  wire [1:0] PIPERX6CHARISK_IN;
  wire [1:0] PIPERX7CHARISK_IN;
  wire [1:0] PLDIRECTEDLINKCHANGE_IN;
  wire [1:0] PLDIRECTEDLINKWIDTH_IN;
  wire [2:0] CFGDSFUNCTIONNUMBER_IN;
  wire [2:0] PIPERX0STATUS_IN;
  wire [2:0] PIPERX1STATUS_IN;
  wire [2:0] PIPERX2STATUS_IN;
  wire [2:0] PIPERX3STATUS_IN;
  wire [2:0] PIPERX4STATUS_IN;
  wire [2:0] PIPERX5STATUS_IN;
  wire [2:0] PIPERX6STATUS_IN;
  wire [2:0] PIPERX7STATUS_IN;
  wire [2:0] PLDBGMODE_IN;
  wire [2:0] TRNFCSEL_IN;
  wire [31:0] CFGDI_IN;
  wire [31:0] TRNTDLLPDATA_IN;
  wire [3:0] CFGBYTEENN_IN;
  wire [47:0] CFGERRTLPCPLHEADER_IN;
  wire [4:0] CFGDSDEVICENUMBER_IN;
  wire [4:0] PL2DIRECTEDLSTATE_IN;
  wire [63:0] CFGDSN_IN;
  wire [63:0] TRNTD_IN;
  wire [67:0] MIMRXRDATA_IN;
  wire [68:0] MIMTXRDATA_IN;
  wire [7:0] CFGDSBUSNUMBER_IN;
  wire [7:0] CFGINTERRUPTDI_IN;
  wire [7:0] CFGPORTNUMBER_IN;
  wire [8:0] DRPDADDR_IN;
  wire [9:0] CFGDWADDR_IN;
  wire CFGERRACSN_INDELAY;
  wire CFGERRCORN_INDELAY;
  wire CFGERRCPLABORTN_INDELAY;
  wire CFGERRCPLTIMEOUTN_INDELAY;
  wire CFGERRCPLUNEXPECTN_INDELAY;
  wire CFGERRECRCN_INDELAY;
  wire CFGERRLOCKEDN_INDELAY;
  wire CFGERRPOSTEDN_INDELAY;
  wire CFGERRURN_INDELAY;
  wire CFGINTERRUPTASSERTN_INDELAY;
  wire CFGINTERRUPTN_INDELAY;
  wire CFGPMDIRECTASPML1N_INDELAY;
  wire CFGPMSENDPMACKN_INDELAY;
  wire CFGPMSENDPMETON_INDELAY;
  wire CFGPMSENDPMNAKN_INDELAY;
  wire CFGPMTURNOFFOKN_INDELAY;
  wire CFGPMWAKEN_INDELAY;
  wire CFGRDENN_INDELAY;
  wire CFGTRNPENDINGN_INDELAY;
  wire CFGWRENN_INDELAY;
  wire CFGWRREADONLYN_INDELAY;
  wire CFGWRRW1CASRWN_INDELAY;
  wire CMRSTN_INDELAY;
  wire CMSTICKYRSTN_INDELAY;
  wire DBGSUBMODE_INDELAY;
  wire DLRSTN_INDELAY;
  wire DRPCLK_INDELAY;
  wire DRPDEN_INDELAY;
  wire DRPDWE_INDELAY;
  wire FUNCLVLRSTN_INDELAY;
  wire LL2SENDASREQL1N_INDELAY;
  wire LL2SENDENTERL1N_INDELAY;
  wire LL2SENDENTERL23N_INDELAY;
  wire LL2SUSPENDNOWN_INDELAY;
  wire LL2TLPRCVN_INDELAY;
  wire PIPECLK_INDELAY;
  wire PIPERX0CHANISALIGNED_INDELAY;
  wire PIPERX0ELECIDLE_INDELAY;
  wire PIPERX0PHYSTATUS_INDELAY;
  wire PIPERX0VALID_INDELAY;
  wire PIPERX1CHANISALIGNED_INDELAY;
  wire PIPERX1ELECIDLE_INDELAY;
  wire PIPERX1PHYSTATUS_INDELAY;
  wire PIPERX1VALID_INDELAY;
  wire PIPERX2CHANISALIGNED_INDELAY;
  wire PIPERX2ELECIDLE_INDELAY;
  wire PIPERX2PHYSTATUS_INDELAY;
  wire PIPERX2VALID_INDELAY;
  wire PIPERX3CHANISALIGNED_INDELAY;
  wire PIPERX3ELECIDLE_INDELAY;
  wire PIPERX3PHYSTATUS_INDELAY;
  wire PIPERX3VALID_INDELAY;
  wire PIPERX4CHANISALIGNED_INDELAY;
  wire PIPERX4ELECIDLE_INDELAY;
  wire PIPERX4PHYSTATUS_INDELAY;
  wire PIPERX4VALID_INDELAY;
  wire PIPERX5CHANISALIGNED_INDELAY;
  wire PIPERX5ELECIDLE_INDELAY;
  wire PIPERX5PHYSTATUS_INDELAY;
  wire PIPERX5VALID_INDELAY;
  wire PIPERX6CHANISALIGNED_INDELAY;
  wire PIPERX6ELECIDLE_INDELAY;
  wire PIPERX6PHYSTATUS_INDELAY;
  wire PIPERX6VALID_INDELAY;
  wire PIPERX7CHANISALIGNED_INDELAY;
  wire PIPERX7ELECIDLE_INDELAY;
  wire PIPERX7PHYSTATUS_INDELAY;
  wire PIPERX7VALID_INDELAY;
  wire PLDIRECTEDLINKAUTON_INDELAY;
  wire PLDIRECTEDLINKSPEED_INDELAY;
  wire PLDOWNSTREAMDEEMPHSOURCE_INDELAY;
  wire PLRSTN_INDELAY;
  wire PLTRANSMITHOTRST_INDELAY;
  wire PLUPSTREAMPREFERDEEMPH_INDELAY;
  wire SYSRSTN_INDELAY;
  wire TL2ASPMSUSPENDCREDITCHECKN_INDELAY;
  wire TL2PPMSUSPENDREQN_INDELAY;
  wire TLRSTN_INDELAY;
  wire TRNRDSTRDYN_INDELAY;
  wire TRNRNPOKN_INDELAY;
  wire TRNTCFGGNTN_INDELAY;
  wire TRNTDLLPSRCRDYN_INDELAY;
  wire TRNTECRCGENN_INDELAY;
  wire TRNTEOFN_INDELAY;
  wire TRNTERRFWDN_INDELAY;
  wire TRNTREMN_INDELAY;
  wire TRNTSOFN_INDELAY;
  wire TRNTSRCDSCN_INDELAY;
  wire TRNTSRCRDYN_INDELAY;
  wire TRNTSTRN_INDELAY;
  wire USERCLK_INDELAY;
  wire [127:0] CFGERRAERHEADERLOG_INDELAY;
  wire [15:0] DRPDI_INDELAY;
  wire [15:0] PIPERX0DATA_INDELAY;
  wire [15:0] PIPERX1DATA_INDELAY;
  wire [15:0] PIPERX2DATA_INDELAY;
  wire [15:0] PIPERX3DATA_INDELAY;
  wire [15:0] PIPERX4DATA_INDELAY;
  wire [15:0] PIPERX5DATA_INDELAY;
  wire [15:0] PIPERX6DATA_INDELAY;
  wire [15:0] PIPERX7DATA_INDELAY;
  wire [1:0] DBGMODE_INDELAY;
  wire [1:0] PIPERX0CHARISK_INDELAY;
  wire [1:0] PIPERX1CHARISK_INDELAY;
  wire [1:0] PIPERX2CHARISK_INDELAY;
  wire [1:0] PIPERX3CHARISK_INDELAY;
  wire [1:0] PIPERX4CHARISK_INDELAY;
  wire [1:0] PIPERX5CHARISK_INDELAY;
  wire [1:0] PIPERX6CHARISK_INDELAY;
  wire [1:0] PIPERX7CHARISK_INDELAY;
  wire [1:0] PLDIRECTEDLINKCHANGE_INDELAY;
  wire [1:0] PLDIRECTEDLINKWIDTH_INDELAY;
  wire [2:0] CFGDSFUNCTIONNUMBER_INDELAY;
  wire [2:0] PIPERX0STATUS_INDELAY;
  wire [2:0] PIPERX1STATUS_INDELAY;
  wire [2:0] PIPERX2STATUS_INDELAY;
  wire [2:0] PIPERX3STATUS_INDELAY;
  wire [2:0] PIPERX4STATUS_INDELAY;
  wire [2:0] PIPERX5STATUS_INDELAY;
  wire [2:0] PIPERX6STATUS_INDELAY;
  wire [2:0] PIPERX7STATUS_INDELAY;
  wire [2:0] PLDBGMODE_INDELAY;
  wire [2:0] TRNFCSEL_INDELAY;
  wire [31:0] CFGDI_INDELAY;
  wire [31:0] TRNTDLLPDATA_INDELAY;
  wire [3:0] CFGBYTEENN_INDELAY;
  wire [47:0] CFGERRTLPCPLHEADER_INDELAY;
  wire [4:0] CFGDSDEVICENUMBER_INDELAY;
  wire [4:0] PL2DIRECTEDLSTATE_INDELAY;
  wire [63:0] CFGDSN_INDELAY;
  wire [63:0] TRNTD_INDELAY;
  wire [67:0] MIMRXRDATA_INDELAY;
  wire [68:0] MIMTXRDATA_INDELAY;
  wire [7:0] CFGDSBUSNUMBER_INDELAY;
  wire [7:0] CFGINTERRUPTDI_INDELAY;
  wire [7:0] CFGPORTNUMBER_INDELAY;
  wire [8:0] DRPDADDR_INDELAY;
  wire [9:0] CFGDWADDR_INDELAY;

  initial begin
    case (AER_CAP_ECRC_CHECK_CAPABLE)
      "FALSE" : AER_CAP_ECRC_CHECK_CAPABLE_BINARY = 1'b0;
      "TRUE" : AER_CAP_ECRC_CHECK_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ECRC_CHECK_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ECRC_CHECK_CAPABLE);
        $finish;
      end
    endcase

    case (AER_CAP_ECRC_GEN_CAPABLE)
      "FALSE" : AER_CAP_ECRC_GEN_CAPABLE_BINARY = 1'b0;
      "TRUE" : AER_CAP_ECRC_GEN_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ECRC_GEN_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ECRC_GEN_CAPABLE);
        $finish;
      end
    endcase

    case (AER_CAP_ON)
      "FALSE" : AER_CAP_ON_BINARY = 1'b0;
      "TRUE" : AER_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_ON);
        $finish;
      end
    endcase

    case (AER_CAP_PERMIT_ROOTERR_UPDATE)
      "FALSE" : AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY = 1'b0;
      "TRUE" : AER_CAP_PERMIT_ROOTERR_UPDATE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute AER_CAP_PERMIT_ROOTERR_UPDATE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", AER_CAP_PERMIT_ROOTERR_UPDATE);
        $finish;
      end
    endcase

    case (ALLOW_X8_GEN2)
      "FALSE" : ALLOW_X8_GEN2_BINARY = 1'b0;
      "TRUE" : ALLOW_X8_GEN2_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ALLOW_X8_GEN2 on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ALLOW_X8_GEN2);
        $finish;
      end
    endcase

    case (CMD_INTX_IMPLEMENTED)
      "FALSE" : CMD_INTX_IMPLEMENTED_BINARY = 1'b0;
      "TRUE" : CMD_INTX_IMPLEMENTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CMD_INTX_IMPLEMENTED on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CMD_INTX_IMPLEMENTED);
        $finish;
      end
    endcase

    case (CPL_TIMEOUT_DISABLE_SUPPORTED)
      "FALSE" : CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY = 1'b0;
      "TRUE" : CPL_TIMEOUT_DISABLE_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute CPL_TIMEOUT_DISABLE_SUPPORTED on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", CPL_TIMEOUT_DISABLE_SUPPORTED);
        $finish;
      end
    endcase

    case (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE)
      "FALSE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE);
        $finish;
      end
    endcase

    case (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE)
      "FALSE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE);
        $finish;
      end
    endcase

    case (DEV_CAP_EXT_TAG_SUPPORTED)
      "FALSE" : DEV_CAP_EXT_TAG_SUPPORTED_BINARY = 1'b0;
      "TRUE" : DEV_CAP_EXT_TAG_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_EXT_TAG_SUPPORTED on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_EXT_TAG_SUPPORTED);
        $finish;
      end
    endcase

    case (DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE)
      "FALSE" : DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY = 1'b0;
      "TRUE" : DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE);
        $finish;
      end
    endcase

    case (DEV_CAP_ROLE_BASED_ERROR)
      "FALSE" : DEV_CAP_ROLE_BASED_ERROR_BINARY = 1'b0;
      "TRUE" : DEV_CAP_ROLE_BASED_ERROR_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CAP_ROLE_BASED_ERROR on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CAP_ROLE_BASED_ERROR);
        $finish;
      end
    endcase

    case (DEV_CONTROL_AUX_POWER_SUPPORTED)
      "FALSE" : DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY = 1'b0;
      "TRUE" : DEV_CONTROL_AUX_POWER_SUPPORTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DEV_CONTROL_AUX_POWER_SUPPORTED on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DEV_CONTROL_AUX_POWER_SUPPORTED);
        $finish;
      end
    endcase

    case (DISABLE_ASPM_L1_TIMER)
      "FALSE" : DISABLE_ASPM_L1_TIMER_BINARY = 1'b0;
      "TRUE" : DISABLE_ASPM_L1_TIMER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_ASPM_L1_TIMER on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_ASPM_L1_TIMER);
        $finish;
      end
    endcase

    case (DISABLE_BAR_FILTERING)
      "FALSE" : DISABLE_BAR_FILTERING_BINARY = 1'b0;
      "TRUE" : DISABLE_BAR_FILTERING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_BAR_FILTERING on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_BAR_FILTERING);
        $finish;
      end
    endcase

    case (DISABLE_ID_CHECK)
      "FALSE" : DISABLE_ID_CHECK_BINARY = 1'b0;
      "TRUE" : DISABLE_ID_CHECK_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_ID_CHECK on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_ID_CHECK);
        $finish;
      end
    endcase

    case (DISABLE_LANE_REVERSAL)
      "FALSE" : DISABLE_LANE_REVERSAL_BINARY = 1'b0;
      "TRUE" : DISABLE_LANE_REVERSAL_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_LANE_REVERSAL on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_LANE_REVERSAL);
        $finish;
      end
    endcase

    case (DISABLE_RX_TC_FILTER)
      "FALSE" : DISABLE_RX_TC_FILTER_BINARY = 1'b0;
      "TRUE" : DISABLE_RX_TC_FILTER_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_RX_TC_FILTER on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_RX_TC_FILTER);
        $finish;
      end
    endcase

    case (DISABLE_SCRAMBLING)
      "FALSE" : DISABLE_SCRAMBLING_BINARY = 1'b0;
      "TRUE" : DISABLE_SCRAMBLING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DISABLE_SCRAMBLING on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DISABLE_SCRAMBLING);
        $finish;
      end
    endcase

    case (DSN_CAP_ON)
      "FALSE" : DSN_CAP_ON_BINARY = 1'b0;
      "TRUE" : DSN_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute DSN_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", DSN_CAP_ON);
        $finish;
      end
    endcase

    case (ENABLE_RX_TD_ECRC_TRIM)
      "FALSE" : ENABLE_RX_TD_ECRC_TRIM_BINARY = 1'b0;
      "TRUE" : ENABLE_RX_TD_ECRC_TRIM_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ENABLE_RX_TD_ECRC_TRIM on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENABLE_RX_TD_ECRC_TRIM);
        $finish;
      end
    endcase

    case (ENTER_RVRY_EI_L0)
      "FALSE" : ENTER_RVRY_EI_L0_BINARY = 1'b0;
      "TRUE" : ENTER_RVRY_EI_L0_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ENTER_RVRY_EI_L0 on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ENTER_RVRY_EI_L0);
        $finish;
      end
    endcase

    case (EXIT_LOOPBACK_ON_EI)
      "FALSE" : EXIT_LOOPBACK_ON_EI_BINARY = 1'b0;
      "TRUE" : EXIT_LOOPBACK_ON_EI_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EXIT_LOOPBACK_ON_EI on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EXIT_LOOPBACK_ON_EI);
        $finish;
      end
    endcase

    case (IS_SWITCH)
      "FALSE" : IS_SWITCH_BINARY = 1'b0;
      "TRUE" : IS_SWITCH_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute IS_SWITCH on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", IS_SWITCH);
        $finish;
      end
    endcase

    case (LINK_CAP_CLOCK_POWER_MANAGEMENT)
      "FALSE" : LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY = 1'b0;
      "TRUE" : LINK_CAP_CLOCK_POWER_MANAGEMENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_CLOCK_POWER_MANAGEMENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_CLOCK_POWER_MANAGEMENT);
        $finish;
      end
    endcase

    case (LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP)
      "FALSE" : LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY = 1'b0;
      "TRUE" : LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP);
        $finish;
      end
    endcase

    case (LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP)
      "FALSE" : LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY = 1'b0;
      "TRUE" : LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP);
        $finish;
      end
    endcase

    case (LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE)
      "FALSE" : LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY = 1'b0;
      "TRUE" : LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE);
        $finish;
      end
    endcase

    case (LINK_CTRL2_DEEMPHASIS)
      "FALSE" : LINK_CTRL2_DEEMPHASIS_BINARY = 1'b0;
      "TRUE" : LINK_CTRL2_DEEMPHASIS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CTRL2_DEEMPHASIS on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CTRL2_DEEMPHASIS);
        $finish;
      end
    endcase

    case (LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE)
      "FALSE" : LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY = 1'b0;
      "TRUE" : LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE);
        $finish;
      end
    endcase

    case (LINK_STATUS_SLOT_CLOCK_CONFIG)
      "FALSE" : LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY = 1'b0;
      "TRUE" : LINK_STATUS_SLOT_CLOCK_CONFIG_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LINK_STATUS_SLOT_CLOCK_CONFIG on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LINK_STATUS_SLOT_CLOCK_CONFIG);
        $finish;
      end
    endcase

    case (LL_ACK_TIMEOUT_EN)
      "FALSE" : LL_ACK_TIMEOUT_EN_BINARY = 1'b0;
      "TRUE" : LL_ACK_TIMEOUT_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LL_ACK_TIMEOUT_EN on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LL_ACK_TIMEOUT_EN);
        $finish;
      end
    endcase

    case (LL_REPLAY_TIMEOUT_EN)
      "FALSE" : LL_REPLAY_TIMEOUT_EN_BINARY = 1'b0;
      "TRUE" : LL_REPLAY_TIMEOUT_EN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute LL_REPLAY_TIMEOUT_EN on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", LL_REPLAY_TIMEOUT_EN);
        $finish;
      end
    endcase

    case (MSIX_CAP_ON)
      "FALSE" : MSIX_CAP_ON_BINARY = 1'b0;
      "TRUE" : MSIX_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSIX_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSIX_CAP_ON);
        $finish;
      end
    endcase

    case (MSI_CAP_64_BIT_ADDR_CAPABLE)
      "FALSE" : MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY = 1'b0;
      "TRUE" : MSI_CAP_64_BIT_ADDR_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_64_BIT_ADDR_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_64_BIT_ADDR_CAPABLE);
        $finish;
      end
    endcase

    case (MSI_CAP_ON)
      "FALSE" : MSI_CAP_ON_BINARY = 1'b0;
      "TRUE" : MSI_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_ON);
        $finish;
      end
    endcase

    case (MSI_CAP_PER_VECTOR_MASKING_CAPABLE)
      "FALSE" : MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY = 1'b0;
      "TRUE" : MSI_CAP_PER_VECTOR_MASKING_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute MSI_CAP_PER_VECTOR_MASKING_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", MSI_CAP_PER_VECTOR_MASKING_CAPABLE);
        $finish;
      end
    endcase

    case (PCIE_CAP_ON)
      "FALSE" : PCIE_CAP_ON_BINARY = 1'b0;
      "TRUE" : PCIE_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PCIE_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIE_CAP_ON);
        $finish;
      end
    endcase

    case (PCIE_CAP_SLOT_IMPLEMENTED)
      "FALSE" : PCIE_CAP_SLOT_IMPLEMENTED_BINARY = 1'b0;
      "TRUE" : PCIE_CAP_SLOT_IMPLEMENTED_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PCIE_CAP_SLOT_IMPLEMENTED on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PCIE_CAP_SLOT_IMPLEMENTED);
        $finish;
      end
    endcase

    case (PL_FAST_TRAIN)
      "FALSE" : PL_FAST_TRAIN_BINARY = 1'b0;
      "TRUE" : PL_FAST_TRAIN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PL_FAST_TRAIN on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PL_FAST_TRAIN);
        $finish;
      end
    endcase

    case (PM_CAP_D1SUPPORT)
      "FALSE" : PM_CAP_D1SUPPORT_BINARY = 1'b0;
      "TRUE" : PM_CAP_D1SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_D1SUPPORT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_D1SUPPORT);
        $finish;
      end
    endcase

    case (PM_CAP_D2SUPPORT)
      "FALSE" : PM_CAP_D2SUPPORT_BINARY = 1'b0;
      "TRUE" : PM_CAP_D2SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_D2SUPPORT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_D2SUPPORT);
        $finish;
      end
    endcase

    case (PM_CAP_DSI)
      "FALSE" : PM_CAP_DSI_BINARY = 1'b0;
      "TRUE" : PM_CAP_DSI_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_DSI on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_DSI);
        $finish;
      end
    endcase

    case (PM_CAP_ON)
      "FALSE" : PM_CAP_ON_BINARY = 1'b0;
      "TRUE" : PM_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_ON);
        $finish;
      end
    endcase

    case (PM_CAP_PME_CLOCK)
      "FALSE" : PM_CAP_PME_CLOCK_BINARY = 1'b0;
      "TRUE" : PM_CAP_PME_CLOCK_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CAP_PME_CLOCK on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CAP_PME_CLOCK);
        $finish;
      end
    endcase

    case (PM_CSR_B2B3)
      "FALSE" : PM_CSR_B2B3_BINARY = 1'b0;
      "TRUE" : PM_CSR_B2B3_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_B2B3 on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_B2B3);
        $finish;
      end
    endcase

    case (PM_CSR_BPCCEN)
      "FALSE" : PM_CSR_BPCCEN_BINARY = 1'b0;
      "TRUE" : PM_CSR_BPCCEN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_BPCCEN on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_BPCCEN);
        $finish;
      end
    endcase

    case (PM_CSR_NOSOFTRST)
      "FALSE" : PM_CSR_NOSOFTRST_BINARY = 1'b0;
      "TRUE" : PM_CSR_NOSOFTRST_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute PM_CSR_NOSOFTRST on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", PM_CSR_NOSOFTRST);
        $finish;
      end
    endcase

    case (RECRC_CHK_TRIM)
      "FALSE" : RECRC_CHK_TRIM_BINARY = 1'b0;
      "TRUE" : RECRC_CHK_TRIM_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute RECRC_CHK_TRIM on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", RECRC_CHK_TRIM);
        $finish;
      end
    endcase

    case (ROOT_CAP_CRS_SW_VISIBILITY)
      "FALSE" : ROOT_CAP_CRS_SW_VISIBILITY_BINARY = 1'b0;
      "TRUE" : ROOT_CAP_CRS_SW_VISIBILITY_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute ROOT_CAP_CRS_SW_VISIBILITY on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", ROOT_CAP_CRS_SW_VISIBILITY);
        $finish;
      end
    endcase

    case (SELECT_DLL_IF)
      "FALSE" : SELECT_DLL_IF_BINARY = 1'b0;
      "TRUE" : SELECT_DLL_IF_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SELECT_DLL_IF on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SELECT_DLL_IF);
        $finish;
      end
    endcase

    case (SLOT_CAP_ATT_BUTTON_PRESENT)
      "FALSE" : SLOT_CAP_ATT_BUTTON_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ATT_BUTTON_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ATT_BUTTON_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ATT_BUTTON_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_ATT_INDICATOR_PRESENT)
      "FALSE" : SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ATT_INDICATOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ATT_INDICATOR_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ATT_INDICATOR_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_ELEC_INTERLOCK_PRESENT)
      "FALSE" : SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_ELEC_INTERLOCK_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_ELEC_INTERLOCK_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_ELEC_INTERLOCK_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_HOTPLUG_CAPABLE)
      "FALSE" : SLOT_CAP_HOTPLUG_CAPABLE_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_HOTPLUG_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_HOTPLUG_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_HOTPLUG_CAPABLE);
        $finish;
      end
    endcase

    case (SLOT_CAP_HOTPLUG_SURPRISE)
      "FALSE" : SLOT_CAP_HOTPLUG_SURPRISE_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_HOTPLUG_SURPRISE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_HOTPLUG_SURPRISE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_HOTPLUG_SURPRISE);
        $finish;
      end
    endcase

    case (SLOT_CAP_MRL_SENSOR_PRESENT)
      "FALSE" : SLOT_CAP_MRL_SENSOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_MRL_SENSOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_MRL_SENSOR_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_MRL_SENSOR_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_NO_CMD_COMPLETED_SUPPORT)
      "FALSE" : SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_NO_CMD_COMPLETED_SUPPORT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_NO_CMD_COMPLETED_SUPPORT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_NO_CMD_COMPLETED_SUPPORT);
        $finish;
      end
    endcase

    case (SLOT_CAP_POWER_CONTROLLER_PRESENT)
      "FALSE" : SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_POWER_CONTROLLER_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_POWER_CONTROLLER_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_POWER_CONTROLLER_PRESENT);
        $finish;
      end
    endcase

    case (SLOT_CAP_POWER_INDICATOR_PRESENT)
      "FALSE" : SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY = 1'b0;
      "TRUE" : SLOT_CAP_POWER_INDICATOR_PRESENT_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute SLOT_CAP_POWER_INDICATOR_PRESENT on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", SLOT_CAP_POWER_INDICATOR_PRESENT);
        $finish;
      end
    endcase

    case (TL_RBYPASS)
      "FALSE" : TL_RBYPASS_BINARY = 1'b0;
      "TRUE" : TL_RBYPASS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_RBYPASS on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_RBYPASS);
        $finish;
      end
    endcase

    case (TL_TFC_DISABLE)
      "FALSE" : TL_TFC_DISABLE_BINARY = 1'b0;
      "TRUE" : TL_TFC_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_TFC_DISABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_TFC_DISABLE);
        $finish;
      end
    endcase

    case (TL_TX_CHECKS_DISABLE)
      "FALSE" : TL_TX_CHECKS_DISABLE_BINARY = 1'b0;
      "TRUE" : TL_TX_CHECKS_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute TL_TX_CHECKS_DISABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", TL_TX_CHECKS_DISABLE);
        $finish;
      end
    endcase

    case (UPCONFIG_CAPABLE)
      "FALSE" : UPCONFIG_CAPABLE_BINARY = 1'b0;
      "TRUE" : UPCONFIG_CAPABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UPCONFIG_CAPABLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPCONFIG_CAPABLE);
        $finish;
      end
    endcase

    case (UPSTREAM_FACING)
      "FALSE" : UPSTREAM_FACING_BINARY = 1'b0;
      "TRUE" : UPSTREAM_FACING_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UPSTREAM_FACING on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UPSTREAM_FACING);
        $finish;
      end
    endcase

    case (UR_INV_REQ)
      "FALSE" : UR_INV_REQ_BINARY = 1'b0;
      "TRUE" : UR_INV_REQ_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute UR_INV_REQ on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", UR_INV_REQ);
        $finish;
      end
    endcase

    case (VC0_CPL_INFINITE)
      "FALSE" : VC0_CPL_INFINITE_BINARY = 1'b0;
      "TRUE" : VC0_CPL_INFINITE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC0_CPL_INFINITE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC0_CPL_INFINITE);
        $finish;
      end
    endcase

    case (VC_CAP_ON)
      "FALSE" : VC_CAP_ON_BINARY = 1'b0;
      "TRUE" : VC_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC_CAP_ON);
        $finish;
      end
    endcase

    case (VC_CAP_REJECT_SNOOP_TRANSACTIONS)
      "FALSE" : VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY = 1'b0;
      "TRUE" : VC_CAP_REJECT_SNOOP_TRANSACTIONS_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VC_CAP_REJECT_SNOOP_TRANSACTIONS on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VC_CAP_REJECT_SNOOP_TRANSACTIONS);
        $finish;
      end
    endcase

    case (VSEC_CAP_IS_LINK_VISIBLE)
      "FALSE" : VSEC_CAP_IS_LINK_VISIBLE_BINARY = 1'b0;
      "TRUE" : VSEC_CAP_IS_LINK_VISIBLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VSEC_CAP_IS_LINK_VISIBLE on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VSEC_CAP_IS_LINK_VISIBLE);
        $finish;
      end
    endcase

    case (VSEC_CAP_ON)
      "FALSE" : VSEC_CAP_ON_BINARY = 1'b0;
      "TRUE" : VSEC_CAP_ON_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute VSEC_CAP_ON on X_PCIE_2_0 instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", VSEC_CAP_ON);
        $finish;
      end
    endcase

    if ((DEV_CAP_ENDPOINT_L0S_LATENCY >= 0) && (DEV_CAP_ENDPOINT_L0S_LATENCY <= 7))
      DEV_CAP_ENDPOINT_L0S_LATENCY_BINARY = DEV_CAP_ENDPOINT_L0S_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_ENDPOINT_L0S_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_ENDPOINT_L0S_LATENCY);
      $finish;
    end

    if ((DEV_CAP_ENDPOINT_L1_LATENCY >= 0) && (DEV_CAP_ENDPOINT_L1_LATENCY <= 7))
      DEV_CAP_ENDPOINT_L1_LATENCY_BINARY = DEV_CAP_ENDPOINT_L1_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_ENDPOINT_L1_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_ENDPOINT_L1_LATENCY);
      $finish;
    end

    if ((DEV_CAP_MAX_PAYLOAD_SUPPORTED >= 0) && (DEV_CAP_MAX_PAYLOAD_SUPPORTED <= 7))
      DEV_CAP_MAX_PAYLOAD_SUPPORTED_BINARY = DEV_CAP_MAX_PAYLOAD_SUPPORTED;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_MAX_PAYLOAD_SUPPORTED on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_MAX_PAYLOAD_SUPPORTED);
      $finish;
    end

    if ((DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT >= 0) && (DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT <= 3))
      DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT_BINARY = DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT);
      $finish;
    end

    if ((DEV_CAP_RSVD_14_12 >= 0) && (DEV_CAP_RSVD_14_12 <= 7))
      DEV_CAP_RSVD_14_12_BINARY = DEV_CAP_RSVD_14_12;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_14_12 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_RSVD_14_12);
      $finish;
    end

    if ((DEV_CAP_RSVD_17_16 >= 0) && (DEV_CAP_RSVD_17_16 <= 3))
      DEV_CAP_RSVD_17_16_BINARY = DEV_CAP_RSVD_17_16;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_17_16 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", DEV_CAP_RSVD_17_16);
      $finish;
    end

    if ((DEV_CAP_RSVD_31_29 >= 0) && (DEV_CAP_RSVD_31_29 <= 7))
      DEV_CAP_RSVD_31_29_BINARY = DEV_CAP_RSVD_31_29;
    else begin
      $display("Attribute Syntax Error : The Attribute DEV_CAP_RSVD_31_29 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", DEV_CAP_RSVD_31_29);
      $finish;
    end

    if ((LINK_CAP_ASPM_SUPPORT >= 0) && (LINK_CAP_ASPM_SUPPORT <= 3))
      LINK_CAP_ASPM_SUPPORT_BINARY = LINK_CAP_ASPM_SUPPORT;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_ASPM_SUPPORT on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LINK_CAP_ASPM_SUPPORT);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1_BINARY = LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2_BINARY = LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN1 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_GEN1 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_GEN1_BINARY = LINK_CAP_L0S_EXIT_LATENCY_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_GEN1);
      $finish;
    end

    if ((LINK_CAP_L0S_EXIT_LATENCY_GEN2 >= 0) && (LINK_CAP_L0S_EXIT_LATENCY_GEN2 <= 7))
      LINK_CAP_L0S_EXIT_LATENCY_GEN2_BINARY = LINK_CAP_L0S_EXIT_LATENCY_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L0S_EXIT_LATENCY_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L0S_EXIT_LATENCY_GEN2);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1_BINARY = LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2_BINARY = LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_GEN1 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_GEN1 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_GEN1_BINARY = LINK_CAP_L1_EXIT_LATENCY_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_GEN1);
      $finish;
    end

    if ((LINK_CAP_L1_EXIT_LATENCY_GEN2 >= 0) && (LINK_CAP_L1_EXIT_LATENCY_GEN2 <= 7))
      LINK_CAP_L1_EXIT_LATENCY_GEN2_BINARY = LINK_CAP_L1_EXIT_LATENCY_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_L1_EXIT_LATENCY_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", LINK_CAP_L1_EXIT_LATENCY_GEN2);
      $finish;
    end

    if ((LINK_CAP_RSVD_23_22 >= 0) && (LINK_CAP_RSVD_23_22 <= 3))
      LINK_CAP_RSVD_23_22_BINARY = LINK_CAP_RSVD_23_22;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CAP_RSVD_23_22 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LINK_CAP_RSVD_23_22);
      $finish;
    end

    if ((LINK_CONTROL_RCB >= 0) && (LINK_CONTROL_RCB <= 1))
      LINK_CONTROL_RCB_BINARY = LINK_CONTROL_RCB;
    else begin
      $display("Attribute Syntax Error : The Attribute LINK_CONTROL_RCB on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", LINK_CONTROL_RCB);
      $finish;
    end

    if ((LL_ACK_TIMEOUT_FUNC >= 0) && (LL_ACK_TIMEOUT_FUNC <= 3))
      LL_ACK_TIMEOUT_FUNC_BINARY = LL_ACK_TIMEOUT_FUNC;
    else begin
      $display("Attribute Syntax Error : The Attribute LL_ACK_TIMEOUT_FUNC on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LL_ACK_TIMEOUT_FUNC);
      $finish;
    end

    if ((LL_REPLAY_TIMEOUT_FUNC >= 0) && (LL_REPLAY_TIMEOUT_FUNC <= 3))
      LL_REPLAY_TIMEOUT_FUNC_BINARY = LL_REPLAY_TIMEOUT_FUNC;
    else begin
      $display("Attribute Syntax Error : The Attribute LL_REPLAY_TIMEOUT_FUNC on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", LL_REPLAY_TIMEOUT_FUNC);
      $finish;
    end

    if ((MSIX_CAP_PBA_BIR >= 0) && (MSIX_CAP_PBA_BIR <= 7))
      MSIX_CAP_PBA_BIR_BINARY = MSIX_CAP_PBA_BIR;
    else begin
      $display("Attribute Syntax Error : The Attribute MSIX_CAP_PBA_BIR on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSIX_CAP_PBA_BIR);
      $finish;
    end

    if ((MSIX_CAP_TABLE_BIR >= 0) && (MSIX_CAP_TABLE_BIR <= 7))
      MSIX_CAP_TABLE_BIR_BINARY = MSIX_CAP_TABLE_BIR;
    else begin
      $display("Attribute Syntax Error : The Attribute MSIX_CAP_TABLE_BIR on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSIX_CAP_TABLE_BIR);
      $finish;
    end

    if ((MSI_CAP_MULTIMSGCAP >= 0) && (MSI_CAP_MULTIMSGCAP <= 7))
      MSI_CAP_MULTIMSGCAP_BINARY = MSI_CAP_MULTIMSGCAP;
    else begin
      $display("Attribute Syntax Error : The Attribute MSI_CAP_MULTIMSGCAP on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", MSI_CAP_MULTIMSGCAP);
      $finish;
    end

    if ((MSI_CAP_MULTIMSG_EXTENSION >= 0) && (MSI_CAP_MULTIMSG_EXTENSION <= 1))
      MSI_CAP_MULTIMSG_EXTENSION_BINARY = MSI_CAP_MULTIMSG_EXTENSION;
    else begin
      $display("Attribute Syntax Error : The Attribute MSI_CAP_MULTIMSG_EXTENSION on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", MSI_CAP_MULTIMSG_EXTENSION);
      $finish;
    end

    if ((N_FTS_COMCLK_GEN1 >= 0) && (N_FTS_COMCLK_GEN1 <= 255))
      N_FTS_COMCLK_GEN1_BINARY = N_FTS_COMCLK_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_COMCLK_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_COMCLK_GEN1);
      $finish;
    end

    if ((N_FTS_COMCLK_GEN2 >= 0) && (N_FTS_COMCLK_GEN2 <= 255))
      N_FTS_COMCLK_GEN2_BINARY = N_FTS_COMCLK_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_COMCLK_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_COMCLK_GEN2);
      $finish;
    end

    if ((N_FTS_GEN1 >= 0) && (N_FTS_GEN1 <= 255))
      N_FTS_GEN1_BINARY = N_FTS_GEN1;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_GEN1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_GEN1);
      $finish;
    end

    if ((N_FTS_GEN2 >= 0) && (N_FTS_GEN2 <= 255))
      N_FTS_GEN2_BINARY = N_FTS_GEN2;
    else begin
      $display("Attribute Syntax Error : The Attribute N_FTS_GEN2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 255.", N_FTS_GEN2);
      $finish;
    end

    if ((PCIE_CAP_RSVD_15_14 >= 0) && (PCIE_CAP_RSVD_15_14 <= 3))
      PCIE_CAP_RSVD_15_14_BINARY = PCIE_CAP_RSVD_15_14;
    else begin
      $display("Attribute Syntax Error : The Attribute PCIE_CAP_RSVD_15_14 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", PCIE_CAP_RSVD_15_14);
      $finish;
    end

    if ((PCIE_REVISION >= 0) && (PCIE_REVISION <= 15))
      PCIE_REVISION_BINARY = PCIE_REVISION;
    else begin
      $display("Attribute Syntax Error : The Attribute PCIE_REVISION on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 15.", PCIE_REVISION);
      $finish;
    end

    if ((PGL0_LANE >= 0) && (PGL0_LANE <= 7))
      PGL0_LANE_BINARY = PGL0_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL0_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL0_LANE);
      $finish;
    end

    if ((PGL1_LANE >= 0) && (PGL1_LANE <= 7))
      PGL1_LANE_BINARY = PGL1_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL1_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL1_LANE);
      $finish;
    end

    if ((PGL2_LANE >= 0) && (PGL2_LANE <= 7))
      PGL2_LANE_BINARY = PGL2_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL2_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL2_LANE);
      $finish;
    end

    if ((PGL3_LANE >= 0) && (PGL3_LANE <= 7))
      PGL3_LANE_BINARY = PGL3_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL3_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL3_LANE);
      $finish;
    end

    if ((PGL4_LANE >= 0) && (PGL4_LANE <= 7))
      PGL4_LANE_BINARY = PGL4_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL4_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL4_LANE);
      $finish;
    end

    if ((PGL5_LANE >= 0) && (PGL5_LANE <= 7))
      PGL5_LANE_BINARY = PGL5_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL5_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL5_LANE);
      $finish;
    end

    if ((PGL6_LANE >= 0) && (PGL6_LANE <= 7))
      PGL6_LANE_BINARY = PGL6_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL6_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL6_LANE);
      $finish;
    end

    if ((PGL7_LANE >= 0) && (PGL7_LANE <= 7))
      PGL7_LANE_BINARY = PGL7_LANE;
    else begin
      $display("Attribute Syntax Error : The Attribute PGL7_LANE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PGL7_LANE);
      $finish;
    end

    if ((PL_AUTO_CONFIG >= 0) && (PL_AUTO_CONFIG <= 7))
      PL_AUTO_CONFIG_BINARY = PL_AUTO_CONFIG;
    else begin
      $display("Attribute Syntax Error : The Attribute PL_AUTO_CONFIG on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PL_AUTO_CONFIG);
      $finish;
    end

    if ((PM_CAP_AUXCURRENT >= 0) && (PM_CAP_AUXCURRENT <= 7))
      PM_CAP_AUXCURRENT_BINARY = PM_CAP_AUXCURRENT;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_AUXCURRENT on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PM_CAP_AUXCURRENT);
      $finish;
    end

    if ((PM_CAP_RSVD_04 >= 0) && (PM_CAP_RSVD_04 <= 1))
      PM_CAP_RSVD_04_BINARY = PM_CAP_RSVD_04;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_RSVD_04 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", PM_CAP_RSVD_04);
      $finish;
    end

    if ((PM_CAP_VERSION >= 0) && (PM_CAP_VERSION <= 7))
      PM_CAP_VERSION_BINARY = PM_CAP_VERSION;
    else begin
      $display("Attribute Syntax Error : The Attribute PM_CAP_VERSION on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", PM_CAP_VERSION);
      $finish;
    end

    if ((RECRC_CHK >= 0) && (RECRC_CHK <= 3))
      RECRC_CHK_BINARY = RECRC_CHK;
    else begin
      $display("Attribute Syntax Error : The Attribute RECRC_CHK on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", RECRC_CHK);
      $finish;
    end

    if ((SLOT_CAP_SLOT_POWER_LIMIT_SCALE >= 0) && (SLOT_CAP_SLOT_POWER_LIMIT_SCALE <= 3))
      SLOT_CAP_SLOT_POWER_LIMIT_SCALE_BINARY = SLOT_CAP_SLOT_POWER_LIMIT_SCALE;
    else begin
      $display("Attribute Syntax Error : The Attribute SLOT_CAP_SLOT_POWER_LIMIT_SCALE on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", SLOT_CAP_SLOT_POWER_LIMIT_SCALE);
      $finish;
    end

    if ((SPARE_BIT0 >= 0) && (SPARE_BIT0 <= 1))
      SPARE_BIT0_BINARY = SPARE_BIT0;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT0 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT0);
      $finish;
    end

    if ((SPARE_BIT1 >= 0) && (SPARE_BIT1 <= 1))
      SPARE_BIT1_BINARY = SPARE_BIT1;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT1 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT1);
      $finish;
    end

    if ((SPARE_BIT2 >= 0) && (SPARE_BIT2 <= 1))
      SPARE_BIT2_BINARY = SPARE_BIT2;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT2 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT2);
      $finish;
    end

    if ((SPARE_BIT3 >= 0) && (SPARE_BIT3 <= 1))
      SPARE_BIT3_BINARY = SPARE_BIT3;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT3 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT3);
      $finish;
    end

    if ((SPARE_BIT4 >= 0) && (SPARE_BIT4 <= 1))
      SPARE_BIT4_BINARY = SPARE_BIT4;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT4 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT4);
      $finish;
    end

    if ((SPARE_BIT5 >= 0) && (SPARE_BIT5 <= 1))
      SPARE_BIT5_BINARY = SPARE_BIT5;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT5 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT5);
      $finish;
    end

    if ((SPARE_BIT6 >= 0) && (SPARE_BIT6 <= 1))
      SPARE_BIT6_BINARY = SPARE_BIT6;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT6 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT6);
      $finish;
    end

    if ((SPARE_BIT7 >= 0) && (SPARE_BIT7 <= 1))
      SPARE_BIT7_BINARY = SPARE_BIT7;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT7 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT7);
      $finish;
    end

    if ((SPARE_BIT8 >= 0) && (SPARE_BIT8 <= 1))
      SPARE_BIT8_BINARY = SPARE_BIT8;
    else begin
      $display("Attribute Syntax Error : The Attribute SPARE_BIT8 on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", SPARE_BIT8);
      $finish;
    end

    if ((TL_RX_RAM_RADDR_LATENCY >= 0) && (TL_RX_RAM_RADDR_LATENCY <= 1))
      TL_RX_RAM_RADDR_LATENCY_BINARY = TL_RX_RAM_RADDR_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_RADDR_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_RX_RAM_RADDR_LATENCY);
      $finish;
    end

    if ((TL_RX_RAM_RDATA_LATENCY >= 0) && (TL_RX_RAM_RDATA_LATENCY <= 3))
      TL_RX_RAM_RDATA_LATENCY_BINARY = TL_RX_RAM_RDATA_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_RDATA_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", TL_RX_RAM_RDATA_LATENCY);
      $finish;
    end

    if ((TL_RX_RAM_WRITE_LATENCY >= 0) && (TL_RX_RAM_WRITE_LATENCY <= 1))
      TL_RX_RAM_WRITE_LATENCY_BINARY = TL_RX_RAM_WRITE_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_RX_RAM_WRITE_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_RX_RAM_WRITE_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_RADDR_LATENCY >= 0) && (TL_TX_RAM_RADDR_LATENCY <= 1))
      TL_TX_RAM_RADDR_LATENCY_BINARY = TL_TX_RAM_RADDR_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_RADDR_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_TX_RAM_RADDR_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_RDATA_LATENCY >= 0) && (TL_TX_RAM_RDATA_LATENCY <= 3))
      TL_TX_RAM_RDATA_LATENCY_BINARY = TL_TX_RAM_RDATA_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_RDATA_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 3.", TL_TX_RAM_RDATA_LATENCY);
      $finish;
    end

    if ((TL_TX_RAM_WRITE_LATENCY >= 0) && (TL_TX_RAM_WRITE_LATENCY <= 1))
      TL_TX_RAM_WRITE_LATENCY_BINARY = TL_TX_RAM_WRITE_LATENCY;
    else begin
      $display("Attribute Syntax Error : The Attribute TL_TX_RAM_WRITE_LATENCY on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 1.", TL_TX_RAM_WRITE_LATENCY);
      $finish;
    end

    if ((USER_CLK_FREQ >= 0) && (USER_CLK_FREQ <= 7))
      USER_CLK_FREQ_BINARY = USER_CLK_FREQ;
    else begin
      $display("Attribute Syntax Error : The Attribute USER_CLK_FREQ on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 7.", USER_CLK_FREQ);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_CD >= 0) && (VC0_TOTAL_CREDITS_CD <= 2047))
      VC0_TOTAL_CREDITS_CD_BINARY = VC0_TOTAL_CREDITS_CD;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_CD on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 2047.", VC0_TOTAL_CREDITS_CD);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_CH >= 0) && (VC0_TOTAL_CREDITS_CH <= 127))
      VC0_TOTAL_CREDITS_CH_BINARY = VC0_TOTAL_CREDITS_CH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_CH on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_CH);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_NPH >= 0) && (VC0_TOTAL_CREDITS_NPH <= 127))
      VC0_TOTAL_CREDITS_NPH_BINARY = VC0_TOTAL_CREDITS_NPH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_NPH on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_NPH);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_PD >= 0) && (VC0_TOTAL_CREDITS_PD <= 2047))
      VC0_TOTAL_CREDITS_PD_BINARY = VC0_TOTAL_CREDITS_PD;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_PD on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 2047.", VC0_TOTAL_CREDITS_PD);
      $finish;
    end

    if ((VC0_TOTAL_CREDITS_PH >= 0) && (VC0_TOTAL_CREDITS_PH <= 127))
      VC0_TOTAL_CREDITS_PH_BINARY = VC0_TOTAL_CREDITS_PH;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TOTAL_CREDITS_PH on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 127.", VC0_TOTAL_CREDITS_PH);
      $finish;
    end

    if ((VC0_TX_LASTPACKET >= 0) && (VC0_TX_LASTPACKET <= 31))
      VC0_TX_LASTPACKET_BINARY = VC0_TX_LASTPACKET;
    else begin
      $display("Attribute Syntax Error : The Attribute VC0_TX_LASTPACKET on X_PCIE_2_0 instance %m is set to %d.  Legal values for this attribute are  0 to 31.", VC0_TX_LASTPACKET);
      $finish;
    end

  end

  buf B_CFGAERECRCCHECKEN (CFGAERECRCCHECKEN, CFGAERECRCCHECKEN_OUT);
  buf B_CFGAERECRCGENEN (CFGAERECRCGENEN, CFGAERECRCGENEN_OUT);
  buf B_CFGCOMMANDBUSMASTERENABLE (CFGCOMMANDBUSMASTERENABLE, CFGCOMMANDBUSMASTERENABLE_OUT);
  buf B_CFGCOMMANDINTERRUPTDISABLE (CFGCOMMANDINTERRUPTDISABLE, CFGCOMMANDINTERRUPTDISABLE_OUT);
  buf B_CFGCOMMANDIOENABLE (CFGCOMMANDIOENABLE, CFGCOMMANDIOENABLE_OUT);
  buf B_CFGCOMMANDMEMENABLE (CFGCOMMANDMEMENABLE, CFGCOMMANDMEMENABLE_OUT);
  buf B_CFGCOMMANDSERREN (CFGCOMMANDSERREN, CFGCOMMANDSERREN_OUT);
  buf B_CFGDEVCONTROL2CPLTIMEOUTDIS (CFGDEVCONTROL2CPLTIMEOUTDIS, CFGDEVCONTROL2CPLTIMEOUTDIS_OUT);
  buf B_CFGDEVCONTROL2CPLTIMEOUTVAL0 (CFGDEVCONTROL2CPLTIMEOUTVAL[0], CFGDEVCONTROL2CPLTIMEOUTVAL_OUT[0]);
  buf B_CFGDEVCONTROL2CPLTIMEOUTVAL1 (CFGDEVCONTROL2CPLTIMEOUTVAL[1], CFGDEVCONTROL2CPLTIMEOUTVAL_OUT[1]);
  buf B_CFGDEVCONTROL2CPLTIMEOUTVAL2 (CFGDEVCONTROL2CPLTIMEOUTVAL[2], CFGDEVCONTROL2CPLTIMEOUTVAL_OUT[2]);
  buf B_CFGDEVCONTROL2CPLTIMEOUTVAL3 (CFGDEVCONTROL2CPLTIMEOUTVAL[3], CFGDEVCONTROL2CPLTIMEOUTVAL_OUT[3]);
  buf B_CFGDEVCONTROLAUXPOWEREN (CFGDEVCONTROLAUXPOWEREN, CFGDEVCONTROLAUXPOWEREN_OUT);
  buf B_CFGDEVCONTROLCORRERRREPORTINGEN (CFGDEVCONTROLCORRERRREPORTINGEN, CFGDEVCONTROLCORRERRREPORTINGEN_OUT);
  buf B_CFGDEVCONTROLENABLERO (CFGDEVCONTROLENABLERO, CFGDEVCONTROLENABLERO_OUT);
  buf B_CFGDEVCONTROLEXTTAGEN (CFGDEVCONTROLEXTTAGEN, CFGDEVCONTROLEXTTAGEN_OUT);
  buf B_CFGDEVCONTROLFATALERRREPORTINGEN (CFGDEVCONTROLFATALERRREPORTINGEN, CFGDEVCONTROLFATALERRREPORTINGEN_OUT);
  buf B_CFGDEVCONTROLMAXPAYLOAD0 (CFGDEVCONTROLMAXPAYLOAD[0], CFGDEVCONTROLMAXPAYLOAD_OUT[0]);
  buf B_CFGDEVCONTROLMAXPAYLOAD1 (CFGDEVCONTROLMAXPAYLOAD[1], CFGDEVCONTROLMAXPAYLOAD_OUT[1]);
  buf B_CFGDEVCONTROLMAXPAYLOAD2 (CFGDEVCONTROLMAXPAYLOAD[2], CFGDEVCONTROLMAXPAYLOAD_OUT[2]);
  buf B_CFGDEVCONTROLMAXREADREQ0 (CFGDEVCONTROLMAXREADREQ[0], CFGDEVCONTROLMAXREADREQ_OUT[0]);
  buf B_CFGDEVCONTROLMAXREADREQ1 (CFGDEVCONTROLMAXREADREQ[1], CFGDEVCONTROLMAXREADREQ_OUT[1]);
  buf B_CFGDEVCONTROLMAXREADREQ2 (CFGDEVCONTROLMAXREADREQ[2], CFGDEVCONTROLMAXREADREQ_OUT[2]);
  buf B_CFGDEVCONTROLNONFATALREPORTINGEN (CFGDEVCONTROLNONFATALREPORTINGEN, CFGDEVCONTROLNONFATALREPORTINGEN_OUT);
  buf B_CFGDEVCONTROLNOSNOOPEN (CFGDEVCONTROLNOSNOOPEN, CFGDEVCONTROLNOSNOOPEN_OUT);
  buf B_CFGDEVCONTROLPHANTOMEN (CFGDEVCONTROLPHANTOMEN, CFGDEVCONTROLPHANTOMEN_OUT);
  buf B_CFGDEVCONTROLURERRREPORTINGEN (CFGDEVCONTROLURERRREPORTINGEN, CFGDEVCONTROLURERRREPORTINGEN_OUT);
  buf B_CFGDEVSTATUSCORRERRDETECTED (CFGDEVSTATUSCORRERRDETECTED, CFGDEVSTATUSCORRERRDETECTED_OUT);
  buf B_CFGDEVSTATUSFATALERRDETECTED (CFGDEVSTATUSFATALERRDETECTED, CFGDEVSTATUSFATALERRDETECTED_OUT);
  buf B_CFGDEVSTATUSNONFATALERRDETECTED (CFGDEVSTATUSNONFATALERRDETECTED, CFGDEVSTATUSNONFATALERRDETECTED_OUT);
  buf B_CFGDEVSTATUSURDETECTED (CFGDEVSTATUSURDETECTED, CFGDEVSTATUSURDETECTED_OUT);
  buf B_CFGDO0 (CFGDO[0], CFGDO_OUT[0]);
  buf B_CFGDO1 (CFGDO[1], CFGDO_OUT[1]);
  buf B_CFGDO10 (CFGDO[10], CFGDO_OUT[10]);
  buf B_CFGDO11 (CFGDO[11], CFGDO_OUT[11]);
  buf B_CFGDO12 (CFGDO[12], CFGDO_OUT[12]);
  buf B_CFGDO13 (CFGDO[13], CFGDO_OUT[13]);
  buf B_CFGDO14 (CFGDO[14], CFGDO_OUT[14]);
  buf B_CFGDO15 (CFGDO[15], CFGDO_OUT[15]);
  buf B_CFGDO16 (CFGDO[16], CFGDO_OUT[16]);
  buf B_CFGDO17 (CFGDO[17], CFGDO_OUT[17]);
  buf B_CFGDO18 (CFGDO[18], CFGDO_OUT[18]);
  buf B_CFGDO19 (CFGDO[19], CFGDO_OUT[19]);
  buf B_CFGDO2 (CFGDO[2], CFGDO_OUT[2]);
  buf B_CFGDO20 (CFGDO[20], CFGDO_OUT[20]);
  buf B_CFGDO21 (CFGDO[21], CFGDO_OUT[21]);
  buf B_CFGDO22 (CFGDO[22], CFGDO_OUT[22]);
  buf B_CFGDO23 (CFGDO[23], CFGDO_OUT[23]);
  buf B_CFGDO24 (CFGDO[24], CFGDO_OUT[24]);
  buf B_CFGDO25 (CFGDO[25], CFGDO_OUT[25]);
  buf B_CFGDO26 (CFGDO[26], CFGDO_OUT[26]);
  buf B_CFGDO27 (CFGDO[27], CFGDO_OUT[27]);
  buf B_CFGDO28 (CFGDO[28], CFGDO_OUT[28]);
  buf B_CFGDO29 (CFGDO[29], CFGDO_OUT[29]);
  buf B_CFGDO3 (CFGDO[3], CFGDO_OUT[3]);
  buf B_CFGDO30 (CFGDO[30], CFGDO_OUT[30]);
  buf B_CFGDO31 (CFGDO[31], CFGDO_OUT[31]);
  buf B_CFGDO4 (CFGDO[4], CFGDO_OUT[4]);
  buf B_CFGDO5 (CFGDO[5], CFGDO_OUT[5]);
  buf B_CFGDO6 (CFGDO[6], CFGDO_OUT[6]);
  buf B_CFGDO7 (CFGDO[7], CFGDO_OUT[7]);
  buf B_CFGDO8 (CFGDO[8], CFGDO_OUT[8]);
  buf B_CFGDO9 (CFGDO[9], CFGDO_OUT[9]);
  buf B_CFGERRAERHEADERLOGSETN (CFGERRAERHEADERLOGSETN, CFGERRAERHEADERLOGSETN_OUT);
  buf B_CFGERRCPLRDYN (CFGERRCPLRDYN, CFGERRCPLRDYN_OUT);
  buf B_CFGINTERRUPTDO0 (CFGINTERRUPTDO[0], CFGINTERRUPTDO_OUT[0]);
  buf B_CFGINTERRUPTDO1 (CFGINTERRUPTDO[1], CFGINTERRUPTDO_OUT[1]);
  buf B_CFGINTERRUPTDO2 (CFGINTERRUPTDO[2], CFGINTERRUPTDO_OUT[2]);
  buf B_CFGINTERRUPTDO3 (CFGINTERRUPTDO[3], CFGINTERRUPTDO_OUT[3]);
  buf B_CFGINTERRUPTDO4 (CFGINTERRUPTDO[4], CFGINTERRUPTDO_OUT[4]);
  buf B_CFGINTERRUPTDO5 (CFGINTERRUPTDO[5], CFGINTERRUPTDO_OUT[5]);
  buf B_CFGINTERRUPTDO6 (CFGINTERRUPTDO[6], CFGINTERRUPTDO_OUT[6]);
  buf B_CFGINTERRUPTDO7 (CFGINTERRUPTDO[7], CFGINTERRUPTDO_OUT[7]);
  buf B_CFGINTERRUPTMMENABLE0 (CFGINTERRUPTMMENABLE[0], CFGINTERRUPTMMENABLE_OUT[0]);
  buf B_CFGINTERRUPTMMENABLE1 (CFGINTERRUPTMMENABLE[1], CFGINTERRUPTMMENABLE_OUT[1]);
  buf B_CFGINTERRUPTMMENABLE2 (CFGINTERRUPTMMENABLE[2], CFGINTERRUPTMMENABLE_OUT[2]);
  buf B_CFGINTERRUPTMSIENABLE (CFGINTERRUPTMSIENABLE, CFGINTERRUPTMSIENABLE_OUT);
  buf B_CFGINTERRUPTMSIXENABLE (CFGINTERRUPTMSIXENABLE, CFGINTERRUPTMSIXENABLE_OUT);
  buf B_CFGINTERRUPTMSIXFM (CFGINTERRUPTMSIXFM, CFGINTERRUPTMSIXFM_OUT);
  buf B_CFGINTERRUPTRDYN (CFGINTERRUPTRDYN, CFGINTERRUPTRDYN_OUT);
  buf B_CFGLINKCONTROLASPMCONTROL0 (CFGLINKCONTROLASPMCONTROL[0], CFGLINKCONTROLASPMCONTROL_OUT[0]);
  buf B_CFGLINKCONTROLASPMCONTROL1 (CFGLINKCONTROLASPMCONTROL[1], CFGLINKCONTROLASPMCONTROL_OUT[1]);
  buf B_CFGLINKCONTROLAUTOBANDWIDTHINTEN (CFGLINKCONTROLAUTOBANDWIDTHINTEN, CFGLINKCONTROLAUTOBANDWIDTHINTEN_OUT);
  buf B_CFGLINKCONTROLBANDWIDTHINTEN (CFGLINKCONTROLBANDWIDTHINTEN, CFGLINKCONTROLBANDWIDTHINTEN_OUT);
  buf B_CFGLINKCONTROLCLOCKPMEN (CFGLINKCONTROLCLOCKPMEN, CFGLINKCONTROLCLOCKPMEN_OUT);
  buf B_CFGLINKCONTROLCOMMONCLOCK (CFGLINKCONTROLCOMMONCLOCK, CFGLINKCONTROLCOMMONCLOCK_OUT);
  buf B_CFGLINKCONTROLEXTENDEDSYNC (CFGLINKCONTROLEXTENDEDSYNC, CFGLINKCONTROLEXTENDEDSYNC_OUT);
  buf B_CFGLINKCONTROLHWAUTOWIDTHDIS (CFGLINKCONTROLHWAUTOWIDTHDIS, CFGLINKCONTROLHWAUTOWIDTHDIS_OUT);
  buf B_CFGLINKCONTROLLINKDISABLE (CFGLINKCONTROLLINKDISABLE, CFGLINKCONTROLLINKDISABLE_OUT);
  buf B_CFGLINKCONTROLRCB (CFGLINKCONTROLRCB, CFGLINKCONTROLRCB_OUT);
  buf B_CFGLINKCONTROLRETRAINLINK (CFGLINKCONTROLRETRAINLINK, CFGLINKCONTROLRETRAINLINK_OUT);
  buf B_CFGLINKSTATUSAUTOBANDWIDTHSTATUS (CFGLINKSTATUSAUTOBANDWIDTHSTATUS, CFGLINKSTATUSAUTOBANDWIDTHSTATUS_OUT);
  buf B_CFGLINKSTATUSBANDWITHSTATUS (CFGLINKSTATUSBANDWITHSTATUS, CFGLINKSTATUSBANDWITHSTATUS_OUT);
  buf B_CFGLINKSTATUSCURRENTSPEED0 (CFGLINKSTATUSCURRENTSPEED[0], CFGLINKSTATUSCURRENTSPEED_OUT[0]);
  buf B_CFGLINKSTATUSCURRENTSPEED1 (CFGLINKSTATUSCURRENTSPEED[1], CFGLINKSTATUSCURRENTSPEED_OUT[1]);
  buf B_CFGLINKSTATUSDLLACTIVE (CFGLINKSTATUSDLLACTIVE, CFGLINKSTATUSDLLACTIVE_OUT);
  buf B_CFGLINKSTATUSLINKTRAINING (CFGLINKSTATUSLINKTRAINING, CFGLINKSTATUSLINKTRAINING_OUT);
  buf B_CFGLINKSTATUSNEGOTIATEDWIDTH0 (CFGLINKSTATUSNEGOTIATEDWIDTH[0], CFGLINKSTATUSNEGOTIATEDWIDTH_OUT[0]);
  buf B_CFGLINKSTATUSNEGOTIATEDWIDTH1 (CFGLINKSTATUSNEGOTIATEDWIDTH[1], CFGLINKSTATUSNEGOTIATEDWIDTH_OUT[1]);
  buf B_CFGLINKSTATUSNEGOTIATEDWIDTH2 (CFGLINKSTATUSNEGOTIATEDWIDTH[2], CFGLINKSTATUSNEGOTIATEDWIDTH_OUT[2]);
  buf B_CFGLINKSTATUSNEGOTIATEDWIDTH3 (CFGLINKSTATUSNEGOTIATEDWIDTH[3], CFGLINKSTATUSNEGOTIATEDWIDTH_OUT[3]);
  buf B_CFGMSGDATA0 (CFGMSGDATA[0], CFGMSGDATA_OUT[0]);
  buf B_CFGMSGDATA1 (CFGMSGDATA[1], CFGMSGDATA_OUT[1]);
  buf B_CFGMSGDATA10 (CFGMSGDATA[10], CFGMSGDATA_OUT[10]);
  buf B_CFGMSGDATA11 (CFGMSGDATA[11], CFGMSGDATA_OUT[11]);
  buf B_CFGMSGDATA12 (CFGMSGDATA[12], CFGMSGDATA_OUT[12]);
  buf B_CFGMSGDATA13 (CFGMSGDATA[13], CFGMSGDATA_OUT[13]);
  buf B_CFGMSGDATA14 (CFGMSGDATA[14], CFGMSGDATA_OUT[14]);
  buf B_CFGMSGDATA15 (CFGMSGDATA[15], CFGMSGDATA_OUT[15]);
  buf B_CFGMSGDATA2 (CFGMSGDATA[2], CFGMSGDATA_OUT[2]);
  buf B_CFGMSGDATA3 (CFGMSGDATA[3], CFGMSGDATA_OUT[3]);
  buf B_CFGMSGDATA4 (CFGMSGDATA[4], CFGMSGDATA_OUT[4]);
  buf B_CFGMSGDATA5 (CFGMSGDATA[5], CFGMSGDATA_OUT[5]);
  buf B_CFGMSGDATA6 (CFGMSGDATA[6], CFGMSGDATA_OUT[6]);
  buf B_CFGMSGDATA7 (CFGMSGDATA[7], CFGMSGDATA_OUT[7]);
  buf B_CFGMSGDATA8 (CFGMSGDATA[8], CFGMSGDATA_OUT[8]);
  buf B_CFGMSGDATA9 (CFGMSGDATA[9], CFGMSGDATA_OUT[9]);
  buf B_CFGMSGRECEIVED (CFGMSGRECEIVED, CFGMSGRECEIVED_OUT);
  buf B_CFGMSGRECEIVEDASSERTINTA (CFGMSGRECEIVEDASSERTINTA, CFGMSGRECEIVEDASSERTINTA_OUT);
  buf B_CFGMSGRECEIVEDASSERTINTB (CFGMSGRECEIVEDASSERTINTB, CFGMSGRECEIVEDASSERTINTB_OUT);
  buf B_CFGMSGRECEIVEDASSERTINTC (CFGMSGRECEIVEDASSERTINTC, CFGMSGRECEIVEDASSERTINTC_OUT);
  buf B_CFGMSGRECEIVEDASSERTINTD (CFGMSGRECEIVEDASSERTINTD, CFGMSGRECEIVEDASSERTINTD_OUT);
  buf B_CFGMSGRECEIVEDDEASSERTINTA (CFGMSGRECEIVEDDEASSERTINTA, CFGMSGRECEIVEDDEASSERTINTA_OUT);
  buf B_CFGMSGRECEIVEDDEASSERTINTB (CFGMSGRECEIVEDDEASSERTINTB, CFGMSGRECEIVEDDEASSERTINTB_OUT);
  buf B_CFGMSGRECEIVEDDEASSERTINTC (CFGMSGRECEIVEDDEASSERTINTC, CFGMSGRECEIVEDDEASSERTINTC_OUT);
  buf B_CFGMSGRECEIVEDDEASSERTINTD (CFGMSGRECEIVEDDEASSERTINTD, CFGMSGRECEIVEDDEASSERTINTD_OUT);
  buf B_CFGMSGRECEIVEDERRCOR (CFGMSGRECEIVEDERRCOR, CFGMSGRECEIVEDERRCOR_OUT);
  buf B_CFGMSGRECEIVEDERRFATAL (CFGMSGRECEIVEDERRFATAL, CFGMSGRECEIVEDERRFATAL_OUT);
  buf B_CFGMSGRECEIVEDERRNONFATAL (CFGMSGRECEIVEDERRNONFATAL, CFGMSGRECEIVEDERRNONFATAL_OUT);
  buf B_CFGMSGRECEIVEDPMASNAK (CFGMSGRECEIVEDPMASNAK, CFGMSGRECEIVEDPMASNAK_OUT);
  buf B_CFGMSGRECEIVEDPMETO (CFGMSGRECEIVEDPMETO, CFGMSGRECEIVEDPMETO_OUT);
  buf B_CFGMSGRECEIVEDPMETOACK (CFGMSGRECEIVEDPMETOACK, CFGMSGRECEIVEDPMETOACK_OUT);
  buf B_CFGMSGRECEIVEDPMPME (CFGMSGRECEIVEDPMPME, CFGMSGRECEIVEDPMPME_OUT);
  buf B_CFGMSGRECEIVEDSETSLOTPOWERLIMIT (CFGMSGRECEIVEDSETSLOTPOWERLIMIT, CFGMSGRECEIVEDSETSLOTPOWERLIMIT_OUT);
  buf B_CFGMSGRECEIVEDUNLOCK (CFGMSGRECEIVEDUNLOCK, CFGMSGRECEIVEDUNLOCK_OUT);
  buf B_CFGPCIELINKSTATE0 (CFGPCIELINKSTATE[0], CFGPCIELINKSTATE_OUT[0]);
  buf B_CFGPCIELINKSTATE1 (CFGPCIELINKSTATE[1], CFGPCIELINKSTATE_OUT[1]);
  buf B_CFGPCIELINKSTATE2 (CFGPCIELINKSTATE[2], CFGPCIELINKSTATE_OUT[2]);
  buf B_CFGPMCSRPMEEN (CFGPMCSRPMEEN, CFGPMCSRPMEEN_OUT);
  buf B_CFGPMCSRPMESTATUS (CFGPMCSRPMESTATUS, CFGPMCSRPMESTATUS_OUT);
  buf B_CFGPMCSRPOWERSTATE0 (CFGPMCSRPOWERSTATE[0], CFGPMCSRPOWERSTATE_OUT[0]);
  buf B_CFGPMCSRPOWERSTATE1 (CFGPMCSRPOWERSTATE[1], CFGPMCSRPOWERSTATE_OUT[1]);
  buf B_CFGPMRCVASREQL1N (CFGPMRCVASREQL1N, CFGPMRCVASREQL1N_OUT);
  buf B_CFGPMRCVENTERL1N (CFGPMRCVENTERL1N, CFGPMRCVENTERL1N_OUT);
  buf B_CFGPMRCVENTERL23N (CFGPMRCVENTERL23N, CFGPMRCVENTERL23N_OUT);
  buf B_CFGPMRCVREQACKN (CFGPMRCVREQACKN, CFGPMRCVREQACKN_OUT);
  buf B_CFGRDWRDONEN (CFGRDWRDONEN, CFGRDWRDONEN_OUT);
  buf B_CFGSLOTCONTROLELECTROMECHILCTLPULSE (CFGSLOTCONTROLELECTROMECHILCTLPULSE, CFGSLOTCONTROLELECTROMECHILCTLPULSE_OUT);
  buf B_CFGTRANSACTION (CFGTRANSACTION, CFGTRANSACTION_OUT);
  buf B_CFGTRANSACTIONADDR0 (CFGTRANSACTIONADDR[0], CFGTRANSACTIONADDR_OUT[0]);
  buf B_CFGTRANSACTIONADDR1 (CFGTRANSACTIONADDR[1], CFGTRANSACTIONADDR_OUT[1]);
  buf B_CFGTRANSACTIONADDR2 (CFGTRANSACTIONADDR[2], CFGTRANSACTIONADDR_OUT[2]);
  buf B_CFGTRANSACTIONADDR3 (CFGTRANSACTIONADDR[3], CFGTRANSACTIONADDR_OUT[3]);
  buf B_CFGTRANSACTIONADDR4 (CFGTRANSACTIONADDR[4], CFGTRANSACTIONADDR_OUT[4]);
  buf B_CFGTRANSACTIONADDR5 (CFGTRANSACTIONADDR[5], CFGTRANSACTIONADDR_OUT[5]);
  buf B_CFGTRANSACTIONADDR6 (CFGTRANSACTIONADDR[6], CFGTRANSACTIONADDR_OUT[6]);
  buf B_CFGTRANSACTIONTYPE (CFGTRANSACTIONTYPE, CFGTRANSACTIONTYPE_OUT);
  buf B_CFGVCTCVCMAP0 (CFGVCTCVCMAP[0], CFGVCTCVCMAP_OUT[0]);
  buf B_CFGVCTCVCMAP1 (CFGVCTCVCMAP[1], CFGVCTCVCMAP_OUT[1]);
  buf B_CFGVCTCVCMAP2 (CFGVCTCVCMAP[2], CFGVCTCVCMAP_OUT[2]);
  buf B_CFGVCTCVCMAP3 (CFGVCTCVCMAP[3], CFGVCTCVCMAP_OUT[3]);
  buf B_CFGVCTCVCMAP4 (CFGVCTCVCMAP[4], CFGVCTCVCMAP_OUT[4]);
  buf B_CFGVCTCVCMAP5 (CFGVCTCVCMAP[5], CFGVCTCVCMAP_OUT[5]);
  buf B_CFGVCTCVCMAP6 (CFGVCTCVCMAP[6], CFGVCTCVCMAP_OUT[6]);
  buf B_DBGSCLRA (DBGSCLRA, DBGSCLRA_OUT);
  buf B_DBGSCLRB (DBGSCLRB, DBGSCLRB_OUT);
  buf B_DBGSCLRC (DBGSCLRC, DBGSCLRC_OUT);
  buf B_DBGSCLRD (DBGSCLRD, DBGSCLRD_OUT);
  buf B_DBGSCLRE (DBGSCLRE, DBGSCLRE_OUT);
  buf B_DBGSCLRF (DBGSCLRF, DBGSCLRF_OUT);
  buf B_DBGSCLRG (DBGSCLRG, DBGSCLRG_OUT);
  buf B_DBGSCLRH (DBGSCLRH, DBGSCLRH_OUT);
  buf B_DBGSCLRI (DBGSCLRI, DBGSCLRI_OUT);
  buf B_DBGSCLRJ (DBGSCLRJ, DBGSCLRJ_OUT);
  buf B_DBGSCLRK (DBGSCLRK, DBGSCLRK_OUT);
  buf B_DBGVECA0 (DBGVECA[0], DBGVECA_OUT[0]);
  buf B_DBGVECA1 (DBGVECA[1], DBGVECA_OUT[1]);
  buf B_DBGVECA10 (DBGVECA[10], DBGVECA_OUT[10]);
  buf B_DBGVECA11 (DBGVECA[11], DBGVECA_OUT[11]);
  buf B_DBGVECA12 (DBGVECA[12], DBGVECA_OUT[12]);
  buf B_DBGVECA13 (DBGVECA[13], DBGVECA_OUT[13]);
  buf B_DBGVECA14 (DBGVECA[14], DBGVECA_OUT[14]);
  buf B_DBGVECA15 (DBGVECA[15], DBGVECA_OUT[15]);
  buf B_DBGVECA16 (DBGVECA[16], DBGVECA_OUT[16]);
  buf B_DBGVECA17 (DBGVECA[17], DBGVECA_OUT[17]);
  buf B_DBGVECA18 (DBGVECA[18], DBGVECA_OUT[18]);
  buf B_DBGVECA19 (DBGVECA[19], DBGVECA_OUT[19]);
  buf B_DBGVECA2 (DBGVECA[2], DBGVECA_OUT[2]);
  buf B_DBGVECA20 (DBGVECA[20], DBGVECA_OUT[20]);
  buf B_DBGVECA21 (DBGVECA[21], DBGVECA_OUT[21]);
  buf B_DBGVECA22 (DBGVECA[22], DBGVECA_OUT[22]);
  buf B_DBGVECA23 (DBGVECA[23], DBGVECA_OUT[23]);
  buf B_DBGVECA24 (DBGVECA[24], DBGVECA_OUT[24]);
  buf B_DBGVECA25 (DBGVECA[25], DBGVECA_OUT[25]);
  buf B_DBGVECA26 (DBGVECA[26], DBGVECA_OUT[26]);
  buf B_DBGVECA27 (DBGVECA[27], DBGVECA_OUT[27]);
  buf B_DBGVECA28 (DBGVECA[28], DBGVECA_OUT[28]);
  buf B_DBGVECA29 (DBGVECA[29], DBGVECA_OUT[29]);
  buf B_DBGVECA3 (DBGVECA[3], DBGVECA_OUT[3]);
  buf B_DBGVECA30 (DBGVECA[30], DBGVECA_OUT[30]);
  buf B_DBGVECA31 (DBGVECA[31], DBGVECA_OUT[31]);
  buf B_DBGVECA32 (DBGVECA[32], DBGVECA_OUT[32]);
  buf B_DBGVECA33 (DBGVECA[33], DBGVECA_OUT[33]);
  buf B_DBGVECA34 (DBGVECA[34], DBGVECA_OUT[34]);
  buf B_DBGVECA35 (DBGVECA[35], DBGVECA_OUT[35]);
  buf B_DBGVECA36 (DBGVECA[36], DBGVECA_OUT[36]);
  buf B_DBGVECA37 (DBGVECA[37], DBGVECA_OUT[37]);
  buf B_DBGVECA38 (DBGVECA[38], DBGVECA_OUT[38]);
  buf B_DBGVECA39 (DBGVECA[39], DBGVECA_OUT[39]);
  buf B_DBGVECA4 (DBGVECA[4], DBGVECA_OUT[4]);
  buf B_DBGVECA40 (DBGVECA[40], DBGVECA_OUT[40]);
  buf B_DBGVECA41 (DBGVECA[41], DBGVECA_OUT[41]);
  buf B_DBGVECA42 (DBGVECA[42], DBGVECA_OUT[42]);
  buf B_DBGVECA43 (DBGVECA[43], DBGVECA_OUT[43]);
  buf B_DBGVECA44 (DBGVECA[44], DBGVECA_OUT[44]);
  buf B_DBGVECA45 (DBGVECA[45], DBGVECA_OUT[45]);
  buf B_DBGVECA46 (DBGVECA[46], DBGVECA_OUT[46]);
  buf B_DBGVECA47 (DBGVECA[47], DBGVECA_OUT[47]);
  buf B_DBGVECA48 (DBGVECA[48], DBGVECA_OUT[48]);
  buf B_DBGVECA49 (DBGVECA[49], DBGVECA_OUT[49]);
  buf B_DBGVECA5 (DBGVECA[5], DBGVECA_OUT[5]);
  buf B_DBGVECA50 (DBGVECA[50], DBGVECA_OUT[50]);
  buf B_DBGVECA51 (DBGVECA[51], DBGVECA_OUT[51]);
  buf B_DBGVECA52 (DBGVECA[52], DBGVECA_OUT[52]);
  buf B_DBGVECA53 (DBGVECA[53], DBGVECA_OUT[53]);
  buf B_DBGVECA54 (DBGVECA[54], DBGVECA_OUT[54]);
  buf B_DBGVECA55 (DBGVECA[55], DBGVECA_OUT[55]);
  buf B_DBGVECA56 (DBGVECA[56], DBGVECA_OUT[56]);
  buf B_DBGVECA57 (DBGVECA[57], DBGVECA_OUT[57]);
  buf B_DBGVECA58 (DBGVECA[58], DBGVECA_OUT[58]);
  buf B_DBGVECA59 (DBGVECA[59], DBGVECA_OUT[59]);
  buf B_DBGVECA6 (DBGVECA[6], DBGVECA_OUT[6]);
  buf B_DBGVECA60 (DBGVECA[60], DBGVECA_OUT[60]);
  buf B_DBGVECA61 (DBGVECA[61], DBGVECA_OUT[61]);
  buf B_DBGVECA62 (DBGVECA[62], DBGVECA_OUT[62]);
  buf B_DBGVECA63 (DBGVECA[63], DBGVECA_OUT[63]);
  buf B_DBGVECA7 (DBGVECA[7], DBGVECA_OUT[7]);
  buf B_DBGVECA8 (DBGVECA[8], DBGVECA_OUT[8]);
  buf B_DBGVECA9 (DBGVECA[9], DBGVECA_OUT[9]);
  buf B_DBGVECB0 (DBGVECB[0], DBGVECB_OUT[0]);
  buf B_DBGVECB1 (DBGVECB[1], DBGVECB_OUT[1]);
  buf B_DBGVECB10 (DBGVECB[10], DBGVECB_OUT[10]);
  buf B_DBGVECB11 (DBGVECB[11], DBGVECB_OUT[11]);
  buf B_DBGVECB12 (DBGVECB[12], DBGVECB_OUT[12]);
  buf B_DBGVECB13 (DBGVECB[13], DBGVECB_OUT[13]);
  buf B_DBGVECB14 (DBGVECB[14], DBGVECB_OUT[14]);
  buf B_DBGVECB15 (DBGVECB[15], DBGVECB_OUT[15]);
  buf B_DBGVECB16 (DBGVECB[16], DBGVECB_OUT[16]);
  buf B_DBGVECB17 (DBGVECB[17], DBGVECB_OUT[17]);
  buf B_DBGVECB18 (DBGVECB[18], DBGVECB_OUT[18]);
  buf B_DBGVECB19 (DBGVECB[19], DBGVECB_OUT[19]);
  buf B_DBGVECB2 (DBGVECB[2], DBGVECB_OUT[2]);
  buf B_DBGVECB20 (DBGVECB[20], DBGVECB_OUT[20]);
  buf B_DBGVECB21 (DBGVECB[21], DBGVECB_OUT[21]);
  buf B_DBGVECB22 (DBGVECB[22], DBGVECB_OUT[22]);
  buf B_DBGVECB23 (DBGVECB[23], DBGVECB_OUT[23]);
  buf B_DBGVECB24 (DBGVECB[24], DBGVECB_OUT[24]);
  buf B_DBGVECB25 (DBGVECB[25], DBGVECB_OUT[25]);
  buf B_DBGVECB26 (DBGVECB[26], DBGVECB_OUT[26]);
  buf B_DBGVECB27 (DBGVECB[27], DBGVECB_OUT[27]);
  buf B_DBGVECB28 (DBGVECB[28], DBGVECB_OUT[28]);
  buf B_DBGVECB29 (DBGVECB[29], DBGVECB_OUT[29]);
  buf B_DBGVECB3 (DBGVECB[3], DBGVECB_OUT[3]);
  buf B_DBGVECB30 (DBGVECB[30], DBGVECB_OUT[30]);
  buf B_DBGVECB31 (DBGVECB[31], DBGVECB_OUT[31]);
  buf B_DBGVECB32 (DBGVECB[32], DBGVECB_OUT[32]);
  buf B_DBGVECB33 (DBGVECB[33], DBGVECB_OUT[33]);
  buf B_DBGVECB34 (DBGVECB[34], DBGVECB_OUT[34]);
  buf B_DBGVECB35 (DBGVECB[35], DBGVECB_OUT[35]);
  buf B_DBGVECB36 (DBGVECB[36], DBGVECB_OUT[36]);
  buf B_DBGVECB37 (DBGVECB[37], DBGVECB_OUT[37]);
  buf B_DBGVECB38 (DBGVECB[38], DBGVECB_OUT[38]);
  buf B_DBGVECB39 (DBGVECB[39], DBGVECB_OUT[39]);
  buf B_DBGVECB4 (DBGVECB[4], DBGVECB_OUT[4]);
  buf B_DBGVECB40 (DBGVECB[40], DBGVECB_OUT[40]);
  buf B_DBGVECB41 (DBGVECB[41], DBGVECB_OUT[41]);
  buf B_DBGVECB42 (DBGVECB[42], DBGVECB_OUT[42]);
  buf B_DBGVECB43 (DBGVECB[43], DBGVECB_OUT[43]);
  buf B_DBGVECB44 (DBGVECB[44], DBGVECB_OUT[44]);
  buf B_DBGVECB45 (DBGVECB[45], DBGVECB_OUT[45]);
  buf B_DBGVECB46 (DBGVECB[46], DBGVECB_OUT[46]);
  buf B_DBGVECB47 (DBGVECB[47], DBGVECB_OUT[47]);
  buf B_DBGVECB48 (DBGVECB[48], DBGVECB_OUT[48]);
  buf B_DBGVECB49 (DBGVECB[49], DBGVECB_OUT[49]);
  buf B_DBGVECB5 (DBGVECB[5], DBGVECB_OUT[5]);
  buf B_DBGVECB50 (DBGVECB[50], DBGVECB_OUT[50]);
  buf B_DBGVECB51 (DBGVECB[51], DBGVECB_OUT[51]);
  buf B_DBGVECB52 (DBGVECB[52], DBGVECB_OUT[52]);
  buf B_DBGVECB53 (DBGVECB[53], DBGVECB_OUT[53]);
  buf B_DBGVECB54 (DBGVECB[54], DBGVECB_OUT[54]);
  buf B_DBGVECB55 (DBGVECB[55], DBGVECB_OUT[55]);
  buf B_DBGVECB56 (DBGVECB[56], DBGVECB_OUT[56]);
  buf B_DBGVECB57 (DBGVECB[57], DBGVECB_OUT[57]);
  buf B_DBGVECB58 (DBGVECB[58], DBGVECB_OUT[58]);
  buf B_DBGVECB59 (DBGVECB[59], DBGVECB_OUT[59]);
  buf B_DBGVECB6 (DBGVECB[6], DBGVECB_OUT[6]);
  buf B_DBGVECB60 (DBGVECB[60], DBGVECB_OUT[60]);
  buf B_DBGVECB61 (DBGVECB[61], DBGVECB_OUT[61]);
  buf B_DBGVECB62 (DBGVECB[62], DBGVECB_OUT[62]);
  buf B_DBGVECB63 (DBGVECB[63], DBGVECB_OUT[63]);
  buf B_DBGVECB7 (DBGVECB[7], DBGVECB_OUT[7]);
  buf B_DBGVECB8 (DBGVECB[8], DBGVECB_OUT[8]);
  buf B_DBGVECB9 (DBGVECB[9], DBGVECB_OUT[9]);
  buf B_DBGVECC0 (DBGVECC[0], DBGVECC_OUT[0]);
  buf B_DBGVECC1 (DBGVECC[1], DBGVECC_OUT[1]);
  buf B_DBGVECC10 (DBGVECC[10], DBGVECC_OUT[10]);
  buf B_DBGVECC11 (DBGVECC[11], DBGVECC_OUT[11]);
  buf B_DBGVECC2 (DBGVECC[2], DBGVECC_OUT[2]);
  buf B_DBGVECC3 (DBGVECC[3], DBGVECC_OUT[3]);
  buf B_DBGVECC4 (DBGVECC[4], DBGVECC_OUT[4]);
  buf B_DBGVECC5 (DBGVECC[5], DBGVECC_OUT[5]);
  buf B_DBGVECC6 (DBGVECC[6], DBGVECC_OUT[6]);
  buf B_DBGVECC7 (DBGVECC[7], DBGVECC_OUT[7]);
  buf B_DBGVECC8 (DBGVECC[8], DBGVECC_OUT[8]);
  buf B_DBGVECC9 (DBGVECC[9], DBGVECC_OUT[9]);
  buf B_DRPDO0 (DRPDO[0], DRPDO_OUT[0]);
  buf B_DRPDO1 (DRPDO[1], DRPDO_OUT[1]);
  buf B_DRPDO10 (DRPDO[10], DRPDO_OUT[10]);
  buf B_DRPDO11 (DRPDO[11], DRPDO_OUT[11]);
  buf B_DRPDO12 (DRPDO[12], DRPDO_OUT[12]);
  buf B_DRPDO13 (DRPDO[13], DRPDO_OUT[13]);
  buf B_DRPDO14 (DRPDO[14], DRPDO_OUT[14]);
  buf B_DRPDO15 (DRPDO[15], DRPDO_OUT[15]);
  buf B_DRPDO2 (DRPDO[2], DRPDO_OUT[2]);
  buf B_DRPDO3 (DRPDO[3], DRPDO_OUT[3]);
  buf B_DRPDO4 (DRPDO[4], DRPDO_OUT[4]);
  buf B_DRPDO5 (DRPDO[5], DRPDO_OUT[5]);
  buf B_DRPDO6 (DRPDO[6], DRPDO_OUT[6]);
  buf B_DRPDO7 (DRPDO[7], DRPDO_OUT[7]);
  buf B_DRPDO8 (DRPDO[8], DRPDO_OUT[8]);
  buf B_DRPDO9 (DRPDO[9], DRPDO_OUT[9]);
  buf B_DRPDRDY (DRPDRDY, DRPDRDY_OUT);
  buf B_LL2BADDLLPERRN (LL2BADDLLPERRN, LL2BADDLLPERRN_OUT);
  buf B_LL2BADTLPERRN (LL2BADTLPERRN, LL2BADTLPERRN_OUT);
  buf B_LL2PROTOCOLERRN (LL2PROTOCOLERRN, LL2PROTOCOLERRN_OUT);
  buf B_LL2REPLAYROERRN (LL2REPLAYROERRN, LL2REPLAYROERRN_OUT);
  buf B_LL2REPLAYTOERRN (LL2REPLAYTOERRN, LL2REPLAYTOERRN_OUT);
  buf B_LL2SUSPENDOKN (LL2SUSPENDOKN, LL2SUSPENDOKN_OUT);
  buf B_LL2TFCINIT1SEQN (LL2TFCINIT1SEQN, LL2TFCINIT1SEQN_OUT);
  buf B_LL2TFCINIT2SEQN (LL2TFCINIT2SEQN, LL2TFCINIT2SEQN_OUT);
  buf B_LNKCLKEN (LNKCLKEN, LNKCLKEN_OUT);
  buf B_MIMRXRADDR0 (MIMRXRADDR[0], MIMRXRADDR_OUT[0]);
  buf B_MIMRXRADDR1 (MIMRXRADDR[1], MIMRXRADDR_OUT[1]);
  buf B_MIMRXRADDR10 (MIMRXRADDR[10], MIMRXRADDR_OUT[10]);
  buf B_MIMRXRADDR11 (MIMRXRADDR[11], MIMRXRADDR_OUT[11]);
  buf B_MIMRXRADDR12 (MIMRXRADDR[12], MIMRXRADDR_OUT[12]);
  buf B_MIMRXRADDR2 (MIMRXRADDR[2], MIMRXRADDR_OUT[2]);
  buf B_MIMRXRADDR3 (MIMRXRADDR[3], MIMRXRADDR_OUT[3]);
  buf B_MIMRXRADDR4 (MIMRXRADDR[4], MIMRXRADDR_OUT[4]);
  buf B_MIMRXRADDR5 (MIMRXRADDR[5], MIMRXRADDR_OUT[5]);
  buf B_MIMRXRADDR6 (MIMRXRADDR[6], MIMRXRADDR_OUT[6]);
  buf B_MIMRXRADDR7 (MIMRXRADDR[7], MIMRXRADDR_OUT[7]);
  buf B_MIMRXRADDR8 (MIMRXRADDR[8], MIMRXRADDR_OUT[8]);
  buf B_MIMRXRADDR9 (MIMRXRADDR[9], MIMRXRADDR_OUT[9]);
  buf B_MIMRXRCE (MIMRXRCE, MIMRXRCE_OUT);
  buf B_MIMRXREN (MIMRXREN, MIMRXREN_OUT);
  buf B_MIMRXWADDR0 (MIMRXWADDR[0], MIMRXWADDR_OUT[0]);
  buf B_MIMRXWADDR1 (MIMRXWADDR[1], MIMRXWADDR_OUT[1]);
  buf B_MIMRXWADDR10 (MIMRXWADDR[10], MIMRXWADDR_OUT[10]);
  buf B_MIMRXWADDR11 (MIMRXWADDR[11], MIMRXWADDR_OUT[11]);
  buf B_MIMRXWADDR12 (MIMRXWADDR[12], MIMRXWADDR_OUT[12]);
  buf B_MIMRXWADDR2 (MIMRXWADDR[2], MIMRXWADDR_OUT[2]);
  buf B_MIMRXWADDR3 (MIMRXWADDR[3], MIMRXWADDR_OUT[3]);
  buf B_MIMRXWADDR4 (MIMRXWADDR[4], MIMRXWADDR_OUT[4]);
  buf B_MIMRXWADDR5 (MIMRXWADDR[5], MIMRXWADDR_OUT[5]);
  buf B_MIMRXWADDR6 (MIMRXWADDR[6], MIMRXWADDR_OUT[6]);
  buf B_MIMRXWADDR7 (MIMRXWADDR[7], MIMRXWADDR_OUT[7]);
  buf B_MIMRXWADDR8 (MIMRXWADDR[8], MIMRXWADDR_OUT[8]);
  buf B_MIMRXWADDR9 (MIMRXWADDR[9], MIMRXWADDR_OUT[9]);
  buf B_MIMRXWDATA0 (MIMRXWDATA[0], MIMRXWDATA_OUT[0]);
  buf B_MIMRXWDATA1 (MIMRXWDATA[1], MIMRXWDATA_OUT[1]);
  buf B_MIMRXWDATA10 (MIMRXWDATA[10], MIMRXWDATA_OUT[10]);
  buf B_MIMRXWDATA11 (MIMRXWDATA[11], MIMRXWDATA_OUT[11]);
  buf B_MIMRXWDATA12 (MIMRXWDATA[12], MIMRXWDATA_OUT[12]);
  buf B_MIMRXWDATA13 (MIMRXWDATA[13], MIMRXWDATA_OUT[13]);
  buf B_MIMRXWDATA14 (MIMRXWDATA[14], MIMRXWDATA_OUT[14]);
  buf B_MIMRXWDATA15 (MIMRXWDATA[15], MIMRXWDATA_OUT[15]);
  buf B_MIMRXWDATA16 (MIMRXWDATA[16], MIMRXWDATA_OUT[16]);
  buf B_MIMRXWDATA17 (MIMRXWDATA[17], MIMRXWDATA_OUT[17]);
  buf B_MIMRXWDATA18 (MIMRXWDATA[18], MIMRXWDATA_OUT[18]);
  buf B_MIMRXWDATA19 (MIMRXWDATA[19], MIMRXWDATA_OUT[19]);
  buf B_MIMRXWDATA2 (MIMRXWDATA[2], MIMRXWDATA_OUT[2]);
  buf B_MIMRXWDATA20 (MIMRXWDATA[20], MIMRXWDATA_OUT[20]);
  buf B_MIMRXWDATA21 (MIMRXWDATA[21], MIMRXWDATA_OUT[21]);
  buf B_MIMRXWDATA22 (MIMRXWDATA[22], MIMRXWDATA_OUT[22]);
  buf B_MIMRXWDATA23 (MIMRXWDATA[23], MIMRXWDATA_OUT[23]);
  buf B_MIMRXWDATA24 (MIMRXWDATA[24], MIMRXWDATA_OUT[24]);
  buf B_MIMRXWDATA25 (MIMRXWDATA[25], MIMRXWDATA_OUT[25]);
  buf B_MIMRXWDATA26 (MIMRXWDATA[26], MIMRXWDATA_OUT[26]);
  buf B_MIMRXWDATA27 (MIMRXWDATA[27], MIMRXWDATA_OUT[27]);
  buf B_MIMRXWDATA28 (MIMRXWDATA[28], MIMRXWDATA_OUT[28]);
  buf B_MIMRXWDATA29 (MIMRXWDATA[29], MIMRXWDATA_OUT[29]);
  buf B_MIMRXWDATA3 (MIMRXWDATA[3], MIMRXWDATA_OUT[3]);
  buf B_MIMRXWDATA30 (MIMRXWDATA[30], MIMRXWDATA_OUT[30]);
  buf B_MIMRXWDATA31 (MIMRXWDATA[31], MIMRXWDATA_OUT[31]);
  buf B_MIMRXWDATA32 (MIMRXWDATA[32], MIMRXWDATA_OUT[32]);
  buf B_MIMRXWDATA33 (MIMRXWDATA[33], MIMRXWDATA_OUT[33]);
  buf B_MIMRXWDATA34 (MIMRXWDATA[34], MIMRXWDATA_OUT[34]);
  buf B_MIMRXWDATA35 (MIMRXWDATA[35], MIMRXWDATA_OUT[35]);
  buf B_MIMRXWDATA36 (MIMRXWDATA[36], MIMRXWDATA_OUT[36]);
  buf B_MIMRXWDATA37 (MIMRXWDATA[37], MIMRXWDATA_OUT[37]);
  buf B_MIMRXWDATA38 (MIMRXWDATA[38], MIMRXWDATA_OUT[38]);
  buf B_MIMRXWDATA39 (MIMRXWDATA[39], MIMRXWDATA_OUT[39]);
  buf B_MIMRXWDATA4 (MIMRXWDATA[4], MIMRXWDATA_OUT[4]);
  buf B_MIMRXWDATA40 (MIMRXWDATA[40], MIMRXWDATA_OUT[40]);
  buf B_MIMRXWDATA41 (MIMRXWDATA[41], MIMRXWDATA_OUT[41]);
  buf B_MIMRXWDATA42 (MIMRXWDATA[42], MIMRXWDATA_OUT[42]);
  buf B_MIMRXWDATA43 (MIMRXWDATA[43], MIMRXWDATA_OUT[43]);
  buf B_MIMRXWDATA44 (MIMRXWDATA[44], MIMRXWDATA_OUT[44]);
  buf B_MIMRXWDATA45 (MIMRXWDATA[45], MIMRXWDATA_OUT[45]);
  buf B_MIMRXWDATA46 (MIMRXWDATA[46], MIMRXWDATA_OUT[46]);
  buf B_MIMRXWDATA47 (MIMRXWDATA[47], MIMRXWDATA_OUT[47]);
  buf B_MIMRXWDATA48 (MIMRXWDATA[48], MIMRXWDATA_OUT[48]);
  buf B_MIMRXWDATA49 (MIMRXWDATA[49], MIMRXWDATA_OUT[49]);
  buf B_MIMRXWDATA5 (MIMRXWDATA[5], MIMRXWDATA_OUT[5]);
  buf B_MIMRXWDATA50 (MIMRXWDATA[50], MIMRXWDATA_OUT[50]);
  buf B_MIMRXWDATA51 (MIMRXWDATA[51], MIMRXWDATA_OUT[51]);
  buf B_MIMRXWDATA52 (MIMRXWDATA[52], MIMRXWDATA_OUT[52]);
  buf B_MIMRXWDATA53 (MIMRXWDATA[53], MIMRXWDATA_OUT[53]);
  buf B_MIMRXWDATA54 (MIMRXWDATA[54], MIMRXWDATA_OUT[54]);
  buf B_MIMRXWDATA55 (MIMRXWDATA[55], MIMRXWDATA_OUT[55]);
  buf B_MIMRXWDATA56 (MIMRXWDATA[56], MIMRXWDATA_OUT[56]);
  buf B_MIMRXWDATA57 (MIMRXWDATA[57], MIMRXWDATA_OUT[57]);
  buf B_MIMRXWDATA58 (MIMRXWDATA[58], MIMRXWDATA_OUT[58]);
  buf B_MIMRXWDATA59 (MIMRXWDATA[59], MIMRXWDATA_OUT[59]);
  buf B_MIMRXWDATA6 (MIMRXWDATA[6], MIMRXWDATA_OUT[6]);
  buf B_MIMRXWDATA60 (MIMRXWDATA[60], MIMRXWDATA_OUT[60]);
  buf B_MIMRXWDATA61 (MIMRXWDATA[61], MIMRXWDATA_OUT[61]);
  buf B_MIMRXWDATA62 (MIMRXWDATA[62], MIMRXWDATA_OUT[62]);
  buf B_MIMRXWDATA63 (MIMRXWDATA[63], MIMRXWDATA_OUT[63]);
  buf B_MIMRXWDATA64 (MIMRXWDATA[64], MIMRXWDATA_OUT[64]);
  buf B_MIMRXWDATA65 (MIMRXWDATA[65], MIMRXWDATA_OUT[65]);
  buf B_MIMRXWDATA66 (MIMRXWDATA[66], MIMRXWDATA_OUT[66]);
  buf B_MIMRXWDATA67 (MIMRXWDATA[67], MIMRXWDATA_OUT[67]);
  buf B_MIMRXWDATA7 (MIMRXWDATA[7], MIMRXWDATA_OUT[7]);
  buf B_MIMRXWDATA8 (MIMRXWDATA[8], MIMRXWDATA_OUT[8]);
  buf B_MIMRXWDATA9 (MIMRXWDATA[9], MIMRXWDATA_OUT[9]);
  buf B_MIMRXWEN (MIMRXWEN, MIMRXWEN_OUT);
  buf B_MIMTXRADDR0 (MIMTXRADDR[0], MIMTXRADDR_OUT[0]);
  buf B_MIMTXRADDR1 (MIMTXRADDR[1], MIMTXRADDR_OUT[1]);
  buf B_MIMTXRADDR10 (MIMTXRADDR[10], MIMTXRADDR_OUT[10]);
  buf B_MIMTXRADDR11 (MIMTXRADDR[11], MIMTXRADDR_OUT[11]);
  buf B_MIMTXRADDR12 (MIMTXRADDR[12], MIMTXRADDR_OUT[12]);
  buf B_MIMTXRADDR2 (MIMTXRADDR[2], MIMTXRADDR_OUT[2]);
  buf B_MIMTXRADDR3 (MIMTXRADDR[3], MIMTXRADDR_OUT[3]);
  buf B_MIMTXRADDR4 (MIMTXRADDR[4], MIMTXRADDR_OUT[4]);
  buf B_MIMTXRADDR5 (MIMTXRADDR[5], MIMTXRADDR_OUT[5]);
  buf B_MIMTXRADDR6 (MIMTXRADDR[6], MIMTXRADDR_OUT[6]);
  buf B_MIMTXRADDR7 (MIMTXRADDR[7], MIMTXRADDR_OUT[7]);
  buf B_MIMTXRADDR8 (MIMTXRADDR[8], MIMTXRADDR_OUT[8]);
  buf B_MIMTXRADDR9 (MIMTXRADDR[9], MIMTXRADDR_OUT[9]);
  buf B_MIMTXRCE (MIMTXRCE, MIMTXRCE_OUT);
  buf B_MIMTXREN (MIMTXREN, MIMTXREN_OUT);
  buf B_MIMTXWADDR0 (MIMTXWADDR[0], MIMTXWADDR_OUT[0]);
  buf B_MIMTXWADDR1 (MIMTXWADDR[1], MIMTXWADDR_OUT[1]);
  buf B_MIMTXWADDR10 (MIMTXWADDR[10], MIMTXWADDR_OUT[10]);
  buf B_MIMTXWADDR11 (MIMTXWADDR[11], MIMTXWADDR_OUT[11]);
  buf B_MIMTXWADDR12 (MIMTXWADDR[12], MIMTXWADDR_OUT[12]);
  buf B_MIMTXWADDR2 (MIMTXWADDR[2], MIMTXWADDR_OUT[2]);
  buf B_MIMTXWADDR3 (MIMTXWADDR[3], MIMTXWADDR_OUT[3]);
  buf B_MIMTXWADDR4 (MIMTXWADDR[4], MIMTXWADDR_OUT[4]);
  buf B_MIMTXWADDR5 (MIMTXWADDR[5], MIMTXWADDR_OUT[5]);
  buf B_MIMTXWADDR6 (MIMTXWADDR[6], MIMTXWADDR_OUT[6]);
  buf B_MIMTXWADDR7 (MIMTXWADDR[7], MIMTXWADDR_OUT[7]);
  buf B_MIMTXWADDR8 (MIMTXWADDR[8], MIMTXWADDR_OUT[8]);
  buf B_MIMTXWADDR9 (MIMTXWADDR[9], MIMTXWADDR_OUT[9]);
  buf B_MIMTXWDATA0 (MIMTXWDATA[0], MIMTXWDATA_OUT[0]);
  buf B_MIMTXWDATA1 (MIMTXWDATA[1], MIMTXWDATA_OUT[1]);
  buf B_MIMTXWDATA10 (MIMTXWDATA[10], MIMTXWDATA_OUT[10]);
  buf B_MIMTXWDATA11 (MIMTXWDATA[11], MIMTXWDATA_OUT[11]);
  buf B_MIMTXWDATA12 (MIMTXWDATA[12], MIMTXWDATA_OUT[12]);
  buf B_MIMTXWDATA13 (MIMTXWDATA[13], MIMTXWDATA_OUT[13]);
  buf B_MIMTXWDATA14 (MIMTXWDATA[14], MIMTXWDATA_OUT[14]);
  buf B_MIMTXWDATA15 (MIMTXWDATA[15], MIMTXWDATA_OUT[15]);
  buf B_MIMTXWDATA16 (MIMTXWDATA[16], MIMTXWDATA_OUT[16]);
  buf B_MIMTXWDATA17 (MIMTXWDATA[17], MIMTXWDATA_OUT[17]);
  buf B_MIMTXWDATA18 (MIMTXWDATA[18], MIMTXWDATA_OUT[18]);
  buf B_MIMTXWDATA19 (MIMTXWDATA[19], MIMTXWDATA_OUT[19]);
  buf B_MIMTXWDATA2 (MIMTXWDATA[2], MIMTXWDATA_OUT[2]);
  buf B_MIMTXWDATA20 (MIMTXWDATA[20], MIMTXWDATA_OUT[20]);
  buf B_MIMTXWDATA21 (MIMTXWDATA[21], MIMTXWDATA_OUT[21]);
  buf B_MIMTXWDATA22 (MIMTXWDATA[22], MIMTXWDATA_OUT[22]);
  buf B_MIMTXWDATA23 (MIMTXWDATA[23], MIMTXWDATA_OUT[23]);
  buf B_MIMTXWDATA24 (MIMTXWDATA[24], MIMTXWDATA_OUT[24]);
  buf B_MIMTXWDATA25 (MIMTXWDATA[25], MIMTXWDATA_OUT[25]);
  buf B_MIMTXWDATA26 (MIMTXWDATA[26], MIMTXWDATA_OUT[26]);
  buf B_MIMTXWDATA27 (MIMTXWDATA[27], MIMTXWDATA_OUT[27]);
  buf B_MIMTXWDATA28 (MIMTXWDATA[28], MIMTXWDATA_OUT[28]);
  buf B_MIMTXWDATA29 (MIMTXWDATA[29], MIMTXWDATA_OUT[29]);
  buf B_MIMTXWDATA3 (MIMTXWDATA[3], MIMTXWDATA_OUT[3]);
  buf B_MIMTXWDATA30 (MIMTXWDATA[30], MIMTXWDATA_OUT[30]);
  buf B_MIMTXWDATA31 (MIMTXWDATA[31], MIMTXWDATA_OUT[31]);
  buf B_MIMTXWDATA32 (MIMTXWDATA[32], MIMTXWDATA_OUT[32]);
  buf B_MIMTXWDATA33 (MIMTXWDATA[33], MIMTXWDATA_OUT[33]);
  buf B_MIMTXWDATA34 (MIMTXWDATA[34], MIMTXWDATA_OUT[34]);
  buf B_MIMTXWDATA35 (MIMTXWDATA[35], MIMTXWDATA_OUT[35]);
  buf B_MIMTXWDATA36 (MIMTXWDATA[36], MIMTXWDATA_OUT[36]);
  buf B_MIMTXWDATA37 (MIMTXWDATA[37], MIMTXWDATA_OUT[37]);
  buf B_MIMTXWDATA38 (MIMTXWDATA[38], MIMTXWDATA_OUT[38]);
  buf B_MIMTXWDATA39 (MIMTXWDATA[39], MIMTXWDATA_OUT[39]);
  buf B_MIMTXWDATA4 (MIMTXWDATA[4], MIMTXWDATA_OUT[4]);
  buf B_MIMTXWDATA40 (MIMTXWDATA[40], MIMTXWDATA_OUT[40]);
  buf B_MIMTXWDATA41 (MIMTXWDATA[41], MIMTXWDATA_OUT[41]);
  buf B_MIMTXWDATA42 (MIMTXWDATA[42], MIMTXWDATA_OUT[42]);
  buf B_MIMTXWDATA43 (MIMTXWDATA[43], MIMTXWDATA_OUT[43]);
  buf B_MIMTXWDATA44 (MIMTXWDATA[44], MIMTXWDATA_OUT[44]);
  buf B_MIMTXWDATA45 (MIMTXWDATA[45], MIMTXWDATA_OUT[45]);
  buf B_MIMTXWDATA46 (MIMTXWDATA[46], MIMTXWDATA_OUT[46]);
  buf B_MIMTXWDATA47 (MIMTXWDATA[47], MIMTXWDATA_OUT[47]);
  buf B_MIMTXWDATA48 (MIMTXWDATA[48], MIMTXWDATA_OUT[48]);
  buf B_MIMTXWDATA49 (MIMTXWDATA[49], MIMTXWDATA_OUT[49]);
  buf B_MIMTXWDATA5 (MIMTXWDATA[5], MIMTXWDATA_OUT[5]);
  buf B_MIMTXWDATA50 (MIMTXWDATA[50], MIMTXWDATA_OUT[50]);
  buf B_MIMTXWDATA51 (MIMTXWDATA[51], MIMTXWDATA_OUT[51]);
  buf B_MIMTXWDATA52 (MIMTXWDATA[52], MIMTXWDATA_OUT[52]);
  buf B_MIMTXWDATA53 (MIMTXWDATA[53], MIMTXWDATA_OUT[53]);
  buf B_MIMTXWDATA54 (MIMTXWDATA[54], MIMTXWDATA_OUT[54]);
  buf B_MIMTXWDATA55 (MIMTXWDATA[55], MIMTXWDATA_OUT[55]);
  buf B_MIMTXWDATA56 (MIMTXWDATA[56], MIMTXWDATA_OUT[56]);
  buf B_MIMTXWDATA57 (MIMTXWDATA[57], MIMTXWDATA_OUT[57]);
  buf B_MIMTXWDATA58 (MIMTXWDATA[58], MIMTXWDATA_OUT[58]);
  buf B_MIMTXWDATA59 (MIMTXWDATA[59], MIMTXWDATA_OUT[59]);
  buf B_MIMTXWDATA6 (MIMTXWDATA[6], MIMTXWDATA_OUT[6]);
  buf B_MIMTXWDATA60 (MIMTXWDATA[60], MIMTXWDATA_OUT[60]);
  buf B_MIMTXWDATA61 (MIMTXWDATA[61], MIMTXWDATA_OUT[61]);
  buf B_MIMTXWDATA62 (MIMTXWDATA[62], MIMTXWDATA_OUT[62]);
  buf B_MIMTXWDATA63 (MIMTXWDATA[63], MIMTXWDATA_OUT[63]);
  buf B_MIMTXWDATA64 (MIMTXWDATA[64], MIMTXWDATA_OUT[64]);
  buf B_MIMTXWDATA65 (MIMTXWDATA[65], MIMTXWDATA_OUT[65]);
  buf B_MIMTXWDATA66 (MIMTXWDATA[66], MIMTXWDATA_OUT[66]);
  buf B_MIMTXWDATA67 (MIMTXWDATA[67], MIMTXWDATA_OUT[67]);
  buf B_MIMTXWDATA68 (MIMTXWDATA[68], MIMTXWDATA_OUT[68]);
  buf B_MIMTXWDATA7 (MIMTXWDATA[7], MIMTXWDATA_OUT[7]);
  buf B_MIMTXWDATA8 (MIMTXWDATA[8], MIMTXWDATA_OUT[8]);
  buf B_MIMTXWDATA9 (MIMTXWDATA[9], MIMTXWDATA_OUT[9]);
  buf B_MIMTXWEN (MIMTXWEN, MIMTXWEN_OUT);
  buf B_PIPERX0POLARITY (PIPERX0POLARITY, PIPERX0POLARITY_OUT);
  buf B_PIPERX1POLARITY (PIPERX1POLARITY, PIPERX1POLARITY_OUT);
  buf B_PIPERX2POLARITY (PIPERX2POLARITY, PIPERX2POLARITY_OUT);
  buf B_PIPERX3POLARITY (PIPERX3POLARITY, PIPERX3POLARITY_OUT);
  buf B_PIPERX4POLARITY (PIPERX4POLARITY, PIPERX4POLARITY_OUT);
  buf B_PIPERX5POLARITY (PIPERX5POLARITY, PIPERX5POLARITY_OUT);
  buf B_PIPERX6POLARITY (PIPERX6POLARITY, PIPERX6POLARITY_OUT);
  buf B_PIPERX7POLARITY (PIPERX7POLARITY, PIPERX7POLARITY_OUT);
  buf B_PIPETX0CHARISK0 (PIPETX0CHARISK[0], PIPETX0CHARISK_OUT[0]);
  buf B_PIPETX0CHARISK1 (PIPETX0CHARISK[1], PIPETX0CHARISK_OUT[1]);
  buf B_PIPETX0COMPLIANCE (PIPETX0COMPLIANCE, PIPETX0COMPLIANCE_OUT);
  buf B_PIPETX0DATA0 (PIPETX0DATA[0], PIPETX0DATA_OUT[0]);
  buf B_PIPETX0DATA1 (PIPETX0DATA[1], PIPETX0DATA_OUT[1]);
  buf B_PIPETX0DATA10 (PIPETX0DATA[10], PIPETX0DATA_OUT[10]);
  buf B_PIPETX0DATA11 (PIPETX0DATA[11], PIPETX0DATA_OUT[11]);
  buf B_PIPETX0DATA12 (PIPETX0DATA[12], PIPETX0DATA_OUT[12]);
  buf B_PIPETX0DATA13 (PIPETX0DATA[13], PIPETX0DATA_OUT[13]);
  buf B_PIPETX0DATA14 (PIPETX0DATA[14], PIPETX0DATA_OUT[14]);
  buf B_PIPETX0DATA15 (PIPETX0DATA[15], PIPETX0DATA_OUT[15]);
  buf B_PIPETX0DATA2 (PIPETX0DATA[2], PIPETX0DATA_OUT[2]);
  buf B_PIPETX0DATA3 (PIPETX0DATA[3], PIPETX0DATA_OUT[3]);
  buf B_PIPETX0DATA4 (PIPETX0DATA[4], PIPETX0DATA_OUT[4]);
  buf B_PIPETX0DATA5 (PIPETX0DATA[5], PIPETX0DATA_OUT[5]);
  buf B_PIPETX0DATA6 (PIPETX0DATA[6], PIPETX0DATA_OUT[6]);
  buf B_PIPETX0DATA7 (PIPETX0DATA[7], PIPETX0DATA_OUT[7]);
  buf B_PIPETX0DATA8 (PIPETX0DATA[8], PIPETX0DATA_OUT[8]);
  buf B_PIPETX0DATA9 (PIPETX0DATA[9], PIPETX0DATA_OUT[9]);
  buf B_PIPETX0ELECIDLE (PIPETX0ELECIDLE, PIPETX0ELECIDLE_OUT);
  buf B_PIPETX0POWERDOWN0 (PIPETX0POWERDOWN[0], PIPETX0POWERDOWN_OUT[0]);
  buf B_PIPETX0POWERDOWN1 (PIPETX0POWERDOWN[1], PIPETX0POWERDOWN_OUT[1]);
  buf B_PIPETX1CHARISK0 (PIPETX1CHARISK[0], PIPETX1CHARISK_OUT[0]);
  buf B_PIPETX1CHARISK1 (PIPETX1CHARISK[1], PIPETX1CHARISK_OUT[1]);
  buf B_PIPETX1COMPLIANCE (PIPETX1COMPLIANCE, PIPETX1COMPLIANCE_OUT);
  buf B_PIPETX1DATA0 (PIPETX1DATA[0], PIPETX1DATA_OUT[0]);
  buf B_PIPETX1DATA1 (PIPETX1DATA[1], PIPETX1DATA_OUT[1]);
  buf B_PIPETX1DATA10 (PIPETX1DATA[10], PIPETX1DATA_OUT[10]);
  buf B_PIPETX1DATA11 (PIPETX1DATA[11], PIPETX1DATA_OUT[11]);
  buf B_PIPETX1DATA12 (PIPETX1DATA[12], PIPETX1DATA_OUT[12]);
  buf B_PIPETX1DATA13 (PIPETX1DATA[13], PIPETX1DATA_OUT[13]);
  buf B_PIPETX1DATA14 (PIPETX1DATA[14], PIPETX1DATA_OUT[14]);
  buf B_PIPETX1DATA15 (PIPETX1DATA[15], PIPETX1DATA_OUT[15]);
  buf B_PIPETX1DATA2 (PIPETX1DATA[2], PIPETX1DATA_OUT[2]);
  buf B_PIPETX1DATA3 (PIPETX1DATA[3], PIPETX1DATA_OUT[3]);
  buf B_PIPETX1DATA4 (PIPETX1DATA[4], PIPETX1DATA_OUT[4]);
  buf B_PIPETX1DATA5 (PIPETX1DATA[5], PIPETX1DATA_OUT[5]);
  buf B_PIPETX1DATA6 (PIPETX1DATA[6], PIPETX1DATA_OUT[6]);
  buf B_PIPETX1DATA7 (PIPETX1DATA[7], PIPETX1DATA_OUT[7]);
  buf B_PIPETX1DATA8 (PIPETX1DATA[8], PIPETX1DATA_OUT[8]);
  buf B_PIPETX1DATA9 (PIPETX1DATA[9], PIPETX1DATA_OUT[9]);
  buf B_PIPETX1ELECIDLE (PIPETX1ELECIDLE, PIPETX1ELECIDLE_OUT);
  buf B_PIPETX1POWERDOWN0 (PIPETX1POWERDOWN[0], PIPETX1POWERDOWN_OUT[0]);
  buf B_PIPETX1POWERDOWN1 (PIPETX1POWERDOWN[1], PIPETX1POWERDOWN_OUT[1]);
  buf B_PIPETX2CHARISK0 (PIPETX2CHARISK[0], PIPETX2CHARISK_OUT[0]);
  buf B_PIPETX2CHARISK1 (PIPETX2CHARISK[1], PIPETX2CHARISK_OUT[1]);
  buf B_PIPETX2COMPLIANCE (PIPETX2COMPLIANCE, PIPETX2COMPLIANCE_OUT);
  buf B_PIPETX2DATA0 (PIPETX2DATA[0], PIPETX2DATA_OUT[0]);
  buf B_PIPETX2DATA1 (PIPETX2DATA[1], PIPETX2DATA_OUT[1]);
  buf B_PIPETX2DATA10 (PIPETX2DATA[10], PIPETX2DATA_OUT[10]);
  buf B_PIPETX2DATA11 (PIPETX2DATA[11], PIPETX2DATA_OUT[11]);
  buf B_PIPETX2DATA12 (PIPETX2DATA[12], PIPETX2DATA_OUT[12]);
  buf B_PIPETX2DATA13 (PIPETX2DATA[13], PIPETX2DATA_OUT[13]);
  buf B_PIPETX2DATA14 (PIPETX2DATA[14], PIPETX2DATA_OUT[14]);
  buf B_PIPETX2DATA15 (PIPETX2DATA[15], PIPETX2DATA_OUT[15]);
  buf B_PIPETX2DATA2 (PIPETX2DATA[2], PIPETX2DATA_OUT[2]);
  buf B_PIPETX2DATA3 (PIPETX2DATA[3], PIPETX2DATA_OUT[3]);
  buf B_PIPETX2DATA4 (PIPETX2DATA[4], PIPETX2DATA_OUT[4]);
  buf B_PIPETX2DATA5 (PIPETX2DATA[5], PIPETX2DATA_OUT[5]);
  buf B_PIPETX2DATA6 (PIPETX2DATA[6], PIPETX2DATA_OUT[6]);
  buf B_PIPETX2DATA7 (PIPETX2DATA[7], PIPETX2DATA_OUT[7]);
  buf B_PIPETX2DATA8 (PIPETX2DATA[8], PIPETX2DATA_OUT[8]);
  buf B_PIPETX2DATA9 (PIPETX2DATA[9], PIPETX2DATA_OUT[9]);
  buf B_PIPETX2ELECIDLE (PIPETX2ELECIDLE, PIPETX2ELECIDLE_OUT);
  buf B_PIPETX2POWERDOWN0 (PIPETX2POWERDOWN[0], PIPETX2POWERDOWN_OUT[0]);
  buf B_PIPETX2POWERDOWN1 (PIPETX2POWERDOWN[1], PIPETX2POWERDOWN_OUT[1]);
  buf B_PIPETX3CHARISK0 (PIPETX3CHARISK[0], PIPETX3CHARISK_OUT[0]);
  buf B_PIPETX3CHARISK1 (PIPETX3CHARISK[1], PIPETX3CHARISK_OUT[1]);
  buf B_PIPETX3COMPLIANCE (PIPETX3COMPLIANCE, PIPETX3COMPLIANCE_OUT);
  buf B_PIPETX3DATA0 (PIPETX3DATA[0], PIPETX3DATA_OUT[0]);
  buf B_PIPETX3DATA1 (PIPETX3DATA[1], PIPETX3DATA_OUT[1]);
  buf B_PIPETX3DATA10 (PIPETX3DATA[10], PIPETX3DATA_OUT[10]);
  buf B_PIPETX3DATA11 (PIPETX3DATA[11], PIPETX3DATA_OUT[11]);
  buf B_PIPETX3DATA12 (PIPETX3DATA[12], PIPETX3DATA_OUT[12]);
  buf B_PIPETX3DATA13 (PIPETX3DATA[13], PIPETX3DATA_OUT[13]);
  buf B_PIPETX3DATA14 (PIPETX3DATA[14], PIPETX3DATA_OUT[14]);
  buf B_PIPETX3DATA15 (PIPETX3DATA[15], PIPETX3DATA_OUT[15]);
  buf B_PIPETX3DATA2 (PIPETX3DATA[2], PIPETX3DATA_OUT[2]);
  buf B_PIPETX3DATA3 (PIPETX3DATA[3], PIPETX3DATA_OUT[3]);
  buf B_PIPETX3DATA4 (PIPETX3DATA[4], PIPETX3DATA_OUT[4]);
  buf B_PIPETX3DATA5 (PIPETX3DATA[5], PIPETX3DATA_OUT[5]);
  buf B_PIPETX3DATA6 (PIPETX3DATA[6], PIPETX3DATA_OUT[6]);
  buf B_PIPETX3DATA7 (PIPETX3DATA[7], PIPETX3DATA_OUT[7]);
  buf B_PIPETX3DATA8 (PIPETX3DATA[8], PIPETX3DATA_OUT[8]);
  buf B_PIPETX3DATA9 (PIPETX3DATA[9], PIPETX3DATA_OUT[9]);
  buf B_PIPETX3ELECIDLE (PIPETX3ELECIDLE, PIPETX3ELECIDLE_OUT);
  buf B_PIPETX3POWERDOWN0 (PIPETX3POWERDOWN[0], PIPETX3POWERDOWN_OUT[0]);
  buf B_PIPETX3POWERDOWN1 (PIPETX3POWERDOWN[1], PIPETX3POWERDOWN_OUT[1]);
  buf B_PIPETX4CHARISK0 (PIPETX4CHARISK[0], PIPETX4CHARISK_OUT[0]);
  buf B_PIPETX4CHARISK1 (PIPETX4CHARISK[1], PIPETX4CHARISK_OUT[1]);
  buf B_PIPETX4COMPLIANCE (PIPETX4COMPLIANCE, PIPETX4COMPLIANCE_OUT);
  buf B_PIPETX4DATA0 (PIPETX4DATA[0], PIPETX4DATA_OUT[0]);
  buf B_PIPETX4DATA1 (PIPETX4DATA[1], PIPETX4DATA_OUT[1]);
  buf B_PIPETX4DATA10 (PIPETX4DATA[10], PIPETX4DATA_OUT[10]);
  buf B_PIPETX4DATA11 (PIPETX4DATA[11], PIPETX4DATA_OUT[11]);
  buf B_PIPETX4DATA12 (PIPETX4DATA[12], PIPETX4DATA_OUT[12]);
  buf B_PIPETX4DATA13 (PIPETX4DATA[13], PIPETX4DATA_OUT[13]);
  buf B_PIPETX4DATA14 (PIPETX4DATA[14], PIPETX4DATA_OUT[14]);
  buf B_PIPETX4DATA15 (PIPETX4DATA[15], PIPETX4DATA_OUT[15]);
  buf B_PIPETX4DATA2 (PIPETX4DATA[2], PIPETX4DATA_OUT[2]);
  buf B_PIPETX4DATA3 (PIPETX4DATA[3], PIPETX4DATA_OUT[3]);
  buf B_PIPETX4DATA4 (PIPETX4DATA[4], PIPETX4DATA_OUT[4]);
  buf B_PIPETX4DATA5 (PIPETX4DATA[5], PIPETX4DATA_OUT[5]);
  buf B_PIPETX4DATA6 (PIPETX4DATA[6], PIPETX4DATA_OUT[6]);
  buf B_PIPETX4DATA7 (PIPETX4DATA[7], PIPETX4DATA_OUT[7]);
  buf B_PIPETX4DATA8 (PIPETX4DATA[8], PIPETX4DATA_OUT[8]);
  buf B_PIPETX4DATA9 (PIPETX4DATA[9], PIPETX4DATA_OUT[9]);
  buf B_PIPETX4ELECIDLE (PIPETX4ELECIDLE, PIPETX4ELECIDLE_OUT);
  buf B_PIPETX4POWERDOWN0 (PIPETX4POWERDOWN[0], PIPETX4POWERDOWN_OUT[0]);
  buf B_PIPETX4POWERDOWN1 (PIPETX4POWERDOWN[1], PIPETX4POWERDOWN_OUT[1]);
  buf B_PIPETX5CHARISK0 (PIPETX5CHARISK[0], PIPETX5CHARISK_OUT[0]);
  buf B_PIPETX5CHARISK1 (PIPETX5CHARISK[1], PIPETX5CHARISK_OUT[1]);
  buf B_PIPETX5COMPLIANCE (PIPETX5COMPLIANCE, PIPETX5COMPLIANCE_OUT);
  buf B_PIPETX5DATA0 (PIPETX5DATA[0], PIPETX5DATA_OUT[0]);
  buf B_PIPETX5DATA1 (PIPETX5DATA[1], PIPETX5DATA_OUT[1]);
  buf B_PIPETX5DATA10 (PIPETX5DATA[10], PIPETX5DATA_OUT[10]);
  buf B_PIPETX5DATA11 (PIPETX5DATA[11], PIPETX5DATA_OUT[11]);
  buf B_PIPETX5DATA12 (PIPETX5DATA[12], PIPETX5DATA_OUT[12]);
  buf B_PIPETX5DATA13 (PIPETX5DATA[13], PIPETX5DATA_OUT[13]);
  buf B_PIPETX5DATA14 (PIPETX5DATA[14], PIPETX5DATA_OUT[14]);
  buf B_PIPETX5DATA15 (PIPETX5DATA[15], PIPETX5DATA_OUT[15]);
  buf B_PIPETX5DATA2 (PIPETX5DATA[2], PIPETX5DATA_OUT[2]);
  buf B_PIPETX5DATA3 (PIPETX5DATA[3], PIPETX5DATA_OUT[3]);
  buf B_PIPETX5DATA4 (PIPETX5DATA[4], PIPETX5DATA_OUT[4]);
  buf B_PIPETX5DATA5 (PIPETX5DATA[5], PIPETX5DATA_OUT[5]);
  buf B_PIPETX5DATA6 (PIPETX5DATA[6], PIPETX5DATA_OUT[6]);
  buf B_PIPETX5DATA7 (PIPETX5DATA[7], PIPETX5DATA_OUT[7]);
  buf B_PIPETX5DATA8 (PIPETX5DATA[8], PIPETX5DATA_OUT[8]);
  buf B_PIPETX5DATA9 (PIPETX5DATA[9], PIPETX5DATA_OUT[9]);
  buf B_PIPETX5ELECIDLE (PIPETX5ELECIDLE, PIPETX5ELECIDLE_OUT);
  buf B_PIPETX5POWERDOWN0 (PIPETX5POWERDOWN[0], PIPETX5POWERDOWN_OUT[0]);
  buf B_PIPETX5POWERDOWN1 (PIPETX5POWERDOWN[1], PIPETX5POWERDOWN_OUT[1]);
  buf B_PIPETX6CHARISK0 (PIPETX6CHARISK[0], PIPETX6CHARISK_OUT[0]);
  buf B_PIPETX6CHARISK1 (PIPETX6CHARISK[1], PIPETX6CHARISK_OUT[1]);
  buf B_PIPETX6COMPLIANCE (PIPETX6COMPLIANCE, PIPETX6COMPLIANCE_OUT);
  buf B_PIPETX6DATA0 (PIPETX6DATA[0], PIPETX6DATA_OUT[0]);
  buf B_PIPETX6DATA1 (PIPETX6DATA[1], PIPETX6DATA_OUT[1]);
  buf B_PIPETX6DATA10 (PIPETX6DATA[10], PIPETX6DATA_OUT[10]);
  buf B_PIPETX6DATA11 (PIPETX6DATA[11], PIPETX6DATA_OUT[11]);
  buf B_PIPETX6DATA12 (PIPETX6DATA[12], PIPETX6DATA_OUT[12]);
  buf B_PIPETX6DATA13 (PIPETX6DATA[13], PIPETX6DATA_OUT[13]);
  buf B_PIPETX6DATA14 (PIPETX6DATA[14], PIPETX6DATA_OUT[14]);
  buf B_PIPETX6DATA15 (PIPETX6DATA[15], PIPETX6DATA_OUT[15]);
  buf B_PIPETX6DATA2 (PIPETX6DATA[2], PIPETX6DATA_OUT[2]);
  buf B_PIPETX6DATA3 (PIPETX6DATA[3], PIPETX6DATA_OUT[3]);
  buf B_PIPETX6DATA4 (PIPETX6DATA[4], PIPETX6DATA_OUT[4]);
  buf B_PIPETX6DATA5 (PIPETX6DATA[5], PIPETX6DATA_OUT[5]);
  buf B_PIPETX6DATA6 (PIPETX6DATA[6], PIPETX6DATA_OUT[6]);
  buf B_PIPETX6DATA7 (PIPETX6DATA[7], PIPETX6DATA_OUT[7]);
  buf B_PIPETX6DATA8 (PIPETX6DATA[8], PIPETX6DATA_OUT[8]);
  buf B_PIPETX6DATA9 (PIPETX6DATA[9], PIPETX6DATA_OUT[9]);
  buf B_PIPETX6ELECIDLE (PIPETX6ELECIDLE, PIPETX6ELECIDLE_OUT);
  buf B_PIPETX6POWERDOWN0 (PIPETX6POWERDOWN[0], PIPETX6POWERDOWN_OUT[0]);
  buf B_PIPETX6POWERDOWN1 (PIPETX6POWERDOWN[1], PIPETX6POWERDOWN_OUT[1]);
  buf B_PIPETX7CHARISK0 (PIPETX7CHARISK[0], PIPETX7CHARISK_OUT[0]);
  buf B_PIPETX7CHARISK1 (PIPETX7CHARISK[1], PIPETX7CHARISK_OUT[1]);
  buf B_PIPETX7COMPLIANCE (PIPETX7COMPLIANCE, PIPETX7COMPLIANCE_OUT);
  buf B_PIPETX7DATA0 (PIPETX7DATA[0], PIPETX7DATA_OUT[0]);
  buf B_PIPETX7DATA1 (PIPETX7DATA[1], PIPETX7DATA_OUT[1]);
  buf B_PIPETX7DATA10 (PIPETX7DATA[10], PIPETX7DATA_OUT[10]);
  buf B_PIPETX7DATA11 (PIPETX7DATA[11], PIPETX7DATA_OUT[11]);
  buf B_PIPETX7DATA12 (PIPETX7DATA[12], PIPETX7DATA_OUT[12]);
  buf B_PIPETX7DATA13 (PIPETX7DATA[13], PIPETX7DATA_OUT[13]);
  buf B_PIPETX7DATA14 (PIPETX7DATA[14], PIPETX7DATA_OUT[14]);
  buf B_PIPETX7DATA15 (PIPETX7DATA[15], PIPETX7DATA_OUT[15]);
  buf B_PIPETX7DATA2 (PIPETX7DATA[2], PIPETX7DATA_OUT[2]);
  buf B_PIPETX7DATA3 (PIPETX7DATA[3], PIPETX7DATA_OUT[3]);
  buf B_PIPETX7DATA4 (PIPETX7DATA[4], PIPETX7DATA_OUT[4]);
  buf B_PIPETX7DATA5 (PIPETX7DATA[5], PIPETX7DATA_OUT[5]);
  buf B_PIPETX7DATA6 (PIPETX7DATA[6], PIPETX7DATA_OUT[6]);
  buf B_PIPETX7DATA7 (PIPETX7DATA[7], PIPETX7DATA_OUT[7]);
  buf B_PIPETX7DATA8 (PIPETX7DATA[8], PIPETX7DATA_OUT[8]);
  buf B_PIPETX7DATA9 (PIPETX7DATA[9], PIPETX7DATA_OUT[9]);
  buf B_PIPETX7ELECIDLE (PIPETX7ELECIDLE, PIPETX7ELECIDLE_OUT);
  buf B_PIPETX7POWERDOWN0 (PIPETX7POWERDOWN[0], PIPETX7POWERDOWN_OUT[0]);
  buf B_PIPETX7POWERDOWN1 (PIPETX7POWERDOWN[1], PIPETX7POWERDOWN_OUT[1]);
  buf B_PIPETXDEEMPH (PIPETXDEEMPH, PIPETXDEEMPH_OUT);
  buf B_PIPETXMARGIN0 (PIPETXMARGIN[0], PIPETXMARGIN_OUT[0]);
  buf B_PIPETXMARGIN1 (PIPETXMARGIN[1], PIPETXMARGIN_OUT[1]);
  buf B_PIPETXMARGIN2 (PIPETXMARGIN[2], PIPETXMARGIN_OUT[2]);
  buf B_PIPETXRATE (PIPETXRATE, PIPETXRATE_OUT);
  buf B_PIPETXRCVRDET (PIPETXRCVRDET, PIPETXRCVRDET_OUT);
  buf B_PIPETXRESET (PIPETXRESET, PIPETXRESET_OUT);
  buf B_PL2LINKUPN (PL2LINKUPN, PL2LINKUPN_OUT);
  buf B_PL2RECEIVERERRN (PL2RECEIVERERRN, PL2RECEIVERERRN_OUT);
  buf B_PL2RECOVERYN (PL2RECOVERYN, PL2RECOVERYN_OUT);
  buf B_PL2RXELECIDLE (PL2RXELECIDLE, PL2RXELECIDLE_OUT);
  buf B_PL2SUSPENDOK (PL2SUSPENDOK, PL2SUSPENDOK_OUT);
  buf B_PLDBGVEC0 (PLDBGVEC[0], PLDBGVEC_OUT[0]);
  buf B_PLDBGVEC1 (PLDBGVEC[1], PLDBGVEC_OUT[1]);
  buf B_PLDBGVEC10 (PLDBGVEC[10], PLDBGVEC_OUT[10]);
  buf B_PLDBGVEC11 (PLDBGVEC[11], PLDBGVEC_OUT[11]);
  buf B_PLDBGVEC2 (PLDBGVEC[2], PLDBGVEC_OUT[2]);
  buf B_PLDBGVEC3 (PLDBGVEC[3], PLDBGVEC_OUT[3]);
  buf B_PLDBGVEC4 (PLDBGVEC[4], PLDBGVEC_OUT[4]);
  buf B_PLDBGVEC5 (PLDBGVEC[5], PLDBGVEC_OUT[5]);
  buf B_PLDBGVEC6 (PLDBGVEC[6], PLDBGVEC_OUT[6]);
  buf B_PLDBGVEC7 (PLDBGVEC[7], PLDBGVEC_OUT[7]);
  buf B_PLDBGVEC8 (PLDBGVEC[8], PLDBGVEC_OUT[8]);
  buf B_PLDBGVEC9 (PLDBGVEC[9], PLDBGVEC_OUT[9]);
  buf B_PLINITIALLINKWIDTH0 (PLINITIALLINKWIDTH[0], PLINITIALLINKWIDTH_OUT[0]);
  buf B_PLINITIALLINKWIDTH1 (PLINITIALLINKWIDTH[1], PLINITIALLINKWIDTH_OUT[1]);
  buf B_PLINITIALLINKWIDTH2 (PLINITIALLINKWIDTH[2], PLINITIALLINKWIDTH_OUT[2]);
  buf B_PLLANEREVERSALMODE0 (PLLANEREVERSALMODE[0], PLLANEREVERSALMODE_OUT[0]);
  buf B_PLLANEREVERSALMODE1 (PLLANEREVERSALMODE[1], PLLANEREVERSALMODE_OUT[1]);
  buf B_PLLINKGEN2CAP (PLLINKGEN2CAP, PLLINKGEN2CAP_OUT);
  buf B_PLLINKPARTNERGEN2SUPPORTED (PLLINKPARTNERGEN2SUPPORTED, PLLINKPARTNERGEN2SUPPORTED_OUT);
  buf B_PLLINKUPCFGCAP (PLLINKUPCFGCAP, PLLINKUPCFGCAP_OUT);
  buf B_PLLTSSMSTATE0 (PLLTSSMSTATE[0], PLLTSSMSTATE_OUT[0]);
  buf B_PLLTSSMSTATE1 (PLLTSSMSTATE[1], PLLTSSMSTATE_OUT[1]);
  buf B_PLLTSSMSTATE2 (PLLTSSMSTATE[2], PLLTSSMSTATE_OUT[2]);
  buf B_PLLTSSMSTATE3 (PLLTSSMSTATE[3], PLLTSSMSTATE_OUT[3]);
  buf B_PLLTSSMSTATE4 (PLLTSSMSTATE[4], PLLTSSMSTATE_OUT[4]);
  buf B_PLLTSSMSTATE5 (PLLTSSMSTATE[5], PLLTSSMSTATE_OUT[5]);
  buf B_PLPHYLNKUPN (PLPHYLNKUPN, PLPHYLNKUPN_OUT);
  buf B_PLRECEIVEDHOTRST (PLRECEIVEDHOTRST, PLRECEIVEDHOTRST_OUT);
  buf B_PLRXPMSTATE0 (PLRXPMSTATE[0], PLRXPMSTATE_OUT[0]);
  buf B_PLRXPMSTATE1 (PLRXPMSTATE[1], PLRXPMSTATE_OUT[1]);
  buf B_PLSELLNKRATE (PLSELLNKRATE, PLSELLNKRATE_OUT);
  buf B_PLSELLNKWIDTH0 (PLSELLNKWIDTH[0], PLSELLNKWIDTH_OUT[0]);
  buf B_PLSELLNKWIDTH1 (PLSELLNKWIDTH[1], PLSELLNKWIDTH_OUT[1]);
  buf B_PLTXPMSTATE0 (PLTXPMSTATE[0], PLTXPMSTATE_OUT[0]);
  buf B_PLTXPMSTATE1 (PLTXPMSTATE[1], PLTXPMSTATE_OUT[1]);
  buf B_PLTXPMSTATE2 (PLTXPMSTATE[2], PLTXPMSTATE_OUT[2]);
  buf B_RECEIVEDFUNCLVLRSTN (RECEIVEDFUNCLVLRSTN, RECEIVEDFUNCLVLRSTN_OUT);
  buf B_TL2ASPMSUSPENDCREDITCHECKOKN (TL2ASPMSUSPENDCREDITCHECKOKN, TL2ASPMSUSPENDCREDITCHECKOKN_OUT);
  buf B_TL2ASPMSUSPENDREQN (TL2ASPMSUSPENDREQN, TL2ASPMSUSPENDREQN_OUT);
  buf B_TL2PPMSUSPENDOKN (TL2PPMSUSPENDOKN, TL2PPMSUSPENDOKN_OUT);
  buf B_TRNFCCPLD0 (TRNFCCPLD[0], TRNFCCPLD_OUT[0]);
  buf B_TRNFCCPLD1 (TRNFCCPLD[1], TRNFCCPLD_OUT[1]);
  buf B_TRNFCCPLD10 (TRNFCCPLD[10], TRNFCCPLD_OUT[10]);
  buf B_TRNFCCPLD11 (TRNFCCPLD[11], TRNFCCPLD_OUT[11]);
  buf B_TRNFCCPLD2 (TRNFCCPLD[2], TRNFCCPLD_OUT[2]);
  buf B_TRNFCCPLD3 (TRNFCCPLD[3], TRNFCCPLD_OUT[3]);
  buf B_TRNFCCPLD4 (TRNFCCPLD[4], TRNFCCPLD_OUT[4]);
  buf B_TRNFCCPLD5 (TRNFCCPLD[5], TRNFCCPLD_OUT[5]);
  buf B_TRNFCCPLD6 (TRNFCCPLD[6], TRNFCCPLD_OUT[6]);
  buf B_TRNFCCPLD7 (TRNFCCPLD[7], TRNFCCPLD_OUT[7]);
  buf B_TRNFCCPLD8 (TRNFCCPLD[8], TRNFCCPLD_OUT[8]);
  buf B_TRNFCCPLD9 (TRNFCCPLD[9], TRNFCCPLD_OUT[9]);
  buf B_TRNFCCPLH0 (TRNFCCPLH[0], TRNFCCPLH_OUT[0]);
  buf B_TRNFCCPLH1 (TRNFCCPLH[1], TRNFCCPLH_OUT[1]);
  buf B_TRNFCCPLH2 (TRNFCCPLH[2], TRNFCCPLH_OUT[2]);
  buf B_TRNFCCPLH3 (TRNFCCPLH[3], TRNFCCPLH_OUT[3]);
  buf B_TRNFCCPLH4 (TRNFCCPLH[4], TRNFCCPLH_OUT[4]);
  buf B_TRNFCCPLH5 (TRNFCCPLH[5], TRNFCCPLH_OUT[5]);
  buf B_TRNFCCPLH6 (TRNFCCPLH[6], TRNFCCPLH_OUT[6]);
  buf B_TRNFCCPLH7 (TRNFCCPLH[7], TRNFCCPLH_OUT[7]);
  buf B_TRNFCNPD0 (TRNFCNPD[0], TRNFCNPD_OUT[0]);
  buf B_TRNFCNPD1 (TRNFCNPD[1], TRNFCNPD_OUT[1]);
  buf B_TRNFCNPD10 (TRNFCNPD[10], TRNFCNPD_OUT[10]);
  buf B_TRNFCNPD11 (TRNFCNPD[11], TRNFCNPD_OUT[11]);
  buf B_TRNFCNPD2 (TRNFCNPD[2], TRNFCNPD_OUT[2]);
  buf B_TRNFCNPD3 (TRNFCNPD[3], TRNFCNPD_OUT[3]);
  buf B_TRNFCNPD4 (TRNFCNPD[4], TRNFCNPD_OUT[4]);
  buf B_TRNFCNPD5 (TRNFCNPD[5], TRNFCNPD_OUT[5]);
  buf B_TRNFCNPD6 (TRNFCNPD[6], TRNFCNPD_OUT[6]);
  buf B_TRNFCNPD7 (TRNFCNPD[7], TRNFCNPD_OUT[7]);
  buf B_TRNFCNPD8 (TRNFCNPD[8], TRNFCNPD_OUT[8]);
  buf B_TRNFCNPD9 (TRNFCNPD[9], TRNFCNPD_OUT[9]);
  buf B_TRNFCNPH0 (TRNFCNPH[0], TRNFCNPH_OUT[0]);
  buf B_TRNFCNPH1 (TRNFCNPH[1], TRNFCNPH_OUT[1]);
  buf B_TRNFCNPH2 (TRNFCNPH[2], TRNFCNPH_OUT[2]);
  buf B_TRNFCNPH3 (TRNFCNPH[3], TRNFCNPH_OUT[3]);
  buf B_TRNFCNPH4 (TRNFCNPH[4], TRNFCNPH_OUT[4]);
  buf B_TRNFCNPH5 (TRNFCNPH[5], TRNFCNPH_OUT[5]);
  buf B_TRNFCNPH6 (TRNFCNPH[6], TRNFCNPH_OUT[6]);
  buf B_TRNFCNPH7 (TRNFCNPH[7], TRNFCNPH_OUT[7]);
  buf B_TRNFCPD0 (TRNFCPD[0], TRNFCPD_OUT[0]);
  buf B_TRNFCPD1 (TRNFCPD[1], TRNFCPD_OUT[1]);
  buf B_TRNFCPD10 (TRNFCPD[10], TRNFCPD_OUT[10]);
  buf B_TRNFCPD11 (TRNFCPD[11], TRNFCPD_OUT[11]);
  buf B_TRNFCPD2 (TRNFCPD[2], TRNFCPD_OUT[2]);
  buf B_TRNFCPD3 (TRNFCPD[3], TRNFCPD_OUT[3]);
  buf B_TRNFCPD4 (TRNFCPD[4], TRNFCPD_OUT[4]);
  buf B_TRNFCPD5 (TRNFCPD[5], TRNFCPD_OUT[5]);
  buf B_TRNFCPD6 (TRNFCPD[6], TRNFCPD_OUT[6]);
  buf B_TRNFCPD7 (TRNFCPD[7], TRNFCPD_OUT[7]);
  buf B_TRNFCPD8 (TRNFCPD[8], TRNFCPD_OUT[8]);
  buf B_TRNFCPD9 (TRNFCPD[9], TRNFCPD_OUT[9]);
  buf B_TRNFCPH0 (TRNFCPH[0], TRNFCPH_OUT[0]);
  buf B_TRNFCPH1 (TRNFCPH[1], TRNFCPH_OUT[1]);
  buf B_TRNFCPH2 (TRNFCPH[2], TRNFCPH_OUT[2]);
  buf B_TRNFCPH3 (TRNFCPH[3], TRNFCPH_OUT[3]);
  buf B_TRNFCPH4 (TRNFCPH[4], TRNFCPH_OUT[4]);
  buf B_TRNFCPH5 (TRNFCPH[5], TRNFCPH_OUT[5]);
  buf B_TRNFCPH6 (TRNFCPH[6], TRNFCPH_OUT[6]);
  buf B_TRNFCPH7 (TRNFCPH[7], TRNFCPH_OUT[7]);
  buf B_TRNLNKUPN (TRNLNKUPN, TRNLNKUPN_OUT);
  buf B_TRNRBARHITN0 (TRNRBARHITN[0], TRNRBARHITN_OUT[0]);
  buf B_TRNRBARHITN1 (TRNRBARHITN[1], TRNRBARHITN_OUT[1]);
  buf B_TRNRBARHITN2 (TRNRBARHITN[2], TRNRBARHITN_OUT[2]);
  buf B_TRNRBARHITN3 (TRNRBARHITN[3], TRNRBARHITN_OUT[3]);
  buf B_TRNRBARHITN4 (TRNRBARHITN[4], TRNRBARHITN_OUT[4]);
  buf B_TRNRBARHITN5 (TRNRBARHITN[5], TRNRBARHITN_OUT[5]);
  buf B_TRNRBARHITN6 (TRNRBARHITN[6], TRNRBARHITN_OUT[6]);
  buf B_TRNRD0 (TRNRD[0], TRNRD_OUT[0]);
  buf B_TRNRD1 (TRNRD[1], TRNRD_OUT[1]);
  buf B_TRNRD10 (TRNRD[10], TRNRD_OUT[10]);
  buf B_TRNRD11 (TRNRD[11], TRNRD_OUT[11]);
  buf B_TRNRD12 (TRNRD[12], TRNRD_OUT[12]);
  buf B_TRNRD13 (TRNRD[13], TRNRD_OUT[13]);
  buf B_TRNRD14 (TRNRD[14], TRNRD_OUT[14]);
  buf B_TRNRD15 (TRNRD[15], TRNRD_OUT[15]);
  buf B_TRNRD16 (TRNRD[16], TRNRD_OUT[16]);
  buf B_TRNRD17 (TRNRD[17], TRNRD_OUT[17]);
  buf B_TRNRD18 (TRNRD[18], TRNRD_OUT[18]);
  buf B_TRNRD19 (TRNRD[19], TRNRD_OUT[19]);
  buf B_TRNRD2 (TRNRD[2], TRNRD_OUT[2]);
  buf B_TRNRD20 (TRNRD[20], TRNRD_OUT[20]);
  buf B_TRNRD21 (TRNRD[21], TRNRD_OUT[21]);
  buf B_TRNRD22 (TRNRD[22], TRNRD_OUT[22]);
  buf B_TRNRD23 (TRNRD[23], TRNRD_OUT[23]);
  buf B_TRNRD24 (TRNRD[24], TRNRD_OUT[24]);
  buf B_TRNRD25 (TRNRD[25], TRNRD_OUT[25]);
  buf B_TRNRD26 (TRNRD[26], TRNRD_OUT[26]);
  buf B_TRNRD27 (TRNRD[27], TRNRD_OUT[27]);
  buf B_TRNRD28 (TRNRD[28], TRNRD_OUT[28]);
  buf B_TRNRD29 (TRNRD[29], TRNRD_OUT[29]);
  buf B_TRNRD3 (TRNRD[3], TRNRD_OUT[3]);
  buf B_TRNRD30 (TRNRD[30], TRNRD_OUT[30]);
  buf B_TRNRD31 (TRNRD[31], TRNRD_OUT[31]);
  buf B_TRNRD32 (TRNRD[32], TRNRD_OUT[32]);
  buf B_TRNRD33 (TRNRD[33], TRNRD_OUT[33]);
  buf B_TRNRD34 (TRNRD[34], TRNRD_OUT[34]);
  buf B_TRNRD35 (TRNRD[35], TRNRD_OUT[35]);
  buf B_TRNRD36 (TRNRD[36], TRNRD_OUT[36]);
  buf B_TRNRD37 (TRNRD[37], TRNRD_OUT[37]);
  buf B_TRNRD38 (TRNRD[38], TRNRD_OUT[38]);
  buf B_TRNRD39 (TRNRD[39], TRNRD_OUT[39]);
  buf B_TRNRD4 (TRNRD[4], TRNRD_OUT[4]);
  buf B_TRNRD40 (TRNRD[40], TRNRD_OUT[40]);
  buf B_TRNRD41 (TRNRD[41], TRNRD_OUT[41]);
  buf B_TRNRD42 (TRNRD[42], TRNRD_OUT[42]);
  buf B_TRNRD43 (TRNRD[43], TRNRD_OUT[43]);
  buf B_TRNRD44 (TRNRD[44], TRNRD_OUT[44]);
  buf B_TRNRD45 (TRNRD[45], TRNRD_OUT[45]);
  buf B_TRNRD46 (TRNRD[46], TRNRD_OUT[46]);
  buf B_TRNRD47 (TRNRD[47], TRNRD_OUT[47]);
  buf B_TRNRD48 (TRNRD[48], TRNRD_OUT[48]);
  buf B_TRNRD49 (TRNRD[49], TRNRD_OUT[49]);
  buf B_TRNRD5 (TRNRD[5], TRNRD_OUT[5]);
  buf B_TRNRD50 (TRNRD[50], TRNRD_OUT[50]);
  buf B_TRNRD51 (TRNRD[51], TRNRD_OUT[51]);
  buf B_TRNRD52 (TRNRD[52], TRNRD_OUT[52]);
  buf B_TRNRD53 (TRNRD[53], TRNRD_OUT[53]);
  buf B_TRNRD54 (TRNRD[54], TRNRD_OUT[54]);
  buf B_TRNRD55 (TRNRD[55], TRNRD_OUT[55]);
  buf B_TRNRD56 (TRNRD[56], TRNRD_OUT[56]);
  buf B_TRNRD57 (TRNRD[57], TRNRD_OUT[57]);
  buf B_TRNRD58 (TRNRD[58], TRNRD_OUT[58]);
  buf B_TRNRD59 (TRNRD[59], TRNRD_OUT[59]);
  buf B_TRNRD6 (TRNRD[6], TRNRD_OUT[6]);
  buf B_TRNRD60 (TRNRD[60], TRNRD_OUT[60]);
  buf B_TRNRD61 (TRNRD[61], TRNRD_OUT[61]);
  buf B_TRNRD62 (TRNRD[62], TRNRD_OUT[62]);
  buf B_TRNRD63 (TRNRD[63], TRNRD_OUT[63]);
  buf B_TRNRD7 (TRNRD[7], TRNRD_OUT[7]);
  buf B_TRNRD8 (TRNRD[8], TRNRD_OUT[8]);
  buf B_TRNRD9 (TRNRD[9], TRNRD_OUT[9]);
  buf B_TRNRDLLPDATA0 (TRNRDLLPDATA[0], TRNRDLLPDATA_OUT[0]);
  buf B_TRNRDLLPDATA1 (TRNRDLLPDATA[1], TRNRDLLPDATA_OUT[1]);
  buf B_TRNRDLLPDATA10 (TRNRDLLPDATA[10], TRNRDLLPDATA_OUT[10]);
  buf B_TRNRDLLPDATA11 (TRNRDLLPDATA[11], TRNRDLLPDATA_OUT[11]);
  buf B_TRNRDLLPDATA12 (TRNRDLLPDATA[12], TRNRDLLPDATA_OUT[12]);
  buf B_TRNRDLLPDATA13 (TRNRDLLPDATA[13], TRNRDLLPDATA_OUT[13]);
  buf B_TRNRDLLPDATA14 (TRNRDLLPDATA[14], TRNRDLLPDATA_OUT[14]);
  buf B_TRNRDLLPDATA15 (TRNRDLLPDATA[15], TRNRDLLPDATA_OUT[15]);
  buf B_TRNRDLLPDATA16 (TRNRDLLPDATA[16], TRNRDLLPDATA_OUT[16]);
  buf B_TRNRDLLPDATA17 (TRNRDLLPDATA[17], TRNRDLLPDATA_OUT[17]);
  buf B_TRNRDLLPDATA18 (TRNRDLLPDATA[18], TRNRDLLPDATA_OUT[18]);
  buf B_TRNRDLLPDATA19 (TRNRDLLPDATA[19], TRNRDLLPDATA_OUT[19]);
  buf B_TRNRDLLPDATA2 (TRNRDLLPDATA[2], TRNRDLLPDATA_OUT[2]);
  buf B_TRNRDLLPDATA20 (TRNRDLLPDATA[20], TRNRDLLPDATA_OUT[20]);
  buf B_TRNRDLLPDATA21 (TRNRDLLPDATA[21], TRNRDLLPDATA_OUT[21]);
  buf B_TRNRDLLPDATA22 (TRNRDLLPDATA[22], TRNRDLLPDATA_OUT[22]);
  buf B_TRNRDLLPDATA23 (TRNRDLLPDATA[23], TRNRDLLPDATA_OUT[23]);
  buf B_TRNRDLLPDATA24 (TRNRDLLPDATA[24], TRNRDLLPDATA_OUT[24]);
  buf B_TRNRDLLPDATA25 (TRNRDLLPDATA[25], TRNRDLLPDATA_OUT[25]);
  buf B_TRNRDLLPDATA26 (TRNRDLLPDATA[26], TRNRDLLPDATA_OUT[26]);
  buf B_TRNRDLLPDATA27 (TRNRDLLPDATA[27], TRNRDLLPDATA_OUT[27]);
  buf B_TRNRDLLPDATA28 (TRNRDLLPDATA[28], TRNRDLLPDATA_OUT[28]);
  buf B_TRNRDLLPDATA29 (TRNRDLLPDATA[29], TRNRDLLPDATA_OUT[29]);
  buf B_TRNRDLLPDATA3 (TRNRDLLPDATA[3], TRNRDLLPDATA_OUT[3]);
  buf B_TRNRDLLPDATA30 (TRNRDLLPDATA[30], TRNRDLLPDATA_OUT[30]);
  buf B_TRNRDLLPDATA31 (TRNRDLLPDATA[31], TRNRDLLPDATA_OUT[31]);
  buf B_TRNRDLLPDATA4 (TRNRDLLPDATA[4], TRNRDLLPDATA_OUT[4]);
  buf B_TRNRDLLPDATA5 (TRNRDLLPDATA[5], TRNRDLLPDATA_OUT[5]);
  buf B_TRNRDLLPDATA6 (TRNRDLLPDATA[6], TRNRDLLPDATA_OUT[6]);
  buf B_TRNRDLLPDATA7 (TRNRDLLPDATA[7], TRNRDLLPDATA_OUT[7]);
  buf B_TRNRDLLPDATA8 (TRNRDLLPDATA[8], TRNRDLLPDATA_OUT[8]);
  buf B_TRNRDLLPDATA9 (TRNRDLLPDATA[9], TRNRDLLPDATA_OUT[9]);
  buf B_TRNRDLLPSRCRDYN (TRNRDLLPSRCRDYN, TRNRDLLPSRCRDYN_OUT);
  buf B_TRNRECRCERRN (TRNRECRCERRN, TRNRECRCERRN_OUT);
  buf B_TRNREOFN (TRNREOFN, TRNREOFN_OUT);
  buf B_TRNRERRFWDN (TRNRERRFWDN, TRNRERRFWDN_OUT);
  buf B_TRNRREMN (TRNRREMN, TRNRREMN_OUT);
  buf B_TRNRSOFN (TRNRSOFN, TRNRSOFN_OUT);
  buf B_TRNRSRCDSCN (TRNRSRCDSCN, TRNRSRCDSCN_OUT);
  buf B_TRNRSRCRDYN (TRNRSRCRDYN, TRNRSRCRDYN_OUT);
  buf B_TRNTBUFAV0 (TRNTBUFAV[0], TRNTBUFAV_OUT[0]);
  buf B_TRNTBUFAV1 (TRNTBUFAV[1], TRNTBUFAV_OUT[1]);
  buf B_TRNTBUFAV2 (TRNTBUFAV[2], TRNTBUFAV_OUT[2]);
  buf B_TRNTBUFAV3 (TRNTBUFAV[3], TRNTBUFAV_OUT[3]);
  buf B_TRNTBUFAV4 (TRNTBUFAV[4], TRNTBUFAV_OUT[4]);
  buf B_TRNTBUFAV5 (TRNTBUFAV[5], TRNTBUFAV_OUT[5]);
  buf B_TRNTCFGREQN (TRNTCFGREQN, TRNTCFGREQN_OUT);
  buf B_TRNTDLLPDSTRDYN (TRNTDLLPDSTRDYN, TRNTDLLPDSTRDYN_OUT);
  buf B_TRNTDSTRDYN (TRNTDSTRDYN, TRNTDSTRDYN_OUT);
  buf B_TRNTERRDROPN (TRNTERRDROPN, TRNTERRDROPN_OUT);
  buf B_USERRSTN (USERRSTN, USERRSTN_OUT);

  buf B_CFGBYTEENN0 (CFGBYTEENN_IN[0], CFGBYTEENN[0]);
  buf B_CFGBYTEENN1 (CFGBYTEENN_IN[1], CFGBYTEENN[1]);
  buf B_CFGBYTEENN2 (CFGBYTEENN_IN[2], CFGBYTEENN[2]);
  buf B_CFGBYTEENN3 (CFGBYTEENN_IN[3], CFGBYTEENN[3]);
  buf B_CFGDI0 (CFGDI_IN[0], CFGDI[0]);
  buf B_CFGDI1 (CFGDI_IN[1], CFGDI[1]);
  buf B_CFGDI10 (CFGDI_IN[10], CFGDI[10]);
  buf B_CFGDI11 (CFGDI_IN[11], CFGDI[11]);
  buf B_CFGDI12 (CFGDI_IN[12], CFGDI[12]);
  buf B_CFGDI13 (CFGDI_IN[13], CFGDI[13]);
  buf B_CFGDI14 (CFGDI_IN[14], CFGDI[14]);
  buf B_CFGDI15 (CFGDI_IN[15], CFGDI[15]);
  buf B_CFGDI16 (CFGDI_IN[16], CFGDI[16]);
  buf B_CFGDI17 (CFGDI_IN[17], CFGDI[17]);
  buf B_CFGDI18 (CFGDI_IN[18], CFGDI[18]);
  buf B_CFGDI19 (CFGDI_IN[19], CFGDI[19]);
  buf B_CFGDI2 (CFGDI_IN[2], CFGDI[2]);
  buf B_CFGDI20 (CFGDI_IN[20], CFGDI[20]);
  buf B_CFGDI21 (CFGDI_IN[21], CFGDI[21]);
  buf B_CFGDI22 (CFGDI_IN[22], CFGDI[22]);
  buf B_CFGDI23 (CFGDI_IN[23], CFGDI[23]);
  buf B_CFGDI24 (CFGDI_IN[24], CFGDI[24]);
  buf B_CFGDI25 (CFGDI_IN[25], CFGDI[25]);
  buf B_CFGDI26 (CFGDI_IN[26], CFGDI[26]);
  buf B_CFGDI27 (CFGDI_IN[27], CFGDI[27]);
  buf B_CFGDI28 (CFGDI_IN[28], CFGDI[28]);
  buf B_CFGDI29 (CFGDI_IN[29], CFGDI[29]);
  buf B_CFGDI3 (CFGDI_IN[3], CFGDI[3]);
  buf B_CFGDI30 (CFGDI_IN[30], CFGDI[30]);
  buf B_CFGDI31 (CFGDI_IN[31], CFGDI[31]);
  buf B_CFGDI4 (CFGDI_IN[4], CFGDI[4]);
  buf B_CFGDI5 (CFGDI_IN[5], CFGDI[5]);
  buf B_CFGDI6 (CFGDI_IN[6], CFGDI[6]);
  buf B_CFGDI7 (CFGDI_IN[7], CFGDI[7]);
  buf B_CFGDI8 (CFGDI_IN[8], CFGDI[8]);
  buf B_CFGDI9 (CFGDI_IN[9], CFGDI[9]);
  buf B_CFGDSBUSNUMBER0 (CFGDSBUSNUMBER_IN[0], CFGDSBUSNUMBER[0]);
  buf B_CFGDSBUSNUMBER1 (CFGDSBUSNUMBER_IN[1], CFGDSBUSNUMBER[1]);
  buf B_CFGDSBUSNUMBER2 (CFGDSBUSNUMBER_IN[2], CFGDSBUSNUMBER[2]);
  buf B_CFGDSBUSNUMBER3 (CFGDSBUSNUMBER_IN[3], CFGDSBUSNUMBER[3]);
  buf B_CFGDSBUSNUMBER4 (CFGDSBUSNUMBER_IN[4], CFGDSBUSNUMBER[4]);
  buf B_CFGDSBUSNUMBER5 (CFGDSBUSNUMBER_IN[5], CFGDSBUSNUMBER[5]);
  buf B_CFGDSBUSNUMBER6 (CFGDSBUSNUMBER_IN[6], CFGDSBUSNUMBER[6]);
  buf B_CFGDSBUSNUMBER7 (CFGDSBUSNUMBER_IN[7], CFGDSBUSNUMBER[7]);
  buf B_CFGDSDEVICENUMBER0 (CFGDSDEVICENUMBER_IN[0], CFGDSDEVICENUMBER[0]);
  buf B_CFGDSDEVICENUMBER1 (CFGDSDEVICENUMBER_IN[1], CFGDSDEVICENUMBER[1]);
  buf B_CFGDSDEVICENUMBER2 (CFGDSDEVICENUMBER_IN[2], CFGDSDEVICENUMBER[2]);
  buf B_CFGDSDEVICENUMBER3 (CFGDSDEVICENUMBER_IN[3], CFGDSDEVICENUMBER[3]);
  buf B_CFGDSDEVICENUMBER4 (CFGDSDEVICENUMBER_IN[4], CFGDSDEVICENUMBER[4]);
  buf B_CFGDSFUNCTIONNUMBER0 (CFGDSFUNCTIONNUMBER_IN[0], CFGDSFUNCTIONNUMBER[0]);
  buf B_CFGDSFUNCTIONNUMBER1 (CFGDSFUNCTIONNUMBER_IN[1], CFGDSFUNCTIONNUMBER[1]);
  buf B_CFGDSFUNCTIONNUMBER2 (CFGDSFUNCTIONNUMBER_IN[2], CFGDSFUNCTIONNUMBER[2]);
  buf B_CFGDSN0 (CFGDSN_IN[0], CFGDSN[0]);
  buf B_CFGDSN1 (CFGDSN_IN[1], CFGDSN[1]);
  buf B_CFGDSN10 (CFGDSN_IN[10], CFGDSN[10]);
  buf B_CFGDSN11 (CFGDSN_IN[11], CFGDSN[11]);
  buf B_CFGDSN12 (CFGDSN_IN[12], CFGDSN[12]);
  buf B_CFGDSN13 (CFGDSN_IN[13], CFGDSN[13]);
  buf B_CFGDSN14 (CFGDSN_IN[14], CFGDSN[14]);
  buf B_CFGDSN15 (CFGDSN_IN[15], CFGDSN[15]);
  buf B_CFGDSN16 (CFGDSN_IN[16], CFGDSN[16]);
  buf B_CFGDSN17 (CFGDSN_IN[17], CFGDSN[17]);
  buf B_CFGDSN18 (CFGDSN_IN[18], CFGDSN[18]);
  buf B_CFGDSN19 (CFGDSN_IN[19], CFGDSN[19]);
  buf B_CFGDSN2 (CFGDSN_IN[2], CFGDSN[2]);
  buf B_CFGDSN20 (CFGDSN_IN[20], CFGDSN[20]);
  buf B_CFGDSN21 (CFGDSN_IN[21], CFGDSN[21]);
  buf B_CFGDSN22 (CFGDSN_IN[22], CFGDSN[22]);
  buf B_CFGDSN23 (CFGDSN_IN[23], CFGDSN[23]);
  buf B_CFGDSN24 (CFGDSN_IN[24], CFGDSN[24]);
  buf B_CFGDSN25 (CFGDSN_IN[25], CFGDSN[25]);
  buf B_CFGDSN26 (CFGDSN_IN[26], CFGDSN[26]);
  buf B_CFGDSN27 (CFGDSN_IN[27], CFGDSN[27]);
  buf B_CFGDSN28 (CFGDSN_IN[28], CFGDSN[28]);
  buf B_CFGDSN29 (CFGDSN_IN[29], CFGDSN[29]);
  buf B_CFGDSN3 (CFGDSN_IN[3], CFGDSN[3]);
  buf B_CFGDSN30 (CFGDSN_IN[30], CFGDSN[30]);
  buf B_CFGDSN31 (CFGDSN_IN[31], CFGDSN[31]);
  buf B_CFGDSN32 (CFGDSN_IN[32], CFGDSN[32]);
  buf B_CFGDSN33 (CFGDSN_IN[33], CFGDSN[33]);
  buf B_CFGDSN34 (CFGDSN_IN[34], CFGDSN[34]);
  buf B_CFGDSN35 (CFGDSN_IN[35], CFGDSN[35]);
  buf B_CFGDSN36 (CFGDSN_IN[36], CFGDSN[36]);
  buf B_CFGDSN37 (CFGDSN_IN[37], CFGDSN[37]);
  buf B_CFGDSN38 (CFGDSN_IN[38], CFGDSN[38]);
  buf B_CFGDSN39 (CFGDSN_IN[39], CFGDSN[39]);
  buf B_CFGDSN4 (CFGDSN_IN[4], CFGDSN[4]);
  buf B_CFGDSN40 (CFGDSN_IN[40], CFGDSN[40]);
  buf B_CFGDSN41 (CFGDSN_IN[41], CFGDSN[41]);
  buf B_CFGDSN42 (CFGDSN_IN[42], CFGDSN[42]);
  buf B_CFGDSN43 (CFGDSN_IN[43], CFGDSN[43]);
  buf B_CFGDSN44 (CFGDSN_IN[44], CFGDSN[44]);
  buf B_CFGDSN45 (CFGDSN_IN[45], CFGDSN[45]);
  buf B_CFGDSN46 (CFGDSN_IN[46], CFGDSN[46]);
  buf B_CFGDSN47 (CFGDSN_IN[47], CFGDSN[47]);
  buf B_CFGDSN48 (CFGDSN_IN[48], CFGDSN[48]);
  buf B_CFGDSN49 (CFGDSN_IN[49], CFGDSN[49]);
  buf B_CFGDSN5 (CFGDSN_IN[5], CFGDSN[5]);
  buf B_CFGDSN50 (CFGDSN_IN[50], CFGDSN[50]);
  buf B_CFGDSN51 (CFGDSN_IN[51], CFGDSN[51]);
  buf B_CFGDSN52 (CFGDSN_IN[52], CFGDSN[52]);
  buf B_CFGDSN53 (CFGDSN_IN[53], CFGDSN[53]);
  buf B_CFGDSN54 (CFGDSN_IN[54], CFGDSN[54]);
  buf B_CFGDSN55 (CFGDSN_IN[55], CFGDSN[55]);
  buf B_CFGDSN56 (CFGDSN_IN[56], CFGDSN[56]);
  buf B_CFGDSN57 (CFGDSN_IN[57], CFGDSN[57]);
  buf B_CFGDSN58 (CFGDSN_IN[58], CFGDSN[58]);
  buf B_CFGDSN59 (CFGDSN_IN[59], CFGDSN[59]);
  buf B_CFGDSN6 (CFGDSN_IN[6], CFGDSN[6]);
  buf B_CFGDSN60 (CFGDSN_IN[60], CFGDSN[60]);
  buf B_CFGDSN61 (CFGDSN_IN[61], CFGDSN[61]);
  buf B_CFGDSN62 (CFGDSN_IN[62], CFGDSN[62]);
  buf B_CFGDSN63 (CFGDSN_IN[63], CFGDSN[63]);
  buf B_CFGDSN7 (CFGDSN_IN[7], CFGDSN[7]);
  buf B_CFGDSN8 (CFGDSN_IN[8], CFGDSN[8]);
  buf B_CFGDSN9 (CFGDSN_IN[9], CFGDSN[9]);
  buf B_CFGDWADDR0 (CFGDWADDR_IN[0], CFGDWADDR[0]);
  buf B_CFGDWADDR1 (CFGDWADDR_IN[1], CFGDWADDR[1]);
  buf B_CFGDWADDR2 (CFGDWADDR_IN[2], CFGDWADDR[2]);
  buf B_CFGDWADDR3 (CFGDWADDR_IN[3], CFGDWADDR[3]);
  buf B_CFGDWADDR4 (CFGDWADDR_IN[4], CFGDWADDR[4]);
  buf B_CFGDWADDR5 (CFGDWADDR_IN[5], CFGDWADDR[5]);
  buf B_CFGDWADDR6 (CFGDWADDR_IN[6], CFGDWADDR[6]);
  buf B_CFGDWADDR7 (CFGDWADDR_IN[7], CFGDWADDR[7]);
  buf B_CFGDWADDR8 (CFGDWADDR_IN[8], CFGDWADDR[8]);
  buf B_CFGDWADDR9 (CFGDWADDR_IN[9], CFGDWADDR[9]);
  buf B_CFGERRACSN (CFGERRACSN_IN, CFGERRACSN);
  buf B_CFGERRAERHEADERLOG0 (CFGERRAERHEADERLOG_IN[0], CFGERRAERHEADERLOG[0]);
  buf B_CFGERRAERHEADERLOG1 (CFGERRAERHEADERLOG_IN[1], CFGERRAERHEADERLOG[1]);
  buf B_CFGERRAERHEADERLOG10 (CFGERRAERHEADERLOG_IN[10], CFGERRAERHEADERLOG[10]);
  buf B_CFGERRAERHEADERLOG100 (CFGERRAERHEADERLOG_IN[100], CFGERRAERHEADERLOG[100]);
  buf B_CFGERRAERHEADERLOG101 (CFGERRAERHEADERLOG_IN[101], CFGERRAERHEADERLOG[101]);
  buf B_CFGERRAERHEADERLOG102 (CFGERRAERHEADERLOG_IN[102], CFGERRAERHEADERLOG[102]);
  buf B_CFGERRAERHEADERLOG103 (CFGERRAERHEADERLOG_IN[103], CFGERRAERHEADERLOG[103]);
  buf B_CFGERRAERHEADERLOG104 (CFGERRAERHEADERLOG_IN[104], CFGERRAERHEADERLOG[104]);
  buf B_CFGERRAERHEADERLOG105 (CFGERRAERHEADERLOG_IN[105], CFGERRAERHEADERLOG[105]);
  buf B_CFGERRAERHEADERLOG106 (CFGERRAERHEADERLOG_IN[106], CFGERRAERHEADERLOG[106]);
  buf B_CFGERRAERHEADERLOG107 (CFGERRAERHEADERLOG_IN[107], CFGERRAERHEADERLOG[107]);
  buf B_CFGERRAERHEADERLOG108 (CFGERRAERHEADERLOG_IN[108], CFGERRAERHEADERLOG[108]);
  buf B_CFGERRAERHEADERLOG109 (CFGERRAERHEADERLOG_IN[109], CFGERRAERHEADERLOG[109]);
  buf B_CFGERRAERHEADERLOG11 (CFGERRAERHEADERLOG_IN[11], CFGERRAERHEADERLOG[11]);
  buf B_CFGERRAERHEADERLOG110 (CFGERRAERHEADERLOG_IN[110], CFGERRAERHEADERLOG[110]);
  buf B_CFGERRAERHEADERLOG111 (CFGERRAERHEADERLOG_IN[111], CFGERRAERHEADERLOG[111]);
  buf B_CFGERRAERHEADERLOG112 (CFGERRAERHEADERLOG_IN[112], CFGERRAERHEADERLOG[112]);
  buf B_CFGERRAERHEADERLOG113 (CFGERRAERHEADERLOG_IN[113], CFGERRAERHEADERLOG[113]);
  buf B_CFGERRAERHEADERLOG114 (CFGERRAERHEADERLOG_IN[114], CFGERRAERHEADERLOG[114]);
  buf B_CFGERRAERHEADERLOG115 (CFGERRAERHEADERLOG_IN[115], CFGERRAERHEADERLOG[115]);
  buf B_CFGERRAERHEADERLOG116 (CFGERRAERHEADERLOG_IN[116], CFGERRAERHEADERLOG[116]);
  buf B_CFGERRAERHEADERLOG117 (CFGERRAERHEADERLOG_IN[117], CFGERRAERHEADERLOG[117]);
  buf B_CFGERRAERHEADERLOG118 (CFGERRAERHEADERLOG_IN[118], CFGERRAERHEADERLOG[118]);
  buf B_CFGERRAERHEADERLOG119 (CFGERRAERHEADERLOG_IN[119], CFGERRAERHEADERLOG[119]);
  buf B_CFGERRAERHEADERLOG12 (CFGERRAERHEADERLOG_IN[12], CFGERRAERHEADERLOG[12]);
  buf B_CFGERRAERHEADERLOG120 (CFGERRAERHEADERLOG_IN[120], CFGERRAERHEADERLOG[120]);
  buf B_CFGERRAERHEADERLOG121 (CFGERRAERHEADERLOG_IN[121], CFGERRAERHEADERLOG[121]);
  buf B_CFGERRAERHEADERLOG122 (CFGERRAERHEADERLOG_IN[122], CFGERRAERHEADERLOG[122]);
  buf B_CFGERRAERHEADERLOG123 (CFGERRAERHEADERLOG_IN[123], CFGERRAERHEADERLOG[123]);
  buf B_CFGERRAERHEADERLOG124 (CFGERRAERHEADERLOG_IN[124], CFGERRAERHEADERLOG[124]);
  buf B_CFGERRAERHEADERLOG125 (CFGERRAERHEADERLOG_IN[125], CFGERRAERHEADERLOG[125]);
  buf B_CFGERRAERHEADERLOG126 (CFGERRAERHEADERLOG_IN[126], CFGERRAERHEADERLOG[126]);
  buf B_CFGERRAERHEADERLOG127 (CFGERRAERHEADERLOG_IN[127], CFGERRAERHEADERLOG[127]);
  buf B_CFGERRAERHEADERLOG13 (CFGERRAERHEADERLOG_IN[13], CFGERRAERHEADERLOG[13]);
  buf B_CFGERRAERHEADERLOG14 (CFGERRAERHEADERLOG_IN[14], CFGERRAERHEADERLOG[14]);
  buf B_CFGERRAERHEADERLOG15 (CFGERRAERHEADERLOG_IN[15], CFGERRAERHEADERLOG[15]);
  buf B_CFGERRAERHEADERLOG16 (CFGERRAERHEADERLOG_IN[16], CFGERRAERHEADERLOG[16]);
  buf B_CFGERRAERHEADERLOG17 (CFGERRAERHEADERLOG_IN[17], CFGERRAERHEADERLOG[17]);
  buf B_CFGERRAERHEADERLOG18 (CFGERRAERHEADERLOG_IN[18], CFGERRAERHEADERLOG[18]);
  buf B_CFGERRAERHEADERLOG19 (CFGERRAERHEADERLOG_IN[19], CFGERRAERHEADERLOG[19]);
  buf B_CFGERRAERHEADERLOG2 (CFGERRAERHEADERLOG_IN[2], CFGERRAERHEADERLOG[2]);
  buf B_CFGERRAERHEADERLOG20 (CFGERRAERHEADERLOG_IN[20], CFGERRAERHEADERLOG[20]);
  buf B_CFGERRAERHEADERLOG21 (CFGERRAERHEADERLOG_IN[21], CFGERRAERHEADERLOG[21]);
  buf B_CFGERRAERHEADERLOG22 (CFGERRAERHEADERLOG_IN[22], CFGERRAERHEADERLOG[22]);
  buf B_CFGERRAERHEADERLOG23 (CFGERRAERHEADERLOG_IN[23], CFGERRAERHEADERLOG[23]);
  buf B_CFGERRAERHEADERLOG24 (CFGERRAERHEADERLOG_IN[24], CFGERRAERHEADERLOG[24]);
  buf B_CFGERRAERHEADERLOG25 (CFGERRAERHEADERLOG_IN[25], CFGERRAERHEADERLOG[25]);
  buf B_CFGERRAERHEADERLOG26 (CFGERRAERHEADERLOG_IN[26], CFGERRAERHEADERLOG[26]);
  buf B_CFGERRAERHEADERLOG27 (CFGERRAERHEADERLOG_IN[27], CFGERRAERHEADERLOG[27]);
  buf B_CFGERRAERHEADERLOG28 (CFGERRAERHEADERLOG_IN[28], CFGERRAERHEADERLOG[28]);
  buf B_CFGERRAERHEADERLOG29 (CFGERRAERHEADERLOG_IN[29], CFGERRAERHEADERLOG[29]);
  buf B_CFGERRAERHEADERLOG3 (CFGERRAERHEADERLOG_IN[3], CFGERRAERHEADERLOG[3]);
  buf B_CFGERRAERHEADERLOG30 (CFGERRAERHEADERLOG_IN[30], CFGERRAERHEADERLOG[30]);
  buf B_CFGERRAERHEADERLOG31 (CFGERRAERHEADERLOG_IN[31], CFGERRAERHEADERLOG[31]);
  buf B_CFGERRAERHEADERLOG32 (CFGERRAERHEADERLOG_IN[32], CFGERRAERHEADERLOG[32]);
  buf B_CFGERRAERHEADERLOG33 (CFGERRAERHEADERLOG_IN[33], CFGERRAERHEADERLOG[33]);
  buf B_CFGERRAERHEADERLOG34 (CFGERRAERHEADERLOG_IN[34], CFGERRAERHEADERLOG[34]);
  buf B_CFGERRAERHEADERLOG35 (CFGERRAERHEADERLOG_IN[35], CFGERRAERHEADERLOG[35]);
  buf B_CFGERRAERHEADERLOG36 (CFGERRAERHEADERLOG_IN[36], CFGERRAERHEADERLOG[36]);
  buf B_CFGERRAERHEADERLOG37 (CFGERRAERHEADERLOG_IN[37], CFGERRAERHEADERLOG[37]);
  buf B_CFGERRAERHEADERLOG38 (CFGERRAERHEADERLOG_IN[38], CFGERRAERHEADERLOG[38]);
  buf B_CFGERRAERHEADERLOG39 (CFGERRAERHEADERLOG_IN[39], CFGERRAERHEADERLOG[39]);
  buf B_CFGERRAERHEADERLOG4 (CFGERRAERHEADERLOG_IN[4], CFGERRAERHEADERLOG[4]);
  buf B_CFGERRAERHEADERLOG40 (CFGERRAERHEADERLOG_IN[40], CFGERRAERHEADERLOG[40]);
  buf B_CFGERRAERHEADERLOG41 (CFGERRAERHEADERLOG_IN[41], CFGERRAERHEADERLOG[41]);
  buf B_CFGERRAERHEADERLOG42 (CFGERRAERHEADERLOG_IN[42], CFGERRAERHEADERLOG[42]);
  buf B_CFGERRAERHEADERLOG43 (CFGERRAERHEADERLOG_IN[43], CFGERRAERHEADERLOG[43]);
  buf B_CFGERRAERHEADERLOG44 (CFGERRAERHEADERLOG_IN[44], CFGERRAERHEADERLOG[44]);
  buf B_CFGERRAERHEADERLOG45 (CFGERRAERHEADERLOG_IN[45], CFGERRAERHEADERLOG[45]);
  buf B_CFGERRAERHEADERLOG46 (CFGERRAERHEADERLOG_IN[46], CFGERRAERHEADERLOG[46]);
  buf B_CFGERRAERHEADERLOG47 (CFGERRAERHEADERLOG_IN[47], CFGERRAERHEADERLOG[47]);
  buf B_CFGERRAERHEADERLOG48 (CFGERRAERHEADERLOG_IN[48], CFGERRAERHEADERLOG[48]);
  buf B_CFGERRAERHEADERLOG49 (CFGERRAERHEADERLOG_IN[49], CFGERRAERHEADERLOG[49]);
  buf B_CFGERRAERHEADERLOG5 (CFGERRAERHEADERLOG_IN[5], CFGERRAERHEADERLOG[5]);
  buf B_CFGERRAERHEADERLOG50 (CFGERRAERHEADERLOG_IN[50], CFGERRAERHEADERLOG[50]);
  buf B_CFGERRAERHEADERLOG51 (CFGERRAERHEADERLOG_IN[51], CFGERRAERHEADERLOG[51]);
  buf B_CFGERRAERHEADERLOG52 (CFGERRAERHEADERLOG_IN[52], CFGERRAERHEADERLOG[52]);
  buf B_CFGERRAERHEADERLOG53 (CFGERRAERHEADERLOG_IN[53], CFGERRAERHEADERLOG[53]);
  buf B_CFGERRAERHEADERLOG54 (CFGERRAERHEADERLOG_IN[54], CFGERRAERHEADERLOG[54]);
  buf B_CFGERRAERHEADERLOG55 (CFGERRAERHEADERLOG_IN[55], CFGERRAERHEADERLOG[55]);
  buf B_CFGERRAERHEADERLOG56 (CFGERRAERHEADERLOG_IN[56], CFGERRAERHEADERLOG[56]);
  buf B_CFGERRAERHEADERLOG57 (CFGERRAERHEADERLOG_IN[57], CFGERRAERHEADERLOG[57]);
  buf B_CFGERRAERHEADERLOG58 (CFGERRAERHEADERLOG_IN[58], CFGERRAERHEADERLOG[58]);
  buf B_CFGERRAERHEADERLOG59 (CFGERRAERHEADERLOG_IN[59], CFGERRAERHEADERLOG[59]);
  buf B_CFGERRAERHEADERLOG6 (CFGERRAERHEADERLOG_IN[6], CFGERRAERHEADERLOG[6]);
  buf B_CFGERRAERHEADERLOG60 (CFGERRAERHEADERLOG_IN[60], CFGERRAERHEADERLOG[60]);
  buf B_CFGERRAERHEADERLOG61 (CFGERRAERHEADERLOG_IN[61], CFGERRAERHEADERLOG[61]);
  buf B_CFGERRAERHEADERLOG62 (CFGERRAERHEADERLOG_IN[62], CFGERRAERHEADERLOG[62]);
  buf B_CFGERRAERHEADERLOG63 (CFGERRAERHEADERLOG_IN[63], CFGERRAERHEADERLOG[63]);
  buf B_CFGERRAERHEADERLOG64 (CFGERRAERHEADERLOG_IN[64], CFGERRAERHEADERLOG[64]);
  buf B_CFGERRAERHEADERLOG65 (CFGERRAERHEADERLOG_IN[65], CFGERRAERHEADERLOG[65]);
  buf B_CFGERRAERHEADERLOG66 (CFGERRAERHEADERLOG_IN[66], CFGERRAERHEADERLOG[66]);
  buf B_CFGERRAERHEADERLOG67 (CFGERRAERHEADERLOG_IN[67], CFGERRAERHEADERLOG[67]);
  buf B_CFGERRAERHEADERLOG68 (CFGERRAERHEADERLOG_IN[68], CFGERRAERHEADERLOG[68]);
  buf B_CFGERRAERHEADERLOG69 (CFGERRAERHEADERLOG_IN[69], CFGERRAERHEADERLOG[69]);
  buf B_CFGERRAERHEADERLOG7 (CFGERRAERHEADERLOG_IN[7], CFGERRAERHEADERLOG[7]);
  buf B_CFGERRAERHEADERLOG70 (CFGERRAERHEADERLOG_IN[70], CFGERRAERHEADERLOG[70]);
  buf B_CFGERRAERHEADERLOG71 (CFGERRAERHEADERLOG_IN[71], CFGERRAERHEADERLOG[71]);
  buf B_CFGERRAERHEADERLOG72 (CFGERRAERHEADERLOG_IN[72], CFGERRAERHEADERLOG[72]);
  buf B_CFGERRAERHEADERLOG73 (CFGERRAERHEADERLOG_IN[73], CFGERRAERHEADERLOG[73]);
  buf B_CFGERRAERHEADERLOG74 (CFGERRAERHEADERLOG_IN[74], CFGERRAERHEADERLOG[74]);
  buf B_CFGERRAERHEADERLOG75 (CFGERRAERHEADERLOG_IN[75], CFGERRAERHEADERLOG[75]);
  buf B_CFGERRAERHEADERLOG76 (CFGERRAERHEADERLOG_IN[76], CFGERRAERHEADERLOG[76]);
  buf B_CFGERRAERHEADERLOG77 (CFGERRAERHEADERLOG_IN[77], CFGERRAERHEADERLOG[77]);
  buf B_CFGERRAERHEADERLOG78 (CFGERRAERHEADERLOG_IN[78], CFGERRAERHEADERLOG[78]);
  buf B_CFGERRAERHEADERLOG79 (CFGERRAERHEADERLOG_IN[79], CFGERRAERHEADERLOG[79]);
  buf B_CFGERRAERHEADERLOG8 (CFGERRAERHEADERLOG_IN[8], CFGERRAERHEADERLOG[8]);
  buf B_CFGERRAERHEADERLOG80 (CFGERRAERHEADERLOG_IN[80], CFGERRAERHEADERLOG[80]);
  buf B_CFGERRAERHEADERLOG81 (CFGERRAERHEADERLOG_IN[81], CFGERRAERHEADERLOG[81]);
  buf B_CFGERRAERHEADERLOG82 (CFGERRAERHEADERLOG_IN[82], CFGERRAERHEADERLOG[82]);
  buf B_CFGERRAERHEADERLOG83 (CFGERRAERHEADERLOG_IN[83], CFGERRAERHEADERLOG[83]);
  buf B_CFGERRAERHEADERLOG84 (CFGERRAERHEADERLOG_IN[84], CFGERRAERHEADERLOG[84]);
  buf B_CFGERRAERHEADERLOG85 (CFGERRAERHEADERLOG_IN[85], CFGERRAERHEADERLOG[85]);
  buf B_CFGERRAERHEADERLOG86 (CFGERRAERHEADERLOG_IN[86], CFGERRAERHEADERLOG[86]);
  buf B_CFGERRAERHEADERLOG87 (CFGERRAERHEADERLOG_IN[87], CFGERRAERHEADERLOG[87]);
  buf B_CFGERRAERHEADERLOG88 (CFGERRAERHEADERLOG_IN[88], CFGERRAERHEADERLOG[88]);
  buf B_CFGERRAERHEADERLOG89 (CFGERRAERHEADERLOG_IN[89], CFGERRAERHEADERLOG[89]);
  buf B_CFGERRAERHEADERLOG9 (CFGERRAERHEADERLOG_IN[9], CFGERRAERHEADERLOG[9]);
  buf B_CFGERRAERHEADERLOG90 (CFGERRAERHEADERLOG_IN[90], CFGERRAERHEADERLOG[90]);
  buf B_CFGERRAERHEADERLOG91 (CFGERRAERHEADERLOG_IN[91], CFGERRAERHEADERLOG[91]);
  buf B_CFGERRAERHEADERLOG92 (CFGERRAERHEADERLOG_IN[92], CFGERRAERHEADERLOG[92]);
  buf B_CFGERRAERHEADERLOG93 (CFGERRAERHEADERLOG_IN[93], CFGERRAERHEADERLOG[93]);
  buf B_CFGERRAERHEADERLOG94 (CFGERRAERHEADERLOG_IN[94], CFGERRAERHEADERLOG[94]);
  buf B_CFGERRAERHEADERLOG95 (CFGERRAERHEADERLOG_IN[95], CFGERRAERHEADERLOG[95]);
  buf B_CFGERRAERHEADERLOG96 (CFGERRAERHEADERLOG_IN[96], CFGERRAERHEADERLOG[96]);
  buf B_CFGERRAERHEADERLOG97 (CFGERRAERHEADERLOG_IN[97], CFGERRAERHEADERLOG[97]);
  buf B_CFGERRAERHEADERLOG98 (CFGERRAERHEADERLOG_IN[98], CFGERRAERHEADERLOG[98]);
  buf B_CFGERRAERHEADERLOG99 (CFGERRAERHEADERLOG_IN[99], CFGERRAERHEADERLOG[99]);
  buf B_CFGERRCORN (CFGERRCORN_IN, CFGERRCORN);
  buf B_CFGERRCPLABORTN (CFGERRCPLABORTN_IN, CFGERRCPLABORTN);
  buf B_CFGERRCPLTIMEOUTN (CFGERRCPLTIMEOUTN_IN, CFGERRCPLTIMEOUTN);
  buf B_CFGERRCPLUNEXPECTN (CFGERRCPLUNEXPECTN_IN, CFGERRCPLUNEXPECTN);
  buf B_CFGERRECRCN (CFGERRECRCN_IN, CFGERRECRCN);
  buf B_CFGERRLOCKEDN (CFGERRLOCKEDN_IN, CFGERRLOCKEDN);
  buf B_CFGERRPOSTEDN (CFGERRPOSTEDN_IN, CFGERRPOSTEDN);
  buf B_CFGERRTLPCPLHEADER0 (CFGERRTLPCPLHEADER_IN[0], CFGERRTLPCPLHEADER[0]);
  buf B_CFGERRTLPCPLHEADER1 (CFGERRTLPCPLHEADER_IN[1], CFGERRTLPCPLHEADER[1]);
  buf B_CFGERRTLPCPLHEADER10 (CFGERRTLPCPLHEADER_IN[10], CFGERRTLPCPLHEADER[10]);
  buf B_CFGERRTLPCPLHEADER11 (CFGERRTLPCPLHEADER_IN[11], CFGERRTLPCPLHEADER[11]);
  buf B_CFGERRTLPCPLHEADER12 (CFGERRTLPCPLHEADER_IN[12], CFGERRTLPCPLHEADER[12]);
  buf B_CFGERRTLPCPLHEADER13 (CFGERRTLPCPLHEADER_IN[13], CFGERRTLPCPLHEADER[13]);
  buf B_CFGERRTLPCPLHEADER14 (CFGERRTLPCPLHEADER_IN[14], CFGERRTLPCPLHEADER[14]);
  buf B_CFGERRTLPCPLHEADER15 (CFGERRTLPCPLHEADER_IN[15], CFGERRTLPCPLHEADER[15]);
  buf B_CFGERRTLPCPLHEADER16 (CFGERRTLPCPLHEADER_IN[16], CFGERRTLPCPLHEADER[16]);
  buf B_CFGERRTLPCPLHEADER17 (CFGERRTLPCPLHEADER_IN[17], CFGERRTLPCPLHEADER[17]);
  buf B_CFGERRTLPCPLHEADER18 (CFGERRTLPCPLHEADER_IN[18], CFGERRTLPCPLHEADER[18]);
  buf B_CFGERRTLPCPLHEADER19 (CFGERRTLPCPLHEADER_IN[19], CFGERRTLPCPLHEADER[19]);
  buf B_CFGERRTLPCPLHEADER2 (CFGERRTLPCPLHEADER_IN[2], CFGERRTLPCPLHEADER[2]);
  buf B_CFGERRTLPCPLHEADER20 (CFGERRTLPCPLHEADER_IN[20], CFGERRTLPCPLHEADER[20]);
  buf B_CFGERRTLPCPLHEADER21 (CFGERRTLPCPLHEADER_IN[21], CFGERRTLPCPLHEADER[21]);
  buf B_CFGERRTLPCPLHEADER22 (CFGERRTLPCPLHEADER_IN[22], CFGERRTLPCPLHEADER[22]);
  buf B_CFGERRTLPCPLHEADER23 (CFGERRTLPCPLHEADER_IN[23], CFGERRTLPCPLHEADER[23]);
  buf B_CFGERRTLPCPLHEADER24 (CFGERRTLPCPLHEADER_IN[24], CFGERRTLPCPLHEADER[24]);
  buf B_CFGERRTLPCPLHEADER25 (CFGERRTLPCPLHEADER_IN[25], CFGERRTLPCPLHEADER[25]);
  buf B_CFGERRTLPCPLHEADER26 (CFGERRTLPCPLHEADER_IN[26], CFGERRTLPCPLHEADER[26]);
  buf B_CFGERRTLPCPLHEADER27 (CFGERRTLPCPLHEADER_IN[27], CFGERRTLPCPLHEADER[27]);
  buf B_CFGERRTLPCPLHEADER28 (CFGERRTLPCPLHEADER_IN[28], CFGERRTLPCPLHEADER[28]);
  buf B_CFGERRTLPCPLHEADER29 (CFGERRTLPCPLHEADER_IN[29], CFGERRTLPCPLHEADER[29]);
  buf B_CFGERRTLPCPLHEADER3 (CFGERRTLPCPLHEADER_IN[3], CFGERRTLPCPLHEADER[3]);
  buf B_CFGERRTLPCPLHEADER30 (CFGERRTLPCPLHEADER_IN[30], CFGERRTLPCPLHEADER[30]);
  buf B_CFGERRTLPCPLHEADER31 (CFGERRTLPCPLHEADER_IN[31], CFGERRTLPCPLHEADER[31]);
  buf B_CFGERRTLPCPLHEADER32 (CFGERRTLPCPLHEADER_IN[32], CFGERRTLPCPLHEADER[32]);
  buf B_CFGERRTLPCPLHEADER33 (CFGERRTLPCPLHEADER_IN[33], CFGERRTLPCPLHEADER[33]);
  buf B_CFGERRTLPCPLHEADER34 (CFGERRTLPCPLHEADER_IN[34], CFGERRTLPCPLHEADER[34]);
  buf B_CFGERRTLPCPLHEADER35 (CFGERRTLPCPLHEADER_IN[35], CFGERRTLPCPLHEADER[35]);
  buf B_CFGERRTLPCPLHEADER36 (CFGERRTLPCPLHEADER_IN[36], CFGERRTLPCPLHEADER[36]);
  buf B_CFGERRTLPCPLHEADER37 (CFGERRTLPCPLHEADER_IN[37], CFGERRTLPCPLHEADER[37]);
  buf B_CFGERRTLPCPLHEADER38 (CFGERRTLPCPLHEADER_IN[38], CFGERRTLPCPLHEADER[38]);
  buf B_CFGERRTLPCPLHEADER39 (CFGERRTLPCPLHEADER_IN[39], CFGERRTLPCPLHEADER[39]);
  buf B_CFGERRTLPCPLHEADER4 (CFGERRTLPCPLHEADER_IN[4], CFGERRTLPCPLHEADER[4]);
  buf B_CFGERRTLPCPLHEADER40 (CFGERRTLPCPLHEADER_IN[40], CFGERRTLPCPLHEADER[40]);
  buf B_CFGERRTLPCPLHEADER41 (CFGERRTLPCPLHEADER_IN[41], CFGERRTLPCPLHEADER[41]);
  buf B_CFGERRTLPCPLHEADER42 (CFGERRTLPCPLHEADER_IN[42], CFGERRTLPCPLHEADER[42]);
  buf B_CFGERRTLPCPLHEADER43 (CFGERRTLPCPLHEADER_IN[43], CFGERRTLPCPLHEADER[43]);
  buf B_CFGERRTLPCPLHEADER44 (CFGERRTLPCPLHEADER_IN[44], CFGERRTLPCPLHEADER[44]);
  buf B_CFGERRTLPCPLHEADER45 (CFGERRTLPCPLHEADER_IN[45], CFGERRTLPCPLHEADER[45]);
  buf B_CFGERRTLPCPLHEADER46 (CFGERRTLPCPLHEADER_IN[46], CFGERRTLPCPLHEADER[46]);
  buf B_CFGERRTLPCPLHEADER47 (CFGERRTLPCPLHEADER_IN[47], CFGERRTLPCPLHEADER[47]);
  buf B_CFGERRTLPCPLHEADER5 (CFGERRTLPCPLHEADER_IN[5], CFGERRTLPCPLHEADER[5]);
  buf B_CFGERRTLPCPLHEADER6 (CFGERRTLPCPLHEADER_IN[6], CFGERRTLPCPLHEADER[6]);
  buf B_CFGERRTLPCPLHEADER7 (CFGERRTLPCPLHEADER_IN[7], CFGERRTLPCPLHEADER[7]);
  buf B_CFGERRTLPCPLHEADER8 (CFGERRTLPCPLHEADER_IN[8], CFGERRTLPCPLHEADER[8]);
  buf B_CFGERRTLPCPLHEADER9 (CFGERRTLPCPLHEADER_IN[9], CFGERRTLPCPLHEADER[9]);
  buf B_CFGERRURN (CFGERRURN_IN, CFGERRURN);
  buf B_CFGINTERRUPTASSERTN (CFGINTERRUPTASSERTN_IN, CFGINTERRUPTASSERTN);
  buf B_CFGINTERRUPTDI0 (CFGINTERRUPTDI_IN[0], CFGINTERRUPTDI[0]);
  buf B_CFGINTERRUPTDI1 (CFGINTERRUPTDI_IN[1], CFGINTERRUPTDI[1]);
  buf B_CFGINTERRUPTDI2 (CFGINTERRUPTDI_IN[2], CFGINTERRUPTDI[2]);
  buf B_CFGINTERRUPTDI3 (CFGINTERRUPTDI_IN[3], CFGINTERRUPTDI[3]);
  buf B_CFGINTERRUPTDI4 (CFGINTERRUPTDI_IN[4], CFGINTERRUPTDI[4]);
  buf B_CFGINTERRUPTDI5 (CFGINTERRUPTDI_IN[5], CFGINTERRUPTDI[5]);
  buf B_CFGINTERRUPTDI6 (CFGINTERRUPTDI_IN[6], CFGINTERRUPTDI[6]);
  buf B_CFGINTERRUPTDI7 (CFGINTERRUPTDI_IN[7], CFGINTERRUPTDI[7]);
  buf B_CFGINTERRUPTN (CFGINTERRUPTN_IN, CFGINTERRUPTN);
  buf B_CFGPMDIRECTASPML1N (CFGPMDIRECTASPML1N_IN, CFGPMDIRECTASPML1N);
  buf B_CFGPMSENDPMACKN (CFGPMSENDPMACKN_IN, CFGPMSENDPMACKN);
  buf B_CFGPMSENDPMETON (CFGPMSENDPMETON_IN, CFGPMSENDPMETON);
  buf B_CFGPMSENDPMNAKN (CFGPMSENDPMNAKN_IN, CFGPMSENDPMNAKN);
  buf B_CFGPMTURNOFFOKN (CFGPMTURNOFFOKN_IN, CFGPMTURNOFFOKN);
  buf B_CFGPMWAKEN (CFGPMWAKEN_IN, CFGPMWAKEN);
  buf B_CFGPORTNUMBER0 (CFGPORTNUMBER_IN[0], CFGPORTNUMBER[0]);
  buf B_CFGPORTNUMBER1 (CFGPORTNUMBER_IN[1], CFGPORTNUMBER[1]);
  buf B_CFGPORTNUMBER2 (CFGPORTNUMBER_IN[2], CFGPORTNUMBER[2]);
  buf B_CFGPORTNUMBER3 (CFGPORTNUMBER_IN[3], CFGPORTNUMBER[3]);
  buf B_CFGPORTNUMBER4 (CFGPORTNUMBER_IN[4], CFGPORTNUMBER[4]);
  buf B_CFGPORTNUMBER5 (CFGPORTNUMBER_IN[5], CFGPORTNUMBER[5]);
  buf B_CFGPORTNUMBER6 (CFGPORTNUMBER_IN[6], CFGPORTNUMBER[6]);
  buf B_CFGPORTNUMBER7 (CFGPORTNUMBER_IN[7], CFGPORTNUMBER[7]);
  buf B_CFGRDENN (CFGRDENN_IN, CFGRDENN);
  buf B_CFGTRNPENDINGN (CFGTRNPENDINGN_IN, CFGTRNPENDINGN);
  buf B_CFGWRENN (CFGWRENN_IN, CFGWRENN);
  buf B_CFGWRREADONLYN (CFGWRREADONLYN_IN, CFGWRREADONLYN);
  buf B_CFGWRRW1CASRWN (CFGWRRW1CASRWN_IN, CFGWRRW1CASRWN);
  buf B_CMRSTN (CMRSTN_IN, CMRSTN);
  buf B_CMSTICKYRSTN (CMSTICKYRSTN_IN, CMSTICKYRSTN);
  buf B_DBGMODE0 (DBGMODE_IN[0], DBGMODE[0]);
  buf B_DBGMODE1 (DBGMODE_IN[1], DBGMODE[1]);
  buf B_DBGSUBMODE (DBGSUBMODE_IN, DBGSUBMODE);
  buf B_DLRSTN (DLRSTN_IN, DLRSTN);
  buf B_DRPCLK (DRPCLK_IN, DRPCLK);
  buf B_DRPDADDR0 (DRPDADDR_IN[0], DRPDADDR[0]);
  buf B_DRPDADDR1 (DRPDADDR_IN[1], DRPDADDR[1]);
  buf B_DRPDADDR2 (DRPDADDR_IN[2], DRPDADDR[2]);
  buf B_DRPDADDR3 (DRPDADDR_IN[3], DRPDADDR[3]);
  buf B_DRPDADDR4 (DRPDADDR_IN[4], DRPDADDR[4]);
  buf B_DRPDADDR5 (DRPDADDR_IN[5], DRPDADDR[5]);
  buf B_DRPDADDR6 (DRPDADDR_IN[6], DRPDADDR[6]);
  buf B_DRPDADDR7 (DRPDADDR_IN[7], DRPDADDR[7]);
  buf B_DRPDADDR8 (DRPDADDR_IN[8], DRPDADDR[8]);
  buf B_DRPDEN (DRPDEN_IN, DRPDEN);
  buf B_DRPDI0 (DRPDI_IN[0], DRPDI[0]);
  buf B_DRPDI1 (DRPDI_IN[1], DRPDI[1]);
  buf B_DRPDI10 (DRPDI_IN[10], DRPDI[10]);
  buf B_DRPDI11 (DRPDI_IN[11], DRPDI[11]);
  buf B_DRPDI12 (DRPDI_IN[12], DRPDI[12]);
  buf B_DRPDI13 (DRPDI_IN[13], DRPDI[13]);
  buf B_DRPDI14 (DRPDI_IN[14], DRPDI[14]);
  buf B_DRPDI15 (DRPDI_IN[15], DRPDI[15]);
  buf B_DRPDI2 (DRPDI_IN[2], DRPDI[2]);
  buf B_DRPDI3 (DRPDI_IN[3], DRPDI[3]);
  buf B_DRPDI4 (DRPDI_IN[4], DRPDI[4]);
  buf B_DRPDI5 (DRPDI_IN[5], DRPDI[5]);
  buf B_DRPDI6 (DRPDI_IN[6], DRPDI[6]);
  buf B_DRPDI7 (DRPDI_IN[7], DRPDI[7]);
  buf B_DRPDI8 (DRPDI_IN[8], DRPDI[8]);
  buf B_DRPDI9 (DRPDI_IN[9], DRPDI[9]);
  buf B_DRPDWE (DRPDWE_IN, DRPDWE);
  buf B_FUNCLVLRSTN (FUNCLVLRSTN_IN, FUNCLVLRSTN);
  buf B_LL2SENDASREQL1N (LL2SENDASREQL1N_IN, LL2SENDASREQL1N);
  buf B_LL2SENDENTERL1N (LL2SENDENTERL1N_IN, LL2SENDENTERL1N);
  buf B_LL2SENDENTERL23N (LL2SENDENTERL23N_IN, LL2SENDENTERL23N);
  buf B_LL2SUSPENDNOWN (LL2SUSPENDNOWN_IN, LL2SUSPENDNOWN);
  buf B_LL2TLPRCVN (LL2TLPRCVN_IN, LL2TLPRCVN);
  buf B_MIMRXRDATA0 (MIMRXRDATA_IN[0], MIMRXRDATA[0]);
  buf B_MIMRXRDATA1 (MIMRXRDATA_IN[1], MIMRXRDATA[1]);
  buf B_MIMRXRDATA10 (MIMRXRDATA_IN[10], MIMRXRDATA[10]);
  buf B_MIMRXRDATA11 (MIMRXRDATA_IN[11], MIMRXRDATA[11]);
  buf B_MIMRXRDATA12 (MIMRXRDATA_IN[12], MIMRXRDATA[12]);
  buf B_MIMRXRDATA13 (MIMRXRDATA_IN[13], MIMRXRDATA[13]);
  buf B_MIMRXRDATA14 (MIMRXRDATA_IN[14], MIMRXRDATA[14]);
  buf B_MIMRXRDATA15 (MIMRXRDATA_IN[15], MIMRXRDATA[15]);
  buf B_MIMRXRDATA16 (MIMRXRDATA_IN[16], MIMRXRDATA[16]);
  buf B_MIMRXRDATA17 (MIMRXRDATA_IN[17], MIMRXRDATA[17]);
  buf B_MIMRXRDATA18 (MIMRXRDATA_IN[18], MIMRXRDATA[18]);
  buf B_MIMRXRDATA19 (MIMRXRDATA_IN[19], MIMRXRDATA[19]);
  buf B_MIMRXRDATA2 (MIMRXRDATA_IN[2], MIMRXRDATA[2]);
  buf B_MIMRXRDATA20 (MIMRXRDATA_IN[20], MIMRXRDATA[20]);
  buf B_MIMRXRDATA21 (MIMRXRDATA_IN[21], MIMRXRDATA[21]);
  buf B_MIMRXRDATA22 (MIMRXRDATA_IN[22], MIMRXRDATA[22]);
  buf B_MIMRXRDATA23 (MIMRXRDATA_IN[23], MIMRXRDATA[23]);
  buf B_MIMRXRDATA24 (MIMRXRDATA_IN[24], MIMRXRDATA[24]);
  buf B_MIMRXRDATA25 (MIMRXRDATA_IN[25], MIMRXRDATA[25]);
  buf B_MIMRXRDATA26 (MIMRXRDATA_IN[26], MIMRXRDATA[26]);
  buf B_MIMRXRDATA27 (MIMRXRDATA_IN[27], MIMRXRDATA[27]);
  buf B_MIMRXRDATA28 (MIMRXRDATA_IN[28], MIMRXRDATA[28]);
  buf B_MIMRXRDATA29 (MIMRXRDATA_IN[29], MIMRXRDATA[29]);
  buf B_MIMRXRDATA3 (MIMRXRDATA_IN[3], MIMRXRDATA[3]);
  buf B_MIMRXRDATA30 (MIMRXRDATA_IN[30], MIMRXRDATA[30]);
  buf B_MIMRXRDATA31 (MIMRXRDATA_IN[31], MIMRXRDATA[31]);
  buf B_MIMRXRDATA32 (MIMRXRDATA_IN[32], MIMRXRDATA[32]);
  buf B_MIMRXRDATA33 (MIMRXRDATA_IN[33], MIMRXRDATA[33]);
  buf B_MIMRXRDATA34 (MIMRXRDATA_IN[34], MIMRXRDATA[34]);
  buf B_MIMRXRDATA35 (MIMRXRDATA_IN[35], MIMRXRDATA[35]);
  buf B_MIMRXRDATA36 (MIMRXRDATA_IN[36], MIMRXRDATA[36]);
  buf B_MIMRXRDATA37 (MIMRXRDATA_IN[37], MIMRXRDATA[37]);
  buf B_MIMRXRDATA38 (MIMRXRDATA_IN[38], MIMRXRDATA[38]);
  buf B_MIMRXRDATA39 (MIMRXRDATA_IN[39], MIMRXRDATA[39]);
  buf B_MIMRXRDATA4 (MIMRXRDATA_IN[4], MIMRXRDATA[4]);
  buf B_MIMRXRDATA40 (MIMRXRDATA_IN[40], MIMRXRDATA[40]);
  buf B_MIMRXRDATA41 (MIMRXRDATA_IN[41], MIMRXRDATA[41]);
  buf B_MIMRXRDATA42 (MIMRXRDATA_IN[42], MIMRXRDATA[42]);
  buf B_MIMRXRDATA43 (MIMRXRDATA_IN[43], MIMRXRDATA[43]);
  buf B_MIMRXRDATA44 (MIMRXRDATA_IN[44], MIMRXRDATA[44]);
  buf B_MIMRXRDATA45 (MIMRXRDATA_IN[45], MIMRXRDATA[45]);
  buf B_MIMRXRDATA46 (MIMRXRDATA_IN[46], MIMRXRDATA[46]);
  buf B_MIMRXRDATA47 (MIMRXRDATA_IN[47], MIMRXRDATA[47]);
  buf B_MIMRXRDATA48 (MIMRXRDATA_IN[48], MIMRXRDATA[48]);
  buf B_MIMRXRDATA49 (MIMRXRDATA_IN[49], MIMRXRDATA[49]);
  buf B_MIMRXRDATA5 (MIMRXRDATA_IN[5], MIMRXRDATA[5]);
  buf B_MIMRXRDATA50 (MIMRXRDATA_IN[50], MIMRXRDATA[50]);
  buf B_MIMRXRDATA51 (MIMRXRDATA_IN[51], MIMRXRDATA[51]);
  buf B_MIMRXRDATA52 (MIMRXRDATA_IN[52], MIMRXRDATA[52]);
  buf B_MIMRXRDATA53 (MIMRXRDATA_IN[53], MIMRXRDATA[53]);
  buf B_MIMRXRDATA54 (MIMRXRDATA_IN[54], MIMRXRDATA[54]);
  buf B_MIMRXRDATA55 (MIMRXRDATA_IN[55], MIMRXRDATA[55]);
  buf B_MIMRXRDATA56 (MIMRXRDATA_IN[56], MIMRXRDATA[56]);
  buf B_MIMRXRDATA57 (MIMRXRDATA_IN[57], MIMRXRDATA[57]);
  buf B_MIMRXRDATA58 (MIMRXRDATA_IN[58], MIMRXRDATA[58]);
  buf B_MIMRXRDATA59 (MIMRXRDATA_IN[59], MIMRXRDATA[59]);
  buf B_MIMRXRDATA6 (MIMRXRDATA_IN[6], MIMRXRDATA[6]);
  buf B_MIMRXRDATA60 (MIMRXRDATA_IN[60], MIMRXRDATA[60]);
  buf B_MIMRXRDATA61 (MIMRXRDATA_IN[61], MIMRXRDATA[61]);
  buf B_MIMRXRDATA62 (MIMRXRDATA_IN[62], MIMRXRDATA[62]);
  buf B_MIMRXRDATA63 (MIMRXRDATA_IN[63], MIMRXRDATA[63]);
  buf B_MIMRXRDATA64 (MIMRXRDATA_IN[64], MIMRXRDATA[64]);
  buf B_MIMRXRDATA65 (MIMRXRDATA_IN[65], MIMRXRDATA[65]);
  buf B_MIMRXRDATA66 (MIMRXRDATA_IN[66], MIMRXRDATA[66]);
  buf B_MIMRXRDATA67 (MIMRXRDATA_IN[67], MIMRXRDATA[67]);
  buf B_MIMRXRDATA7 (MIMRXRDATA_IN[7], MIMRXRDATA[7]);
  buf B_MIMRXRDATA8 (MIMRXRDATA_IN[8], MIMRXRDATA[8]);
  buf B_MIMRXRDATA9 (MIMRXRDATA_IN[9], MIMRXRDATA[9]);
  buf B_MIMTXRDATA0 (MIMTXRDATA_IN[0], MIMTXRDATA[0]);
  buf B_MIMTXRDATA1 (MIMTXRDATA_IN[1], MIMTXRDATA[1]);
  buf B_MIMTXRDATA10 (MIMTXRDATA_IN[10], MIMTXRDATA[10]);
  buf B_MIMTXRDATA11 (MIMTXRDATA_IN[11], MIMTXRDATA[11]);
  buf B_MIMTXRDATA12 (MIMTXRDATA_IN[12], MIMTXRDATA[12]);
  buf B_MIMTXRDATA13 (MIMTXRDATA_IN[13], MIMTXRDATA[13]);
  buf B_MIMTXRDATA14 (MIMTXRDATA_IN[14], MIMTXRDATA[14]);
  buf B_MIMTXRDATA15 (MIMTXRDATA_IN[15], MIMTXRDATA[15]);
  buf B_MIMTXRDATA16 (MIMTXRDATA_IN[16], MIMTXRDATA[16]);
  buf B_MIMTXRDATA17 (MIMTXRDATA_IN[17], MIMTXRDATA[17]);
  buf B_MIMTXRDATA18 (MIMTXRDATA_IN[18], MIMTXRDATA[18]);
  buf B_MIMTXRDATA19 (MIMTXRDATA_IN[19], MIMTXRDATA[19]);
  buf B_MIMTXRDATA2 (MIMTXRDATA_IN[2], MIMTXRDATA[2]);
  buf B_MIMTXRDATA20 (MIMTXRDATA_IN[20], MIMTXRDATA[20]);
  buf B_MIMTXRDATA21 (MIMTXRDATA_IN[21], MIMTXRDATA[21]);
  buf B_MIMTXRDATA22 (MIMTXRDATA_IN[22], MIMTXRDATA[22]);
  buf B_MIMTXRDATA23 (MIMTXRDATA_IN[23], MIMTXRDATA[23]);
  buf B_MIMTXRDATA24 (MIMTXRDATA_IN[24], MIMTXRDATA[24]);
  buf B_MIMTXRDATA25 (MIMTXRDATA_IN[25], MIMTXRDATA[25]);
  buf B_MIMTXRDATA26 (MIMTXRDATA_IN[26], MIMTXRDATA[26]);
  buf B_MIMTXRDATA27 (MIMTXRDATA_IN[27], MIMTXRDATA[27]);
  buf B_MIMTXRDATA28 (MIMTXRDATA_IN[28], MIMTXRDATA[28]);
  buf B_MIMTXRDATA29 (MIMTXRDATA_IN[29], MIMTXRDATA[29]);
  buf B_MIMTXRDATA3 (MIMTXRDATA_IN[3], MIMTXRDATA[3]);
  buf B_MIMTXRDATA30 (MIMTXRDATA_IN[30], MIMTXRDATA[30]);
  buf B_MIMTXRDATA31 (MIMTXRDATA_IN[31], MIMTXRDATA[31]);
  buf B_MIMTXRDATA32 (MIMTXRDATA_IN[32], MIMTXRDATA[32]);
  buf B_MIMTXRDATA33 (MIMTXRDATA_IN[33], MIMTXRDATA[33]);
  buf B_MIMTXRDATA34 (MIMTXRDATA_IN[34], MIMTXRDATA[34]);
  buf B_MIMTXRDATA35 (MIMTXRDATA_IN[35], MIMTXRDATA[35]);
  buf B_MIMTXRDATA36 (MIMTXRDATA_IN[36], MIMTXRDATA[36]);
  buf B_MIMTXRDATA37 (MIMTXRDATA_IN[37], MIMTXRDATA[37]);
  buf B_MIMTXRDATA38 (MIMTXRDATA_IN[38], MIMTXRDATA[38]);
  buf B_MIMTXRDATA39 (MIMTXRDATA_IN[39], MIMTXRDATA[39]);
  buf B_MIMTXRDATA4 (MIMTXRDATA_IN[4], MIMTXRDATA[4]);
  buf B_MIMTXRDATA40 (MIMTXRDATA_IN[40], MIMTXRDATA[40]);
  buf B_MIMTXRDATA41 (MIMTXRDATA_IN[41], MIMTXRDATA[41]);
  buf B_MIMTXRDATA42 (MIMTXRDATA_IN[42], MIMTXRDATA[42]);
  buf B_MIMTXRDATA43 (MIMTXRDATA_IN[43], MIMTXRDATA[43]);
  buf B_MIMTXRDATA44 (MIMTXRDATA_IN[44], MIMTXRDATA[44]);
  buf B_MIMTXRDATA45 (MIMTXRDATA_IN[45], MIMTXRDATA[45]);
  buf B_MIMTXRDATA46 (MIMTXRDATA_IN[46], MIMTXRDATA[46]);
  buf B_MIMTXRDATA47 (MIMTXRDATA_IN[47], MIMTXRDATA[47]);
  buf B_MIMTXRDATA48 (MIMTXRDATA_IN[48], MIMTXRDATA[48]);
  buf B_MIMTXRDATA49 (MIMTXRDATA_IN[49], MIMTXRDATA[49]);
  buf B_MIMTXRDATA5 (MIMTXRDATA_IN[5], MIMTXRDATA[5]);
  buf B_MIMTXRDATA50 (MIMTXRDATA_IN[50], MIMTXRDATA[50]);
  buf B_MIMTXRDATA51 (MIMTXRDATA_IN[51], MIMTXRDATA[51]);
  buf B_MIMTXRDATA52 (MIMTXRDATA_IN[52], MIMTXRDATA[52]);
  buf B_MIMTXRDATA53 (MIMTXRDATA_IN[53], MIMTXRDATA[53]);
  buf B_MIMTXRDATA54 (MIMTXRDATA_IN[54], MIMTXRDATA[54]);
  buf B_MIMTXRDATA55 (MIMTXRDATA_IN[55], MIMTXRDATA[55]);
  buf B_MIMTXRDATA56 (MIMTXRDATA_IN[56], MIMTXRDATA[56]);
  buf B_MIMTXRDATA57 (MIMTXRDATA_IN[57], MIMTXRDATA[57]);
  buf B_MIMTXRDATA58 (MIMTXRDATA_IN[58], MIMTXRDATA[58]);
  buf B_MIMTXRDATA59 (MIMTXRDATA_IN[59], MIMTXRDATA[59]);
  buf B_MIMTXRDATA6 (MIMTXRDATA_IN[6], MIMTXRDATA[6]);
  buf B_MIMTXRDATA60 (MIMTXRDATA_IN[60], MIMTXRDATA[60]);
  buf B_MIMTXRDATA61 (MIMTXRDATA_IN[61], MIMTXRDATA[61]);
  buf B_MIMTXRDATA62 (MIMTXRDATA_IN[62], MIMTXRDATA[62]);
  buf B_MIMTXRDATA63 (MIMTXRDATA_IN[63], MIMTXRDATA[63]);
  buf B_MIMTXRDATA64 (MIMTXRDATA_IN[64], MIMTXRDATA[64]);
  buf B_MIMTXRDATA65 (MIMTXRDATA_IN[65], MIMTXRDATA[65]);
  buf B_MIMTXRDATA66 (MIMTXRDATA_IN[66], MIMTXRDATA[66]);
  buf B_MIMTXRDATA67 (MIMTXRDATA_IN[67], MIMTXRDATA[67]);
  buf B_MIMTXRDATA68 (MIMTXRDATA_IN[68], MIMTXRDATA[68]);
  buf B_MIMTXRDATA7 (MIMTXRDATA_IN[7], MIMTXRDATA[7]);
  buf B_MIMTXRDATA8 (MIMTXRDATA_IN[8], MIMTXRDATA[8]);
  buf B_MIMTXRDATA9 (MIMTXRDATA_IN[9], MIMTXRDATA[9]);
  buf B_PIPECLK (PIPECLK_IN, PIPECLK);
  buf B_PIPERX0CHANISALIGNED (PIPERX0CHANISALIGNED_IN, PIPERX0CHANISALIGNED);
  buf B_PIPERX0CHARISK0 (PIPERX0CHARISK_IN[0], PIPERX0CHARISK[0]);
  buf B_PIPERX0CHARISK1 (PIPERX0CHARISK_IN[1], PIPERX0CHARISK[1]);
  buf B_PIPERX0DATA0 (PIPERX0DATA_IN[0], PIPERX0DATA[0]);
  buf B_PIPERX0DATA1 (PIPERX0DATA_IN[1], PIPERX0DATA[1]);
  buf B_PIPERX0DATA10 (PIPERX0DATA_IN[10], PIPERX0DATA[10]);
  buf B_PIPERX0DATA11 (PIPERX0DATA_IN[11], PIPERX0DATA[11]);
  buf B_PIPERX0DATA12 (PIPERX0DATA_IN[12], PIPERX0DATA[12]);
  buf B_PIPERX0DATA13 (PIPERX0DATA_IN[13], PIPERX0DATA[13]);
  buf B_PIPERX0DATA14 (PIPERX0DATA_IN[14], PIPERX0DATA[14]);
  buf B_PIPERX0DATA15 (PIPERX0DATA_IN[15], PIPERX0DATA[15]);
  buf B_PIPERX0DATA2 (PIPERX0DATA_IN[2], PIPERX0DATA[2]);
  buf B_PIPERX0DATA3 (PIPERX0DATA_IN[3], PIPERX0DATA[3]);
  buf B_PIPERX0DATA4 (PIPERX0DATA_IN[4], PIPERX0DATA[4]);
  buf B_PIPERX0DATA5 (PIPERX0DATA_IN[5], PIPERX0DATA[5]);
  buf B_PIPERX0DATA6 (PIPERX0DATA_IN[6], PIPERX0DATA[6]);
  buf B_PIPERX0DATA7 (PIPERX0DATA_IN[7], PIPERX0DATA[7]);
  buf B_PIPERX0DATA8 (PIPERX0DATA_IN[8], PIPERX0DATA[8]);
  buf B_PIPERX0DATA9 (PIPERX0DATA_IN[9], PIPERX0DATA[9]);
  buf B_PIPERX0ELECIDLE (PIPERX0ELECIDLE_IN, PIPERX0ELECIDLE);
  buf B_PIPERX0PHYSTATUS (PIPERX0PHYSTATUS_IN, PIPERX0PHYSTATUS);
  buf B_PIPERX0STATUS0 (PIPERX0STATUS_IN[0], PIPERX0STATUS[0]);
  buf B_PIPERX0STATUS1 (PIPERX0STATUS_IN[1], PIPERX0STATUS[1]);
  buf B_PIPERX0STATUS2 (PIPERX0STATUS_IN[2], PIPERX0STATUS[2]);
  buf B_PIPERX0VALID (PIPERX0VALID_IN, PIPERX0VALID);
  buf B_PIPERX1CHANISALIGNED (PIPERX1CHANISALIGNED_IN, PIPERX1CHANISALIGNED);
  buf B_PIPERX1CHARISK0 (PIPERX1CHARISK_IN[0], PIPERX1CHARISK[0]);
  buf B_PIPERX1CHARISK1 (PIPERX1CHARISK_IN[1], PIPERX1CHARISK[1]);
  buf B_PIPERX1DATA0 (PIPERX1DATA_IN[0], PIPERX1DATA[0]);
  buf B_PIPERX1DATA1 (PIPERX1DATA_IN[1], PIPERX1DATA[1]);
  buf B_PIPERX1DATA10 (PIPERX1DATA_IN[10], PIPERX1DATA[10]);
  buf B_PIPERX1DATA11 (PIPERX1DATA_IN[11], PIPERX1DATA[11]);
  buf B_PIPERX1DATA12 (PIPERX1DATA_IN[12], PIPERX1DATA[12]);
  buf B_PIPERX1DATA13 (PIPERX1DATA_IN[13], PIPERX1DATA[13]);
  buf B_PIPERX1DATA14 (PIPERX1DATA_IN[14], PIPERX1DATA[14]);
  buf B_PIPERX1DATA15 (PIPERX1DATA_IN[15], PIPERX1DATA[15]);
  buf B_PIPERX1DATA2 (PIPERX1DATA_IN[2], PIPERX1DATA[2]);
  buf B_PIPERX1DATA3 (PIPERX1DATA_IN[3], PIPERX1DATA[3]);
  buf B_PIPERX1DATA4 (PIPERX1DATA_IN[4], PIPERX1DATA[4]);
  buf B_PIPERX1DATA5 (PIPERX1DATA_IN[5], PIPERX1DATA[5]);
  buf B_PIPERX1DATA6 (PIPERX1DATA_IN[6], PIPERX1DATA[6]);
  buf B_PIPERX1DATA7 (PIPERX1DATA_IN[7], PIPERX1DATA[7]);
  buf B_PIPERX1DATA8 (PIPERX1DATA_IN[8], PIPERX1DATA[8]);
  buf B_PIPERX1DATA9 (PIPERX1DATA_IN[9], PIPERX1DATA[9]);
  buf B_PIPERX1ELECIDLE (PIPERX1ELECIDLE_IN, PIPERX1ELECIDLE);
  buf B_PIPERX1PHYSTATUS (PIPERX1PHYSTATUS_IN, PIPERX1PHYSTATUS);
  buf B_PIPERX1STATUS0 (PIPERX1STATUS_IN[0], PIPERX1STATUS[0]);
  buf B_PIPERX1STATUS1 (PIPERX1STATUS_IN[1], PIPERX1STATUS[1]);
  buf B_PIPERX1STATUS2 (PIPERX1STATUS_IN[2], PIPERX1STATUS[2]);
  buf B_PIPERX1VALID (PIPERX1VALID_IN, PIPERX1VALID);
  buf B_PIPERX2CHANISALIGNED (PIPERX2CHANISALIGNED_IN, PIPERX2CHANISALIGNED);
  buf B_PIPERX2CHARISK0 (PIPERX2CHARISK_IN[0], PIPERX2CHARISK[0]);
  buf B_PIPERX2CHARISK1 (PIPERX2CHARISK_IN[1], PIPERX2CHARISK[1]);
  buf B_PIPERX2DATA0 (PIPERX2DATA_IN[0], PIPERX2DATA[0]);
  buf B_PIPERX2DATA1 (PIPERX2DATA_IN[1], PIPERX2DATA[1]);
  buf B_PIPERX2DATA10 (PIPERX2DATA_IN[10], PIPERX2DATA[10]);
  buf B_PIPERX2DATA11 (PIPERX2DATA_IN[11], PIPERX2DATA[11]);
  buf B_PIPERX2DATA12 (PIPERX2DATA_IN[12], PIPERX2DATA[12]);
  buf B_PIPERX2DATA13 (PIPERX2DATA_IN[13], PIPERX2DATA[13]);
  buf B_PIPERX2DATA14 (PIPERX2DATA_IN[14], PIPERX2DATA[14]);
  buf B_PIPERX2DATA15 (PIPERX2DATA_IN[15], PIPERX2DATA[15]);
  buf B_PIPERX2DATA2 (PIPERX2DATA_IN[2], PIPERX2DATA[2]);
  buf B_PIPERX2DATA3 (PIPERX2DATA_IN[3], PIPERX2DATA[3]);
  buf B_PIPERX2DATA4 (PIPERX2DATA_IN[4], PIPERX2DATA[4]);
  buf B_PIPERX2DATA5 (PIPERX2DATA_IN[5], PIPERX2DATA[5]);
  buf B_PIPERX2DATA6 (PIPERX2DATA_IN[6], PIPERX2DATA[6]);
  buf B_PIPERX2DATA7 (PIPERX2DATA_IN[7], PIPERX2DATA[7]);
  buf B_PIPERX2DATA8 (PIPERX2DATA_IN[8], PIPERX2DATA[8]);
  buf B_PIPERX2DATA9 (PIPERX2DATA_IN[9], PIPERX2DATA[9]);
  buf B_PIPERX2ELECIDLE (PIPERX2ELECIDLE_IN, PIPERX2ELECIDLE);
  buf B_PIPERX2PHYSTATUS (PIPERX2PHYSTATUS_IN, PIPERX2PHYSTATUS);
  buf B_PIPERX2STATUS0 (PIPERX2STATUS_IN[0], PIPERX2STATUS[0]);
  buf B_PIPERX2STATUS1 (PIPERX2STATUS_IN[1], PIPERX2STATUS[1]);
  buf B_PIPERX2STATUS2 (PIPERX2STATUS_IN[2], PIPERX2STATUS[2]);
  buf B_PIPERX2VALID (PIPERX2VALID_IN, PIPERX2VALID);
  buf B_PIPERX3CHANISALIGNED (PIPERX3CHANISALIGNED_IN, PIPERX3CHANISALIGNED);
  buf B_PIPERX3CHARISK0 (PIPERX3CHARISK_IN[0], PIPERX3CHARISK[0]);
  buf B_PIPERX3CHARISK1 (PIPERX3CHARISK_IN[1], PIPERX3CHARISK[1]);
  buf B_PIPERX3DATA0 (PIPERX3DATA_IN[0], PIPERX3DATA[0]);
  buf B_PIPERX3DATA1 (PIPERX3DATA_IN[1], PIPERX3DATA[1]);
  buf B_PIPERX3DATA10 (PIPERX3DATA_IN[10], PIPERX3DATA[10]);
  buf B_PIPERX3DATA11 (PIPERX3DATA_IN[11], PIPERX3DATA[11]);
  buf B_PIPERX3DATA12 (PIPERX3DATA_IN[12], PIPERX3DATA[12]);
  buf B_PIPERX3DATA13 (PIPERX3DATA_IN[13], PIPERX3DATA[13]);
  buf B_PIPERX3DATA14 (PIPERX3DATA_IN[14], PIPERX3DATA[14]);
  buf B_PIPERX3DATA15 (PIPERX3DATA_IN[15], PIPERX3DATA[15]);
  buf B_PIPERX3DATA2 (PIPERX3DATA_IN[2], PIPERX3DATA[2]);
  buf B_PIPERX3DATA3 (PIPERX3DATA_IN[3], PIPERX3DATA[3]);
  buf B_PIPERX3DATA4 (PIPERX3DATA_IN[4], PIPERX3DATA[4]);
  buf B_PIPERX3DATA5 (PIPERX3DATA_IN[5], PIPERX3DATA[5]);
  buf B_PIPERX3DATA6 (PIPERX3DATA_IN[6], PIPERX3DATA[6]);
  buf B_PIPERX3DATA7 (PIPERX3DATA_IN[7], PIPERX3DATA[7]);
  buf B_PIPERX3DATA8 (PIPERX3DATA_IN[8], PIPERX3DATA[8]);
  buf B_PIPERX3DATA9 (PIPERX3DATA_IN[9], PIPERX3DATA[9]);
  buf B_PIPERX3ELECIDLE (PIPERX3ELECIDLE_IN, PIPERX3ELECIDLE);
  buf B_PIPERX3PHYSTATUS (PIPERX3PHYSTATUS_IN, PIPERX3PHYSTATUS);
  buf B_PIPERX3STATUS0 (PIPERX3STATUS_IN[0], PIPERX3STATUS[0]);
  buf B_PIPERX3STATUS1 (PIPERX3STATUS_IN[1], PIPERX3STATUS[1]);
  buf B_PIPERX3STATUS2 (PIPERX3STATUS_IN[2], PIPERX3STATUS[2]);
  buf B_PIPERX3VALID (PIPERX3VALID_IN, PIPERX3VALID);
  buf B_PIPERX4CHANISALIGNED (PIPERX4CHANISALIGNED_IN, PIPERX4CHANISALIGNED);
  buf B_PIPERX4CHARISK0 (PIPERX4CHARISK_IN[0], PIPERX4CHARISK[0]);
  buf B_PIPERX4CHARISK1 (PIPERX4CHARISK_IN[1], PIPERX4CHARISK[1]);
  buf B_PIPERX4DATA0 (PIPERX4DATA_IN[0], PIPERX4DATA[0]);
  buf B_PIPERX4DATA1 (PIPERX4DATA_IN[1], PIPERX4DATA[1]);
  buf B_PIPERX4DATA10 (PIPERX4DATA_IN[10], PIPERX4DATA[10]);
  buf B_PIPERX4DATA11 (PIPERX4DATA_IN[11], PIPERX4DATA[11]);
  buf B_PIPERX4DATA12 (PIPERX4DATA_IN[12], PIPERX4DATA[12]);
  buf B_PIPERX4DATA13 (PIPERX4DATA_IN[13], PIPERX4DATA[13]);
  buf B_PIPERX4DATA14 (PIPERX4DATA_IN[14], PIPERX4DATA[14]);
  buf B_PIPERX4DATA15 (PIPERX4DATA_IN[15], PIPERX4DATA[15]);
  buf B_PIPERX4DATA2 (PIPERX4DATA_IN[2], PIPERX4DATA[2]);
  buf B_PIPERX4DATA3 (PIPERX4DATA_IN[3], PIPERX4DATA[3]);
  buf B_PIPERX4DATA4 (PIPERX4DATA_IN[4], PIPERX4DATA[4]);
  buf B_PIPERX4DATA5 (PIPERX4DATA_IN[5], PIPERX4DATA[5]);
  buf B_PIPERX4DATA6 (PIPERX4DATA_IN[6], PIPERX4DATA[6]);
  buf B_PIPERX4DATA7 (PIPERX4DATA_IN[7], PIPERX4DATA[7]);
  buf B_PIPERX4DATA8 (PIPERX4DATA_IN[8], PIPERX4DATA[8]);
  buf B_PIPERX4DATA9 (PIPERX4DATA_IN[9], PIPERX4DATA[9]);
  buf B_PIPERX4ELECIDLE (PIPERX4ELECIDLE_IN, PIPERX4ELECIDLE);
  buf B_PIPERX4PHYSTATUS (PIPERX4PHYSTATUS_IN, PIPERX4PHYSTATUS);
  buf B_PIPERX4STATUS0 (PIPERX4STATUS_IN[0], PIPERX4STATUS[0]);
  buf B_PIPERX4STATUS1 (PIPERX4STATUS_IN[1], PIPERX4STATUS[1]);
  buf B_PIPERX4STATUS2 (PIPERX4STATUS_IN[2], PIPERX4STATUS[2]);
  buf B_PIPERX4VALID (PIPERX4VALID_IN, PIPERX4VALID);
  buf B_PIPERX5CHANISALIGNED (PIPERX5CHANISALIGNED_IN, PIPERX5CHANISALIGNED);
  buf B_PIPERX5CHARISK0 (PIPERX5CHARISK_IN[0], PIPERX5CHARISK[0]);
  buf B_PIPERX5CHARISK1 (PIPERX5CHARISK_IN[1], PIPERX5CHARISK[1]);
  buf B_PIPERX5DATA0 (PIPERX5DATA_IN[0], PIPERX5DATA[0]);
  buf B_PIPERX5DATA1 (PIPERX5DATA_IN[1], PIPERX5DATA[1]);
  buf B_PIPERX5DATA10 (PIPERX5DATA_IN[10], PIPERX5DATA[10]);
  buf B_PIPERX5DATA11 (PIPERX5DATA_IN[11], PIPERX5DATA[11]);
  buf B_PIPERX5DATA12 (PIPERX5DATA_IN[12], PIPERX5DATA[12]);
  buf B_PIPERX5DATA13 (PIPERX5DATA_IN[13], PIPERX5DATA[13]);
  buf B_PIPERX5DATA14 (PIPERX5DATA_IN[14], PIPERX5DATA[14]);
  buf B_PIPERX5DATA15 (PIPERX5DATA_IN[15], PIPERX5DATA[15]);
  buf B_PIPERX5DATA2 (PIPERX5DATA_IN[2], PIPERX5DATA[2]);
  buf B_PIPERX5DATA3 (PIPERX5DATA_IN[3], PIPERX5DATA[3]);
  buf B_PIPERX5DATA4 (PIPERX5DATA_IN[4], PIPERX5DATA[4]);
  buf B_PIPERX5DATA5 (PIPERX5DATA_IN[5], PIPERX5DATA[5]);
  buf B_PIPERX5DATA6 (PIPERX5DATA_IN[6], PIPERX5DATA[6]);
  buf B_PIPERX5DATA7 (PIPERX5DATA_IN[7], PIPERX5DATA[7]);
  buf B_PIPERX5DATA8 (PIPERX5DATA_IN[8], PIPERX5DATA[8]);
  buf B_PIPERX5DATA9 (PIPERX5DATA_IN[9], PIPERX5DATA[9]);
  buf B_PIPERX5ELECIDLE (PIPERX5ELECIDLE_IN, PIPERX5ELECIDLE);
  buf B_PIPERX5PHYSTATUS (PIPERX5PHYSTATUS_IN, PIPERX5PHYSTATUS);
  buf B_PIPERX5STATUS0 (PIPERX5STATUS_IN[0], PIPERX5STATUS[0]);
  buf B_PIPERX5STATUS1 (PIPERX5STATUS_IN[1], PIPERX5STATUS[1]);
  buf B_PIPERX5STATUS2 (PIPERX5STATUS_IN[2], PIPERX5STATUS[2]);
  buf B_PIPERX5VALID (PIPERX5VALID_IN, PIPERX5VALID);
  buf B_PIPERX6CHANISALIGNED (PIPERX6CHANISALIGNED_IN, PIPERX6CHANISALIGNED);
  buf B_PIPERX6CHARISK0 (PIPERX6CHARISK_IN[0], PIPERX6CHARISK[0]);
  buf B_PIPERX6CHARISK1 (PIPERX6CHARISK_IN[1], PIPERX6CHARISK[1]);
  buf B_PIPERX6DATA0 (PIPERX6DATA_IN[0], PIPERX6DATA[0]);
  buf B_PIPERX6DATA1 (PIPERX6DATA_IN[1], PIPERX6DATA[1]);
  buf B_PIPERX6DATA10 (PIPERX6DATA_IN[10], PIPERX6DATA[10]);
  buf B_PIPERX6DATA11 (PIPERX6DATA_IN[11], PIPERX6DATA[11]);
  buf B_PIPERX6DATA12 (PIPERX6DATA_IN[12], PIPERX6DATA[12]);
  buf B_PIPERX6DATA13 (PIPERX6DATA_IN[13], PIPERX6DATA[13]);
  buf B_PIPERX6DATA14 (PIPERX6DATA_IN[14], PIPERX6DATA[14]);
  buf B_PIPERX6DATA15 (PIPERX6DATA_IN[15], PIPERX6DATA[15]);
  buf B_PIPERX6DATA2 (PIPERX6DATA_IN[2], PIPERX6DATA[2]);
  buf B_PIPERX6DATA3 (PIPERX6DATA_IN[3], PIPERX6DATA[3]);
  buf B_PIPERX6DATA4 (PIPERX6DATA_IN[4], PIPERX6DATA[4]);
  buf B_PIPERX6DATA5 (PIPERX6DATA_IN[5], PIPERX6DATA[5]);
  buf B_PIPERX6DATA6 (PIPERX6DATA_IN[6], PIPERX6DATA[6]);
  buf B_PIPERX6DATA7 (PIPERX6DATA_IN[7], PIPERX6DATA[7]);
  buf B_PIPERX6DATA8 (PIPERX6DATA_IN[8], PIPERX6DATA[8]);
  buf B_PIPERX6DATA9 (PIPERX6DATA_IN[9], PIPERX6DATA[9]);
  buf B_PIPERX6ELECIDLE (PIPERX6ELECIDLE_IN, PIPERX6ELECIDLE);
  buf B_PIPERX6PHYSTATUS (PIPERX6PHYSTATUS_IN, PIPERX6PHYSTATUS);
  buf B_PIPERX6STATUS0 (PIPERX6STATUS_IN[0], PIPERX6STATUS[0]);
  buf B_PIPERX6STATUS1 (PIPERX6STATUS_IN[1], PIPERX6STATUS[1]);
  buf B_PIPERX6STATUS2 (PIPERX6STATUS_IN[2], PIPERX6STATUS[2]);
  buf B_PIPERX6VALID (PIPERX6VALID_IN, PIPERX6VALID);
  buf B_PIPERX7CHANISALIGNED (PIPERX7CHANISALIGNED_IN, PIPERX7CHANISALIGNED);
  buf B_PIPERX7CHARISK0 (PIPERX7CHARISK_IN[0], PIPERX7CHARISK[0]);
  buf B_PIPERX7CHARISK1 (PIPERX7CHARISK_IN[1], PIPERX7CHARISK[1]);
  buf B_PIPERX7DATA0 (PIPERX7DATA_IN[0], PIPERX7DATA[0]);
  buf B_PIPERX7DATA1 (PIPERX7DATA_IN[1], PIPERX7DATA[1]);
  buf B_PIPERX7DATA10 (PIPERX7DATA_IN[10], PIPERX7DATA[10]);
  buf B_PIPERX7DATA11 (PIPERX7DATA_IN[11], PIPERX7DATA[11]);
  buf B_PIPERX7DATA12 (PIPERX7DATA_IN[12], PIPERX7DATA[12]);
  buf B_PIPERX7DATA13 (PIPERX7DATA_IN[13], PIPERX7DATA[13]);
  buf B_PIPERX7DATA14 (PIPERX7DATA_IN[14], PIPERX7DATA[14]);
  buf B_PIPERX7DATA15 (PIPERX7DATA_IN[15], PIPERX7DATA[15]);
  buf B_PIPERX7DATA2 (PIPERX7DATA_IN[2], PIPERX7DATA[2]);
  buf B_PIPERX7DATA3 (PIPERX7DATA_IN[3], PIPERX7DATA[3]);
  buf B_PIPERX7DATA4 (PIPERX7DATA_IN[4], PIPERX7DATA[4]);
  buf B_PIPERX7DATA5 (PIPERX7DATA_IN[5], PIPERX7DATA[5]);
  buf B_PIPERX7DATA6 (PIPERX7DATA_IN[6], PIPERX7DATA[6]);
  buf B_PIPERX7DATA7 (PIPERX7DATA_IN[7], PIPERX7DATA[7]);
  buf B_PIPERX7DATA8 (PIPERX7DATA_IN[8], PIPERX7DATA[8]);
  buf B_PIPERX7DATA9 (PIPERX7DATA_IN[9], PIPERX7DATA[9]);
  buf B_PIPERX7ELECIDLE (PIPERX7ELECIDLE_IN, PIPERX7ELECIDLE);
  buf B_PIPERX7PHYSTATUS (PIPERX7PHYSTATUS_IN, PIPERX7PHYSTATUS);
  buf B_PIPERX7STATUS0 (PIPERX7STATUS_IN[0], PIPERX7STATUS[0]);
  buf B_PIPERX7STATUS1 (PIPERX7STATUS_IN[1], PIPERX7STATUS[1]);
  buf B_PIPERX7STATUS2 (PIPERX7STATUS_IN[2], PIPERX7STATUS[2]);
  buf B_PIPERX7VALID (PIPERX7VALID_IN, PIPERX7VALID);
  buf B_PL2DIRECTEDLSTATE0 (PL2DIRECTEDLSTATE_IN[0], PL2DIRECTEDLSTATE[0]);
  buf B_PL2DIRECTEDLSTATE1 (PL2DIRECTEDLSTATE_IN[1], PL2DIRECTEDLSTATE[1]);
  buf B_PL2DIRECTEDLSTATE2 (PL2DIRECTEDLSTATE_IN[2], PL2DIRECTEDLSTATE[2]);
  buf B_PL2DIRECTEDLSTATE3 (PL2DIRECTEDLSTATE_IN[3], PL2DIRECTEDLSTATE[3]);
  buf B_PL2DIRECTEDLSTATE4 (PL2DIRECTEDLSTATE_IN[4], PL2DIRECTEDLSTATE[4]);
  buf B_PLDBGMODE0 (PLDBGMODE_IN[0], PLDBGMODE[0]);
  buf B_PLDBGMODE1 (PLDBGMODE_IN[1], PLDBGMODE[1]);
  buf B_PLDBGMODE2 (PLDBGMODE_IN[2], PLDBGMODE[2]);
  buf B_PLDIRECTEDLINKAUTON (PLDIRECTEDLINKAUTON_IN, PLDIRECTEDLINKAUTON);
  buf B_PLDIRECTEDLINKCHANGE0 (PLDIRECTEDLINKCHANGE_IN[0], PLDIRECTEDLINKCHANGE[0]);
  buf B_PLDIRECTEDLINKCHANGE1 (PLDIRECTEDLINKCHANGE_IN[1], PLDIRECTEDLINKCHANGE[1]);
  buf B_PLDIRECTEDLINKSPEED (PLDIRECTEDLINKSPEED_IN, PLDIRECTEDLINKSPEED);
  buf B_PLDIRECTEDLINKWIDTH0 (PLDIRECTEDLINKWIDTH_IN[0], PLDIRECTEDLINKWIDTH[0]);
  buf B_PLDIRECTEDLINKWIDTH1 (PLDIRECTEDLINKWIDTH_IN[1], PLDIRECTEDLINKWIDTH[1]);
  buf B_PLDOWNSTREAMDEEMPHSOURCE (PLDOWNSTREAMDEEMPHSOURCE_IN, PLDOWNSTREAMDEEMPHSOURCE);
  buf B_PLRSTN (PLRSTN_IN, PLRSTN);
  buf B_PLTRANSMITHOTRST (PLTRANSMITHOTRST_IN, PLTRANSMITHOTRST);
  buf B_PLUPSTREAMPREFERDEEMPH (PLUPSTREAMPREFERDEEMPH_IN, PLUPSTREAMPREFERDEEMPH);
  buf B_SYSRSTN (SYSRSTN_IN, SYSRSTN);
  buf B_TL2ASPMSUSPENDCREDITCHECKN (TL2ASPMSUSPENDCREDITCHECKN_IN, TL2ASPMSUSPENDCREDITCHECKN);
  buf B_TL2PPMSUSPENDREQN (TL2PPMSUSPENDREQN_IN, TL2PPMSUSPENDREQN);
  buf B_TLRSTN (TLRSTN_IN, TLRSTN);
  buf B_TRNFCSEL0 (TRNFCSEL_IN[0], TRNFCSEL[0]);
  buf B_TRNFCSEL1 (TRNFCSEL_IN[1], TRNFCSEL[1]);
  buf B_TRNFCSEL2 (TRNFCSEL_IN[2], TRNFCSEL[2]);
  buf B_TRNRDSTRDYN (TRNRDSTRDYN_IN, TRNRDSTRDYN);
  buf B_TRNRNPOKN (TRNRNPOKN_IN, TRNRNPOKN);
  buf B_TRNTCFGGNTN (TRNTCFGGNTN_IN, TRNTCFGGNTN);
  buf B_TRNTD0 (TRNTD_IN[0], TRNTD[0]);
  buf B_TRNTD1 (TRNTD_IN[1], TRNTD[1]);
  buf B_TRNTD10 (TRNTD_IN[10], TRNTD[10]);
  buf B_TRNTD11 (TRNTD_IN[11], TRNTD[11]);
  buf B_TRNTD12 (TRNTD_IN[12], TRNTD[12]);
  buf B_TRNTD13 (TRNTD_IN[13], TRNTD[13]);
  buf B_TRNTD14 (TRNTD_IN[14], TRNTD[14]);
  buf B_TRNTD15 (TRNTD_IN[15], TRNTD[15]);
  buf B_TRNTD16 (TRNTD_IN[16], TRNTD[16]);
  buf B_TRNTD17 (TRNTD_IN[17], TRNTD[17]);
  buf B_TRNTD18 (TRNTD_IN[18], TRNTD[18]);
  buf B_TRNTD19 (TRNTD_IN[19], TRNTD[19]);
  buf B_TRNTD2 (TRNTD_IN[2], TRNTD[2]);
  buf B_TRNTD20 (TRNTD_IN[20], TRNTD[20]);
  buf B_TRNTD21 (TRNTD_IN[21], TRNTD[21]);
  buf B_TRNTD22 (TRNTD_IN[22], TRNTD[22]);
  buf B_TRNTD23 (TRNTD_IN[23], TRNTD[23]);
  buf B_TRNTD24 (TRNTD_IN[24], TRNTD[24]);
  buf B_TRNTD25 (TRNTD_IN[25], TRNTD[25]);
  buf B_TRNTD26 (TRNTD_IN[26], TRNTD[26]);
  buf B_TRNTD27 (TRNTD_IN[27], TRNTD[27]);
  buf B_TRNTD28 (TRNTD_IN[28], TRNTD[28]);
  buf B_TRNTD29 (TRNTD_IN[29], TRNTD[29]);
  buf B_TRNTD3 (TRNTD_IN[3], TRNTD[3]);
  buf B_TRNTD30 (TRNTD_IN[30], TRNTD[30]);
  buf B_TRNTD31 (TRNTD_IN[31], TRNTD[31]);
  buf B_TRNTD32 (TRNTD_IN[32], TRNTD[32]);
  buf B_TRNTD33 (TRNTD_IN[33], TRNTD[33]);
  buf B_TRNTD34 (TRNTD_IN[34], TRNTD[34]);
  buf B_TRNTD35 (TRNTD_IN[35], TRNTD[35]);
  buf B_TRNTD36 (TRNTD_IN[36], TRNTD[36]);
  buf B_TRNTD37 (TRNTD_IN[37], TRNTD[37]);
  buf B_TRNTD38 (TRNTD_IN[38], TRNTD[38]);
  buf B_TRNTD39 (TRNTD_IN[39], TRNTD[39]);
  buf B_TRNTD4 (TRNTD_IN[4], TRNTD[4]);
  buf B_TRNTD40 (TRNTD_IN[40], TRNTD[40]);
  buf B_TRNTD41 (TRNTD_IN[41], TRNTD[41]);
  buf B_TRNTD42 (TRNTD_IN[42], TRNTD[42]);
  buf B_TRNTD43 (TRNTD_IN[43], TRNTD[43]);
  buf B_TRNTD44 (TRNTD_IN[44], TRNTD[44]);
  buf B_TRNTD45 (TRNTD_IN[45], TRNTD[45]);
  buf B_TRNTD46 (TRNTD_IN[46], TRNTD[46]);
  buf B_TRNTD47 (TRNTD_IN[47], TRNTD[47]);
  buf B_TRNTD48 (TRNTD_IN[48], TRNTD[48]);
  buf B_TRNTD49 (TRNTD_IN[49], TRNTD[49]);
  buf B_TRNTD5 (TRNTD_IN[5], TRNTD[5]);
  buf B_TRNTD50 (TRNTD_IN[50], TRNTD[50]);
  buf B_TRNTD51 (TRNTD_IN[51], TRNTD[51]);
  buf B_TRNTD52 (TRNTD_IN[52], TRNTD[52]);
  buf B_TRNTD53 (TRNTD_IN[53], TRNTD[53]);
  buf B_TRNTD54 (TRNTD_IN[54], TRNTD[54]);
  buf B_TRNTD55 (TRNTD_IN[55], TRNTD[55]);
  buf B_TRNTD56 (TRNTD_IN[56], TRNTD[56]);
  buf B_TRNTD57 (TRNTD_IN[57], TRNTD[57]);
  buf B_TRNTD58 (TRNTD_IN[58], TRNTD[58]);
  buf B_TRNTD59 (TRNTD_IN[59], TRNTD[59]);
  buf B_TRNTD6 (TRNTD_IN[6], TRNTD[6]);
  buf B_TRNTD60 (TRNTD_IN[60], TRNTD[60]);
  buf B_TRNTD61 (TRNTD_IN[61], TRNTD[61]);
  buf B_TRNTD62 (TRNTD_IN[62], TRNTD[62]);
  buf B_TRNTD63 (TRNTD_IN[63], TRNTD[63]);
  buf B_TRNTD7 (TRNTD_IN[7], TRNTD[7]);
  buf B_TRNTD8 (TRNTD_IN[8], TRNTD[8]);
  buf B_TRNTD9 (TRNTD_IN[9], TRNTD[9]);
  buf B_TRNTDLLPDATA0 (TRNTDLLPDATA_IN[0], TRNTDLLPDATA[0]);
  buf B_TRNTDLLPDATA1 (TRNTDLLPDATA_IN[1], TRNTDLLPDATA[1]);
  buf B_TRNTDLLPDATA10 (TRNTDLLPDATA_IN[10], TRNTDLLPDATA[10]);
  buf B_TRNTDLLPDATA11 (TRNTDLLPDATA_IN[11], TRNTDLLPDATA[11]);
  buf B_TRNTDLLPDATA12 (TRNTDLLPDATA_IN[12], TRNTDLLPDATA[12]);
  buf B_TRNTDLLPDATA13 (TRNTDLLPDATA_IN[13], TRNTDLLPDATA[13]);
  buf B_TRNTDLLPDATA14 (TRNTDLLPDATA_IN[14], TRNTDLLPDATA[14]);
  buf B_TRNTDLLPDATA15 (TRNTDLLPDATA_IN[15], TRNTDLLPDATA[15]);
  buf B_TRNTDLLPDATA16 (TRNTDLLPDATA_IN[16], TRNTDLLPDATA[16]);
  buf B_TRNTDLLPDATA17 (TRNTDLLPDATA_IN[17], TRNTDLLPDATA[17]);
  buf B_TRNTDLLPDATA18 (TRNTDLLPDATA_IN[18], TRNTDLLPDATA[18]);
  buf B_TRNTDLLPDATA19 (TRNTDLLPDATA_IN[19], TRNTDLLPDATA[19]);
  buf B_TRNTDLLPDATA2 (TRNTDLLPDATA_IN[2], TRNTDLLPDATA[2]);
  buf B_TRNTDLLPDATA20 (TRNTDLLPDATA_IN[20], TRNTDLLPDATA[20]);
  buf B_TRNTDLLPDATA21 (TRNTDLLPDATA_IN[21], TRNTDLLPDATA[21]);
  buf B_TRNTDLLPDATA22 (TRNTDLLPDATA_IN[22], TRNTDLLPDATA[22]);
  buf B_TRNTDLLPDATA23 (TRNTDLLPDATA_IN[23], TRNTDLLPDATA[23]);
  buf B_TRNTDLLPDATA24 (TRNTDLLPDATA_IN[24], TRNTDLLPDATA[24]);
  buf B_TRNTDLLPDATA25 (TRNTDLLPDATA_IN[25], TRNTDLLPDATA[25]);
  buf B_TRNTDLLPDATA26 (TRNTDLLPDATA_IN[26], TRNTDLLPDATA[26]);
  buf B_TRNTDLLPDATA27 (TRNTDLLPDATA_IN[27], TRNTDLLPDATA[27]);
  buf B_TRNTDLLPDATA28 (TRNTDLLPDATA_IN[28], TRNTDLLPDATA[28]);
  buf B_TRNTDLLPDATA29 (TRNTDLLPDATA_IN[29], TRNTDLLPDATA[29]);
  buf B_TRNTDLLPDATA3 (TRNTDLLPDATA_IN[3], TRNTDLLPDATA[3]);
  buf B_TRNTDLLPDATA30 (TRNTDLLPDATA_IN[30], TRNTDLLPDATA[30]);
  buf B_TRNTDLLPDATA31 (TRNTDLLPDATA_IN[31], TRNTDLLPDATA[31]);
  buf B_TRNTDLLPDATA4 (TRNTDLLPDATA_IN[4], TRNTDLLPDATA[4]);
  buf B_TRNTDLLPDATA5 (TRNTDLLPDATA_IN[5], TRNTDLLPDATA[5]);
  buf B_TRNTDLLPDATA6 (TRNTDLLPDATA_IN[6], TRNTDLLPDATA[6]);
  buf B_TRNTDLLPDATA7 (TRNTDLLPDATA_IN[7], TRNTDLLPDATA[7]);
  buf B_TRNTDLLPDATA8 (TRNTDLLPDATA_IN[8], TRNTDLLPDATA[8]);
  buf B_TRNTDLLPDATA9 (TRNTDLLPDATA_IN[9], TRNTDLLPDATA[9]);
  buf B_TRNTDLLPSRCRDYN (TRNTDLLPSRCRDYN_IN, TRNTDLLPSRCRDYN);
  buf B_TRNTECRCGENN (TRNTECRCGENN_IN, TRNTECRCGENN);
  buf B_TRNTEOFN (TRNTEOFN_IN, TRNTEOFN);
  buf B_TRNTERRFWDN (TRNTERRFWDN_IN, TRNTERRFWDN);
  buf B_TRNTREMN (TRNTREMN_IN, TRNTREMN);
  buf B_TRNTSOFN (TRNTSOFN_IN, TRNTSOFN);
  buf B_TRNTSRCDSCN (TRNTSRCDSCN_IN, TRNTSRCDSCN);
  buf B_TRNTSRCRDYN (TRNTSRCRDYN_IN, TRNTSRCRDYN);
  buf B_TRNTSTRN (TRNTSTRN_IN, TRNTSTRN);
  buf B_USERCLK (USERCLK_IN, USERCLK);

  wire [11:0] delay_DBGVECC;
  wire [11:0] delay_PLDBGVEC;
  wire [11:0] delay_TRNFCCPLD;
  wire [11:0] delay_TRNFCNPD;
  wire [11:0] delay_TRNFCPD;
  wire [12:0] delay_MIMRXRADDR;
  wire [12:0] delay_MIMRXWADDR;
  wire [12:0] delay_MIMTXRADDR;
  wire [12:0] delay_MIMTXWADDR;
  wire [15:0] delay_CFGMSGDATA;
  wire [15:0] delay_DRPDO;
  wire [15:0] delay_PIPETX0DATA;
  wire [15:0] delay_PIPETX1DATA;
  wire [15:0] delay_PIPETX2DATA;
  wire [15:0] delay_PIPETX3DATA;
  wire [15:0] delay_PIPETX4DATA;
  wire [15:0] delay_PIPETX5DATA;
  wire [15:0] delay_PIPETX6DATA;
  wire [15:0] delay_PIPETX7DATA;
  wire [1:0] delay_CFGLINKCONTROLASPMCONTROL;
  wire [1:0] delay_CFGLINKSTATUSCURRENTSPEED;
  wire [1:0] delay_CFGPMCSRPOWERSTATE;
  wire [1:0] delay_PIPETX0CHARISK;
  wire [1:0] delay_PIPETX0POWERDOWN;
  wire [1:0] delay_PIPETX1CHARISK;
  wire [1:0] delay_PIPETX1POWERDOWN;
  wire [1:0] delay_PIPETX2CHARISK;
  wire [1:0] delay_PIPETX2POWERDOWN;
  wire [1:0] delay_PIPETX3CHARISK;
  wire [1:0] delay_PIPETX3POWERDOWN;
  wire [1:0] delay_PIPETX4CHARISK;
  wire [1:0] delay_PIPETX4POWERDOWN;
  wire [1:0] delay_PIPETX5CHARISK;
  wire [1:0] delay_PIPETX5POWERDOWN;
  wire [1:0] delay_PIPETX6CHARISK;
  wire [1:0] delay_PIPETX6POWERDOWN;
  wire [1:0] delay_PIPETX7CHARISK;
  wire [1:0] delay_PIPETX7POWERDOWN;
  wire [1:0] delay_PLLANEREVERSALMODE;
  wire [1:0] delay_PLRXPMSTATE;
  wire [1:0] delay_PLSELLNKWIDTH;
  wire [2:0] delay_CFGDEVCONTROLMAXPAYLOAD;
  wire [2:0] delay_CFGDEVCONTROLMAXREADREQ;
  wire [2:0] delay_CFGINTERRUPTMMENABLE;
  wire [2:0] delay_CFGPCIELINKSTATE;
  wire [2:0] delay_PIPETXMARGIN;
  wire [2:0] delay_PLINITIALLINKWIDTH;
  wire [2:0] delay_PLTXPMSTATE;
  wire [31:0] delay_CFGDO;
  wire [31:0] delay_TRNRDLLPDATA;
  wire [3:0] delay_CFGDEVCONTROL2CPLTIMEOUTVAL;
  wire [3:0] delay_CFGLINKSTATUSNEGOTIATEDWIDTH;
  wire [5:0] delay_PLLTSSMSTATE;
  wire [5:0] delay_TRNTBUFAV;
  wire [63:0] delay_DBGVECA;
  wire [63:0] delay_DBGVECB;
  wire [63:0] delay_TRNRD;
  wire [67:0] delay_MIMRXWDATA;
  wire [68:0] delay_MIMTXWDATA;
  wire [6:0] delay_CFGTRANSACTIONADDR;
  wire [6:0] delay_CFGVCTCVCMAP;
  wire [6:0] delay_TRNRBARHITN;
  wire [7:0] delay_CFGINTERRUPTDO;
  wire [7:0] delay_TRNFCCPLH;
  wire [7:0] delay_TRNFCNPH;
  wire [7:0] delay_TRNFCPH;
  wire delay_CFGAERECRCCHECKEN;
  wire delay_CFGAERECRCGENEN;
  wire delay_CFGCOMMANDBUSMASTERENABLE;
  wire delay_CFGCOMMANDINTERRUPTDISABLE;
  wire delay_CFGCOMMANDIOENABLE;
  wire delay_CFGCOMMANDMEMENABLE;
  wire delay_CFGCOMMANDSERREN;
  wire delay_CFGDEVCONTROL2CPLTIMEOUTDIS;
  wire delay_CFGDEVCONTROLAUXPOWEREN;
  wire delay_CFGDEVCONTROLCORRERRREPORTINGEN;
  wire delay_CFGDEVCONTROLENABLERO;
  wire delay_CFGDEVCONTROLEXTTAGEN;
  wire delay_CFGDEVCONTROLFATALERRREPORTINGEN;
  wire delay_CFGDEVCONTROLNONFATALREPORTINGEN;
  wire delay_CFGDEVCONTROLNOSNOOPEN;
  wire delay_CFGDEVCONTROLPHANTOMEN;
  wire delay_CFGDEVCONTROLURERRREPORTINGEN;
  wire delay_CFGDEVSTATUSCORRERRDETECTED;
  wire delay_CFGDEVSTATUSFATALERRDETECTED;
  wire delay_CFGDEVSTATUSNONFATALERRDETECTED;
  wire delay_CFGDEVSTATUSURDETECTED;
  wire delay_CFGERRAERHEADERLOGSETN;
  wire delay_CFGERRCPLRDYN;
  wire delay_CFGINTERRUPTMSIENABLE;
  wire delay_CFGINTERRUPTMSIXENABLE;
  wire delay_CFGINTERRUPTMSIXFM;
  wire delay_CFGINTERRUPTRDYN;
  wire delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  wire delay_CFGLINKCONTROLBANDWIDTHINTEN;
  wire delay_CFGLINKCONTROLCLOCKPMEN;
  wire delay_CFGLINKCONTROLCOMMONCLOCK;
  wire delay_CFGLINKCONTROLEXTENDEDSYNC;
  wire delay_CFGLINKCONTROLHWAUTOWIDTHDIS;
  wire delay_CFGLINKCONTROLLINKDISABLE;
  wire delay_CFGLINKCONTROLRCB;
  wire delay_CFGLINKCONTROLRETRAINLINK;
  wire delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  wire delay_CFGLINKSTATUSBANDWITHSTATUS;
  wire delay_CFGLINKSTATUSDLLACTIVE;
  wire delay_CFGLINKSTATUSLINKTRAINING;
  wire delay_CFGMSGRECEIVED;
  wire delay_CFGMSGRECEIVEDASSERTINTA;
  wire delay_CFGMSGRECEIVEDASSERTINTB;
  wire delay_CFGMSGRECEIVEDASSERTINTC;
  wire delay_CFGMSGRECEIVEDASSERTINTD;
  wire delay_CFGMSGRECEIVEDDEASSERTINTA;
  wire delay_CFGMSGRECEIVEDDEASSERTINTB;
  wire delay_CFGMSGRECEIVEDDEASSERTINTC;
  wire delay_CFGMSGRECEIVEDDEASSERTINTD;
  wire delay_CFGMSGRECEIVEDERRCOR;
  wire delay_CFGMSGRECEIVEDERRFATAL;
  wire delay_CFGMSGRECEIVEDERRNONFATAL;
  wire delay_CFGMSGRECEIVEDPMASNAK;
  wire delay_CFGMSGRECEIVEDPMETO;
  wire delay_CFGMSGRECEIVEDPMETOACK;
  wire delay_CFGMSGRECEIVEDPMPME;
  wire delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  wire delay_CFGMSGRECEIVEDUNLOCK;
  wire delay_CFGPMCSRPMEEN;
  wire delay_CFGPMCSRPMESTATUS;
  wire delay_CFGPMRCVASREQL1N;
  wire delay_CFGPMRCVENTERL1N;
  wire delay_CFGPMRCVENTERL23N;
  wire delay_CFGPMRCVREQACKN;
  wire delay_CFGRDWRDONEN;
  wire delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  wire delay_CFGTRANSACTION;
  wire delay_CFGTRANSACTIONTYPE;
  wire delay_DBGSCLRA;
  wire delay_DBGSCLRB;
  wire delay_DBGSCLRC;
  wire delay_DBGSCLRD;
  wire delay_DBGSCLRE;
  wire delay_DBGSCLRF;
  wire delay_DBGSCLRG;
  wire delay_DBGSCLRH;
  wire delay_DBGSCLRI;
  wire delay_DBGSCLRJ;
  wire delay_DBGSCLRK;
  wire delay_DRPDRDY;
  wire delay_LL2BADDLLPERRN;
  wire delay_LL2BADTLPERRN;
  wire delay_LL2PROTOCOLERRN;
  wire delay_LL2REPLAYROERRN;
  wire delay_LL2REPLAYTOERRN;
  wire delay_LL2SUSPENDOKN;
  wire delay_LL2TFCINIT1SEQN;
  wire delay_LL2TFCINIT2SEQN;
  wire delay_LNKCLKEN;
  wire delay_MIMRXRCE;
  wire delay_MIMRXREN;
  wire delay_MIMRXWEN;
  wire delay_MIMTXRCE;
  wire delay_MIMTXREN;
  wire delay_MIMTXWEN;
  wire delay_PIPERX0POLARITY;
  wire delay_PIPERX1POLARITY;
  wire delay_PIPERX2POLARITY;
  wire delay_PIPERX3POLARITY;
  wire delay_PIPERX4POLARITY;
  wire delay_PIPERX5POLARITY;
  wire delay_PIPERX6POLARITY;
  wire delay_PIPERX7POLARITY;
  wire delay_PIPETX0COMPLIANCE;
  wire delay_PIPETX0ELECIDLE;
  wire delay_PIPETX1COMPLIANCE;
  wire delay_PIPETX1ELECIDLE;
  wire delay_PIPETX2COMPLIANCE;
  wire delay_PIPETX2ELECIDLE;
  wire delay_PIPETX3COMPLIANCE;
  wire delay_PIPETX3ELECIDLE;
  wire delay_PIPETX4COMPLIANCE;
  wire delay_PIPETX4ELECIDLE;
  wire delay_PIPETX5COMPLIANCE;
  wire delay_PIPETX5ELECIDLE;
  wire delay_PIPETX6COMPLIANCE;
  wire delay_PIPETX6ELECIDLE;
  wire delay_PIPETX7COMPLIANCE;
  wire delay_PIPETX7ELECIDLE;
  wire delay_PIPETXDEEMPH;
  wire delay_PIPETXRATE;
  wire delay_PIPETXRCVRDET;
  wire delay_PIPETXRESET;
  wire delay_PL2LINKUPN;
  wire delay_PL2RECEIVERERRN;
  wire delay_PL2RECOVERYN;
  wire delay_PL2RXELECIDLE;
  wire delay_PL2SUSPENDOK;
  wire delay_PLLINKGEN2CAP;
  wire delay_PLLINKPARTNERGEN2SUPPORTED;
  wire delay_PLLINKUPCFGCAP;
  wire delay_PLPHYLNKUPN;
  wire delay_PLRECEIVEDHOTRST;
  wire delay_PLSELLNKRATE;
  wire delay_RECEIVEDFUNCLVLRSTN;
  wire delay_TL2ASPMSUSPENDCREDITCHECKOKN;
  wire delay_TL2ASPMSUSPENDREQN;
  wire delay_TL2PPMSUSPENDOKN;
  wire delay_TRNLNKUPN;
  wire delay_TRNRDLLPSRCRDYN;
  wire delay_TRNRECRCERRN;
  wire delay_TRNREOFN;
  wire delay_TRNRERRFWDN;
  wire delay_TRNRREMN;
  wire delay_TRNRSOFN;
  wire delay_TRNRSRCDSCN;
  wire delay_TRNRSRCRDYN;
  wire delay_TRNTCFGREQN;
  wire delay_TRNTDLLPDSTRDYN;
  wire delay_TRNTDSTRDYN;
  wire delay_TRNTERRDROPN;
  wire delay_USERRSTN;

  wire [127:0] delay_CFGERRAERHEADERLOG;
  wire [15:0] delay_DRPDI;
  wire [15:0] delay_PIPERX0DATA;
  wire [15:0] delay_PIPERX1DATA;
  wire [15:0] delay_PIPERX2DATA;
  wire [15:0] delay_PIPERX3DATA;
  wire [15:0] delay_PIPERX4DATA;
  wire [15:0] delay_PIPERX5DATA;
  wire [15:0] delay_PIPERX6DATA;
  wire [15:0] delay_PIPERX7DATA;
  wire [1:0] delay_DBGMODE;
  wire [1:0] delay_PIPERX0CHARISK;
  wire [1:0] delay_PIPERX1CHARISK;
  wire [1:0] delay_PIPERX2CHARISK;
  wire [1:0] delay_PIPERX3CHARISK;
  wire [1:0] delay_PIPERX4CHARISK;
  wire [1:0] delay_PIPERX5CHARISK;
  wire [1:0] delay_PIPERX6CHARISK;
  wire [1:0] delay_PIPERX7CHARISK;
  wire [1:0] delay_PLDIRECTEDLINKCHANGE;
  wire [1:0] delay_PLDIRECTEDLINKWIDTH;
  wire [2:0] delay_CFGDSFUNCTIONNUMBER;
  wire [2:0] delay_PIPERX0STATUS;
  wire [2:0] delay_PIPERX1STATUS;
  wire [2:0] delay_PIPERX2STATUS;
  wire [2:0] delay_PIPERX3STATUS;
  wire [2:0] delay_PIPERX4STATUS;
  wire [2:0] delay_PIPERX5STATUS;
  wire [2:0] delay_PIPERX6STATUS;
  wire [2:0] delay_PIPERX7STATUS;
  wire [2:0] delay_PLDBGMODE;
  wire [2:0] delay_TRNFCSEL;
  wire [31:0] delay_CFGDI;
  wire [31:0] delay_TRNTDLLPDATA;
  wire [3:0] delay_CFGBYTEENN;
  wire [47:0] delay_CFGERRTLPCPLHEADER;
  wire [4:0] delay_CFGDSDEVICENUMBER;
  wire [4:0] delay_PL2DIRECTEDLSTATE;
  wire [63:0] delay_CFGDSN;
  wire [63:0] delay_TRNTD;
  wire [67:0] delay_MIMRXRDATA;
  wire [68:0] delay_MIMTXRDATA;
  wire [7:0] delay_CFGDSBUSNUMBER;
  wire [7:0] delay_CFGINTERRUPTDI;
  wire [7:0] delay_CFGPORTNUMBER;
  wire [8:0] delay_DRPDADDR;
  wire [9:0] delay_CFGDWADDR;
  wire delay_CFGERRACSN;
  wire delay_CFGERRCORN;
  wire delay_CFGERRCPLABORTN;
  wire delay_CFGERRCPLTIMEOUTN;
  wire delay_CFGERRCPLUNEXPECTN;
  wire delay_CFGERRECRCN;
  wire delay_CFGERRLOCKEDN;
  wire delay_CFGERRPOSTEDN;
  wire delay_CFGERRURN;
  wire delay_CFGINTERRUPTASSERTN;
  wire delay_CFGINTERRUPTN;
  wire delay_CFGPMDIRECTASPML1N;
  wire delay_CFGPMSENDPMACKN;
  wire delay_CFGPMSENDPMETON;
  wire delay_CFGPMSENDPMNAKN;
  wire delay_CFGPMTURNOFFOKN;
  wire delay_CFGPMWAKEN;
  wire delay_CFGRDENN;
  wire delay_CFGTRNPENDINGN;
  wire delay_CFGWRENN;
  wire delay_CFGWRREADONLYN;
  wire delay_CFGWRRW1CASRWN;
  wire delay_CMRSTN;
  wire delay_CMSTICKYRSTN;
  wire delay_DBGSUBMODE;
  wire delay_DLRSTN;
  wire delay_DRPCLK;
  wire delay_DRPDEN;
  wire delay_DRPDWE;
  wire delay_FUNCLVLRSTN;
  wire delay_LL2SENDASREQL1N;
  wire delay_LL2SENDENTERL1N;
  wire delay_LL2SENDENTERL23N;
  wire delay_LL2SUSPENDNOWN;
  wire delay_LL2TLPRCVN;
  wire delay_PIPECLK;
  wire delay_PIPERX0CHANISALIGNED;
  wire delay_PIPERX0ELECIDLE;
  wire delay_PIPERX0PHYSTATUS;
  wire delay_PIPERX0VALID;
  wire delay_PIPERX1CHANISALIGNED;
  wire delay_PIPERX1ELECIDLE;
  wire delay_PIPERX1PHYSTATUS;
  wire delay_PIPERX1VALID;
  wire delay_PIPERX2CHANISALIGNED;
  wire delay_PIPERX2ELECIDLE;
  wire delay_PIPERX2PHYSTATUS;
  wire delay_PIPERX2VALID;
  wire delay_PIPERX3CHANISALIGNED;
  wire delay_PIPERX3ELECIDLE;
  wire delay_PIPERX3PHYSTATUS;
  wire delay_PIPERX3VALID;
  wire delay_PIPERX4CHANISALIGNED;
  wire delay_PIPERX4ELECIDLE;
  wire delay_PIPERX4PHYSTATUS;
  wire delay_PIPERX4VALID;
  wire delay_PIPERX5CHANISALIGNED;
  wire delay_PIPERX5ELECIDLE;
  wire delay_PIPERX5PHYSTATUS;
  wire delay_PIPERX5VALID;
  wire delay_PIPERX6CHANISALIGNED;
  wire delay_PIPERX6ELECIDLE;
  wire delay_PIPERX6PHYSTATUS;
  wire delay_PIPERX6VALID;
  wire delay_PIPERX7CHANISALIGNED;
  wire delay_PIPERX7ELECIDLE;
  wire delay_PIPERX7PHYSTATUS;
  wire delay_PIPERX7VALID;
  wire delay_PLDIRECTEDLINKAUTON;
  wire delay_PLDIRECTEDLINKSPEED;
  wire delay_PLDOWNSTREAMDEEMPHSOURCE;
  wire delay_PLRSTN;
  wire delay_PLTRANSMITHOTRST;
  wire delay_PLUPSTREAMPREFERDEEMPH;
  wire delay_SYSRSTN;
  wire delay_TL2ASPMSUSPENDCREDITCHECKN;
  wire delay_TL2PPMSUSPENDREQN;
  wire delay_TLRSTN;
  wire delay_TRNRDSTRDYN;
  wire delay_TRNRNPOKN;
  wire delay_TRNTCFGGNTN;
  wire delay_TRNTDLLPSRCRDYN;
  wire delay_TRNTECRCGENN;
  wire delay_TRNTEOFN;
  wire delay_TRNTERRFWDN;
  wire delay_TRNTREMN;
  wire delay_TRNTSOFN;
  wire delay_TRNTSRCDSCN;
  wire delay_TRNTSRCRDYN;
  wire delay_TRNTSTRN;
  wire delay_USERCLK;


  assign #(out_delay) CFGAERECRCCHECKEN_OUT = delay_CFGAERECRCCHECKEN;
  assign #(out_delay) CFGAERECRCGENEN_OUT = delay_CFGAERECRCGENEN;
  assign #(out_delay) CFGCOMMANDBUSMASTERENABLE_OUT = delay_CFGCOMMANDBUSMASTERENABLE;
  assign #(out_delay) CFGCOMMANDINTERRUPTDISABLE_OUT = delay_CFGCOMMANDINTERRUPTDISABLE;
  assign #(out_delay) CFGCOMMANDIOENABLE_OUT = delay_CFGCOMMANDIOENABLE;
  assign #(out_delay) CFGCOMMANDMEMENABLE_OUT = delay_CFGCOMMANDMEMENABLE;
  assign #(out_delay) CFGCOMMANDSERREN_OUT = delay_CFGCOMMANDSERREN;
  assign #(out_delay) CFGDEVCONTROL2CPLTIMEOUTDIS_OUT = delay_CFGDEVCONTROL2CPLTIMEOUTDIS;
  assign #(out_delay) CFGDEVCONTROL2CPLTIMEOUTVAL_OUT = delay_CFGDEVCONTROL2CPLTIMEOUTVAL;
  assign #(out_delay) CFGDEVCONTROLAUXPOWEREN_OUT = delay_CFGDEVCONTROLAUXPOWEREN;
  assign #(out_delay) CFGDEVCONTROLCORRERRREPORTINGEN_OUT = delay_CFGDEVCONTROLCORRERRREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLENABLERO_OUT = delay_CFGDEVCONTROLENABLERO;
  assign #(out_delay) CFGDEVCONTROLEXTTAGEN_OUT = delay_CFGDEVCONTROLEXTTAGEN;
  assign #(out_delay) CFGDEVCONTROLFATALERRREPORTINGEN_OUT = delay_CFGDEVCONTROLFATALERRREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLMAXPAYLOAD_OUT = delay_CFGDEVCONTROLMAXPAYLOAD;
  assign #(out_delay) CFGDEVCONTROLMAXREADREQ_OUT = delay_CFGDEVCONTROLMAXREADREQ;
  assign #(out_delay) CFGDEVCONTROLNONFATALREPORTINGEN_OUT = delay_CFGDEVCONTROLNONFATALREPORTINGEN;
  assign #(out_delay) CFGDEVCONTROLNOSNOOPEN_OUT = delay_CFGDEVCONTROLNOSNOOPEN;
  assign #(out_delay) CFGDEVCONTROLPHANTOMEN_OUT = delay_CFGDEVCONTROLPHANTOMEN;
  assign #(out_delay) CFGDEVCONTROLURERRREPORTINGEN_OUT = delay_CFGDEVCONTROLURERRREPORTINGEN;
  assign #(out_delay) CFGDEVSTATUSCORRERRDETECTED_OUT = delay_CFGDEVSTATUSCORRERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSFATALERRDETECTED_OUT = delay_CFGDEVSTATUSFATALERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSNONFATALERRDETECTED_OUT = delay_CFGDEVSTATUSNONFATALERRDETECTED;
  assign #(out_delay) CFGDEVSTATUSURDETECTED_OUT = delay_CFGDEVSTATUSURDETECTED;
  assign #(out_delay) CFGDO_OUT = delay_CFGDO;
  assign #(out_delay) CFGERRAERHEADERLOGSETN_OUT = delay_CFGERRAERHEADERLOGSETN;
  assign #(out_delay) CFGERRCPLRDYN_OUT = delay_CFGERRCPLRDYN;
  assign #(out_delay) CFGINTERRUPTDO_OUT = delay_CFGINTERRUPTDO;
  assign #(out_delay) CFGINTERRUPTMMENABLE_OUT = delay_CFGINTERRUPTMMENABLE;
  assign #(out_delay) CFGINTERRUPTMSIENABLE_OUT = delay_CFGINTERRUPTMSIENABLE;
  assign #(out_delay) CFGINTERRUPTMSIXENABLE_OUT = delay_CFGINTERRUPTMSIXENABLE;
  assign #(out_delay) CFGINTERRUPTMSIXFM_OUT = delay_CFGINTERRUPTMSIXFM;
  assign #(out_delay) CFGINTERRUPTRDYN_OUT = delay_CFGINTERRUPTRDYN;
  assign #(out_delay) CFGLINKCONTROLASPMCONTROL_OUT = delay_CFGLINKCONTROLASPMCONTROL;
  assign #(out_delay) CFGLINKCONTROLAUTOBANDWIDTHINTEN_OUT = delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN;
  assign #(out_delay) CFGLINKCONTROLBANDWIDTHINTEN_OUT = delay_CFGLINKCONTROLBANDWIDTHINTEN;
  assign #(out_delay) CFGLINKCONTROLCLOCKPMEN_OUT = delay_CFGLINKCONTROLCLOCKPMEN;
  assign #(out_delay) CFGLINKCONTROLCOMMONCLOCK_OUT = delay_CFGLINKCONTROLCOMMONCLOCK;
  assign #(out_delay) CFGLINKCONTROLEXTENDEDSYNC_OUT = delay_CFGLINKCONTROLEXTENDEDSYNC;
  assign #(out_delay) CFGLINKCONTROLHWAUTOWIDTHDIS_OUT = delay_CFGLINKCONTROLHWAUTOWIDTHDIS;
  assign #(out_delay) CFGLINKCONTROLLINKDISABLE_OUT = delay_CFGLINKCONTROLLINKDISABLE;
  assign #(out_delay) CFGLINKCONTROLRCB_OUT = delay_CFGLINKCONTROLRCB;
  assign #(out_delay) CFGLINKCONTROLRETRAINLINK_OUT = delay_CFGLINKCONTROLRETRAINLINK;
  assign #(out_delay) CFGLINKSTATUSAUTOBANDWIDTHSTATUS_OUT = delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS;
  assign #(out_delay) CFGLINKSTATUSBANDWITHSTATUS_OUT = delay_CFGLINKSTATUSBANDWITHSTATUS;
  assign #(out_delay) CFGLINKSTATUSCURRENTSPEED_OUT = delay_CFGLINKSTATUSCURRENTSPEED;
  assign #(out_delay) CFGLINKSTATUSDLLACTIVE_OUT = delay_CFGLINKSTATUSDLLACTIVE;
  assign #(out_delay) CFGLINKSTATUSLINKTRAINING_OUT = delay_CFGLINKSTATUSLINKTRAINING;
  assign #(out_delay) CFGLINKSTATUSNEGOTIATEDWIDTH_OUT = delay_CFGLINKSTATUSNEGOTIATEDWIDTH;
  assign #(out_delay) CFGMSGDATA_OUT = delay_CFGMSGDATA;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTA_OUT = delay_CFGMSGRECEIVEDASSERTINTA;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTB_OUT = delay_CFGMSGRECEIVEDASSERTINTB;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTC_OUT = delay_CFGMSGRECEIVEDASSERTINTC;
  assign #(out_delay) CFGMSGRECEIVEDASSERTINTD_OUT = delay_CFGMSGRECEIVEDASSERTINTD;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTA_OUT = delay_CFGMSGRECEIVEDDEASSERTINTA;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTB_OUT = delay_CFGMSGRECEIVEDDEASSERTINTB;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTC_OUT = delay_CFGMSGRECEIVEDDEASSERTINTC;
  assign #(out_delay) CFGMSGRECEIVEDDEASSERTINTD_OUT = delay_CFGMSGRECEIVEDDEASSERTINTD;
  assign #(out_delay) CFGMSGRECEIVEDERRCOR_OUT = delay_CFGMSGRECEIVEDERRCOR;
  assign #(out_delay) CFGMSGRECEIVEDERRFATAL_OUT = delay_CFGMSGRECEIVEDERRFATAL;
  assign #(out_delay) CFGMSGRECEIVEDERRNONFATAL_OUT = delay_CFGMSGRECEIVEDERRNONFATAL;
  assign #(out_delay) CFGMSGRECEIVEDPMASNAK_OUT = delay_CFGMSGRECEIVEDPMASNAK;
  assign #(out_delay) CFGMSGRECEIVEDPMETOACK_OUT = delay_CFGMSGRECEIVEDPMETOACK;
  assign #(out_delay) CFGMSGRECEIVEDPMETO_OUT = delay_CFGMSGRECEIVEDPMETO;
  assign #(out_delay) CFGMSGRECEIVEDPMPME_OUT = delay_CFGMSGRECEIVEDPMPME;
  assign #(out_delay) CFGMSGRECEIVEDSETSLOTPOWERLIMIT_OUT = delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT;
  assign #(out_delay) CFGMSGRECEIVEDUNLOCK_OUT = delay_CFGMSGRECEIVEDUNLOCK;
  assign #(out_delay) CFGMSGRECEIVED_OUT = delay_CFGMSGRECEIVED;
  assign #(out_delay) CFGPCIELINKSTATE_OUT = delay_CFGPCIELINKSTATE;
  assign #(out_delay) CFGPMCSRPMEEN_OUT = delay_CFGPMCSRPMEEN;
  assign #(out_delay) CFGPMCSRPMESTATUS_OUT = delay_CFGPMCSRPMESTATUS;
  assign #(out_delay) CFGPMCSRPOWERSTATE_OUT = delay_CFGPMCSRPOWERSTATE;
  assign #(out_delay) CFGPMRCVASREQL1N_OUT = delay_CFGPMRCVASREQL1N;
  assign #(out_delay) CFGPMRCVENTERL1N_OUT = delay_CFGPMRCVENTERL1N;
  assign #(out_delay) CFGPMRCVENTERL23N_OUT = delay_CFGPMRCVENTERL23N;
  assign #(out_delay) CFGPMRCVREQACKN_OUT = delay_CFGPMRCVREQACKN;
  assign #(out_delay) CFGRDWRDONEN_OUT = delay_CFGRDWRDONEN;
  assign #(out_delay) CFGSLOTCONTROLELECTROMECHILCTLPULSE_OUT = delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE;
  assign #(out_delay) CFGTRANSACTIONADDR_OUT = delay_CFGTRANSACTIONADDR;
  assign #(out_delay) CFGTRANSACTIONTYPE_OUT = delay_CFGTRANSACTIONTYPE;
  assign #(out_delay) CFGTRANSACTION_OUT = delay_CFGTRANSACTION;
  assign #(out_delay) CFGVCTCVCMAP_OUT = delay_CFGVCTCVCMAP;
  assign #(out_delay) DBGSCLRA_OUT = delay_DBGSCLRA;
  assign #(out_delay) DBGSCLRB_OUT = delay_DBGSCLRB;
  assign #(out_delay) DBGSCLRC_OUT = delay_DBGSCLRC;
  assign #(out_delay) DBGSCLRD_OUT = delay_DBGSCLRD;
  assign #(out_delay) DBGSCLRE_OUT = delay_DBGSCLRE;
  assign #(out_delay) DBGSCLRF_OUT = delay_DBGSCLRF;
  assign #(out_delay) DBGSCLRG_OUT = delay_DBGSCLRG;
  assign #(out_delay) DBGSCLRH_OUT = delay_DBGSCLRH;
  assign #(out_delay) DBGSCLRI_OUT = delay_DBGSCLRI;
  assign #(out_delay) DBGSCLRJ_OUT = delay_DBGSCLRJ;
  assign #(out_delay) DBGSCLRK_OUT = delay_DBGSCLRK;
  assign #(out_delay) DBGVECA_OUT = delay_DBGVECA;
  assign #(out_delay) DBGVECB_OUT = delay_DBGVECB;
  assign #(out_delay) DBGVECC_OUT = delay_DBGVECC;
  assign #(out_delay) DRPDO_OUT = delay_DRPDO;
  assign #(out_delay) DRPDRDY_OUT = delay_DRPDRDY;
  assign #(out_delay) LL2BADDLLPERRN_OUT = delay_LL2BADDLLPERRN;
  assign #(out_delay) LL2BADTLPERRN_OUT = delay_LL2BADTLPERRN;
  assign #(out_delay) LL2PROTOCOLERRN_OUT = delay_LL2PROTOCOLERRN;
  assign #(out_delay) LL2REPLAYROERRN_OUT = delay_LL2REPLAYROERRN;
  assign #(out_delay) LL2REPLAYTOERRN_OUT = delay_LL2REPLAYTOERRN;
  assign #(out_delay) LL2SUSPENDOKN_OUT = delay_LL2SUSPENDOKN;
  assign #(out_delay) LL2TFCINIT1SEQN_OUT = delay_LL2TFCINIT1SEQN;
  assign #(out_delay) LL2TFCINIT2SEQN_OUT = delay_LL2TFCINIT2SEQN;
  assign #(out_delay) LNKCLKEN_OUT = delay_LNKCLKEN;
  assign #(out_delay) MIMRXRADDR_OUT = delay_MIMRXRADDR;
  assign #(out_delay) MIMRXRCE_OUT = delay_MIMRXRCE;
  assign #(out_delay) MIMRXREN_OUT = delay_MIMRXREN;
  assign #(out_delay) MIMRXWADDR_OUT = delay_MIMRXWADDR;
  assign #(out_delay) MIMRXWDATA_OUT = delay_MIMRXWDATA;
  assign #(out_delay) MIMRXWEN_OUT = delay_MIMRXWEN;
  assign #(out_delay) MIMTXRADDR_OUT = delay_MIMTXRADDR;
  assign #(out_delay) MIMTXRCE_OUT = delay_MIMTXRCE;
  assign #(out_delay) MIMTXREN_OUT = delay_MIMTXREN;
  assign #(out_delay) MIMTXWADDR_OUT = delay_MIMTXWADDR;
  assign #(out_delay) MIMTXWDATA_OUT = delay_MIMTXWDATA;
  assign #(out_delay) MIMTXWEN_OUT = delay_MIMTXWEN;
  assign #(out_delay) PIPERX0POLARITY_OUT = delay_PIPERX0POLARITY;
  assign #(out_delay) PIPERX1POLARITY_OUT = delay_PIPERX1POLARITY;
  assign #(out_delay) PIPERX2POLARITY_OUT = delay_PIPERX2POLARITY;
  assign #(out_delay) PIPERX3POLARITY_OUT = delay_PIPERX3POLARITY;
  assign #(out_delay) PIPERX4POLARITY_OUT = delay_PIPERX4POLARITY;
  assign #(out_delay) PIPERX5POLARITY_OUT = delay_PIPERX5POLARITY;
  assign #(out_delay) PIPERX6POLARITY_OUT = delay_PIPERX6POLARITY;
  assign #(out_delay) PIPERX7POLARITY_OUT = delay_PIPERX7POLARITY;
  assign #(out_delay) PIPETX0CHARISK_OUT = delay_PIPETX0CHARISK;
  assign #(out_delay) PIPETX0COMPLIANCE_OUT = delay_PIPETX0COMPLIANCE;
  assign #(out_delay) PIPETX0DATA_OUT = delay_PIPETX0DATA;
  assign #(out_delay) PIPETX0ELECIDLE_OUT = delay_PIPETX0ELECIDLE;
  assign #(out_delay) PIPETX0POWERDOWN_OUT = delay_PIPETX0POWERDOWN;
  assign #(out_delay) PIPETX1CHARISK_OUT = delay_PIPETX1CHARISK;
  assign #(out_delay) PIPETX1COMPLIANCE_OUT = delay_PIPETX1COMPLIANCE;
  assign #(out_delay) PIPETX1DATA_OUT = delay_PIPETX1DATA;
  assign #(out_delay) PIPETX1ELECIDLE_OUT = delay_PIPETX1ELECIDLE;
  assign #(out_delay) PIPETX1POWERDOWN_OUT = delay_PIPETX1POWERDOWN;
  assign #(out_delay) PIPETX2CHARISK_OUT = delay_PIPETX2CHARISK;
  assign #(out_delay) PIPETX2COMPLIANCE_OUT = delay_PIPETX2COMPLIANCE;
  assign #(out_delay) PIPETX2DATA_OUT = delay_PIPETX2DATA;
  assign #(out_delay) PIPETX2ELECIDLE_OUT = delay_PIPETX2ELECIDLE;
  assign #(out_delay) PIPETX2POWERDOWN_OUT = delay_PIPETX2POWERDOWN;
  assign #(out_delay) PIPETX3CHARISK_OUT = delay_PIPETX3CHARISK;
  assign #(out_delay) PIPETX3COMPLIANCE_OUT = delay_PIPETX3COMPLIANCE;
  assign #(out_delay) PIPETX3DATA_OUT = delay_PIPETX3DATA;
  assign #(out_delay) PIPETX3ELECIDLE_OUT = delay_PIPETX3ELECIDLE;
  assign #(out_delay) PIPETX3POWERDOWN_OUT = delay_PIPETX3POWERDOWN;
  assign #(out_delay) PIPETX4CHARISK_OUT = delay_PIPETX4CHARISK;
  assign #(out_delay) PIPETX4COMPLIANCE_OUT = delay_PIPETX4COMPLIANCE;
  assign #(out_delay) PIPETX4DATA_OUT = delay_PIPETX4DATA;
  assign #(out_delay) PIPETX4ELECIDLE_OUT = delay_PIPETX4ELECIDLE;
  assign #(out_delay) PIPETX4POWERDOWN_OUT = delay_PIPETX4POWERDOWN;
  assign #(out_delay) PIPETX5CHARISK_OUT = delay_PIPETX5CHARISK;
  assign #(out_delay) PIPETX5COMPLIANCE_OUT = delay_PIPETX5COMPLIANCE;
  assign #(out_delay) PIPETX5DATA_OUT = delay_PIPETX5DATA;
  assign #(out_delay) PIPETX5ELECIDLE_OUT = delay_PIPETX5ELECIDLE;
  assign #(out_delay) PIPETX5POWERDOWN_OUT = delay_PIPETX5POWERDOWN;
  assign #(out_delay) PIPETX6CHARISK_OUT = delay_PIPETX6CHARISK;
  assign #(out_delay) PIPETX6COMPLIANCE_OUT = delay_PIPETX6COMPLIANCE;
  assign #(out_delay) PIPETX6DATA_OUT = delay_PIPETX6DATA;
  assign #(out_delay) PIPETX6ELECIDLE_OUT = delay_PIPETX6ELECIDLE;
  assign #(out_delay) PIPETX6POWERDOWN_OUT = delay_PIPETX6POWERDOWN;
  assign #(out_delay) PIPETX7CHARISK_OUT = delay_PIPETX7CHARISK;
  assign #(out_delay) PIPETX7COMPLIANCE_OUT = delay_PIPETX7COMPLIANCE;
  assign #(out_delay) PIPETX7DATA_OUT = delay_PIPETX7DATA;
  assign #(out_delay) PIPETX7ELECIDLE_OUT = delay_PIPETX7ELECIDLE;
  assign #(out_delay) PIPETX7POWERDOWN_OUT = delay_PIPETX7POWERDOWN;
  assign #(out_delay) PIPETXDEEMPH_OUT = delay_PIPETXDEEMPH;
  assign #(out_delay) PIPETXMARGIN_OUT = delay_PIPETXMARGIN;
  assign #(out_delay) PIPETXRATE_OUT = delay_PIPETXRATE;
  assign #(out_delay) PIPETXRCVRDET_OUT = delay_PIPETXRCVRDET;
  assign #(out_delay) PIPETXRESET_OUT = delay_PIPETXRESET;
  assign #(out_delay) PL2LINKUPN_OUT = delay_PL2LINKUPN;
  assign #(out_delay) PL2RECEIVERERRN_OUT = delay_PL2RECEIVERERRN;
  assign #(out_delay) PL2RECOVERYN_OUT = delay_PL2RECOVERYN;
  assign #(out_delay) PL2RXELECIDLE_OUT = delay_PL2RXELECIDLE;
  assign #(out_delay) PL2SUSPENDOK_OUT = delay_PL2SUSPENDOK;
  assign #(out_delay) PLDBGVEC_OUT = delay_PLDBGVEC;
  assign #(out_delay) PLINITIALLINKWIDTH_OUT = delay_PLINITIALLINKWIDTH;
  assign #(out_delay) PLLANEREVERSALMODE_OUT = delay_PLLANEREVERSALMODE;
  assign #(out_delay) PLLINKGEN2CAP_OUT = delay_PLLINKGEN2CAP;
  assign #(out_delay) PLLINKPARTNERGEN2SUPPORTED_OUT = delay_PLLINKPARTNERGEN2SUPPORTED;
  assign #(out_delay) PLLINKUPCFGCAP_OUT = delay_PLLINKUPCFGCAP;
  assign #(out_delay) PLLTSSMSTATE_OUT = delay_PLLTSSMSTATE;
  assign #(out_delay) PLPHYLNKUPN_OUT = delay_PLPHYLNKUPN;
  assign #(out_delay) PLRECEIVEDHOTRST_OUT = delay_PLRECEIVEDHOTRST;
  assign #(out_delay) PLRXPMSTATE_OUT = delay_PLRXPMSTATE;
  assign #(out_delay) PLSELLNKRATE_OUT = delay_PLSELLNKRATE;
  assign #(out_delay) PLSELLNKWIDTH_OUT = delay_PLSELLNKWIDTH;
  assign #(out_delay) PLTXPMSTATE_OUT = delay_PLTXPMSTATE;
  assign #(out_delay) RECEIVEDFUNCLVLRSTN_OUT = delay_RECEIVEDFUNCLVLRSTN;
  assign #(out_delay) TL2ASPMSUSPENDCREDITCHECKOKN_OUT = delay_TL2ASPMSUSPENDCREDITCHECKOKN;
  assign #(out_delay) TL2ASPMSUSPENDREQN_OUT = delay_TL2ASPMSUSPENDREQN;
  assign #(out_delay) TL2PPMSUSPENDOKN_OUT = delay_TL2PPMSUSPENDOKN;
  assign #(out_delay) TRNFCCPLD_OUT = delay_TRNFCCPLD;
  assign #(out_delay) TRNFCCPLH_OUT = delay_TRNFCCPLH;
  assign #(out_delay) TRNFCNPD_OUT = delay_TRNFCNPD;
  assign #(out_delay) TRNFCNPH_OUT = delay_TRNFCNPH;
  assign #(out_delay) TRNFCPD_OUT = delay_TRNFCPD;
  assign #(out_delay) TRNFCPH_OUT = delay_TRNFCPH;
  assign #(out_delay) TRNLNKUPN_OUT = delay_TRNLNKUPN;
  assign #(out_delay) TRNRBARHITN_OUT = delay_TRNRBARHITN;
  assign #(out_delay) TRNRDLLPDATA_OUT = delay_TRNRDLLPDATA;
  assign #(out_delay) TRNRDLLPSRCRDYN_OUT = delay_TRNRDLLPSRCRDYN;
  assign #(out_delay) TRNRD_OUT = delay_TRNRD;
  assign #(out_delay) TRNRECRCERRN_OUT = delay_TRNRECRCERRN;
  assign #(out_delay) TRNREOFN_OUT = delay_TRNREOFN;
  assign #(out_delay) TRNRERRFWDN_OUT = delay_TRNRERRFWDN;
  assign #(out_delay) TRNRREMN_OUT = delay_TRNRREMN;
  assign #(out_delay) TRNRSOFN_OUT = delay_TRNRSOFN;
  assign #(out_delay) TRNRSRCDSCN_OUT = delay_TRNRSRCDSCN;
  assign #(out_delay) TRNRSRCRDYN_OUT = delay_TRNRSRCRDYN;
  assign #(out_delay) TRNTBUFAV_OUT = delay_TRNTBUFAV;
  assign #(out_delay) TRNTCFGREQN_OUT = delay_TRNTCFGREQN;
  assign #(out_delay) TRNTDLLPDSTRDYN_OUT = delay_TRNTDLLPDSTRDYN;
  assign #(out_delay) TRNTDSTRDYN_OUT = delay_TRNTDSTRDYN;
  assign #(out_delay) TRNTERRDROPN_OUT = delay_TRNTERRDROPN;
  assign #(out_delay) USERRSTN_OUT = delay_USERRSTN;

  assign #(INCLK_DELAY) DRPCLK_INDELAY = DRPCLK_IN;
  assign #(INCLK_DELAY) PIPECLK_INDELAY = PIPECLK_IN;
  assign #(INCLK_DELAY) USERCLK_INDELAY = USERCLK_IN;

  assign #(in_delay) CFGBYTEENN_INDELAY = CFGBYTEENN_IN;
  assign #(in_delay) CFGDI_INDELAY = CFGDI_IN;
  assign #(in_delay) CFGDSBUSNUMBER_INDELAY = CFGDSBUSNUMBER_IN;
  assign #(in_delay) CFGDSDEVICENUMBER_INDELAY = CFGDSDEVICENUMBER_IN;
  assign #(in_delay) CFGDSFUNCTIONNUMBER_INDELAY = CFGDSFUNCTIONNUMBER_IN;
  assign #(in_delay) CFGDSN_INDELAY = CFGDSN_IN;
  assign #(in_delay) CFGDWADDR_INDELAY = CFGDWADDR_IN;
  assign #(in_delay) CFGERRACSN_INDELAY = CFGERRACSN_IN;
  assign #(in_delay) CFGERRAERHEADERLOG_INDELAY = CFGERRAERHEADERLOG_IN;
  assign #(in_delay) CFGERRCORN_INDELAY = CFGERRCORN_IN;
  assign #(in_delay) CFGERRCPLABORTN_INDELAY = CFGERRCPLABORTN_IN;
  assign #(in_delay) CFGERRCPLTIMEOUTN_INDELAY = CFGERRCPLTIMEOUTN_IN;
  assign #(in_delay) CFGERRCPLUNEXPECTN_INDELAY = CFGERRCPLUNEXPECTN_IN;
  assign #(in_delay) CFGERRECRCN_INDELAY = CFGERRECRCN_IN;
  assign #(in_delay) CFGERRLOCKEDN_INDELAY = CFGERRLOCKEDN_IN;
  assign #(in_delay) CFGERRPOSTEDN_INDELAY = CFGERRPOSTEDN_IN;
  assign #(in_delay) CFGERRTLPCPLHEADER_INDELAY = CFGERRTLPCPLHEADER_IN;
  assign #(in_delay) CFGERRURN_INDELAY = CFGERRURN_IN;
  assign #(in_delay) CFGINTERRUPTASSERTN_INDELAY = CFGINTERRUPTASSERTN_IN;
  assign #(in_delay) CFGINTERRUPTDI_INDELAY = CFGINTERRUPTDI_IN;
  assign #(in_delay) CFGINTERRUPTN_INDELAY = CFGINTERRUPTN_IN;
  assign #(in_delay) CFGPMDIRECTASPML1N_INDELAY = CFGPMDIRECTASPML1N_IN;
  assign #(in_delay) CFGPMSENDPMACKN_INDELAY = CFGPMSENDPMACKN_IN;
  assign #(in_delay) CFGPMSENDPMETON_INDELAY = CFGPMSENDPMETON_IN;
  assign #(in_delay) CFGPMSENDPMNAKN_INDELAY = CFGPMSENDPMNAKN_IN;
  assign #(in_delay) CFGPMTURNOFFOKN_INDELAY = CFGPMTURNOFFOKN_IN;
  assign #(in_delay) CFGPMWAKEN_INDELAY = CFGPMWAKEN_IN;
  assign #(in_delay) CFGPORTNUMBER_INDELAY = CFGPORTNUMBER_IN;
  assign #(in_delay) CFGRDENN_INDELAY = CFGRDENN_IN;
  assign #(in_delay) CFGTRNPENDINGN_INDELAY = CFGTRNPENDINGN_IN;
  assign #(in_delay) CFGWRENN_INDELAY = CFGWRENN_IN;
  assign #(in_delay) CFGWRREADONLYN_INDELAY = CFGWRREADONLYN_IN;
  assign #(in_delay) CFGWRRW1CASRWN_INDELAY = CFGWRRW1CASRWN_IN;
  assign #(in_delay) CMRSTN_INDELAY = CMRSTN_IN;
  assign #(in_delay) CMSTICKYRSTN_INDELAY = CMSTICKYRSTN_IN;
  assign #(in_delay) DBGMODE_INDELAY = DBGMODE_IN;
  assign #(in_delay) DBGSUBMODE_INDELAY = DBGSUBMODE_IN;
  assign #(in_delay) DLRSTN_INDELAY = DLRSTN_IN;
  assign #(in_delay) DRPDADDR_INDELAY = DRPDADDR_IN;
  assign #(in_delay) DRPDEN_INDELAY = DRPDEN_IN;
  assign #(in_delay) DRPDI_INDELAY = DRPDI_IN;
  assign #(in_delay) DRPDWE_INDELAY = DRPDWE_IN;
  assign #(in_delay) FUNCLVLRSTN_INDELAY = FUNCLVLRSTN_IN;
  assign #(in_delay) LL2SENDASREQL1N_INDELAY = LL2SENDASREQL1N_IN;
  assign #(in_delay) LL2SENDENTERL1N_INDELAY = LL2SENDENTERL1N_IN;
  assign #(in_delay) LL2SENDENTERL23N_INDELAY = LL2SENDENTERL23N_IN;
  assign #(in_delay) LL2SUSPENDNOWN_INDELAY = LL2SUSPENDNOWN_IN;
  assign #(in_delay) LL2TLPRCVN_INDELAY = LL2TLPRCVN_IN;
  assign #(in_delay) MIMRXRDATA_INDELAY = MIMRXRDATA_IN;
  assign #(in_delay) MIMTXRDATA_INDELAY = MIMTXRDATA_IN;
  assign #(in_delay) PIPERX0CHANISALIGNED_INDELAY = PIPERX0CHANISALIGNED_IN;
  assign #(in_delay) PIPERX0CHARISK_INDELAY = PIPERX0CHARISK_IN;
  assign #(in_delay) PIPERX0DATA_INDELAY = PIPERX0DATA_IN;
  assign #(in_delay) PIPERX0ELECIDLE_INDELAY = PIPERX0ELECIDLE_IN;
  assign #(in_delay) PIPERX0PHYSTATUS_INDELAY = PIPERX0PHYSTATUS_IN;
  assign #(in_delay) PIPERX0STATUS_INDELAY = PIPERX0STATUS_IN;
  assign #(in_delay) PIPERX0VALID_INDELAY = PIPERX0VALID_IN;
  assign #(in_delay) PIPERX1CHANISALIGNED_INDELAY = PIPERX1CHANISALIGNED_IN;
  assign #(in_delay) PIPERX1CHARISK_INDELAY = PIPERX1CHARISK_IN;
  assign #(in_delay) PIPERX1DATA_INDELAY = PIPERX1DATA_IN;
  assign #(in_delay) PIPERX1ELECIDLE_INDELAY = PIPERX1ELECIDLE_IN;
  assign #(in_delay) PIPERX1PHYSTATUS_INDELAY = PIPERX1PHYSTATUS_IN;
  assign #(in_delay) PIPERX1STATUS_INDELAY = PIPERX1STATUS_IN;
  assign #(in_delay) PIPERX1VALID_INDELAY = PIPERX1VALID_IN;
  assign #(in_delay) PIPERX2CHANISALIGNED_INDELAY = PIPERX2CHANISALIGNED_IN;
  assign #(in_delay) PIPERX2CHARISK_INDELAY = PIPERX2CHARISK_IN;
  assign #(in_delay) PIPERX2DATA_INDELAY = PIPERX2DATA_IN;
  assign #(in_delay) PIPERX2ELECIDLE_INDELAY = PIPERX2ELECIDLE_IN;
  assign #(in_delay) PIPERX2PHYSTATUS_INDELAY = PIPERX2PHYSTATUS_IN;
  assign #(in_delay) PIPERX2STATUS_INDELAY = PIPERX2STATUS_IN;
  assign #(in_delay) PIPERX2VALID_INDELAY = PIPERX2VALID_IN;
  assign #(in_delay) PIPERX3CHANISALIGNED_INDELAY = PIPERX3CHANISALIGNED_IN;
  assign #(in_delay) PIPERX3CHARISK_INDELAY = PIPERX3CHARISK_IN;
  assign #(in_delay) PIPERX3DATA_INDELAY = PIPERX3DATA_IN;
  assign #(in_delay) PIPERX3ELECIDLE_INDELAY = PIPERX3ELECIDLE_IN;
  assign #(in_delay) PIPERX3PHYSTATUS_INDELAY = PIPERX3PHYSTATUS_IN;
  assign #(in_delay) PIPERX3STATUS_INDELAY = PIPERX3STATUS_IN;
  assign #(in_delay) PIPERX3VALID_INDELAY = PIPERX3VALID_IN;
  assign #(in_delay) PIPERX4CHANISALIGNED_INDELAY = PIPERX4CHANISALIGNED_IN;
  assign #(in_delay) PIPERX4CHARISK_INDELAY = PIPERX4CHARISK_IN;
  assign #(in_delay) PIPERX4DATA_INDELAY = PIPERX4DATA_IN;
  assign #(in_delay) PIPERX4ELECIDLE_INDELAY = PIPERX4ELECIDLE_IN;
  assign #(in_delay) PIPERX4PHYSTATUS_INDELAY = PIPERX4PHYSTATUS_IN;
  assign #(in_delay) PIPERX4STATUS_INDELAY = PIPERX4STATUS_IN;
  assign #(in_delay) PIPERX4VALID_INDELAY = PIPERX4VALID_IN;
  assign #(in_delay) PIPERX5CHANISALIGNED_INDELAY = PIPERX5CHANISALIGNED_IN;
  assign #(in_delay) PIPERX5CHARISK_INDELAY = PIPERX5CHARISK_IN;
  assign #(in_delay) PIPERX5DATA_INDELAY = PIPERX5DATA_IN;
  assign #(in_delay) PIPERX5ELECIDLE_INDELAY = PIPERX5ELECIDLE_IN;
  assign #(in_delay) PIPERX5PHYSTATUS_INDELAY = PIPERX5PHYSTATUS_IN;
  assign #(in_delay) PIPERX5STATUS_INDELAY = PIPERX5STATUS_IN;
  assign #(in_delay) PIPERX5VALID_INDELAY = PIPERX5VALID_IN;
  assign #(in_delay) PIPERX6CHANISALIGNED_INDELAY = PIPERX6CHANISALIGNED_IN;
  assign #(in_delay) PIPERX6CHARISK_INDELAY = PIPERX6CHARISK_IN;
  assign #(in_delay) PIPERX6DATA_INDELAY = PIPERX6DATA_IN;
  assign #(in_delay) PIPERX6ELECIDLE_INDELAY = PIPERX6ELECIDLE_IN;
  assign #(in_delay) PIPERX6PHYSTATUS_INDELAY = PIPERX6PHYSTATUS_IN;
  assign #(in_delay) PIPERX6STATUS_INDELAY = PIPERX6STATUS_IN;
  assign #(in_delay) PIPERX6VALID_INDELAY = PIPERX6VALID_IN;
  assign #(in_delay) PIPERX7CHANISALIGNED_INDELAY = PIPERX7CHANISALIGNED_IN;
  assign #(in_delay) PIPERX7CHARISK_INDELAY = PIPERX7CHARISK_IN;
  assign #(in_delay) PIPERX7DATA_INDELAY = PIPERX7DATA_IN;
  assign #(in_delay) PIPERX7ELECIDLE_INDELAY = PIPERX7ELECIDLE_IN;
  assign #(in_delay) PIPERX7PHYSTATUS_INDELAY = PIPERX7PHYSTATUS_IN;
  assign #(in_delay) PIPERX7STATUS_INDELAY = PIPERX7STATUS_IN;
  assign #(in_delay) PIPERX7VALID_INDELAY = PIPERX7VALID_IN;
  assign #(in_delay) PL2DIRECTEDLSTATE_INDELAY = PL2DIRECTEDLSTATE_IN;
  assign #(in_delay) PLDBGMODE_INDELAY = PLDBGMODE_IN;
  assign #(in_delay) PLDIRECTEDLINKAUTON_INDELAY = PLDIRECTEDLINKAUTON_IN;
  assign #(in_delay) PLDIRECTEDLINKCHANGE_INDELAY = PLDIRECTEDLINKCHANGE_IN;
  assign #(in_delay) PLDIRECTEDLINKSPEED_INDELAY = PLDIRECTEDLINKSPEED_IN;
  assign #(in_delay) PLDIRECTEDLINKWIDTH_INDELAY = PLDIRECTEDLINKWIDTH_IN;
  assign #(in_delay) PLDOWNSTREAMDEEMPHSOURCE_INDELAY = PLDOWNSTREAMDEEMPHSOURCE_IN;
  assign #(in_delay) PLRSTN_INDELAY = PLRSTN_IN;
  assign #(in_delay) PLTRANSMITHOTRST_INDELAY = PLTRANSMITHOTRST_IN;
  assign #(in_delay) PLUPSTREAMPREFERDEEMPH_INDELAY = PLUPSTREAMPREFERDEEMPH_IN;
  assign #(in_delay) SYSRSTN_INDELAY = SYSRSTN_IN;
  assign #(in_delay) TL2ASPMSUSPENDCREDITCHECKN_INDELAY = TL2ASPMSUSPENDCREDITCHECKN_IN;
  assign #(in_delay) TL2PPMSUSPENDREQN_INDELAY = TL2PPMSUSPENDREQN_IN;
  assign #(in_delay) TLRSTN_INDELAY = TLRSTN_IN;
  assign #(in_delay) TRNFCSEL_INDELAY = TRNFCSEL_IN;
  assign #(in_delay) TRNRDSTRDYN_INDELAY = TRNRDSTRDYN_IN;
  assign #(in_delay) TRNRNPOKN_INDELAY = TRNRNPOKN_IN;
  assign #(in_delay) TRNTCFGGNTN_INDELAY = TRNTCFGGNTN_IN;
  assign #(in_delay) TRNTDLLPDATA_INDELAY = TRNTDLLPDATA_IN;
  assign #(in_delay) TRNTDLLPSRCRDYN_INDELAY = TRNTDLLPSRCRDYN_IN;
  assign #(in_delay) TRNTD_INDELAY = TRNTD_IN;
  assign #(in_delay) TRNTECRCGENN_INDELAY = TRNTECRCGENN_IN;
  assign #(in_delay) TRNTEOFN_INDELAY = TRNTEOFN_IN;
  assign #(in_delay) TRNTERRFWDN_INDELAY = TRNTERRFWDN_IN;
  assign #(in_delay) TRNTREMN_INDELAY = TRNTREMN_IN;
  assign #(in_delay) TRNTSOFN_INDELAY = TRNTSOFN_IN;
  assign #(in_delay) TRNTSRCDSCN_INDELAY = TRNTSRCDSCN_IN;
  assign #(in_delay) TRNTSRCRDYN_INDELAY = TRNTSRCRDYN_IN;
  assign #(in_delay) TRNTSTRN_INDELAY = TRNTSTRN_IN;
  assign  delay_SYSRSTN = SYSRSTN_INDELAY;
   
  B_PCIE_2_0 #(
    .AER_BASE_PTR (AER_BASE_PTR),
    .AER_CAP_ECRC_CHECK_CAPABLE (AER_CAP_ECRC_CHECK_CAPABLE),
    .AER_CAP_ECRC_GEN_CAPABLE (AER_CAP_ECRC_GEN_CAPABLE),
    .AER_CAP_ID (AER_CAP_ID),
    .AER_CAP_INT_MSG_NUM_MSI (AER_CAP_INT_MSG_NUM_MSI),
    .AER_CAP_INT_MSG_NUM_MSIX (AER_CAP_INT_MSG_NUM_MSIX),
    .AER_CAP_NEXTPTR (AER_CAP_NEXTPTR),
    .AER_CAP_ON (AER_CAP_ON),
    .AER_CAP_PERMIT_ROOTERR_UPDATE (AER_CAP_PERMIT_ROOTERR_UPDATE),
    .AER_CAP_VERSION (AER_CAP_VERSION),
    .ALLOW_X8_GEN2 (ALLOW_X8_GEN2),
    .BAR0 (BAR0),
    .BAR1 (BAR1),
    .BAR2 (BAR2),
    .BAR3 (BAR3),
    .BAR4 (BAR4),
    .BAR5 (BAR5),
    .CAPABILITIES_PTR (CAPABILITIES_PTR),
    .CARDBUS_CIS_POINTER (CARDBUS_CIS_POINTER),
    .CLASS_CODE (CLASS_CODE),
    .CMD_INTX_IMPLEMENTED (CMD_INTX_IMPLEMENTED),
    .CPL_TIMEOUT_DISABLE_SUPPORTED (CPL_TIMEOUT_DISABLE_SUPPORTED),
    .CPL_TIMEOUT_RANGES_SUPPORTED (CPL_TIMEOUT_RANGES_SUPPORTED),
    .CRM_MODULE_RSTS (CRM_MODULE_RSTS),
    .DEVICE_ID (DEVICE_ID),
    .DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE),
    .DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE (DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE),
    .DEV_CAP_ENDPOINT_L0S_LATENCY (DEV_CAP_ENDPOINT_L0S_LATENCY),
    .DEV_CAP_ENDPOINT_L1_LATENCY (DEV_CAP_ENDPOINT_L1_LATENCY),
    .DEV_CAP_EXT_TAG_SUPPORTED (DEV_CAP_EXT_TAG_SUPPORTED),
    .DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .DEV_CAP_MAX_PAYLOAD_SUPPORTED (DEV_CAP_MAX_PAYLOAD_SUPPORTED),
    .DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT (DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT),
    .DEV_CAP_ROLE_BASED_ERROR (DEV_CAP_ROLE_BASED_ERROR),
    .DEV_CAP_RSVD_14_12 (DEV_CAP_RSVD_14_12),
    .DEV_CAP_RSVD_17_16 (DEV_CAP_RSVD_17_16),
    .DEV_CAP_RSVD_31_29 (DEV_CAP_RSVD_31_29),
    .DEV_CONTROL_AUX_POWER_SUPPORTED (DEV_CONTROL_AUX_POWER_SUPPORTED),
    .DISABLE_ASPM_L1_TIMER (DISABLE_ASPM_L1_TIMER),
    .DISABLE_BAR_FILTERING (DISABLE_BAR_FILTERING),
    .DISABLE_ID_CHECK (DISABLE_ID_CHECK),
    .DISABLE_LANE_REVERSAL (DISABLE_LANE_REVERSAL),
    .DISABLE_RX_TC_FILTER (DISABLE_RX_TC_FILTER),
    .DISABLE_SCRAMBLING (DISABLE_SCRAMBLING),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .DSN_BASE_PTR (DSN_BASE_PTR),
    .DSN_CAP_ID (DSN_CAP_ID),
    .DSN_CAP_NEXTPTR (DSN_CAP_NEXTPTR),
    .DSN_CAP_ON (DSN_CAP_ON),
    .DSN_CAP_VERSION (DSN_CAP_VERSION),
    .ENABLE_MSG_ROUTE (ENABLE_MSG_ROUTE),
    .ENABLE_RX_TD_ECRC_TRIM (ENABLE_RX_TD_ECRC_TRIM),
    .ENTER_RVRY_EI_L0 (ENTER_RVRY_EI_L0),
    .EXIT_LOOPBACK_ON_EI (EXIT_LOOPBACK_ON_EI),
    .EXPANSION_ROM (EXPANSION_ROM),
    .EXT_CFG_CAP_PTR (EXT_CFG_CAP_PTR),
    .EXT_CFG_XP_CAP_PTR (EXT_CFG_XP_CAP_PTR),
    .HEADER_TYPE (HEADER_TYPE),
    .INFER_EI (INFER_EI),
    .INTERRUPT_PIN (INTERRUPT_PIN),
    .IS_SWITCH (IS_SWITCH),
    .LAST_CONFIG_DWORD (LAST_CONFIG_DWORD),
    .LINK_CAP_ASPM_SUPPORT (LINK_CAP_ASPM_SUPPORT),
    .LINK_CAP_CLOCK_POWER_MANAGEMENT (LINK_CAP_CLOCK_POWER_MANAGEMENT),
    .LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP (LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP),
    .LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .LINK_CAP_L0S_EXIT_LATENCY_GEN1 (LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .LINK_CAP_L0S_EXIT_LATENCY_GEN2 (LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .LINK_CAP_L1_EXIT_LATENCY_GEN1 (LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .LINK_CAP_L1_EXIT_LATENCY_GEN2 (LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP (LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP),
    .LINK_CAP_MAX_LINK_SPEED (LINK_CAP_MAX_LINK_SPEED),
    .LINK_CAP_MAX_LINK_WIDTH (LINK_CAP_MAX_LINK_WIDTH),
    .LINK_CAP_RSVD_23_22 (LINK_CAP_RSVD_23_22),
    .LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE (LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE),
    .LINK_CONTROL_RCB (LINK_CONTROL_RCB),
    .LINK_CTRL2_DEEMPHASIS (LINK_CTRL2_DEEMPHASIS),
    .LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE (LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE),
    .LINK_CTRL2_TARGET_LINK_SPEED (LINK_CTRL2_TARGET_LINK_SPEED),
    .LINK_STATUS_SLOT_CLOCK_CONFIG (LINK_STATUS_SLOT_CLOCK_CONFIG),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTSSM_MAX_LINK_WIDTH (LTSSM_MAX_LINK_WIDTH),
    .MSIX_BASE_PTR (MSIX_BASE_PTR),
    .MSIX_CAP_ID (MSIX_CAP_ID),
    .MSIX_CAP_NEXTPTR (MSIX_CAP_NEXTPTR),
    .MSIX_CAP_ON (MSIX_CAP_ON),
    .MSIX_CAP_PBA_BIR (MSIX_CAP_PBA_BIR),
    .MSIX_CAP_PBA_OFFSET (MSIX_CAP_PBA_OFFSET),
    .MSIX_CAP_TABLE_BIR (MSIX_CAP_TABLE_BIR),
    .MSIX_CAP_TABLE_OFFSET (MSIX_CAP_TABLE_OFFSET),
    .MSIX_CAP_TABLE_SIZE (MSIX_CAP_TABLE_SIZE),
    .MSI_BASE_PTR (MSI_BASE_PTR),
    .MSI_CAP_64_BIT_ADDR_CAPABLE (MSI_CAP_64_BIT_ADDR_CAPABLE),
    .MSI_CAP_ID (MSI_CAP_ID),
    .MSI_CAP_MULTIMSGCAP (MSI_CAP_MULTIMSGCAP),
    .MSI_CAP_MULTIMSG_EXTENSION (MSI_CAP_MULTIMSG_EXTENSION),
    .MSI_CAP_NEXTPTR (MSI_CAP_NEXTPTR),
    .MSI_CAP_ON (MSI_CAP_ON),
    .MSI_CAP_PER_VECTOR_MASKING_CAPABLE (MSI_CAP_PER_VECTOR_MASKING_CAPABLE),
    .N_FTS_COMCLK_GEN1 (N_FTS_COMCLK_GEN1),
    .N_FTS_COMCLK_GEN2 (N_FTS_COMCLK_GEN2),
    .N_FTS_GEN1 (N_FTS_GEN1),
    .N_FTS_GEN2 (N_FTS_GEN2),
    .PCIE_BASE_PTR (PCIE_BASE_PTR),
    .PCIE_CAP_CAPABILITY_ID (PCIE_CAP_CAPABILITY_ID),
    .PCIE_CAP_CAPABILITY_VERSION (PCIE_CAP_CAPABILITY_VERSION),
    .PCIE_CAP_DEVICE_PORT_TYPE (PCIE_CAP_DEVICE_PORT_TYPE),
    .PCIE_CAP_INT_MSG_NUM (PCIE_CAP_INT_MSG_NUM),
    .PCIE_CAP_NEXTPTR (PCIE_CAP_NEXTPTR),
    .PCIE_CAP_ON (PCIE_CAP_ON),
    .PCIE_CAP_RSVD_15_14 (PCIE_CAP_RSVD_15_14),
    .PCIE_CAP_SLOT_IMPLEMENTED (PCIE_CAP_SLOT_IMPLEMENTED),
    .PCIE_REVISION (PCIE_REVISION),
    .PGL0_LANE (PGL0_LANE),
    .PGL1_LANE (PGL1_LANE),
    .PGL2_LANE (PGL2_LANE),
    .PGL3_LANE (PGL3_LANE),
    .PGL4_LANE (PGL4_LANE),
    .PGL5_LANE (PGL5_LANE),
    .PGL6_LANE (PGL6_LANE),
    .PGL7_LANE (PGL7_LANE),
    .PL_AUTO_CONFIG (PL_AUTO_CONFIG),
    .PL_FAST_TRAIN (PL_FAST_TRAIN),
    .PM_BASE_PTR (PM_BASE_PTR),
    .PM_CAP_AUXCURRENT (PM_CAP_AUXCURRENT),
    .PM_CAP_D1SUPPORT (PM_CAP_D1SUPPORT),
    .PM_CAP_D2SUPPORT (PM_CAP_D2SUPPORT),
    .PM_CAP_DSI (PM_CAP_DSI),
    .PM_CAP_ID (PM_CAP_ID),
    .PM_CAP_NEXTPTR (PM_CAP_NEXTPTR),
    .PM_CAP_ON (PM_CAP_ON),
    .PM_CAP_PMESUPPORT (PM_CAP_PMESUPPORT),
    .PM_CAP_PME_CLOCK (PM_CAP_PME_CLOCK),
    .PM_CAP_RSVD_04 (PM_CAP_RSVD_04),
    .PM_CAP_VERSION (PM_CAP_VERSION),
    .PM_CSR_B2B3 (PM_CSR_B2B3),
    .PM_CSR_BPCCEN (PM_CSR_BPCCEN),
    .PM_CSR_NOSOFTRST (PM_CSR_NOSOFTRST),
    .PM_DATA0 (PM_DATA0),
    .PM_DATA1 (PM_DATA1),
    .PM_DATA2 (PM_DATA2),
    .PM_DATA3 (PM_DATA3),
    .PM_DATA4 (PM_DATA4),
    .PM_DATA5 (PM_DATA5),
    .PM_DATA6 (PM_DATA6),
    .PM_DATA7 (PM_DATA7),
    .PM_DATA_SCALE0 (PM_DATA_SCALE0),
    .PM_DATA_SCALE1 (PM_DATA_SCALE1),
    .PM_DATA_SCALE2 (PM_DATA_SCALE2),
    .PM_DATA_SCALE3 (PM_DATA_SCALE3),
    .PM_DATA_SCALE4 (PM_DATA_SCALE4),
    .PM_DATA_SCALE5 (PM_DATA_SCALE5),
    .PM_DATA_SCALE6 (PM_DATA_SCALE6),
    .PM_DATA_SCALE7 (PM_DATA_SCALE7),
    .RECRC_CHK (RECRC_CHK),
    .RECRC_CHK_TRIM (RECRC_CHK_TRIM),
    .REVISION_ID (REVISION_ID),
    .ROOT_CAP_CRS_SW_VISIBILITY (ROOT_CAP_CRS_SW_VISIBILITY),
    .SELECT_DLL_IF (SELECT_DLL_IF),
    .SIM_VERSION (SIM_VERSION),    
    .SLOT_CAP_ATT_BUTTON_PRESENT (SLOT_CAP_ATT_BUTTON_PRESENT),
    .SLOT_CAP_ATT_INDICATOR_PRESENT (SLOT_CAP_ATT_INDICATOR_PRESENT),
    .SLOT_CAP_ELEC_INTERLOCK_PRESENT (SLOT_CAP_ELEC_INTERLOCK_PRESENT),
    .SLOT_CAP_HOTPLUG_CAPABLE (SLOT_CAP_HOTPLUG_CAPABLE),
    .SLOT_CAP_HOTPLUG_SURPRISE (SLOT_CAP_HOTPLUG_SURPRISE),
    .SLOT_CAP_MRL_SENSOR_PRESENT (SLOT_CAP_MRL_SENSOR_PRESENT),
    .SLOT_CAP_NO_CMD_COMPLETED_SUPPORT (SLOT_CAP_NO_CMD_COMPLETED_SUPPORT),
    .SLOT_CAP_PHYSICAL_SLOT_NUM (SLOT_CAP_PHYSICAL_SLOT_NUM),
    .SLOT_CAP_POWER_CONTROLLER_PRESENT (SLOT_CAP_POWER_CONTROLLER_PRESENT),
    .SLOT_CAP_POWER_INDICATOR_PRESENT (SLOT_CAP_POWER_INDICATOR_PRESENT),
    .SLOT_CAP_SLOT_POWER_LIMIT_SCALE (SLOT_CAP_SLOT_POWER_LIMIT_SCALE),
    .SLOT_CAP_SLOT_POWER_LIMIT_VALUE (SLOT_CAP_SLOT_POWER_LIMIT_VALUE),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SUBSYSTEM_ID (SUBSYSTEM_ID),
    .SUBSYSTEM_VENDOR_ID (SUBSYSTEM_VENDOR_ID),
    .TL_RBYPASS (TL_RBYPASS),
    .TL_RX_RAM_RADDR_LATENCY (TL_RX_RAM_RADDR_LATENCY),
    .TL_RX_RAM_RDATA_LATENCY (TL_RX_RAM_RDATA_LATENCY),
    .TL_RX_RAM_WRITE_LATENCY (TL_RX_RAM_WRITE_LATENCY),
    .TL_TFC_DISABLE (TL_TFC_DISABLE),
    .TL_TX_CHECKS_DISABLE (TL_TX_CHECKS_DISABLE),
    .TL_TX_RAM_RADDR_LATENCY (TL_TX_RAM_RADDR_LATENCY),
    .TL_TX_RAM_RDATA_LATENCY (TL_TX_RAM_RDATA_LATENCY),
    .TL_TX_RAM_WRITE_LATENCY (TL_TX_RAM_WRITE_LATENCY),
    .UPCONFIG_CAPABLE (UPCONFIG_CAPABLE),
    .UPSTREAM_FACING (UPSTREAM_FACING),
    .UR_INV_REQ (UR_INV_REQ),
    .USER_CLK_FREQ (USER_CLK_FREQ),
    .VC0_CPL_INFINITE (VC0_CPL_INFINITE),
    .VC0_RX_RAM_LIMIT (VC0_RX_RAM_LIMIT),
    .VC0_TOTAL_CREDITS_CD (VC0_TOTAL_CREDITS_CD),
    .VC0_TOTAL_CREDITS_CH (VC0_TOTAL_CREDITS_CH),
    .VC0_TOTAL_CREDITS_NPH (VC0_TOTAL_CREDITS_NPH),
    .VC0_TOTAL_CREDITS_PD (VC0_TOTAL_CREDITS_PD),
    .VC0_TOTAL_CREDITS_PH (VC0_TOTAL_CREDITS_PH),
    .VC0_TX_LASTPACKET (VC0_TX_LASTPACKET),
    .VC_BASE_PTR (VC_BASE_PTR),
    .VC_CAP_ID (VC_CAP_ID),
    .VC_CAP_NEXTPTR (VC_CAP_NEXTPTR),
    .VC_CAP_ON (VC_CAP_ON),
    .VC_CAP_REJECT_SNOOP_TRANSACTIONS (VC_CAP_REJECT_SNOOP_TRANSACTIONS),
    .VC_CAP_VERSION (VC_CAP_VERSION),
    .VENDOR_ID (VENDOR_ID),
    .VSEC_BASE_PTR (VSEC_BASE_PTR),
    .VSEC_CAP_HDR_ID (VSEC_CAP_HDR_ID),
    .VSEC_CAP_HDR_LENGTH (VSEC_CAP_HDR_LENGTH),
    .VSEC_CAP_HDR_REVISION (VSEC_CAP_HDR_REVISION),
    .VSEC_CAP_ID (VSEC_CAP_ID),
    .VSEC_CAP_IS_LINK_VISIBLE (VSEC_CAP_IS_LINK_VISIBLE),
    .VSEC_CAP_NEXTPTR (VSEC_CAP_NEXTPTR),
    .VSEC_CAP_ON (VSEC_CAP_ON),
    .VSEC_CAP_VERSION (VSEC_CAP_VERSION))

    B_PCIE_2_0_INST(
    .CFGAERECRCCHECKEN (delay_CFGAERECRCCHECKEN),
    .CFGAERECRCGENEN (delay_CFGAERECRCGENEN),
    .CFGCOMMANDBUSMASTERENABLE (delay_CFGCOMMANDBUSMASTERENABLE),
    .CFGCOMMANDINTERRUPTDISABLE (delay_CFGCOMMANDINTERRUPTDISABLE),
    .CFGCOMMANDIOENABLE (delay_CFGCOMMANDIOENABLE),
    .CFGCOMMANDMEMENABLE (delay_CFGCOMMANDMEMENABLE),
    .CFGCOMMANDSERREN (delay_CFGCOMMANDSERREN),
    .CFGDEVCONTROL2CPLTIMEOUTDIS (delay_CFGDEVCONTROL2CPLTIMEOUTDIS),
    .CFGDEVCONTROL2CPLTIMEOUTVAL (delay_CFGDEVCONTROL2CPLTIMEOUTVAL),
    .CFGDEVCONTROLAUXPOWEREN (delay_CFGDEVCONTROLAUXPOWEREN),
    .CFGDEVCONTROLCORRERRREPORTINGEN (delay_CFGDEVCONTROLCORRERRREPORTINGEN),
    .CFGDEVCONTROLENABLERO (delay_CFGDEVCONTROLENABLERO),
    .CFGDEVCONTROLEXTTAGEN (delay_CFGDEVCONTROLEXTTAGEN),
    .CFGDEVCONTROLFATALERRREPORTINGEN (delay_CFGDEVCONTROLFATALERRREPORTINGEN),
    .CFGDEVCONTROLMAXPAYLOAD (delay_CFGDEVCONTROLMAXPAYLOAD),
    .CFGDEVCONTROLMAXREADREQ (delay_CFGDEVCONTROLMAXREADREQ),
    .CFGDEVCONTROLNONFATALREPORTINGEN (delay_CFGDEVCONTROLNONFATALREPORTINGEN),
    .CFGDEVCONTROLNOSNOOPEN (delay_CFGDEVCONTROLNOSNOOPEN),
    .CFGDEVCONTROLPHANTOMEN (delay_CFGDEVCONTROLPHANTOMEN),
    .CFGDEVCONTROLURERRREPORTINGEN (delay_CFGDEVCONTROLURERRREPORTINGEN),
    .CFGDEVSTATUSCORRERRDETECTED (delay_CFGDEVSTATUSCORRERRDETECTED),
    .CFGDEVSTATUSFATALERRDETECTED (delay_CFGDEVSTATUSFATALERRDETECTED),
    .CFGDEVSTATUSNONFATALERRDETECTED (delay_CFGDEVSTATUSNONFATALERRDETECTED),
    .CFGDEVSTATUSURDETECTED (delay_CFGDEVSTATUSURDETECTED),
    .CFGDO (delay_CFGDO),
    .CFGERRAERHEADERLOGSETN (delay_CFGERRAERHEADERLOGSETN),
    .CFGERRCPLRDYN (delay_CFGERRCPLRDYN),
    .CFGINTERRUPTDO (delay_CFGINTERRUPTDO),
    .CFGINTERRUPTMMENABLE (delay_CFGINTERRUPTMMENABLE),
    .CFGINTERRUPTMSIENABLE (delay_CFGINTERRUPTMSIENABLE),
    .CFGINTERRUPTMSIXENABLE (delay_CFGINTERRUPTMSIXENABLE),
    .CFGINTERRUPTMSIXFM (delay_CFGINTERRUPTMSIXFM),
    .CFGINTERRUPTRDYN (delay_CFGINTERRUPTRDYN),
    .CFGLINKCONTROLASPMCONTROL (delay_CFGLINKCONTROLASPMCONTROL),
    .CFGLINKCONTROLAUTOBANDWIDTHINTEN (delay_CFGLINKCONTROLAUTOBANDWIDTHINTEN),
    .CFGLINKCONTROLBANDWIDTHINTEN (delay_CFGLINKCONTROLBANDWIDTHINTEN),
    .CFGLINKCONTROLCLOCKPMEN (delay_CFGLINKCONTROLCLOCKPMEN),
    .CFGLINKCONTROLCOMMONCLOCK (delay_CFGLINKCONTROLCOMMONCLOCK),
    .CFGLINKCONTROLEXTENDEDSYNC (delay_CFGLINKCONTROLEXTENDEDSYNC),
    .CFGLINKCONTROLHWAUTOWIDTHDIS (delay_CFGLINKCONTROLHWAUTOWIDTHDIS),
    .CFGLINKCONTROLLINKDISABLE (delay_CFGLINKCONTROLLINKDISABLE),
    .CFGLINKCONTROLRCB (delay_CFGLINKCONTROLRCB),
    .CFGLINKCONTROLRETRAINLINK (delay_CFGLINKCONTROLRETRAINLINK),
    .CFGLINKSTATUSAUTOBANDWIDTHSTATUS (delay_CFGLINKSTATUSAUTOBANDWIDTHSTATUS),
    .CFGLINKSTATUSBANDWITHSTATUS (delay_CFGLINKSTATUSBANDWITHSTATUS),
    .CFGLINKSTATUSCURRENTSPEED (delay_CFGLINKSTATUSCURRENTSPEED),
    .CFGLINKSTATUSDLLACTIVE (delay_CFGLINKSTATUSDLLACTIVE),
    .CFGLINKSTATUSLINKTRAINING (delay_CFGLINKSTATUSLINKTRAINING),
    .CFGLINKSTATUSNEGOTIATEDWIDTH (delay_CFGLINKSTATUSNEGOTIATEDWIDTH),
    .CFGMSGDATA (delay_CFGMSGDATA),
    .CFGMSGRECEIVED (delay_CFGMSGRECEIVED),
    .CFGMSGRECEIVEDASSERTINTA (delay_CFGMSGRECEIVEDASSERTINTA),
    .CFGMSGRECEIVEDASSERTINTB (delay_CFGMSGRECEIVEDASSERTINTB),
    .CFGMSGRECEIVEDASSERTINTC (delay_CFGMSGRECEIVEDASSERTINTC),
    .CFGMSGRECEIVEDASSERTINTD (delay_CFGMSGRECEIVEDASSERTINTD),
    .CFGMSGRECEIVEDDEASSERTINTA (delay_CFGMSGRECEIVEDDEASSERTINTA),
    .CFGMSGRECEIVEDDEASSERTINTB (delay_CFGMSGRECEIVEDDEASSERTINTB),
    .CFGMSGRECEIVEDDEASSERTINTC (delay_CFGMSGRECEIVEDDEASSERTINTC),
    .CFGMSGRECEIVEDDEASSERTINTD (delay_CFGMSGRECEIVEDDEASSERTINTD),
    .CFGMSGRECEIVEDERRCOR (delay_CFGMSGRECEIVEDERRCOR),
    .CFGMSGRECEIVEDERRFATAL (delay_CFGMSGRECEIVEDERRFATAL),
    .CFGMSGRECEIVEDERRNONFATAL (delay_CFGMSGRECEIVEDERRNONFATAL),
    .CFGMSGRECEIVEDPMASNAK (delay_CFGMSGRECEIVEDPMASNAK),
    .CFGMSGRECEIVEDPMETO (delay_CFGMSGRECEIVEDPMETO),
    .CFGMSGRECEIVEDPMETOACK (delay_CFGMSGRECEIVEDPMETOACK),
    .CFGMSGRECEIVEDPMPME (delay_CFGMSGRECEIVEDPMPME),
    .CFGMSGRECEIVEDSETSLOTPOWERLIMIT (delay_CFGMSGRECEIVEDSETSLOTPOWERLIMIT),
    .CFGMSGRECEIVEDUNLOCK (delay_CFGMSGRECEIVEDUNLOCK),
    .CFGPCIELINKSTATE (delay_CFGPCIELINKSTATE),
    .CFGPMCSRPMEEN (delay_CFGPMCSRPMEEN),
    .CFGPMCSRPMESTATUS(delay_CFGPMCSRPMESTATUS),
    .CFGPMCSRPOWERSTATE(delay_CFGPMCSRPOWERSTATE),   
    .CFGPMRCVASREQL1N (delay_CFGPMRCVASREQL1N),
    .CFGPMRCVENTERL1N (delay_CFGPMRCVENTERL1N),
    .CFGPMRCVENTERL23N (delay_CFGPMRCVENTERL23N),
    .CFGPMRCVREQACKN (delay_CFGPMRCVREQACKN),
    .CFGRDWRDONEN (delay_CFGRDWRDONEN),
    .CFGSLOTCONTROLELECTROMECHILCTLPULSE (delay_CFGSLOTCONTROLELECTROMECHILCTLPULSE),
    .CFGTRANSACTION (delay_CFGTRANSACTION),
    .CFGTRANSACTIONADDR (delay_CFGTRANSACTIONADDR),
    .CFGTRANSACTIONTYPE (delay_CFGTRANSACTIONTYPE),
    .CFGVCTCVCMAP (delay_CFGVCTCVCMAP),
    .DBGSCLRA (delay_DBGSCLRA),
    .DBGSCLRB (delay_DBGSCLRB),
    .DBGSCLRC (delay_DBGSCLRC),
    .DBGSCLRD (delay_DBGSCLRD),
    .DBGSCLRE (delay_DBGSCLRE),
    .DBGSCLRF (delay_DBGSCLRF),
    .DBGSCLRG (delay_DBGSCLRG),
    .DBGSCLRH (delay_DBGSCLRH),
    .DBGSCLRI (delay_DBGSCLRI),
    .DBGSCLRJ (delay_DBGSCLRJ),
    .DBGSCLRK (delay_DBGSCLRK),
    .DBGVECA (delay_DBGVECA),
    .DBGVECB (delay_DBGVECB),
    .DBGVECC (delay_DBGVECC),
    .DRPDO (delay_DRPDO),
    .DRPDRDY (delay_DRPDRDY),
    .LL2BADDLLPERRN (delay_LL2BADDLLPERRN),
    .LL2BADTLPERRN (delay_LL2BADTLPERRN),
    .LL2PROTOCOLERRN (delay_LL2PROTOCOLERRN),
    .LL2REPLAYROERRN (delay_LL2REPLAYROERRN),
    .LL2REPLAYTOERRN (delay_LL2REPLAYTOERRN),
    .LL2SUSPENDOKN (delay_LL2SUSPENDOKN),
    .LL2TFCINIT1SEQN (delay_LL2TFCINIT1SEQN),
    .LL2TFCINIT2SEQN (delay_LL2TFCINIT2SEQN),
    .LNKCLKEN (delay_LNKCLKEN),
    .MIMRXRADDR (delay_MIMRXRADDR),
    .MIMRXRCE (delay_MIMRXRCE),
    .MIMRXREN (delay_MIMRXREN),
    .MIMRXWADDR (delay_MIMRXWADDR),
    .MIMRXWDATA (delay_MIMRXWDATA),
    .MIMRXWEN (delay_MIMRXWEN),
    .MIMTXRADDR (delay_MIMTXRADDR),
    .MIMTXRCE (delay_MIMTXRCE),
    .MIMTXREN (delay_MIMTXREN),
    .MIMTXWADDR (delay_MIMTXWADDR),
    .MIMTXWDATA (delay_MIMTXWDATA),
    .MIMTXWEN (delay_MIMTXWEN),
    .PIPERX0POLARITY (delay_PIPERX0POLARITY),
    .PIPERX1POLARITY (delay_PIPERX1POLARITY),
    .PIPERX2POLARITY (delay_PIPERX2POLARITY),
    .PIPERX3POLARITY (delay_PIPERX3POLARITY),
    .PIPERX4POLARITY (delay_PIPERX4POLARITY),
    .PIPERX5POLARITY (delay_PIPERX5POLARITY),
    .PIPERX6POLARITY (delay_PIPERX6POLARITY),
    .PIPERX7POLARITY (delay_PIPERX7POLARITY),
    .PIPETX0CHARISK (delay_PIPETX0CHARISK),
    .PIPETX0COMPLIANCE (delay_PIPETX0COMPLIANCE),
    .PIPETX0DATA (delay_PIPETX0DATA),
    .PIPETX0ELECIDLE (delay_PIPETX0ELECIDLE),
    .PIPETX0POWERDOWN (delay_PIPETX0POWERDOWN),
    .PIPETX1CHARISK (delay_PIPETX1CHARISK),
    .PIPETX1COMPLIANCE (delay_PIPETX1COMPLIANCE),
    .PIPETX1DATA (delay_PIPETX1DATA),
    .PIPETX1ELECIDLE (delay_PIPETX1ELECIDLE),
    .PIPETX1POWERDOWN (delay_PIPETX1POWERDOWN),
    .PIPETX2CHARISK (delay_PIPETX2CHARISK),
    .PIPETX2COMPLIANCE (delay_PIPETX2COMPLIANCE),
    .PIPETX2DATA (delay_PIPETX2DATA),
    .PIPETX2ELECIDLE (delay_PIPETX2ELECIDLE),
    .PIPETX2POWERDOWN (delay_PIPETX2POWERDOWN),
    .PIPETX3CHARISK (delay_PIPETX3CHARISK),
    .PIPETX3COMPLIANCE (delay_PIPETX3COMPLIANCE),
    .PIPETX3DATA (delay_PIPETX3DATA),
    .PIPETX3ELECIDLE (delay_PIPETX3ELECIDLE),
    .PIPETX3POWERDOWN (delay_PIPETX3POWERDOWN),
    .PIPETX4CHARISK (delay_PIPETX4CHARISK),
    .PIPETX4COMPLIANCE (delay_PIPETX4COMPLIANCE),
    .PIPETX4DATA (delay_PIPETX4DATA),
    .PIPETX4ELECIDLE (delay_PIPETX4ELECIDLE),
    .PIPETX4POWERDOWN (delay_PIPETX4POWERDOWN),
    .PIPETX5CHARISK (delay_PIPETX5CHARISK),
    .PIPETX5COMPLIANCE (delay_PIPETX5COMPLIANCE),
    .PIPETX5DATA (delay_PIPETX5DATA),
    .PIPETX5ELECIDLE (delay_PIPETX5ELECIDLE),
    .PIPETX5POWERDOWN (delay_PIPETX5POWERDOWN),
    .PIPETX6CHARISK (delay_PIPETX6CHARISK),
    .PIPETX6COMPLIANCE (delay_PIPETX6COMPLIANCE),
    .PIPETX6DATA (delay_PIPETX6DATA),
    .PIPETX6ELECIDLE (delay_PIPETX6ELECIDLE),
    .PIPETX6POWERDOWN (delay_PIPETX6POWERDOWN),
    .PIPETX7CHARISK (delay_PIPETX7CHARISK),
    .PIPETX7COMPLIANCE (delay_PIPETX7COMPLIANCE),
    .PIPETX7DATA (delay_PIPETX7DATA),
    .PIPETX7ELECIDLE (delay_PIPETX7ELECIDLE),
    .PIPETX7POWERDOWN (delay_PIPETX7POWERDOWN),
    .PIPETXDEEMPH (delay_PIPETXDEEMPH),
    .PIPETXMARGIN (delay_PIPETXMARGIN),
    .PIPETXRATE (delay_PIPETXRATE),
    .PIPETXRCVRDET (delay_PIPETXRCVRDET),
    .PIPETXRESET (delay_PIPETXRESET),
    .PL2LINKUPN (delay_PL2LINKUPN),
    .PL2RECEIVERERRN (delay_PL2RECEIVERERRN),
    .PL2RECOVERYN (delay_PL2RECOVERYN),
    .PL2RXELECIDLE (delay_PL2RXELECIDLE),
    .PL2SUSPENDOK (delay_PL2SUSPENDOK),
    .PLDBGVEC (delay_PLDBGVEC),
    .PLINITIALLINKWIDTH (delay_PLINITIALLINKWIDTH),
    .PLLANEREVERSALMODE (delay_PLLANEREVERSALMODE),
    .PLLINKGEN2CAP (delay_PLLINKGEN2CAP),
    .PLLINKPARTNERGEN2SUPPORTED (delay_PLLINKPARTNERGEN2SUPPORTED),
    .PLLINKUPCFGCAP (delay_PLLINKUPCFGCAP),
    .PLLTSSMSTATE (delay_PLLTSSMSTATE),
    .PLPHYLNKUPN (delay_PLPHYLNKUPN),
    .PLRECEIVEDHOTRST (delay_PLRECEIVEDHOTRST),
    .PLRXPMSTATE (delay_PLRXPMSTATE),
    .PLSELLNKRATE (delay_PLSELLNKRATE),
    .PLSELLNKWIDTH (delay_PLSELLNKWIDTH),
    .PLTXPMSTATE (delay_PLTXPMSTATE),
    .RECEIVEDFUNCLVLRSTN (delay_RECEIVEDFUNCLVLRSTN),
    .TL2ASPMSUSPENDCREDITCHECKOKN (delay_TL2ASPMSUSPENDCREDITCHECKOKN),
    .TL2ASPMSUSPENDREQN (delay_TL2ASPMSUSPENDREQN),
    .TL2PPMSUSPENDOKN (delay_TL2PPMSUSPENDOKN),
    .TRNFCCPLD (delay_TRNFCCPLD),
    .TRNFCCPLH (delay_TRNFCCPLH),
    .TRNFCNPD (delay_TRNFCNPD),
    .TRNFCNPH (delay_TRNFCNPH),
    .TRNFCPD (delay_TRNFCPD),
    .TRNFCPH (delay_TRNFCPH),
    .TRNLNKUPN (delay_TRNLNKUPN),
    .TRNRBARHITN (delay_TRNRBARHITN),
    .TRNRD (delay_TRNRD),
    .TRNRDLLPDATA (delay_TRNRDLLPDATA),
    .TRNRDLLPSRCRDYN (delay_TRNRDLLPSRCRDYN),
    .TRNRECRCERRN (delay_TRNRECRCERRN),
    .TRNREOFN (delay_TRNREOFN),
    .TRNRERRFWDN (delay_TRNRERRFWDN),
    .TRNRREMN (delay_TRNRREMN),
    .TRNRSOFN (delay_TRNRSOFN),
    .TRNRSRCDSCN (delay_TRNRSRCDSCN),
    .TRNRSRCRDYN (delay_TRNRSRCRDYN),
    .TRNTBUFAV (delay_TRNTBUFAV),
    .TRNTCFGREQN (delay_TRNTCFGREQN),
    .TRNTDLLPDSTRDYN (delay_TRNTDLLPDSTRDYN),
    .TRNTDSTRDYN (delay_TRNTDSTRDYN),
    .TRNTERRDROPN (delay_TRNTERRDROPN),
    .USERRSTN (delay_USERRSTN),
    .CFGBYTEENN (delay_CFGBYTEENN),
    .CFGDI (delay_CFGDI),
    .CFGDSBUSNUMBER (delay_CFGDSBUSNUMBER),
    .CFGDSDEVICENUMBER (delay_CFGDSDEVICENUMBER),
    .CFGDSFUNCTIONNUMBER (delay_CFGDSFUNCTIONNUMBER),
    .CFGDSN (delay_CFGDSN),
    .CFGDWADDR (delay_CFGDWADDR),
    .CFGERRACSN (delay_CFGERRACSN),
    .CFGERRAERHEADERLOG (delay_CFGERRAERHEADERLOG),
    .CFGERRCORN (delay_CFGERRCORN),
    .CFGERRCPLABORTN (delay_CFGERRCPLABORTN),
    .CFGERRCPLTIMEOUTN (delay_CFGERRCPLTIMEOUTN),
    .CFGERRCPLUNEXPECTN (delay_CFGERRCPLUNEXPECTN),
    .CFGERRECRCN (delay_CFGERRECRCN),
    .CFGERRLOCKEDN (delay_CFGERRLOCKEDN),
    .CFGERRPOSTEDN (delay_CFGERRPOSTEDN),
    .CFGERRTLPCPLHEADER (delay_CFGERRTLPCPLHEADER),
    .CFGERRURN (delay_CFGERRURN),
    .CFGINTERRUPTASSERTN (delay_CFGINTERRUPTASSERTN),
    .CFGINTERRUPTDI (delay_CFGINTERRUPTDI),
    .CFGINTERRUPTN (delay_CFGINTERRUPTN),
    .CFGPMDIRECTASPML1N (delay_CFGPMDIRECTASPML1N),
    .CFGPMSENDPMACKN (delay_CFGPMSENDPMACKN),
    .CFGPMSENDPMETON (delay_CFGPMSENDPMETON),
    .CFGPMSENDPMNAKN (delay_CFGPMSENDPMNAKN),
    .CFGPMTURNOFFOKN (delay_CFGPMTURNOFFOKN),
    .CFGPMWAKEN (delay_CFGPMWAKEN),
    .CFGPORTNUMBER (delay_CFGPORTNUMBER),
    .CFGRDENN (delay_CFGRDENN),
    .CFGTRNPENDINGN (delay_CFGTRNPENDINGN),
    .CFGWRENN (delay_CFGWRENN),
    .CFGWRREADONLYN (delay_CFGWRREADONLYN),
    .CFGWRRW1CASRWN (delay_CFGWRRW1CASRWN),
    .CMRSTN (delay_CMRSTN),
    .CMSTICKYRSTN (delay_CMSTICKYRSTN),
    .DBGMODE (delay_DBGMODE),
    .DBGSUBMODE (delay_DBGSUBMODE),
    .DLRSTN (delay_DLRSTN),
    .DRPCLK (delay_DRPCLK),
    .DRPDADDR (delay_DRPDADDR),
    .DRPDEN (delay_DRPDEN),
    .DRPDI (delay_DRPDI),
    .DRPDWE (delay_DRPDWE),
    .FUNCLVLRSTN (delay_FUNCLVLRSTN),
    .LL2SENDASREQL1N (delay_LL2SENDASREQL1N),
    .LL2SENDENTERL1N (delay_LL2SENDENTERL1N),
    .LL2SENDENTERL23N (delay_LL2SENDENTERL23N),
    .LL2SUSPENDNOWN (delay_LL2SUSPENDNOWN),
    .LL2TLPRCVN (delay_LL2TLPRCVN),
    .MIMRXRDATA (delay_MIMRXRDATA),
    .MIMTXRDATA (delay_MIMTXRDATA),
    .PIPECLK (delay_PIPECLK),
    .PIPERX0CHANISALIGNED (delay_PIPERX0CHANISALIGNED),
    .PIPERX0CHARISK (delay_PIPERX0CHARISK),
    .PIPERX0DATA (delay_PIPERX0DATA),
    .PIPERX0ELECIDLE (delay_PIPERX0ELECIDLE),
    .PIPERX0PHYSTATUS (delay_PIPERX0PHYSTATUS),
    .PIPERX0STATUS (delay_PIPERX0STATUS),
    .PIPERX0VALID (delay_PIPERX0VALID),
    .PIPERX1CHANISALIGNED (delay_PIPERX1CHANISALIGNED),
    .PIPERX1CHARISK (delay_PIPERX1CHARISK),
    .PIPERX1DATA (delay_PIPERX1DATA),
    .PIPERX1ELECIDLE (delay_PIPERX1ELECIDLE),
    .PIPERX1PHYSTATUS (delay_PIPERX1PHYSTATUS),
    .PIPERX1STATUS (delay_PIPERX1STATUS),
    .PIPERX1VALID (delay_PIPERX1VALID),
    .PIPERX2CHANISALIGNED (delay_PIPERX2CHANISALIGNED),
    .PIPERX2CHARISK (delay_PIPERX2CHARISK),
    .PIPERX2DATA (delay_PIPERX2DATA),
    .PIPERX2ELECIDLE (delay_PIPERX2ELECIDLE),
    .PIPERX2PHYSTATUS (delay_PIPERX2PHYSTATUS),
    .PIPERX2STATUS (delay_PIPERX2STATUS),
    .PIPERX2VALID (delay_PIPERX2VALID),
    .PIPERX3CHANISALIGNED (delay_PIPERX3CHANISALIGNED),
    .PIPERX3CHARISK (delay_PIPERX3CHARISK),
    .PIPERX3DATA (delay_PIPERX3DATA),
    .PIPERX3ELECIDLE (delay_PIPERX3ELECIDLE),
    .PIPERX3PHYSTATUS (delay_PIPERX3PHYSTATUS),
    .PIPERX3STATUS (delay_PIPERX3STATUS),
    .PIPERX3VALID (delay_PIPERX3VALID),
    .PIPERX4CHANISALIGNED (delay_PIPERX4CHANISALIGNED),
    .PIPERX4CHARISK (delay_PIPERX4CHARISK),
    .PIPERX4DATA (delay_PIPERX4DATA),
    .PIPERX4ELECIDLE (delay_PIPERX4ELECIDLE),
    .PIPERX4PHYSTATUS (delay_PIPERX4PHYSTATUS),
    .PIPERX4STATUS (delay_PIPERX4STATUS),
    .PIPERX4VALID (delay_PIPERX4VALID),
    .PIPERX5CHANISALIGNED (delay_PIPERX5CHANISALIGNED),
    .PIPERX5CHARISK (delay_PIPERX5CHARISK),
    .PIPERX5DATA (delay_PIPERX5DATA),
    .PIPERX5ELECIDLE (delay_PIPERX5ELECIDLE),
    .PIPERX5PHYSTATUS (delay_PIPERX5PHYSTATUS),
    .PIPERX5STATUS (delay_PIPERX5STATUS),
    .PIPERX5VALID (delay_PIPERX5VALID),
    .PIPERX6CHANISALIGNED (delay_PIPERX6CHANISALIGNED),
    .PIPERX6CHARISK (delay_PIPERX6CHARISK),
    .PIPERX6DATA (delay_PIPERX6DATA),
    .PIPERX6ELECIDLE (delay_PIPERX6ELECIDLE),
    .PIPERX6PHYSTATUS (delay_PIPERX6PHYSTATUS),
    .PIPERX6STATUS (delay_PIPERX6STATUS),
    .PIPERX6VALID (delay_PIPERX6VALID),
    .PIPERX7CHANISALIGNED (delay_PIPERX7CHANISALIGNED),
    .PIPERX7CHARISK (delay_PIPERX7CHARISK),
    .PIPERX7DATA (delay_PIPERX7DATA),
    .PIPERX7ELECIDLE (delay_PIPERX7ELECIDLE),
    .PIPERX7PHYSTATUS (delay_PIPERX7PHYSTATUS),
    .PIPERX7STATUS (delay_PIPERX7STATUS),
    .PIPERX7VALID (delay_PIPERX7VALID),
    .PL2DIRECTEDLSTATE (delay_PL2DIRECTEDLSTATE),
    .PLDBGMODE (delay_PLDBGMODE),
    .PLDIRECTEDLINKAUTON (delay_PLDIRECTEDLINKAUTON),
    .PLDIRECTEDLINKCHANGE (delay_PLDIRECTEDLINKCHANGE),
    .PLDIRECTEDLINKSPEED (delay_PLDIRECTEDLINKSPEED),
    .PLDIRECTEDLINKWIDTH (delay_PLDIRECTEDLINKWIDTH),
    .PLDOWNSTREAMDEEMPHSOURCE (delay_PLDOWNSTREAMDEEMPHSOURCE),
    .PLRSTN (delay_PLRSTN),
    .PLTRANSMITHOTRST (delay_PLTRANSMITHOTRST),
    .PLUPSTREAMPREFERDEEMPH (delay_PLUPSTREAMPREFERDEEMPH),
    .SYSRSTN (delay_SYSRSTN),
    .TL2ASPMSUSPENDCREDITCHECKN (delay_TL2ASPMSUSPENDCREDITCHECKN),
    .TL2PPMSUSPENDREQN (delay_TL2PPMSUSPENDREQN),
    .TLRSTN (delay_TLRSTN),
    .TRNFCSEL (delay_TRNFCSEL),
    .TRNRDSTRDYN (delay_TRNRDSTRDYN),
    .TRNRNPOKN (delay_TRNRNPOKN),
    .TRNTCFGGNTN (delay_TRNTCFGGNTN),
    .TRNTD (delay_TRNTD),
    .TRNTDLLPDATA (delay_TRNTDLLPDATA),
    .TRNTDLLPSRCRDYN (delay_TRNTDLLPSRCRDYN),
    .TRNTECRCGENN (delay_TRNTECRCGENN),
    .TRNTEOFN (delay_TRNTEOFN),
    .TRNTERRFWDN (delay_TRNTERRFWDN),
    .TRNTREMN (delay_TRNTREMN),
    .TRNTSOFN (delay_TRNTSOFN),
    .TRNTSRCDSCN (delay_TRNTSRCDSCN),
    .TRNTSRCRDYN (delay_TRNTSRCRDYN),
    .TRNTSTRN (delay_TRNTSTRN),
    .USERCLK (delay_USERCLK),
    .GSR(GSR)   
  );

  specify
    $period (posedge DRPCLK, 0:0:0, notifier);
    $period (posedge PIPECLK, 0:0:0, notifier);
    $period (posedge USERCLK, 0:0:0, notifier);

    $setuphold (posedge DRPCLK, negedge DRPDADDR[0], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[0]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[1], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[1]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[2], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[2]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[3], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[3]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[4], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[4]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[5], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[5]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[6], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[6]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[7], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[7]);
    $setuphold (posedge DRPCLK, negedge DRPDADDR[8], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[8]);
    $setuphold (posedge DRPCLK, negedge DRPDEN, 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDEN);
    $setuphold (posedge DRPCLK, negedge DRPDI[0], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[0]);
    $setuphold (posedge DRPCLK, negedge DRPDI[10], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[10]);
    $setuphold (posedge DRPCLK, negedge DRPDI[11], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[11]);
    $setuphold (posedge DRPCLK, negedge DRPDI[12], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[12]);
    $setuphold (posedge DRPCLK, negedge DRPDI[13], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[13]);
    $setuphold (posedge DRPCLK, negedge DRPDI[14], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[14]);
    $setuphold (posedge DRPCLK, negedge DRPDI[15], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[15]);
    $setuphold (posedge DRPCLK, negedge DRPDI[1], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[1]);
    $setuphold (posedge DRPCLK, negedge DRPDI[2], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[2]);
    $setuphold (posedge DRPCLK, negedge DRPDI[3], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[3]);
    $setuphold (posedge DRPCLK, negedge DRPDI[4], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[4]);
    $setuphold (posedge DRPCLK, negedge DRPDI[5], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[5]);
    $setuphold (posedge DRPCLK, negedge DRPDI[6], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[6]);
    $setuphold (posedge DRPCLK, negedge DRPDI[7], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[7]);
    $setuphold (posedge DRPCLK, negedge DRPDI[8], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[8]);
    $setuphold (posedge DRPCLK, negedge DRPDI[9], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[9]);
    $setuphold (posedge DRPCLK, negedge DRPDWE, 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDWE);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[0], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[0]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[1], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[1]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[2], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[2]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[3], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[3]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[4], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[4]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[5], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[5]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[6], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[6]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[7], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[7]);
    $setuphold (posedge DRPCLK, posedge DRPDADDR[8], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDADDR[8]);
    $setuphold (posedge DRPCLK, posedge DRPDEN, 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDEN);
    $setuphold (posedge DRPCLK, posedge DRPDI[0], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[0]);
    $setuphold (posedge DRPCLK, posedge DRPDI[10], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[10]);
    $setuphold (posedge DRPCLK, posedge DRPDI[11], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[11]);
    $setuphold (posedge DRPCLK, posedge DRPDI[12], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[12]);
    $setuphold (posedge DRPCLK, posedge DRPDI[13], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[13]);
    $setuphold (posedge DRPCLK, posedge DRPDI[14], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[14]);
    $setuphold (posedge DRPCLK, posedge DRPDI[15], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[15]);
    $setuphold (posedge DRPCLK, posedge DRPDI[1], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[1]);
    $setuphold (posedge DRPCLK, posedge DRPDI[2], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[2]);
    $setuphold (posedge DRPCLK, posedge DRPDI[3], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[3]);
    $setuphold (posedge DRPCLK, posedge DRPDI[4], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[4]);
    $setuphold (posedge DRPCLK, posedge DRPDI[5], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[5]);
    $setuphold (posedge DRPCLK, posedge DRPDI[6], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[6]);
    $setuphold (posedge DRPCLK, posedge DRPDI[7], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[7]);
    $setuphold (posedge DRPCLK, posedge DRPDI[8], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[8]);
    $setuphold (posedge DRPCLK, posedge DRPDI[9], 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDI[9]);
    $setuphold (posedge DRPCLK, posedge DRPDWE, 0:0:0, 0:0:0, notifier,,, delay_DRPCLK, delay_DRPDWE);
    $setuphold (posedge PIPECLK, negedge PIPERX0CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX0CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX0CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX0DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX0ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX0PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX0STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX0STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX0STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX0VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX1CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX1CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX1CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX1DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX1ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX1PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX1STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX1STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX1STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX1VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX2CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX2CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX2CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX2DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX2ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX2PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX2STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX2STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX2STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX2VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX3CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX3CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX3CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX3DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX3ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX3PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX3STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX3STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX3STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX3VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX4CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX4CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX4CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX4DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX4ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX4PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX4STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX4STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX4STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX4VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX5CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX5CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX5CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX5DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX5ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX5PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX5STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX5STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX5STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX5VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX6CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX6CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX6CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX6DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX6ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX6PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX6STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX6STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX6STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX6VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6VALID);
    $setuphold (posedge PIPECLK, negedge PIPERX7CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHANISALIGNED);
    $setuphold (posedge PIPECLK, negedge PIPERX7CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHARISK[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX7CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHARISK[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[10]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[11]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[12]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[13]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[14]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[15]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[3]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[4]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[5]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[6]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[7]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[8]);
    $setuphold (posedge PIPECLK, negedge PIPERX7DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[9]);
    $setuphold (posedge PIPECLK, negedge PIPERX7ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7ELECIDLE);
    $setuphold (posedge PIPECLK, negedge PIPERX7PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7PHYSTATUS);
    $setuphold (posedge PIPECLK, negedge PIPERX7STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[0]);
    $setuphold (posedge PIPECLK, negedge PIPERX7STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[1]);
    $setuphold (posedge PIPECLK, negedge PIPERX7STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[2]);
    $setuphold (posedge PIPECLK, negedge PIPERX7VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7VALID);
    $setuphold (posedge PIPECLK, negedge PLDBGMODE[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[0]);
    $setuphold (posedge PIPECLK, negedge PLDBGMODE[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[1]);
    $setuphold (posedge PIPECLK, negedge PLDBGMODE[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[2]);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKAUTON, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKAUTON);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKCHANGE[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKCHANGE[0]);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKCHANGE[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKCHANGE[1]);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKSPEED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKSPEED);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKWIDTH[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKWIDTH[0]);
    $setuphold (posedge PIPECLK, negedge PLDIRECTEDLINKWIDTH[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKWIDTH[1]);
    $setuphold (posedge PIPECLK, negedge PLDOWNSTREAMDEEMPHSOURCE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDOWNSTREAMDEEMPHSOURCE);
    $setuphold (posedge PIPECLK, negedge PLRSTN, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLRSTN);
    $setuphold (posedge PIPECLK, negedge PLTRANSMITHOTRST, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLTRANSMITHOTRST);
    $setuphold (posedge PIPECLK, negedge PLUPSTREAMPREFERDEEMPH, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLUPSTREAMPREFERDEEMPH);
    $setuphold (posedge PIPECLK, posedge PIPERX0CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX0CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX0CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX0DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX0ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX0PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX0STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX0STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX0STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX0VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX0VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX1CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX1CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX1CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX1DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX1ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX1PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX1STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX1STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX1STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX1VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX1VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX2CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX2CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX2CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX2DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX2ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX2PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX2STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX2STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX2STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX2VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX2VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX3CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX3CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX3CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX3DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX3ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX3PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX3STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX3STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX3STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX3VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX3VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX4CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX4CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX4CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX4DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX4ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX4PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX4STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX4STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX4STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX4VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX4VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX5CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX5CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX5CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX5DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX5ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX5PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX5STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX5STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX5STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX5VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX5VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX6CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX6CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX6CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX6DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX6ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX6PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX6STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX6STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX6STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX6VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX6VALID);
    $setuphold (posedge PIPECLK, posedge PIPERX7CHANISALIGNED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHANISALIGNED);
    $setuphold (posedge PIPECLK, posedge PIPERX7CHARISK[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHARISK[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX7CHARISK[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7CHARISK[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[10], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[10]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[11], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[11]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[12], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[12]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[13], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[13]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[14], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[14]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[15], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[15]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[3], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[3]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[4], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[4]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[5], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[5]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[6], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[6]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[7], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[7]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[8], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[8]);
    $setuphold (posedge PIPECLK, posedge PIPERX7DATA[9], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7DATA[9]);
    $setuphold (posedge PIPECLK, posedge PIPERX7ELECIDLE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7ELECIDLE);
    $setuphold (posedge PIPECLK, posedge PIPERX7PHYSTATUS, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7PHYSTATUS);
    $setuphold (posedge PIPECLK, posedge PIPERX7STATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[0]);
    $setuphold (posedge PIPECLK, posedge PIPERX7STATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[1]);
    $setuphold (posedge PIPECLK, posedge PIPERX7STATUS[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7STATUS[2]);
    $setuphold (posedge PIPECLK, posedge PIPERX7VALID, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PIPERX7VALID);
    $setuphold (posedge PIPECLK, posedge PLDBGMODE[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[0]);
    $setuphold (posedge PIPECLK, posedge PLDBGMODE[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[1]);
    $setuphold (posedge PIPECLK, posedge PLDBGMODE[2], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDBGMODE[2]);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKAUTON, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKAUTON);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKCHANGE[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKCHANGE[0]);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKCHANGE[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKCHANGE[1]);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKSPEED, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKSPEED);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKWIDTH[0], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKWIDTH[0]);
    $setuphold (posedge PIPECLK, posedge PLDIRECTEDLINKWIDTH[1], 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDIRECTEDLINKWIDTH[1]);
    $setuphold (posedge PIPECLK, posedge PLDOWNSTREAMDEEMPHSOURCE, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLDOWNSTREAMDEEMPHSOURCE);
    $setuphold (posedge PIPECLK, posedge PLRSTN, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLRSTN);
    $setuphold (posedge PIPECLK, posedge PLTRANSMITHOTRST, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLTRANSMITHOTRST);
    $setuphold (posedge PIPECLK, posedge PLUPSTREAMPREFERDEEMPH, 0:0:0, 0:0:0, notifier,,, delay_PIPECLK, delay_PLUPSTREAMPREFERDEEMPH);
    $setuphold (posedge USERCLK, negedge CFGBYTEENN[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[0]);
    $setuphold (posedge USERCLK, negedge CFGBYTEENN[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[1]);
    $setuphold (posedge USERCLK, negedge CFGBYTEENN[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[2]);
    $setuphold (posedge USERCLK, negedge CFGBYTEENN[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[3]);
    $setuphold (posedge USERCLK, negedge CFGDI[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[0]);
    $setuphold (posedge USERCLK, negedge CFGDI[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[10]);
    $setuphold (posedge USERCLK, negedge CFGDI[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[11]);
    $setuphold (posedge USERCLK, negedge CFGDI[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[12]);
    $setuphold (posedge USERCLK, negedge CFGDI[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[13]);
    $setuphold (posedge USERCLK, negedge CFGDI[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[14]);
    $setuphold (posedge USERCLK, negedge CFGDI[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[15]);
    $setuphold (posedge USERCLK, negedge CFGDI[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[16]);
    $setuphold (posedge USERCLK, negedge CFGDI[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[17]);
    $setuphold (posedge USERCLK, negedge CFGDI[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[18]);
    $setuphold (posedge USERCLK, negedge CFGDI[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[19]);
    $setuphold (posedge USERCLK, negedge CFGDI[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[1]);
    $setuphold (posedge USERCLK, negedge CFGDI[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[20]);
    $setuphold (posedge USERCLK, negedge CFGDI[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[21]);
    $setuphold (posedge USERCLK, negedge CFGDI[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[22]);
    $setuphold (posedge USERCLK, negedge CFGDI[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[23]);
    $setuphold (posedge USERCLK, negedge CFGDI[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[24]);
    $setuphold (posedge USERCLK, negedge CFGDI[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[25]);
    $setuphold (posedge USERCLK, negedge CFGDI[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[26]);
    $setuphold (posedge USERCLK, negedge CFGDI[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[27]);
    $setuphold (posedge USERCLK, negedge CFGDI[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[28]);
    $setuphold (posedge USERCLK, negedge CFGDI[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[29]);
    $setuphold (posedge USERCLK, negedge CFGDI[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[2]);
    $setuphold (posedge USERCLK, negedge CFGDI[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[30]);
    $setuphold (posedge USERCLK, negedge CFGDI[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[31]);
    $setuphold (posedge USERCLK, negedge CFGDI[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[3]);
    $setuphold (posedge USERCLK, negedge CFGDI[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[4]);
    $setuphold (posedge USERCLK, negedge CFGDI[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[5]);
    $setuphold (posedge USERCLK, negedge CFGDI[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[6]);
    $setuphold (posedge USERCLK, negedge CFGDI[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[7]);
    $setuphold (posedge USERCLK, negedge CFGDI[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[8]);
    $setuphold (posedge USERCLK, negedge CFGDI[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[9]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[0]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[1]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[2]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[3]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[4]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[5]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[6]);
    $setuphold (posedge USERCLK, negedge CFGDSBUSNUMBER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[7]);
    $setuphold (posedge USERCLK, negedge CFGDSDEVICENUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[0]);
    $setuphold (posedge USERCLK, negedge CFGDSDEVICENUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[1]);
    $setuphold (posedge USERCLK, negedge CFGDSDEVICENUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[2]);
    $setuphold (posedge USERCLK, negedge CFGDSDEVICENUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[3]);
    $setuphold (posedge USERCLK, negedge CFGDSDEVICENUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[4]);
    $setuphold (posedge USERCLK, negedge CFGDSFUNCTIONNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[0]);
    $setuphold (posedge USERCLK, negedge CFGDSFUNCTIONNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[1]);
    $setuphold (posedge USERCLK, negedge CFGDSFUNCTIONNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[2]);
    $setuphold (posedge USERCLK, negedge CFGDSN[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[0]);
    $setuphold (posedge USERCLK, negedge CFGDSN[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[10]);
    $setuphold (posedge USERCLK, negedge CFGDSN[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[11]);
    $setuphold (posedge USERCLK, negedge CFGDSN[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[12]);
    $setuphold (posedge USERCLK, negedge CFGDSN[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[13]);
    $setuphold (posedge USERCLK, negedge CFGDSN[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[14]);
    $setuphold (posedge USERCLK, negedge CFGDSN[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[15]);
    $setuphold (posedge USERCLK, negedge CFGDSN[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[16]);
    $setuphold (posedge USERCLK, negedge CFGDSN[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[17]);
    $setuphold (posedge USERCLK, negedge CFGDSN[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[18]);
    $setuphold (posedge USERCLK, negedge CFGDSN[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[19]);
    $setuphold (posedge USERCLK, negedge CFGDSN[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[1]);
    $setuphold (posedge USERCLK, negedge CFGDSN[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[20]);
    $setuphold (posedge USERCLK, negedge CFGDSN[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[21]);
    $setuphold (posedge USERCLK, negedge CFGDSN[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[22]);
    $setuphold (posedge USERCLK, negedge CFGDSN[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[23]);
    $setuphold (posedge USERCLK, negedge CFGDSN[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[24]);
    $setuphold (posedge USERCLK, negedge CFGDSN[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[25]);
    $setuphold (posedge USERCLK, negedge CFGDSN[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[26]);
    $setuphold (posedge USERCLK, negedge CFGDSN[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[27]);
    $setuphold (posedge USERCLK, negedge CFGDSN[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[28]);
    $setuphold (posedge USERCLK, negedge CFGDSN[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[29]);
    $setuphold (posedge USERCLK, negedge CFGDSN[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[2]);
    $setuphold (posedge USERCLK, negedge CFGDSN[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[30]);
    $setuphold (posedge USERCLK, negedge CFGDSN[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[31]);
    $setuphold (posedge USERCLK, negedge CFGDSN[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[32]);
    $setuphold (posedge USERCLK, negedge CFGDSN[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[33]);
    $setuphold (posedge USERCLK, negedge CFGDSN[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[34]);
    $setuphold (posedge USERCLK, negedge CFGDSN[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[35]);
    $setuphold (posedge USERCLK, negedge CFGDSN[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[36]);
    $setuphold (posedge USERCLK, negedge CFGDSN[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[37]);
    $setuphold (posedge USERCLK, negedge CFGDSN[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[38]);
    $setuphold (posedge USERCLK, negedge CFGDSN[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[39]);
    $setuphold (posedge USERCLK, negedge CFGDSN[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[3]);
    $setuphold (posedge USERCLK, negedge CFGDSN[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[40]);
    $setuphold (posedge USERCLK, negedge CFGDSN[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[41]);
    $setuphold (posedge USERCLK, negedge CFGDSN[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[42]);
    $setuphold (posedge USERCLK, negedge CFGDSN[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[43]);
    $setuphold (posedge USERCLK, negedge CFGDSN[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[44]);
    $setuphold (posedge USERCLK, negedge CFGDSN[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[45]);
    $setuphold (posedge USERCLK, negedge CFGDSN[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[46]);
    $setuphold (posedge USERCLK, negedge CFGDSN[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[47]);
    $setuphold (posedge USERCLK, negedge CFGDSN[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[48]);
    $setuphold (posedge USERCLK, negedge CFGDSN[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[49]);
    $setuphold (posedge USERCLK, negedge CFGDSN[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[4]);
    $setuphold (posedge USERCLK, negedge CFGDSN[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[50]);
    $setuphold (posedge USERCLK, negedge CFGDSN[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[51]);
    $setuphold (posedge USERCLK, negedge CFGDSN[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[52]);
    $setuphold (posedge USERCLK, negedge CFGDSN[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[53]);
    $setuphold (posedge USERCLK, negedge CFGDSN[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[54]);
    $setuphold (posedge USERCLK, negedge CFGDSN[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[55]);
    $setuphold (posedge USERCLK, negedge CFGDSN[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[56]);
    $setuphold (posedge USERCLK, negedge CFGDSN[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[57]);
    $setuphold (posedge USERCLK, negedge CFGDSN[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[58]);
    $setuphold (posedge USERCLK, negedge CFGDSN[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[59]);
    $setuphold (posedge USERCLK, negedge CFGDSN[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[5]);
    $setuphold (posedge USERCLK, negedge CFGDSN[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[60]);
    $setuphold (posedge USERCLK, negedge CFGDSN[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[61]);
    $setuphold (posedge USERCLK, negedge CFGDSN[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[62]);
    $setuphold (posedge USERCLK, negedge CFGDSN[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[63]);
    $setuphold (posedge USERCLK, negedge CFGDSN[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[6]);
    $setuphold (posedge USERCLK, negedge CFGDSN[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[7]);
    $setuphold (posedge USERCLK, negedge CFGDSN[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[8]);
    $setuphold (posedge USERCLK, negedge CFGDSN[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[9]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[0]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[1]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[2]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[3]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[4]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[5]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[6]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[7]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[8]);
    $setuphold (posedge USERCLK, negedge CFGDWADDR[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[9]);
    $setuphold (posedge USERCLK, negedge CFGERRACSN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRACSN);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[0]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[100], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[100]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[101], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[101]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[102], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[102]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[103], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[103]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[104], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[104]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[105], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[105]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[106], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[106]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[107], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[107]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[108], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[108]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[109], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[109]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[10]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[110], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[110]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[111], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[111]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[112], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[112]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[113], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[113]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[114], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[114]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[115], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[115]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[116], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[116]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[117], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[117]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[118], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[118]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[119], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[119]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[11]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[120], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[120]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[121], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[121]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[122], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[122]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[123], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[123]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[124], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[124]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[125], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[125]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[126], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[126]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[127], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[127]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[12]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[13]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[14]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[15]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[16]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[17]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[18]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[19]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[1]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[20]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[21]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[22]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[23]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[24]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[25]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[26]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[27]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[28]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[29]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[2]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[30]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[31]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[32]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[33]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[34]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[35]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[36]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[37]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[38]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[39]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[3]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[40]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[41]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[42]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[43]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[44]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[45]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[46]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[47]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[48]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[49]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[4]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[50]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[51]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[52]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[53]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[54]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[55]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[56]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[57]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[58]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[59]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[5]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[60]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[61]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[62]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[63]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[64]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[65]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[66]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[67]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[68], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[68]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[69], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[69]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[6]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[70], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[70]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[71], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[71]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[72], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[72]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[73], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[73]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[74], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[74]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[75], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[75]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[76], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[76]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[77], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[77]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[78], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[78]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[79], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[79]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[7]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[80], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[80]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[81], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[81]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[82], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[82]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[83], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[83]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[84], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[84]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[85], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[85]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[86], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[86]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[87], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[87]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[88], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[88]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[89], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[89]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[8]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[90], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[90]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[91], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[91]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[92], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[92]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[93], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[93]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[94], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[94]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[95], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[95]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[96], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[96]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[97], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[97]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[98], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[98]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[99], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[99]);
    $setuphold (posedge USERCLK, negedge CFGERRAERHEADERLOG[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[9]);
    $setuphold (posedge USERCLK, negedge CFGERRCORN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCORN);
    $setuphold (posedge USERCLK, negedge CFGERRCPLABORTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLABORTN);
    $setuphold (posedge USERCLK, negedge CFGERRCPLTIMEOUTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLTIMEOUTN);
    $setuphold (posedge USERCLK, negedge CFGERRCPLUNEXPECTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLUNEXPECTN);
    $setuphold (posedge USERCLK, negedge CFGERRECRCN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRECRCN);
    $setuphold (posedge USERCLK, negedge CFGERRLOCKEDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRLOCKEDN);
    $setuphold (posedge USERCLK, negedge CFGERRPOSTEDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRPOSTEDN);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[0]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[10]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[11]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[12]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[13]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[14]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[15]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[16]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[17]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[18]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[19]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[1]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[20]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[21]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[22]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[23]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[24]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[25]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[26]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[27]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[28]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[29]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[2]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[30]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[31]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[32]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[33]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[34]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[35]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[36]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[37]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[38]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[39]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[3]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[40]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[41]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[42]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[43]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[44]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[45]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[46]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[47]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[4]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[5]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[6]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[7]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[8]);
    $setuphold (posedge USERCLK, negedge CFGERRTLPCPLHEADER[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[9]);
    $setuphold (posedge USERCLK, negedge CFGERRURN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRURN);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTASSERTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTASSERTN);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[0]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[1]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[2]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[3]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[4]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[5]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[6]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTDI[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[7]);
    $setuphold (posedge USERCLK, negedge CFGINTERRUPTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTN);
    $setuphold (posedge USERCLK, negedge CFGPMDIRECTASPML1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMDIRECTASPML1N);
    $setuphold (posedge USERCLK, negedge CFGPMSENDPMACKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMACKN);
    $setuphold (posedge USERCLK, negedge CFGPMSENDPMETON, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMETON);
    $setuphold (posedge USERCLK, negedge CFGPMSENDPMNAKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMNAKN);
    $setuphold (posedge USERCLK, negedge CFGPMTURNOFFOKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMTURNOFFOKN);
    $setuphold (posedge USERCLK, negedge CFGPMWAKEN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMWAKEN);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[0]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[1]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[2]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[3]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[4]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[5]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[6]);
    $setuphold (posedge USERCLK, negedge CFGPORTNUMBER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[7]);
    $setuphold (posedge USERCLK, negedge CFGRDENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGRDENN);
    $setuphold (posedge USERCLK, negedge CFGTRNPENDINGN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGTRNPENDINGN);
    $setuphold (posedge USERCLK, negedge CFGWRENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRENN);
    $setuphold (posedge USERCLK, negedge CFGWRREADONLYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRREADONLYN);
    $setuphold (posedge USERCLK, negedge CFGWRRW1CASRWN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRRW1CASRWN);
    $setuphold (posedge USERCLK, negedge CMRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CMRSTN);
    $setuphold (posedge USERCLK, negedge CMSTICKYRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CMSTICKYRSTN);
    $setuphold (posedge USERCLK, negedge DBGMODE[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGMODE[0]);
    $setuphold (posedge USERCLK, negedge DBGMODE[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGMODE[1]);
    $setuphold (posedge USERCLK, negedge DBGSUBMODE, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGSUBMODE);
    $setuphold (posedge USERCLK, negedge DLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DLRSTN);
    $setuphold (posedge USERCLK, negedge FUNCLVLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_FUNCLVLRSTN);
    $setuphold (posedge USERCLK, negedge LL2SENDASREQL1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDASREQL1N);
    $setuphold (posedge USERCLK, negedge LL2SENDENTERL1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDENTERL1N);
    $setuphold (posedge USERCLK, negedge LL2SENDENTERL23N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDENTERL23N);
    $setuphold (posedge USERCLK, negedge LL2SUSPENDNOWN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SUSPENDNOWN);
    $setuphold (posedge USERCLK, negedge LL2TLPRCVN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2TLPRCVN);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[0]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[10]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[11]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[12]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[13]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[14]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[15]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[16]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[17]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[18]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[19]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[1]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[20]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[21]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[22]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[23]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[24]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[25]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[26]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[27]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[28]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[29]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[2]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[30]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[31]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[32]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[33]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[34]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[35]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[36]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[37]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[38]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[39]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[3]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[40]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[41]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[42]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[43]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[44]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[45]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[46]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[47]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[48]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[49]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[4]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[50]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[51]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[52]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[53]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[54]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[55]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[56]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[57]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[58]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[59]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[5]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[60]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[61]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[62]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[63]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[64]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[65]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[66]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[67]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[6]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[7]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[8]);
    $setuphold (posedge USERCLK, negedge MIMRXRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[9]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[0]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[10]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[11]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[12]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[13]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[14]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[15]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[16]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[17]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[18]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[19]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[1]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[20]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[21]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[22]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[23]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[24]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[25]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[26]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[27]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[28]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[29]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[2]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[30]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[31]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[32]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[33]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[34]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[35]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[36]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[37]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[38]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[39]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[3]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[40]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[41]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[42]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[43]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[44]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[45]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[46]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[47]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[48]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[49]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[4]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[50]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[51]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[52]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[53]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[54]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[55]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[56]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[57]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[58]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[59]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[5]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[60]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[61]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[62]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[63]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[64]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[65]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[66]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[67]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[68], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[68]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[6]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[7]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[8]);
    $setuphold (posedge USERCLK, negedge MIMTXRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[9]);
    $setuphold (posedge USERCLK, negedge PL2DIRECTEDLSTATE[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[0]);
    $setuphold (posedge USERCLK, negedge PL2DIRECTEDLSTATE[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[1]);
    $setuphold (posedge USERCLK, negedge PL2DIRECTEDLSTATE[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[2]);
    $setuphold (posedge USERCLK, negedge PL2DIRECTEDLSTATE[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[3]);
    $setuphold (posedge USERCLK, negedge PL2DIRECTEDLSTATE[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[4]);
    $setuphold (posedge USERCLK, negedge TL2ASPMSUSPENDCREDITCHECKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TL2ASPMSUSPENDCREDITCHECKN);
    $setuphold (posedge USERCLK, negedge TL2PPMSUSPENDREQN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TL2PPMSUSPENDREQN);
    $setuphold (posedge USERCLK, negedge TLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TLRSTN);
    $setuphold (posedge USERCLK, negedge TRNFCSEL[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[0]);
    $setuphold (posedge USERCLK, negedge TRNFCSEL[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[1]);
    $setuphold (posedge USERCLK, negedge TRNFCSEL[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[2]);
    $setuphold (posedge USERCLK, negedge TRNRDSTRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNRDSTRDYN);
    $setuphold (posedge USERCLK, negedge TRNRNPOKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNRNPOKN);
    $setuphold (posedge USERCLK, negedge TRNTCFGGNTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTCFGGNTN);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[0]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[10]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[11]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[12]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[13]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[14]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[15]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[16]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[17]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[18]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[19]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[1]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[20]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[21]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[22]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[23]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[24]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[25]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[26]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[27]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[28]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[29]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[2]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[30]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[31]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[3]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[4]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[5]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[6]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[7]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[8]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[9]);
    $setuphold (posedge USERCLK, negedge TRNTDLLPSRCRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPSRCRDYN);
    $setuphold (posedge USERCLK, negedge TRNTD[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[0]);
    $setuphold (posedge USERCLK, negedge TRNTD[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[10]);
    $setuphold (posedge USERCLK, negedge TRNTD[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[11]);
    $setuphold (posedge USERCLK, negedge TRNTD[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[12]);
    $setuphold (posedge USERCLK, negedge TRNTD[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[13]);
    $setuphold (posedge USERCLK, negedge TRNTD[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[14]);
    $setuphold (posedge USERCLK, negedge TRNTD[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[15]);
    $setuphold (posedge USERCLK, negedge TRNTD[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[16]);
    $setuphold (posedge USERCLK, negedge TRNTD[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[17]);
    $setuphold (posedge USERCLK, negedge TRNTD[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[18]);
    $setuphold (posedge USERCLK, negedge TRNTD[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[19]);
    $setuphold (posedge USERCLK, negedge TRNTD[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[1]);
    $setuphold (posedge USERCLK, negedge TRNTD[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[20]);
    $setuphold (posedge USERCLK, negedge TRNTD[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[21]);
    $setuphold (posedge USERCLK, negedge TRNTD[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[22]);
    $setuphold (posedge USERCLK, negedge TRNTD[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[23]);
    $setuphold (posedge USERCLK, negedge TRNTD[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[24]);
    $setuphold (posedge USERCLK, negedge TRNTD[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[25]);
    $setuphold (posedge USERCLK, negedge TRNTD[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[26]);
    $setuphold (posedge USERCLK, negedge TRNTD[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[27]);
    $setuphold (posedge USERCLK, negedge TRNTD[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[28]);
    $setuphold (posedge USERCLK, negedge TRNTD[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[29]);
    $setuphold (posedge USERCLK, negedge TRNTD[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[2]);
    $setuphold (posedge USERCLK, negedge TRNTD[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[30]);
    $setuphold (posedge USERCLK, negedge TRNTD[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[31]);
    $setuphold (posedge USERCLK, negedge TRNTD[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[32]);
    $setuphold (posedge USERCLK, negedge TRNTD[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[33]);
    $setuphold (posedge USERCLK, negedge TRNTD[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[34]);
    $setuphold (posedge USERCLK, negedge TRNTD[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[35]);
    $setuphold (posedge USERCLK, negedge TRNTD[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[36]);
    $setuphold (posedge USERCLK, negedge TRNTD[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[37]);
    $setuphold (posedge USERCLK, negedge TRNTD[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[38]);
    $setuphold (posedge USERCLK, negedge TRNTD[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[39]);
    $setuphold (posedge USERCLK, negedge TRNTD[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[3]);
    $setuphold (posedge USERCLK, negedge TRNTD[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[40]);
    $setuphold (posedge USERCLK, negedge TRNTD[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[41]);
    $setuphold (posedge USERCLK, negedge TRNTD[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[42]);
    $setuphold (posedge USERCLK, negedge TRNTD[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[43]);
    $setuphold (posedge USERCLK, negedge TRNTD[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[44]);
    $setuphold (posedge USERCLK, negedge TRNTD[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[45]);
    $setuphold (posedge USERCLK, negedge TRNTD[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[46]);
    $setuphold (posedge USERCLK, negedge TRNTD[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[47]);
    $setuphold (posedge USERCLK, negedge TRNTD[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[48]);
    $setuphold (posedge USERCLK, negedge TRNTD[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[49]);
    $setuphold (posedge USERCLK, negedge TRNTD[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[4]);
    $setuphold (posedge USERCLK, negedge TRNTD[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[50]);
    $setuphold (posedge USERCLK, negedge TRNTD[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[51]);
    $setuphold (posedge USERCLK, negedge TRNTD[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[52]);
    $setuphold (posedge USERCLK, negedge TRNTD[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[53]);
    $setuphold (posedge USERCLK, negedge TRNTD[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[54]);
    $setuphold (posedge USERCLK, negedge TRNTD[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[55]);
    $setuphold (posedge USERCLK, negedge TRNTD[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[56]);
    $setuphold (posedge USERCLK, negedge TRNTD[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[57]);
    $setuphold (posedge USERCLK, negedge TRNTD[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[58]);
    $setuphold (posedge USERCLK, negedge TRNTD[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[59]);
    $setuphold (posedge USERCLK, negedge TRNTD[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[5]);
    $setuphold (posedge USERCLK, negedge TRNTD[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[60]);
    $setuphold (posedge USERCLK, negedge TRNTD[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[61]);
    $setuphold (posedge USERCLK, negedge TRNTD[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[62]);
    $setuphold (posedge USERCLK, negedge TRNTD[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[63]);
    $setuphold (posedge USERCLK, negedge TRNTD[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[6]);
    $setuphold (posedge USERCLK, negedge TRNTD[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[7]);
    $setuphold (posedge USERCLK, negedge TRNTD[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[8]);
    $setuphold (posedge USERCLK, negedge TRNTD[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[9]);
    $setuphold (posedge USERCLK, negedge TRNTECRCGENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTECRCGENN);
    $setuphold (posedge USERCLK, negedge TRNTEOFN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTEOFN);
    $setuphold (posedge USERCLK, negedge TRNTERRFWDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTERRFWDN);
    $setuphold (posedge USERCLK, negedge TRNTREMN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTREMN);
    $setuphold (posedge USERCLK, negedge TRNTSOFN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSOFN);
    $setuphold (posedge USERCLK, negedge TRNTSRCDSCN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSRCDSCN);
    $setuphold (posedge USERCLK, negedge TRNTSRCRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSRCRDYN);
    $setuphold (posedge USERCLK, negedge TRNTSTRN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSTRN);
    $setuphold (posedge USERCLK, posedge CFGBYTEENN[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[0]);
    $setuphold (posedge USERCLK, posedge CFGBYTEENN[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[1]);
    $setuphold (posedge USERCLK, posedge CFGBYTEENN[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[2]);
    $setuphold (posedge USERCLK, posedge CFGBYTEENN[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGBYTEENN[3]);
    $setuphold (posedge USERCLK, posedge CFGDI[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[0]);
    $setuphold (posedge USERCLK, posedge CFGDI[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[10]);
    $setuphold (posedge USERCLK, posedge CFGDI[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[11]);
    $setuphold (posedge USERCLK, posedge CFGDI[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[12]);
    $setuphold (posedge USERCLK, posedge CFGDI[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[13]);
    $setuphold (posedge USERCLK, posedge CFGDI[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[14]);
    $setuphold (posedge USERCLK, posedge CFGDI[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[15]);
    $setuphold (posedge USERCLK, posedge CFGDI[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[16]);
    $setuphold (posedge USERCLK, posedge CFGDI[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[17]);
    $setuphold (posedge USERCLK, posedge CFGDI[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[18]);
    $setuphold (posedge USERCLK, posedge CFGDI[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[19]);
    $setuphold (posedge USERCLK, posedge CFGDI[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[1]);
    $setuphold (posedge USERCLK, posedge CFGDI[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[20]);
    $setuphold (posedge USERCLK, posedge CFGDI[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[21]);
    $setuphold (posedge USERCLK, posedge CFGDI[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[22]);
    $setuphold (posedge USERCLK, posedge CFGDI[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[23]);
    $setuphold (posedge USERCLK, posedge CFGDI[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[24]);
    $setuphold (posedge USERCLK, posedge CFGDI[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[25]);
    $setuphold (posedge USERCLK, posedge CFGDI[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[26]);
    $setuphold (posedge USERCLK, posedge CFGDI[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[27]);
    $setuphold (posedge USERCLK, posedge CFGDI[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[28]);
    $setuphold (posedge USERCLK, posedge CFGDI[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[29]);
    $setuphold (posedge USERCLK, posedge CFGDI[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[2]);
    $setuphold (posedge USERCLK, posedge CFGDI[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[30]);
    $setuphold (posedge USERCLK, posedge CFGDI[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[31]);
    $setuphold (posedge USERCLK, posedge CFGDI[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[3]);
    $setuphold (posedge USERCLK, posedge CFGDI[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[4]);
    $setuphold (posedge USERCLK, posedge CFGDI[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[5]);
    $setuphold (posedge USERCLK, posedge CFGDI[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[6]);
    $setuphold (posedge USERCLK, posedge CFGDI[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[7]);
    $setuphold (posedge USERCLK, posedge CFGDI[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[8]);
    $setuphold (posedge USERCLK, posedge CFGDI[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDI[9]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[0]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[1]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[2]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[3]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[4]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[5]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[6]);
    $setuphold (posedge USERCLK, posedge CFGDSBUSNUMBER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSBUSNUMBER[7]);
    $setuphold (posedge USERCLK, posedge CFGDSDEVICENUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[0]);
    $setuphold (posedge USERCLK, posedge CFGDSDEVICENUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[1]);
    $setuphold (posedge USERCLK, posedge CFGDSDEVICENUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[2]);
    $setuphold (posedge USERCLK, posedge CFGDSDEVICENUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[3]);
    $setuphold (posedge USERCLK, posedge CFGDSDEVICENUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSDEVICENUMBER[4]);
    $setuphold (posedge USERCLK, posedge CFGDSFUNCTIONNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[0]);
    $setuphold (posedge USERCLK, posedge CFGDSFUNCTIONNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[1]);
    $setuphold (posedge USERCLK, posedge CFGDSFUNCTIONNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSFUNCTIONNUMBER[2]);
    $setuphold (posedge USERCLK, posedge CFGDSN[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[0]);
    $setuphold (posedge USERCLK, posedge CFGDSN[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[10]);
    $setuphold (posedge USERCLK, posedge CFGDSN[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[11]);
    $setuphold (posedge USERCLK, posedge CFGDSN[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[12]);
    $setuphold (posedge USERCLK, posedge CFGDSN[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[13]);
    $setuphold (posedge USERCLK, posedge CFGDSN[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[14]);
    $setuphold (posedge USERCLK, posedge CFGDSN[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[15]);
    $setuphold (posedge USERCLK, posedge CFGDSN[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[16]);
    $setuphold (posedge USERCLK, posedge CFGDSN[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[17]);
    $setuphold (posedge USERCLK, posedge CFGDSN[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[18]);
    $setuphold (posedge USERCLK, posedge CFGDSN[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[19]);
    $setuphold (posedge USERCLK, posedge CFGDSN[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[1]);
    $setuphold (posedge USERCLK, posedge CFGDSN[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[20]);
    $setuphold (posedge USERCLK, posedge CFGDSN[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[21]);
    $setuphold (posedge USERCLK, posedge CFGDSN[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[22]);
    $setuphold (posedge USERCLK, posedge CFGDSN[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[23]);
    $setuphold (posedge USERCLK, posedge CFGDSN[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[24]);
    $setuphold (posedge USERCLK, posedge CFGDSN[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[25]);
    $setuphold (posedge USERCLK, posedge CFGDSN[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[26]);
    $setuphold (posedge USERCLK, posedge CFGDSN[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[27]);
    $setuphold (posedge USERCLK, posedge CFGDSN[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[28]);
    $setuphold (posedge USERCLK, posedge CFGDSN[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[29]);
    $setuphold (posedge USERCLK, posedge CFGDSN[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[2]);
    $setuphold (posedge USERCLK, posedge CFGDSN[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[30]);
    $setuphold (posedge USERCLK, posedge CFGDSN[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[31]);
    $setuphold (posedge USERCLK, posedge CFGDSN[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[32]);
    $setuphold (posedge USERCLK, posedge CFGDSN[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[33]);
    $setuphold (posedge USERCLK, posedge CFGDSN[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[34]);
    $setuphold (posedge USERCLK, posedge CFGDSN[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[35]);
    $setuphold (posedge USERCLK, posedge CFGDSN[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[36]);
    $setuphold (posedge USERCLK, posedge CFGDSN[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[37]);
    $setuphold (posedge USERCLK, posedge CFGDSN[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[38]);
    $setuphold (posedge USERCLK, posedge CFGDSN[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[39]);
    $setuphold (posedge USERCLK, posedge CFGDSN[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[3]);
    $setuphold (posedge USERCLK, posedge CFGDSN[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[40]);
    $setuphold (posedge USERCLK, posedge CFGDSN[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[41]);
    $setuphold (posedge USERCLK, posedge CFGDSN[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[42]);
    $setuphold (posedge USERCLK, posedge CFGDSN[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[43]);
    $setuphold (posedge USERCLK, posedge CFGDSN[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[44]);
    $setuphold (posedge USERCLK, posedge CFGDSN[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[45]);
    $setuphold (posedge USERCLK, posedge CFGDSN[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[46]);
    $setuphold (posedge USERCLK, posedge CFGDSN[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[47]);
    $setuphold (posedge USERCLK, posedge CFGDSN[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[48]);
    $setuphold (posedge USERCLK, posedge CFGDSN[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[49]);
    $setuphold (posedge USERCLK, posedge CFGDSN[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[4]);
    $setuphold (posedge USERCLK, posedge CFGDSN[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[50]);
    $setuphold (posedge USERCLK, posedge CFGDSN[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[51]);
    $setuphold (posedge USERCLK, posedge CFGDSN[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[52]);
    $setuphold (posedge USERCLK, posedge CFGDSN[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[53]);
    $setuphold (posedge USERCLK, posedge CFGDSN[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[54]);
    $setuphold (posedge USERCLK, posedge CFGDSN[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[55]);
    $setuphold (posedge USERCLK, posedge CFGDSN[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[56]);
    $setuphold (posedge USERCLK, posedge CFGDSN[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[57]);
    $setuphold (posedge USERCLK, posedge CFGDSN[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[58]);
    $setuphold (posedge USERCLK, posedge CFGDSN[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[59]);
    $setuphold (posedge USERCLK, posedge CFGDSN[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[5]);
    $setuphold (posedge USERCLK, posedge CFGDSN[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[60]);
    $setuphold (posedge USERCLK, posedge CFGDSN[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[61]);
    $setuphold (posedge USERCLK, posedge CFGDSN[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[62]);
    $setuphold (posedge USERCLK, posedge CFGDSN[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[63]);
    $setuphold (posedge USERCLK, posedge CFGDSN[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[6]);
    $setuphold (posedge USERCLK, posedge CFGDSN[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[7]);
    $setuphold (posedge USERCLK, posedge CFGDSN[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[8]);
    $setuphold (posedge USERCLK, posedge CFGDSN[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDSN[9]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[0]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[1]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[2]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[3]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[4]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[5]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[6]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[7]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[8]);
    $setuphold (posedge USERCLK, posedge CFGDWADDR[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGDWADDR[9]);
    $setuphold (posedge USERCLK, posedge CFGERRACSN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRACSN);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[0]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[100], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[100]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[101], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[101]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[102], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[102]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[103], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[103]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[104], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[104]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[105], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[105]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[106], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[106]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[107], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[107]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[108], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[108]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[109], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[109]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[10]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[110], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[110]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[111], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[111]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[112], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[112]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[113], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[113]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[114], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[114]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[115], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[115]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[116], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[116]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[117], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[117]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[118], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[118]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[119], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[119]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[11]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[120], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[120]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[121], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[121]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[122], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[122]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[123], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[123]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[124], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[124]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[125], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[125]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[126], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[126]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[127], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[127]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[12]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[13]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[14]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[15]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[16]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[17]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[18]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[19]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[1]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[20]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[21]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[22]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[23]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[24]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[25]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[26]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[27]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[28]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[29]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[2]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[30]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[31]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[32]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[33]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[34]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[35]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[36]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[37]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[38]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[39]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[3]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[40]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[41]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[42]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[43]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[44]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[45]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[46]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[47]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[48]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[49]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[4]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[50]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[51]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[52]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[53]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[54]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[55]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[56]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[57]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[58]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[59]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[5]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[60]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[61]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[62]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[63]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[64]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[65]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[66]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[67]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[68], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[68]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[69], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[69]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[6]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[70], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[70]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[71], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[71]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[72], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[72]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[73], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[73]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[74], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[74]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[75], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[75]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[76], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[76]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[77], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[77]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[78], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[78]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[79], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[79]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[7]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[80], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[80]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[81], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[81]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[82], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[82]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[83], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[83]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[84], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[84]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[85], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[85]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[86], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[86]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[87], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[87]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[88], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[88]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[89], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[89]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[8]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[90], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[90]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[91], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[91]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[92], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[92]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[93], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[93]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[94], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[94]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[95], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[95]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[96], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[96]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[97], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[97]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[98], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[98]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[99], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[99]);
    $setuphold (posedge USERCLK, posedge CFGERRAERHEADERLOG[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRAERHEADERLOG[9]);
    $setuphold (posedge USERCLK, posedge CFGERRCORN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCORN);
    $setuphold (posedge USERCLK, posedge CFGERRCPLABORTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLABORTN);
    $setuphold (posedge USERCLK, posedge CFGERRCPLTIMEOUTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLTIMEOUTN);
    $setuphold (posedge USERCLK, posedge CFGERRCPLUNEXPECTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRCPLUNEXPECTN);
    $setuphold (posedge USERCLK, posedge CFGERRECRCN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRECRCN);
    $setuphold (posedge USERCLK, posedge CFGERRLOCKEDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRLOCKEDN);
    $setuphold (posedge USERCLK, posedge CFGERRPOSTEDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRPOSTEDN);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[0]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[10]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[11]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[12]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[13]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[14]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[15]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[16]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[17]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[18]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[19]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[1]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[20]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[21]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[22]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[23]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[24]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[25]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[26]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[27]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[28]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[29]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[2]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[30]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[31]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[32]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[33]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[34]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[35]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[36]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[37]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[38]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[39]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[3]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[40]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[41]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[42]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[43]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[44]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[45]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[46]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[47]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[4]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[5]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[6]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[7]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[8]);
    $setuphold (posedge USERCLK, posedge CFGERRTLPCPLHEADER[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRTLPCPLHEADER[9]);
    $setuphold (posedge USERCLK, posedge CFGERRURN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGERRURN);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTASSERTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTASSERTN);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[0]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[1]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[2]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[3]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[4]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[5]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[6]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTDI[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTDI[7]);
    $setuphold (posedge USERCLK, posedge CFGINTERRUPTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGINTERRUPTN);
    $setuphold (posedge USERCLK, posedge CFGPMDIRECTASPML1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMDIRECTASPML1N);
    $setuphold (posedge USERCLK, posedge CFGPMSENDPMACKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMACKN);
    $setuphold (posedge USERCLK, posedge CFGPMSENDPMETON, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMETON);
    $setuphold (posedge USERCLK, posedge CFGPMSENDPMNAKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMSENDPMNAKN);
    $setuphold (posedge USERCLK, posedge CFGPMTURNOFFOKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMTURNOFFOKN);
    $setuphold (posedge USERCLK, posedge CFGPMWAKEN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPMWAKEN);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[0]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[1]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[2]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[3]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[4]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[5]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[6]);
    $setuphold (posedge USERCLK, posedge CFGPORTNUMBER[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGPORTNUMBER[7]);
    $setuphold (posedge USERCLK, posedge CFGRDENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGRDENN);
    $setuphold (posedge USERCLK, posedge CFGTRNPENDINGN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGTRNPENDINGN);
    $setuphold (posedge USERCLK, posedge CFGWRENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRENN);
    $setuphold (posedge USERCLK, posedge CFGWRREADONLYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRREADONLYN);
    $setuphold (posedge USERCLK, posedge CFGWRRW1CASRWN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CFGWRRW1CASRWN);
    $setuphold (posedge USERCLK, posedge CMRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CMRSTN);
    $setuphold (posedge USERCLK, posedge CMSTICKYRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_CMSTICKYRSTN);
    $setuphold (posedge USERCLK, posedge DBGMODE[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGMODE[0]);
    $setuphold (posedge USERCLK, posedge DBGMODE[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGMODE[1]);
    $setuphold (posedge USERCLK, posedge DBGSUBMODE, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DBGSUBMODE);
    $setuphold (posedge USERCLK, posedge DLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_DLRSTN);
    $setuphold (posedge USERCLK, posedge FUNCLVLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_FUNCLVLRSTN);
    $setuphold (posedge USERCLK, posedge LL2SENDASREQL1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDASREQL1N);
    $setuphold (posedge USERCLK, posedge LL2SENDENTERL1N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDENTERL1N);
    $setuphold (posedge USERCLK, posedge LL2SENDENTERL23N, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SENDENTERL23N);
    $setuphold (posedge USERCLK, posedge LL2SUSPENDNOWN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2SUSPENDNOWN);
    $setuphold (posedge USERCLK, posedge LL2TLPRCVN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_LL2TLPRCVN);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[0]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[10]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[11]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[12]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[13]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[14]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[15]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[16]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[17]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[18]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[19]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[1]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[20]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[21]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[22]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[23]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[24]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[25]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[26]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[27]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[28]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[29]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[2]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[30]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[31]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[32]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[33]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[34]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[35]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[36]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[37]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[38]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[39]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[3]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[40]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[41]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[42]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[43]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[44]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[45]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[46]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[47]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[48]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[49]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[4]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[50]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[51]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[52]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[53]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[54]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[55]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[56]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[57]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[58]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[59]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[5]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[60]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[61]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[62]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[63]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[64]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[65]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[66]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[67]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[6]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[7]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[8]);
    $setuphold (posedge USERCLK, posedge MIMRXRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMRXRDATA[9]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[0]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[10]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[11]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[12]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[13]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[14]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[15]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[16]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[17]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[18]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[19]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[1]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[20]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[21]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[22]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[23]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[24]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[25]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[26]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[27]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[28]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[29]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[2]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[30]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[31]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[32]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[33]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[34]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[35]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[36]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[37]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[38]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[39]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[3]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[40]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[41]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[42]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[43]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[44]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[45]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[46]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[47]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[48]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[49]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[4]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[50]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[51]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[52]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[53]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[54]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[55]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[56]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[57]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[58]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[59]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[5]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[60]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[61]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[62]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[63]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[64], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[64]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[65], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[65]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[66], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[66]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[67], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[67]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[68], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[68]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[6]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[7]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[8]);
    $setuphold (posedge USERCLK, posedge MIMTXRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_MIMTXRDATA[9]);
    $setuphold (posedge USERCLK, posedge PL2DIRECTEDLSTATE[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[0]);
    $setuphold (posedge USERCLK, posedge PL2DIRECTEDLSTATE[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[1]);
    $setuphold (posedge USERCLK, posedge PL2DIRECTEDLSTATE[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[2]);
    $setuphold (posedge USERCLK, posedge PL2DIRECTEDLSTATE[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[3]);
    $setuphold (posedge USERCLK, posedge PL2DIRECTEDLSTATE[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_PL2DIRECTEDLSTATE[4]);
    $setuphold (posedge USERCLK, posedge TL2ASPMSUSPENDCREDITCHECKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TL2ASPMSUSPENDCREDITCHECKN);
    $setuphold (posedge USERCLK, posedge TL2PPMSUSPENDREQN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TL2PPMSUSPENDREQN);
    $setuphold (posedge USERCLK, posedge TLRSTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TLRSTN);
    $setuphold (posedge USERCLK, posedge TRNFCSEL[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[0]);
    $setuphold (posedge USERCLK, posedge TRNFCSEL[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[1]);
    $setuphold (posedge USERCLK, posedge TRNFCSEL[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNFCSEL[2]);
    $setuphold (posedge USERCLK, posedge TRNRDSTRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNRDSTRDYN);
    $setuphold (posedge USERCLK, posedge TRNRNPOKN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNRNPOKN);
    $setuphold (posedge USERCLK, posedge TRNTCFGGNTN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTCFGGNTN);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[0]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[10]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[11]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[12]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[13]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[14]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[15]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[16]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[17]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[18]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[19]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[1]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[20]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[21]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[22]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[23]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[24]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[25]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[26]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[27]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[28]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[29]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[2]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[30]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[31]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[3]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[4]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[5]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[6]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[7]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[8]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPDATA[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPDATA[9]);
    $setuphold (posedge USERCLK, posedge TRNTDLLPSRCRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTDLLPSRCRDYN);
    $setuphold (posedge USERCLK, posedge TRNTD[0], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[0]);
    $setuphold (posedge USERCLK, posedge TRNTD[10], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[10]);
    $setuphold (posedge USERCLK, posedge TRNTD[11], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[11]);
    $setuphold (posedge USERCLK, posedge TRNTD[12], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[12]);
    $setuphold (posedge USERCLK, posedge TRNTD[13], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[13]);
    $setuphold (posedge USERCLK, posedge TRNTD[14], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[14]);
    $setuphold (posedge USERCLK, posedge TRNTD[15], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[15]);
    $setuphold (posedge USERCLK, posedge TRNTD[16], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[16]);
    $setuphold (posedge USERCLK, posedge TRNTD[17], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[17]);
    $setuphold (posedge USERCLK, posedge TRNTD[18], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[18]);
    $setuphold (posedge USERCLK, posedge TRNTD[19], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[19]);
    $setuphold (posedge USERCLK, posedge TRNTD[1], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[1]);
    $setuphold (posedge USERCLK, posedge TRNTD[20], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[20]);
    $setuphold (posedge USERCLK, posedge TRNTD[21], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[21]);
    $setuphold (posedge USERCLK, posedge TRNTD[22], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[22]);
    $setuphold (posedge USERCLK, posedge TRNTD[23], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[23]);
    $setuphold (posedge USERCLK, posedge TRNTD[24], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[24]);
    $setuphold (posedge USERCLK, posedge TRNTD[25], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[25]);
    $setuphold (posedge USERCLK, posedge TRNTD[26], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[26]);
    $setuphold (posedge USERCLK, posedge TRNTD[27], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[27]);
    $setuphold (posedge USERCLK, posedge TRNTD[28], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[28]);
    $setuphold (posedge USERCLK, posedge TRNTD[29], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[29]);
    $setuphold (posedge USERCLK, posedge TRNTD[2], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[2]);
    $setuphold (posedge USERCLK, posedge TRNTD[30], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[30]);
    $setuphold (posedge USERCLK, posedge TRNTD[31], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[31]);
    $setuphold (posedge USERCLK, posedge TRNTD[32], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[32]);
    $setuphold (posedge USERCLK, posedge TRNTD[33], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[33]);
    $setuphold (posedge USERCLK, posedge TRNTD[34], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[34]);
    $setuphold (posedge USERCLK, posedge TRNTD[35], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[35]);
    $setuphold (posedge USERCLK, posedge TRNTD[36], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[36]);
    $setuphold (posedge USERCLK, posedge TRNTD[37], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[37]);
    $setuphold (posedge USERCLK, posedge TRNTD[38], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[38]);
    $setuphold (posedge USERCLK, posedge TRNTD[39], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[39]);
    $setuphold (posedge USERCLK, posedge TRNTD[3], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[3]);
    $setuphold (posedge USERCLK, posedge TRNTD[40], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[40]);
    $setuphold (posedge USERCLK, posedge TRNTD[41], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[41]);
    $setuphold (posedge USERCLK, posedge TRNTD[42], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[42]);
    $setuphold (posedge USERCLK, posedge TRNTD[43], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[43]);
    $setuphold (posedge USERCLK, posedge TRNTD[44], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[44]);
    $setuphold (posedge USERCLK, posedge TRNTD[45], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[45]);
    $setuphold (posedge USERCLK, posedge TRNTD[46], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[46]);
    $setuphold (posedge USERCLK, posedge TRNTD[47], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[47]);
    $setuphold (posedge USERCLK, posedge TRNTD[48], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[48]);
    $setuphold (posedge USERCLK, posedge TRNTD[49], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[49]);
    $setuphold (posedge USERCLK, posedge TRNTD[4], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[4]);
    $setuphold (posedge USERCLK, posedge TRNTD[50], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[50]);
    $setuphold (posedge USERCLK, posedge TRNTD[51], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[51]);
    $setuphold (posedge USERCLK, posedge TRNTD[52], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[52]);
    $setuphold (posedge USERCLK, posedge TRNTD[53], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[53]);
    $setuphold (posedge USERCLK, posedge TRNTD[54], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[54]);
    $setuphold (posedge USERCLK, posedge TRNTD[55], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[55]);
    $setuphold (posedge USERCLK, posedge TRNTD[56], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[56]);
    $setuphold (posedge USERCLK, posedge TRNTD[57], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[57]);
    $setuphold (posedge USERCLK, posedge TRNTD[58], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[58]);
    $setuphold (posedge USERCLK, posedge TRNTD[59], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[59]);
    $setuphold (posedge USERCLK, posedge TRNTD[5], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[5]);
    $setuphold (posedge USERCLK, posedge TRNTD[60], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[60]);
    $setuphold (posedge USERCLK, posedge TRNTD[61], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[61]);
    $setuphold (posedge USERCLK, posedge TRNTD[62], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[62]);
    $setuphold (posedge USERCLK, posedge TRNTD[63], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[63]);
    $setuphold (posedge USERCLK, posedge TRNTD[6], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[6]);
    $setuphold (posedge USERCLK, posedge TRNTD[7], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[7]);
    $setuphold (posedge USERCLK, posedge TRNTD[8], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[8]);
    $setuphold (posedge USERCLK, posedge TRNTD[9], 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTD[9]);
    $setuphold (posedge USERCLK, posedge TRNTECRCGENN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTECRCGENN);
    $setuphold (posedge USERCLK, posedge TRNTEOFN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTEOFN);
    $setuphold (posedge USERCLK, posedge TRNTERRFWDN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTERRFWDN);
    $setuphold (posedge USERCLK, posedge TRNTREMN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTREMN);
    $setuphold (posedge USERCLK, posedge TRNTSOFN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSOFN);
    $setuphold (posedge USERCLK, posedge TRNTSRCDSCN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSRCDSCN);
    $setuphold (posedge USERCLK, posedge TRNTSRCRDYN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSRCRDYN);
    $setuphold (posedge USERCLK, posedge TRNTSTRN, 0:0:0, 0:0:0, notifier,,, delay_USERCLK, delay_TRNTSTRN);
    ( DRPCLK => DRPDO[0]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[10]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[11]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[12]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[13]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[14]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[15]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[1]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[2]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[3]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[4]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[5]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[6]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[7]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[8]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDO[9]) = (0:0:0, 0:0:0);
    ( DRPCLK => DRPDRDY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX0POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX1POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX2POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX3POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX4POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX5POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX6POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPERX7POLARITY) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX0POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX1POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX2POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX3POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX4POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX5POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX6POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7CHARISK[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7CHARISK[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7COMPLIANCE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[12]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[13]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[14]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[15]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7DATA[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7ELECIDLE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7POWERDOWN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETX7POWERDOWN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXDEEMPH) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXMARGIN[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXMARGIN[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXMARGIN[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXRATE) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXRCVRDET) = (0:0:0, 0:0:0);
    ( PIPECLK => PIPETXRESET) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[10]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[11]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[6]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[7]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[8]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLDBGVEC[9]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLINITIALLINKWIDTH[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLINITIALLINKWIDTH[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLINITIALLINKWIDTH[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLANEREVERSALMODE[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLANEREVERSALMODE[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLINKGEN2CAP) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLINKPARTNERGEN2SUPPORTED) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLINKUPCFGCAP) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[2]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[3]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[4]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLLTSSMSTATE[5]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLPHYLNKUPN) = (0:0:0, 0:0:0);
    ( PIPECLK => PLRECEIVEDHOTRST) = (0:0:0, 0:0:0);
    ( PIPECLK => PLRXPMSTATE[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLRXPMSTATE[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLSELLNKRATE) = (0:0:0, 0:0:0);
    ( PIPECLK => PLSELLNKWIDTH[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLSELLNKWIDTH[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLTXPMSTATE[0]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLTXPMSTATE[1]) = (0:0:0, 0:0:0);
    ( PIPECLK => PLTXPMSTATE[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGAERECRCCHECKEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGAERECRCGENEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGCOMMANDBUSMASTERENABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGCOMMANDINTERRUPTDISABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGCOMMANDIOENABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGCOMMANDMEMENABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGCOMMANDSERREN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTDIS) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROL2CPLTIMEOUTVAL[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLAUXPOWEREN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLCORRERRREPORTINGEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLENABLERO) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLEXTTAGEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLFATALERRREPORTINGEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXPAYLOAD[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLMAXREADREQ[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLNONFATALREPORTINGEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLNOSNOOPEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLPHANTOMEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVCONTROLURERRREPORTINGEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVSTATUSCORRERRDETECTED) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVSTATUSFATALERRDETECTED) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVSTATUSNONFATALERRDETECTED) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDEVSTATUSURDETECTED) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[10]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[11]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[12]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[13]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[14]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[15]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[16]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[17]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[18]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[19]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[20]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[21]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[22]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[23]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[24]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[25]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[26]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[27]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[28]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[29]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[30]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[31]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[4]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[5]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[6]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[7]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[8]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGDO[9]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGERRAERHEADERLOGSETN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGERRCPLRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[4]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[5]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[6]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTDO[7]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMMENABLE[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMMENABLE[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMMENABLE[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMSIENABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMSIXENABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTMSIXFM) = (0:0:0, 0:0:0);
    ( USERCLK => CFGINTERRUPTRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLASPMCONTROL[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLASPMCONTROL[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLAUTOBANDWIDTHINTEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLBANDWIDTHINTEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLCLOCKPMEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLCOMMONCLOCK) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLEXTENDEDSYNC) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLHWAUTOWIDTHDIS) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLLINKDISABLE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLRCB) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKCONTROLRETRAINLINK) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSAUTOBANDWIDTHSTATUS) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSBANDWITHSTATUS) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSCURRENTSPEED[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSCURRENTSPEED[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSDLLACTIVE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSLINKTRAINING) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGLINKSTATUSNEGOTIATEDWIDTH[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[10]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[11]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[12]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[13]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[14]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[15]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[4]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[5]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[6]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[7]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[8]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGDATA[9]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVED) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTA) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTB) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTC) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDASSERTINTD) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTA) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTB) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTC) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDDEASSERTINTD) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDERRCOR) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDERRFATAL) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDERRNONFATAL) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDPMASNAK) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDPMETO) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDPMETOACK) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDPMPME) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDSETSLOTPOWERLIMIT) = (0:0:0, 0:0:0);
    ( USERCLK => CFGMSGRECEIVEDUNLOCK) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPCIELINKSTATE[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPCIELINKSTATE[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPCIELINKSTATE[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMCSRPMEEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMCSRPMESTATUS) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMCSRPOWERSTATE[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMCSRPOWERSTATE[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMRCVASREQL1N) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMRCVENTERL1N) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMRCVENTERL23N) = (0:0:0, 0:0:0);
    ( USERCLK => CFGPMRCVREQACKN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGRDWRDONEN) = (0:0:0, 0:0:0);
    ( USERCLK => CFGSLOTCONTROLELECTROMECHILCTLPULSE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTION) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[4]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[5]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONADDR[6]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGTRANSACTIONTYPE) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[0]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[1]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[2]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[3]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[4]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[5]) = (0:0:0, 0:0:0);
    ( USERCLK => CFGVCTCVCMAP[6]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRA) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRB) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRC) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRD) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRE) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRF) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRG) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRH) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRI) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRJ) = (0:0:0, 0:0:0);
    ( USERCLK => DBGSCLRK) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[0]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[10]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[11]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[12]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[13]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[14]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[15]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[16]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[17]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[18]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[19]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[1]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[20]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[21]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[22]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[23]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[24]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[25]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[26]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[27]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[28]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[29]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[2]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[30]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[31]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[32]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[33]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[34]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[35]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[36]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[37]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[38]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[39]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[3]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[40]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[41]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[42]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[43]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[44]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[45]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[46]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[47]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[48]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[49]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[4]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[50]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[51]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[52]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[53]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[54]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[55]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[56]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[57]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[58]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[59]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[5]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[60]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[61]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[62]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[63]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[6]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[7]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[8]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECA[9]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[0]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[10]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[11]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[12]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[13]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[14]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[15]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[16]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[17]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[18]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[19]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[1]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[20]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[21]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[22]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[23]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[24]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[25]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[26]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[27]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[28]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[29]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[2]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[30]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[31]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[32]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[33]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[34]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[35]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[36]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[37]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[38]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[39]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[3]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[40]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[41]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[42]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[43]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[44]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[45]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[46]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[47]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[48]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[49]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[4]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[50]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[51]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[52]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[53]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[54]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[55]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[56]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[57]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[58]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[59]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[5]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[60]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[61]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[62]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[63]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[6]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[7]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[8]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECB[9]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[0]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[10]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[11]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[1]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[2]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[3]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[4]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[5]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[6]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[7]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[8]) = (0:0:0, 0:0:0);
    ( USERCLK => DBGVECC[9]) = (0:0:0, 0:0:0);
    ( USERCLK => LL2BADDLLPERRN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2BADTLPERRN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2PROTOCOLERRN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2REPLAYROERRN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2REPLAYTOERRN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2SUSPENDOKN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2TFCINIT1SEQN) = (0:0:0, 0:0:0);
    ( USERCLK => LL2TFCINIT2SEQN) = (0:0:0, 0:0:0);
    ( USERCLK => LNKCLKEN) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRADDR[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXRCE) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXREN) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWADDR[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[13]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[14]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[15]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[16]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[17]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[18]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[19]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[20]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[21]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[22]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[23]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[24]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[25]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[26]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[27]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[28]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[29]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[30]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[31]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[32]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[33]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[34]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[35]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[36]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[37]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[38]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[39]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[40]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[41]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[42]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[43]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[44]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[45]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[46]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[47]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[48]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[49]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[50]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[51]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[52]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[53]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[54]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[55]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[56]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[57]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[58]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[59]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[60]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[61]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[62]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[63]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[64]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[65]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[66]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[67]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWDATA[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMRXWEN) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRADDR[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXRCE) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXREN) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWADDR[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[0]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[10]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[11]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[12]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[13]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[14]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[15]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[16]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[17]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[18]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[19]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[1]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[20]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[21]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[22]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[23]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[24]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[25]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[26]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[27]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[28]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[29]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[2]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[30]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[31]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[32]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[33]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[34]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[35]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[36]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[37]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[38]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[39]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[3]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[40]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[41]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[42]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[43]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[44]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[45]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[46]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[47]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[48]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[49]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[4]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[50]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[51]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[52]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[53]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[54]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[55]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[56]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[57]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[58]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[59]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[5]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[60]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[61]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[62]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[63]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[64]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[65]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[66]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[67]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[68]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[6]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[7]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[8]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWDATA[9]) = (0:0:0, 0:0:0);
    ( USERCLK => MIMTXWEN) = (0:0:0, 0:0:0);
    ( USERCLK => PL2LINKUPN) = (0:0:0, 0:0:0);
    ( USERCLK => PL2RECEIVERERRN) = (0:0:0, 0:0:0);
    ( USERCLK => PL2RECOVERYN) = (0:0:0, 0:0:0);
    ( USERCLK => PL2RXELECIDLE) = (0:0:0, 0:0:0);
    ( USERCLK => PL2SUSPENDOK) = (0:0:0, 0:0:0);
    ( USERCLK => RECEIVEDFUNCLVLRSTN) = (0:0:0, 0:0:0);
    ( USERCLK => TL2ASPMSUSPENDCREDITCHECKOKN) = (0:0:0, 0:0:0);
    ( USERCLK => TL2ASPMSUSPENDREQN) = (0:0:0, 0:0:0);
    ( USERCLK => TL2PPMSUSPENDOKN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[10]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[11]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[8]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLD[9]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCCPLH[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[10]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[11]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[8]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPD[9]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCNPH[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[10]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[11]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[8]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPD[9]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNFCPH[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNLNKUPN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRBARHITN[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[10]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[11]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[12]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[13]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[14]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[15]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[16]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[17]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[18]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[19]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[20]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[21]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[22]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[23]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[24]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[25]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[26]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[27]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[28]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[29]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[30]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[31]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[8]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPDATA[9]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRDLLPSRCRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[10]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[11]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[12]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[13]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[14]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[15]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[16]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[17]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[18]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[19]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[20]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[21]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[22]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[23]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[24]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[25]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[26]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[27]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[28]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[29]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[30]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[31]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[32]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[33]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[34]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[35]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[36]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[37]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[38]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[39]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[40]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[41]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[42]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[43]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[44]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[45]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[46]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[47]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[48]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[49]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[50]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[51]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[52]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[53]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[54]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[55]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[56]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[57]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[58]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[59]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[60]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[61]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[62]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[63]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[6]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[7]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[8]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRD[9]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRECRCERRN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNREOFN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRERRFWDN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRREMN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRSOFN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRSRCDSCN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNRSRCRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[0]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[1]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[2]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[3]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[4]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTBUFAV[5]) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTCFGREQN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTDLLPDSTRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTDSTRDYN) = (0:0:0, 0:0:0);
    ( USERCLK => TRNTERRDROPN) = (0:0:0, 0:0:0);
    ( USERCLK => USERRSTN) = (0:0:0, 0:0:0);

    specparam PATHPULSE$ = 0;
  endspecify
endmodule
